/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.DeclareCellDataParamsDto;
import kd.taxc.bdtaxr.common.dto.DeclareMainDataParamsDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tpo.business.declare.NxxDeclareMainService;
import kd.taxc.tpo.service.DeclareCellService;
import kd.taxc.tpo.service.TccitDeclareDataService;
import kd.taxc.tpo.service.impl.DeclareCellServiceImpl;

public class TccitDeclareDataServiceImpl
implements TccitDeclareDataService {
    private static Log logger = LogFactory.getLog(TccitDeclareDataServiceImpl.class);
    private DeclareCellService declareCellService;
    private static final String QYSDSJB_YNSDSE = "tccit_qysds_zb#1#ynsdse";
    private static final String QYSDSJB_LRZE = "tccit_qysds_zb#1#lrze";
    private static final String QYSDSNB_SJYNSDSE = "tccit_qysds_a100000#1#sjynsdse";
    private static final String QYSDSNB_LRZE = "tccit_qysds_a100000#1#lrze";

    @Override
    public Map<String, Object> getTaxAndProfitAmount(Long orgId, Date startDate, Date endDate) {
        logger.info("getTaxAndProfitAmount params,org:{},date:{}-{}", new Object[]{orgId, startDate, endDate});
        DeclareCellDataParamsDto cellParams = this.doSetParams(orgId, startDate, endDate);
        if (cellParams.getSbbId() == null) {
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)"500", (String)"SbbId is null", null);
        }
        this.declareCellService = new DeclareCellServiceImpl();
        Map<String, Object> result = this.declareCellService.getDeclareCellValue(cellParams);
        this.handleResult(result);
        logger.info("getTaxAndProfitAmount\uff0cresult:{}", (Object)JSON.toJSONString(result));
        return result;
    }

    private void handleResult(Map<String, Object> result) {
        if (result == null) {
            return;
        }
        Map data = (Map)result.get("data");
        if (CollectionUtils.isEmpty((Map)data)) {
            return;
        }
        HashMap newData = new HashMap(data.size());
        data.forEach((key, value) -> {
            if (Arrays.asList(QYSDSJB_YNSDSE, QYSDSNB_SJYNSDSE).contains(key)) {
                newData.put("ynsdse", value);
            }
            if (Arrays.asList(QYSDSJB_LRZE, QYSDSNB_LRZE).contains(key)) {
                newData.put("lrze", value);
            }
        });
        result.put("data", newData);
    }

    private DeclareCellDataParamsDto doSetParams(Long orgId, Date startDate, Date endDate) {
        DeclareCellDataParamsDto cellParams = new DeclareCellDataParamsDto();
        DeclareMainDataParamsDto mainParams = new DeclareMainDataParamsDto();
        mainParams.setOrgId(orgId);
        mainParams.setStartDate(startDate);
        mainParams.setEndDate(endDate);
        mainParams.setTaxType("qysds");
        mainParams.setDeclareType(this.isYear(startDate, endDate) ? "qysdsnb" : "qysdsjb");
        DynamicObject obj = NxxDeclareMainService.queryLastDeclareMainWithinTaxPeriod((DeclareMainDataParamsDto)mainParams);
        if (obj != null && "C".equals(obj.getString("billstatus"))) {
            cellParams.setSbbId(Long.valueOf(obj.getLong("id")));
        }
        cellParams.setMainParams(mainParams);
        cellParams.setCellKeys(this.doSetCellKeysByDeclareType(mainParams.getDeclareType()));
        return cellParams;
    }

    private List<String> doSetCellKeysByDeclareType(String declareType) {
        switch (declareType) {
            case "qysds_hdzs_jb": {
                return new ArrayList<String>();
            }
            case "qysds_hdzs_nb": {
                return new ArrayList<String>();
            }
            case "qysdsjb": {
                return Arrays.asList(QYSDSJB_YNSDSE, QYSDSJB_LRZE);
            }
            case "qysdsnb": {
                return Arrays.asList(QYSDSNB_SJYNSDSE, QYSDSNB_LRZE);
            }
        }
        return new ArrayList<String>();
    }

    private boolean isYear(Date startDate, Date endDate) {
        return DateUtils.getMonthDiff((Date)startDate, (Date)endDate) == 12;
    }
}

