/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.DeclareReportFactory;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DefaultDeclareReportService;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.service.YbnsrService;

public class YbnsrServiceImpl
implements YbnsrService {
    private static Log logger = LogFactory.getLog(YbnsrServiceImpl.class);
    public static final String TCVAT_NSRXX = "tcvat_nsrxx";
    public static final String SPLITSTRING = "#";
    public static final String EWBLXH = "ewblxh";
    public static final String SBBID = "sbbid";
    private static final String ORGID = "org";
    private static final String STATUS = "declarestatus";
    private static final String PAY_STATUS = "paystatus";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String SBRQ = "sbrq";
    private static final String NSRTYPE = "type";
    private static final String TAXLIMIT = "taxlimit";
    private static final String TEMPLATE_ID = "templateid";
    private static final String ID = "id";
    public static final String GROUP_REGISTER_TABLE = "tcvvt_clique_mcinfo";

    @Override
    public Map<String, String> createYbnsrNoBillNo(String id, String type, String orgId, String startData, String endData, boolean isCreate, Map<String, Object> extendParams, Long templateId) {
        return this.createYbnsr(id, null, type, orgId, startData, endData, isCreate, extendParams, templateId);
    }

    @Override
    public Map<String, String> createYbnsr(String id, String billNo, String type, String orgId, String startData, String endData, boolean isCreate, Map<String, Object> extendParams, Long templateId) {
        HashMap<String, String> map = new HashMap<String, String>();
        YbnsrServiceImpl.set(map, ORGID, orgId);
        YbnsrServiceImpl.set(map, STATUS, "editing");
        YbnsrServiceImpl.set(map, PAY_STATUS, "unpaid");
        YbnsrServiceImpl.set(map, SKSSQQ, startData);
        YbnsrServiceImpl.set(map, SKSSQZ, endData);
        YbnsrServiceImpl.set(map, NSRTYPE, type);
        if (templateId != null) {
            YbnsrServiceImpl.set(map, TEMPLATE_ID, String.valueOf(templateId));
        }
        YbnsrServiceImpl.set(map, TAXLIMIT, DateUtils.getTaxLimit((Date)DateUtils.stringToDate((String)startData), (Date)DateUtils.stringToDate((String)endData)));
        YbnsrServiceImpl.set(map, EWBLXH, "1");
        if (isCreate) {
            YbnsrServiceImpl.set(map, "archivestatus", "unfiled");
            YbnsrServiceImpl.set(map, "creator", RequestContext.get().getUserId());
            YbnsrServiceImpl.set(map, "createtime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            String versiontype = this.queryYbnsrFieldWithId("versiontype", id);
            YbnsrServiceImpl.set(map, "versiontype", StringUtil.isBlank((CharSequence)versiontype) ? "zcsb" : versiontype);
        }
        YbnsrServiceImpl.set(map, "billstatus", "A");
        YbnsrServiceImpl.set(map, "modifier", RequestContext.get().getUserId());
        YbnsrServiceImpl.set(map, "modifytime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        YbnsrServiceImpl.set(map, ID, id);
        YbnsrServiceImpl.set(map, "billno", StringUtil.isNotBlank((CharSequence)billNo) ? billNo : id);
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData();
        if (taxMain != null) {
            DynamicObjectCollection m;
            String actualaddress;
            DynamicObject taxorg = taxMain.getDynamicObject("taxorg");
            YbnsrServiceImpl.set(map, "nsrsbh", TaxOrgUtil.getUnifiedsocialcode((DynamicObject)taxorg));
            YbnsrServiceImpl.set(map, "nsrmc", TaxOrgUtil.getTaxpayer((DynamicObject)taxorg));
            YbnsrServiceImpl.set(map, "taxauthority", taxMain.getString("taxoffice.id"));
            YbnsrServiceImpl.set(map, "sshymc", taxMain.getString("codeandname.name"));
            YbnsrServiceImpl.set(map, "fddbrxm", taxMain.getString("legalpeople"));
            YbnsrServiceImpl.set(map, "registertype", taxMain.getString("registertype.name"));
            YbnsrServiceImpl.set(map, "zcdz", "");
            YbnsrServiceImpl.set(map, "scjydz", "");
            YbnsrServiceImpl.set(map, "phonenum", taxMain.getString("contactinformation"));
            String registeraddress = taxMain.getString("registeraddress");
            if (StringUtils.isNotEmpty((CharSequence)registeraddress)) {
                String registeraddrdetail = taxMain.getString("registeraddrdetail");
                YbnsrServiceImpl.set(map, "zcdz", registeraddrdetail);
                String jbrdzKey = null;
                if ("zzsybnsr".equals(type) || "zzsybnsr_ybhz".equals(type)) {
                    jbrdzKey = "tcvat_ybnsr_zb#5#jbrdz";
                } else if ("zzsxgmnsr".equals(type)) {
                    jbrdzKey = "tcvat_xgm_zb#7#jbrdz";
                }
                if (jbrdzKey != null) {
                    DynamicObject adrs = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"fullname", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)Long.parseLong(registeraddress))});
                    String fullname = adrs.getString("fullname");
                    fullname = fullname.replace("_", "");
                    String jbrdz = fullname + registeraddrdetail;
                    map.put(jbrdzKey, jbrdz);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(actualaddress = taxMain.getString("actualaddress")))) {
                YbnsrServiceImpl.set(map, "scjydz", taxMain.getString("actualaddrdetail"));
            }
            if (null != (m = taxMain.getDynamicObjectCollection("entryentity")) && m.size() > 0) {
                YbnsrServiceImpl.set(map, "khyh", ((DynamicObject)m.get(0)).getString("bankname"));
                YbnsrServiceImpl.set(map, "yhzh", ((DynamicObject)m.get(0)).getString("bankacct"));
            }
        }
        YbnsrServiceImpl.set(map, "sblx", "1");
        YbnsrServiceImpl.set(map, "serialno", "0");
        if (null != extendParams && extendParams.size() != 0) {
            for (Map.Entry<String, Object> entry : extendParams.entrySet()) {
                if (entry.getValue() == null) continue;
                YbnsrServiceImpl.set(map, entry.getKey(), entry.getValue().toString());
            }
        }
        YbnsrServiceImpl.set(map, "datatype", "1");
        return map;
    }

    @Override
    public Map<String, String> createMultiCnDeclareMain(long modelId, String id, String billNo, String type, String orgId, String startData, String endData, boolean isCreate, Map<String, Object> extendParams, Long templateId) {
        HashMap<String, String> map = new HashMap<String, String>();
        DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)modelId);
        String mainTable = declareTable.getMainTable();
        YbnsrServiceImpl.multiSet(map, ORGID, orgId, mainTable);
        YbnsrServiceImpl.multiSet(map, STATUS, "editing", mainTable);
        YbnsrServiceImpl.multiSet(map, PAY_STATUS, "unpaid", mainTable);
        YbnsrServiceImpl.multiSet(map, SKSSQQ, startData, mainTable);
        YbnsrServiceImpl.multiSet(map, SKSSQZ, endData, mainTable);
        YbnsrServiceImpl.multiSet(map, NSRTYPE, type, mainTable);
        if (templateId != null) {
            YbnsrServiceImpl.multiSet(map, TEMPLATE_ID, String.valueOf(templateId), mainTable);
        }
        YbnsrServiceImpl.multiSet(map, TAXLIMIT, DateUtils.getTaxLimit((Date)DateUtils.stringToDate((String)startData), (Date)DateUtils.stringToDate((String)endData)), mainTable);
        YbnsrServiceImpl.multiSet(map, EWBLXH, "1", mainTable);
        YbnsrServiceImpl.multiSet(map, ID, id, mainTable);
        YbnsrServiceImpl.multiSet(map, "billno", StringUtil.isNotBlank((CharSequence)billNo) ? billNo : id, mainTable);
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData();
        if (taxMain != null && "tpo_declare_main_tsc".equals(mainTable)) {
            YbnsrServiceImpl.multiSet(map, "taxauthority", taxMain.getString("taxoffice.id"), mainTable);
            String registeraddress = taxMain.getString("registeraddress");
            if (StringUtils.isNotEmpty((CharSequence)registeraddress)) {
                String registeraddrdetail = taxMain.getString("registeraddrdetail");
                YbnsrServiceImpl.multiSet(map, "zcdz", registeraddrdetail, mainTable);
            }
        }
        YbnsrServiceImpl.multiSet(map, "sblx", "1", mainTable);
        YbnsrServiceImpl.multiSet(map, "serialno", "0", mainTable);
        YbnsrServiceImpl.multiSet(map, "datatype", "1", mainTable);
        map.putAll(this.getOrgInfoById(Long.parseLong(orgId), mainTable));
        map.putAll(YbnsrServiceHelper.getAdditionalInfo((String)mainTable, (boolean)isCreate));
        if (null != extendParams && extendParams.size() != 0) {
            for (Map.Entry<String, Object> entry : extendParams.entrySet()) {
                if (entry.getValue() instanceof Long) {
                    YbnsrServiceImpl.multiSet(map, entry.getKey(), String.valueOf(entry.getValue()), mainTable);
                    continue;
                }
                YbnsrServiceImpl.multiSet(map, entry.getKey(), (String)entry.getValue(), mainTable);
            }
        }
        return map;
    }

    @Override
    public Map<String, String> getOrgInfoById(long orgId, String mainTable) {
        HashMap<String, String> map = new HashMap<String, String>();
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId).getData();
        if (taxMain != null) {
            DynamicObject taxorg = taxMain.getDynamicObject("taxorg");
            YbnsrServiceImpl.multiSet(map, "nsrsbh", TaxOrgUtil.getUnifiedsocialcode((DynamicObject)taxorg), mainTable);
            YbnsrServiceImpl.multiSet(map, "nsrmc", TaxOrgUtil.getTaxpayer((DynamicObject)taxorg), mainTable);
            YbnsrServiceImpl.multiSet(map, "taxauthority", taxMain.getString("taxoffice.id"), mainTable);
            YbnsrServiceImpl.multiSet(map, "sshymc", taxMain.getString("codeandname.name"), mainTable);
            YbnsrServiceImpl.multiSet(map, "orgnumber", taxorg.getString("org.number"), mainTable);
            YbnsrServiceImpl.multiSet(map, "fddbrxm", taxMain.getString("legalpeople"), mainTable);
            YbnsrServiceImpl.multiSet(map, "registertype", taxMain.getString("registertype.name"), mainTable);
        }
        return map;
    }

    @Override
    public Map<String, String> getOrgInfoByIdWithEx(long orgId, String mainTable, Map<String, Object> extendParams) {
        Map<String, String> map = this.getOrgInfoById(orgId, mainTable);
        if (null != extendParams && extendParams.size() != 0) {
            for (Map.Entry<String, Object> entry : extendParams.entrySet()) {
                YbnsrServiceImpl.multiSet(map, entry.getKey(), (String)entry.getValue(), mainTable);
            }
        }
        return map;
    }

    private static void multiSet(Map<String, String> map, String key, String value, String mainTable) {
        if (StringUtil.isNotBlank((CharSequence)value)) {
            map.put(mainTable + SPLITSTRING + key, value);
        }
    }

    @Override
    public Map<String, String> createYbnsrSetMainDataId(String id, String type, String orgId, String startData, String endData, boolean isCreate, Map<String, Object> extendParams, String mainDataId, Long temlateId) {
        Map<String, String> map = this.createYbnsrNoBillNo(id, type, orgId, startData, endData, isCreate, extendParams, temlateId);
        YbnsrServiceImpl.set(map, "maindataid", mainDataId);
        return map;
    }

    private static void set(Map<String, String> map, String key, String value) {
        if (StringUtil.isNotBlank((CharSequence)value)) {
            map.put("tcvat_nsrxx#1#" + key, value);
        }
    }

    @Override
    public String queryYbnsrPreMonth(String orgid, String type, String startData, String endData) {
        Long id = this.queryYbnsr(orgid, type, startData, endData, -1, null);
        return id == null ? "0" : id.toString();
    }

    @Override
    public String queryYbnsrPre(String orgid, String type, String startData, String endData, int month) {
        Long id = this.queryYbnsr(orgid, type, startData, endData, month, null);
        return id == null ? "0" : id.toString();
    }

    @Override
    public String queryYbnsrPreByDatePoint(String orgid, String type, String startData) {
        Date datePoint = DateUtils.addMonth((Date)DateUtils.stringToDate((String)startData), (int)-1);
        Long id = this.queryYbnsrByDatePoint(orgid, type, datePoint);
        return id == null ? "0" : id.toString();
    }

    @Override
    public Long queryYbnsrByDatePoint(String orgid, String type, Date datePoint) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(ORGID, "=", (Object)Long.parseLong(orgid)));
        qFilters.add(new QFilter(NSRTYPE, "=", (Object)type));
        qFilters.add(new QFilter(SKSSQQ, "<=", (Object)datePoint));
        qFilters.add(new QFilter(SKSSQZ, ">=", (Object)datePoint));
        DynamicObjectCollection temp = QueryServiceHelper.query((String)TCVAT_NSRXX, (String)ID, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        if (null != temp && temp.size() > 0) {
            return ((DynamicObject)temp.get(0)).getLong(ID);
        }
        return null;
    }

    @Override
    public Long queryYbnsrWithId(String sbbid) {
        QFilter qFilter = new QFilter(ID, "=", (Object)(EmptyCheckUtils.isEmpty((Object)sbbid) ? 0L : Long.parseLong(sbbid)));
        DynamicObject dynamicObject = YbnsrServiceImpl.getDynamicObjectByFilters(null, Collections.singletonList(qFilter));
        return dynamicObject == null ? 0L : dynamicObject.getLong(ID);
    }

    @Override
    public String queryYbnsrFieldWithId(String field, String sbbid) {
        QFilter qFilter = new QFilter(ID, "=", (Object)(EmptyCheckUtils.isEmpty((Object)sbbid) ? 0L : Long.parseLong(sbbid)));
        DynamicObjectCollection temp = QueryServiceHelper.query((String)TCVAT_NSRXX, (String)field, (QFilter[])qFilter.toArray());
        if (null != temp && temp.size() > 0) {
            Object result = ((DynamicObject)temp.get(0)).get(field);
            return result == null ? null : String.valueOf(result);
        }
        return null;
    }

    @Override
    public String queryYbnsrPreYear(String orgid, String type, String startData, String endData) {
        int year = DateUtils.getYearOfDate((Date)DateUtils.stringToDate((String)startData));
        Long id = this.queryYbnsr(orgid, type, year - 1 + "-12-01", year - 1 + "-12-31", 0, null);
        return id == null ? "0" : id.toString();
    }

    @Override
    public Long queryYbnsrWithEx(String orgid, String type, String startData, String endData, Map<String, Object> extendParams) {
        Long id = this.queryYbnsr(orgid, type, startData, endData, 0, extendParams);
        return id;
    }

    @Override
    public Long queryMultiDeclareMain(String mainTable, long orgId, String type, String startData, String endData, QFilter extendFilter) {
        List<QFilter> queryFilters = this.getMainTableFilter(extendFilter, orgId, startData, endData, type);
        return this.queryMultiDeclareMain(mainTable, queryFilters);
    }

    @Override
    public Long queryMultiDeclareMainEx(String mainTable, long orgId, String type, String startData, String endData, Map<String, Object> extendParams) {
        List<QFilter> queryFilters = this.getMainTableFilter(extendParams, orgId, startData, endData, type);
        return this.queryMultiDeclareMain(mainTable, queryFilters);
    }

    @Override
    public List<Long> queryMultiDeclareMainList(String mainTable, long orgId, String type, String startData, String endData, QFilter extendFilter) {
        List<QFilter> queryFilters = this.getMainTableListFilter(extendFilter, orgId, startData, endData, type);
        return this.queryMultiDeclareMainList(mainTable, queryFilters);
    }

    private List<QFilter> getMainTableFilter(Map<String, Object> extendParams, long orgId, String skssqq, String skssqz, String templateType) {
        ArrayList<QFilter> queryFilters = new ArrayList<QFilter>();
        DeclareReportService declareReportService = DeclareReportFactory.createHandler((String)templateType);
        List mainQueryMainFilter = null;
        QFilter extendFilter = null;
        if (declareReportService != null) {
            extendFilter = declareReportService.getDeclareMainQueryExtendFilter(extendParams);
            mainQueryMainFilter = declareReportService.getDeclareMainQueryMainFilter(orgId, templateType, skssqq, skssqz);
        } else {
            mainQueryMainFilter = new DefaultDeclareReportService().getDeclareMainQueryMainFilter(orgId, templateType, skssqq, skssqz);
        }
        if (mainQueryMainFilter != null) {
            queryFilters.addAll(mainQueryMainFilter);
        }
        if (extendFilter != null) {
            queryFilters.add(extendFilter);
        }
        return queryFilters;
    }

    private List<QFilter> getMainTableFilter(QFilter extendFilter, long orgId, String skssqq, String skssqz, String templateType) {
        ArrayList<QFilter> queryFilters = new ArrayList<QFilter>();
        DeclareReportService declareReportService = DeclareReportFactory.createHandler((String)templateType);
        List mainQueryMainFilter = null;
        mainQueryMainFilter = declareReportService != null ? declareReportService.getDeclareMainQueryMainFilter(orgId, templateType, skssqq, skssqz) : new DefaultDeclareReportService().getDeclareMainQueryMainFilter(orgId, templateType, skssqq, skssqz);
        if (mainQueryMainFilter != null) {
            queryFilters.addAll(mainQueryMainFilter);
        }
        if (extendFilter != null) {
            queryFilters.add(extendFilter);
        }
        return queryFilters;
    }

    private List<QFilter> getMainTableListFilter(QFilter extendFilter, long orgId, String skssqq, String skssqz, String templateType) {
        ArrayList<QFilter> queryFilters = new ArrayList<QFilter>();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(ORGID, "=", (Object)orgId));
        qFilters.add(new QFilter("templatetype", "=", (Object)templateType));
        if (StringUtil.isNotBlank((CharSequence)skssqq)) {
            qFilters.add(new QFilter(SKSSQQ, ">=", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)skssqq))));
        }
        if (StringUtil.isNotBlank((CharSequence)skssqz)) {
            qFilters.add(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)skssqz))));
        }
        queryFilters.addAll(qFilters);
        if (extendFilter != null) {
            queryFilters.add(extendFilter);
        }
        return queryFilters;
    }

    private Long queryMultiDeclareMain(String mainTable, List<QFilter> qFilters) {
        QFilter[] qFilterArr = new QFilter[qFilters.size()];
        DynamicObjectCollection temp = QueryServiceHelper.query((String)mainTable, (String)ID, (QFilter[])qFilters.toArray(qFilterArr));
        if (temp.size() > 0) {
            return ((DynamicObject)temp.get(0)).getLong(ID);
        }
        return null;
    }

    private List<Long> queryMultiDeclareMainList(String mainTable, List<QFilter> qFilters) {
        QFilter[] qFilterArr = new QFilter[qFilters.size()];
        DynamicObjectCollection temp = QueryServiceHelper.query((String)mainTable, (String)ID, (QFilter[])qFilters.toArray(qFilterArr));
        int resultSize = temp.size();
        if (resultSize > 0) {
            ArrayList<Long> ids = new ArrayList<Long>(resultSize);
            for (DynamicObject obj : temp) {
                ids.add(obj.getLong(ID));
            }
            return ids;
        }
        return null;
    }

    @Override
    public List<Long> queryZzsSbb(List<String> orgList, String type, String startData, String endData) {
        QFilter orgidFilter = new QFilter(ORGID, "in", orgList.stream().map(Long::parseLong).collect(Collectors.toList()));
        QFilter stypeFilter = new QFilter(NSRTYPE, "=", (Object)type);
        QFilter startDataFilter = new QFilter(SKSSQQ, "=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)startData), (int)0));
        QFilter endDataFilter = new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)endData), (int)0)));
        DynamicObjectCollection temp = QueryServiceHelper.query((String)TCVAT_NSRXX, (String)ID, (QFilter[])new QFilter[]{orgidFilter, stypeFilter, startDataFilter, endDataFilter});
        return temp.stream().map(a -> a.getLong(ID)).collect(Collectors.toList());
    }

    @Override
    public List<Long> querySbbs(List<String> orgList, String type, String taxLimit, String startData, String endData) {
        QFilter orgidFilter = new QFilter(ORGID, "in", orgList.stream().map(Long::parseLong).collect(Collectors.toList()));
        QFilter stypeFilter = new QFilter(NSRTYPE, "=", (Object)type);
        QFilter limitFilter = new QFilter(TAXLIMIT, "=", (Object)taxLimit);
        QFilter startDataFilter = new QFilter(SKSSQQ, ">=", (Object)DateUtils.getDayFirst((Date)DateUtils.stringToDate((String)startData)));
        QFilter endDataFilter = new QFilter(SKSSQZ, "<=", (Object)DateUtils.getDayLast((Date)DateUtils.stringToDate((String)endData)));
        DynamicObjectCollection temp = QueryServiceHelper.query((String)TCVAT_NSRXX, (String)"declarestatus,org,id", (QFilter[])new QFilter[]{orgidFilter, stypeFilter, limitFilter, startDataFilter, endDataFilter});
        return temp.stream().map(a -> a.getLong(ID)).collect(Collectors.toList());
    }

    @Override
    public Boolean isExistsSbbs(List<String> orgList, List<String> typeList, String taxLimit, String startData, String endData) {
        QFilter orgidFilter = new QFilter(ORGID, "in", orgList.stream().map(Long::parseLong).collect(Collectors.toList()));
        QFilter stypeFilter = new QFilter(NSRTYPE, "in", typeList);
        QFilter limitFilter = new QFilter(TAXLIMIT, "=", (Object)taxLimit);
        QFilter startDataFilter = new QFilter(SKSSQQ, "=", (Object)DateUtils.getDayFirst((Date)DateUtils.stringToDate((String)startData)));
        QFilter endDataFilter = new QFilter(SKSSQZ, "<=", (Object)DateUtils.getDayLast((Date)DateUtils.stringToDate((String)endData)));
        return QueryServiceHelper.exists((String)TCVAT_NSRXX, (QFilter[])new QFilter[]{orgidFilter, stypeFilter, limitFilter, startDataFilter, endDataFilter});
    }

    private static DynamicObject getDynamicObjectByFilters(Map<String, Object> extendParams, List<QFilter> qFilters) {
        QFilter[] qFilterArr;
        DynamicObjectCollection temp;
        if (null != extendParams && extendParams.size() != 0) {
            for (Map.Entry<String, Object> entry : extendParams.entrySet()) {
                Object value = entry.getValue();
                if (entry.getKey().equals("groupid")) {
                    value = Long.parseLong(value.toString());
                }
                QFilter extendFilter = new QFilter(entry.getKey(), "=", value);
                qFilters.add(extendFilter);
            }
        }
        if (null != (temp = QueryServiceHelper.query((String)TCVAT_NSRXX, (String)ID, (QFilter[])qFilters.toArray(qFilterArr = new QFilter[qFilters.size()]))) && temp.size() > 0) {
            return (DynamicObject)temp.get(0);
        }
        return null;
    }

    public Long queryYbnsr(String orgid, String stype, String startData, String endData, int month, Map<String, Object> extendParams) {
        return this.queryYbnsr(orgid, stype, startData, endData, month, false, extendParams);
    }

    @Override
    public Long queryYbnsr(String orgid, String stype, String startData, String endData, int month, boolean dateRange, Map<String, Object> extendParams) {
        List<QFilter> qFilters = YbnsrServiceImpl.getQFilters(orgid, stype, startData, endData, month, dateRange, extendParams);
        DynamicObject d = YbnsrServiceImpl.getDynamicObjectByFilters(extendParams, qFilters);
        if (null != d) {
            return d.getLong(ID);
        }
        return 0L;
    }

    @Override
    public Long queryYbnsrByMainDataIdAndType(String stype, String mainDataId, Map<String, Object> extendParams) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(NSRTYPE, "=", (Object)stype));
        qFilters.add(new QFilter("maindataid", "=", (Object)Long.valueOf(mainDataId)));
        DynamicObject d = YbnsrServiceImpl.getDynamicObjectByFilters(extendParams, qFilters);
        if (null != d) {
            return d.getLong(ID);
        }
        return 0L;
    }

    private static List<QFilter> getQFilters(String orgid, String stype, String startData, String endData, int month, boolean dateRange, Map<String, Object> extendParams) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (!YbnsrServiceImpl.checkGroupSubmmitted(stype, extendParams)) {
            qFilters.add(new QFilter(ORGID, "=", (Object)Long.parseLong(orgid)));
        }
        qFilters.add(new QFilter(NSRTYPE, "=", (Object)stype));
        if (dateRange) {
            qFilters.add(new QFilter(SKSSQQ, ">=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)startData), (int)month)));
        } else {
            qFilters.add(new QFilter(SKSSQQ, "=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)startData), (int)month)));
        }
        qFilters.add(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)endData), (int)month))));
        qFilters.add(new QFilter(TAXLIMIT, "=", (Object)DateUtils.getTaxLimit((Date)DateUtils.stringToDate((String)startData), (Date)DateUtils.stringToDate((String)endData))));
        return qFilters;
    }

    @Override
    public Map<String, List<Object>> queryYbnsrTableByType(String type, String sbbid, String orgId, Map<String, Object> extendParams) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        Map tableMap = TemplateTypeConstant.DECLARE_TWO_TYPE.contains(type) ? TemplateUtils.queryEntityByTypeId((String)type) : TemplateUtilsOld.queryEntityByTypeId((String)type);
        for (String t : tableMap.keySet()) {
            List<Object> data = YbnsrServiceImpl.queryTable(t, sbbid, orgId, type, extendParams);
            if (null == data || data.size() <= 0) continue;
            map.put(t, data);
        }
        return map;
    }

    @Override
    public Map<String, List<Object>> queryYbnsrTable(String sbbid, Map<String, String> tableMap) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (String t : tableMap.keySet()) {
            List<Object> data = YbnsrServiceImpl.queryTable(t, sbbid);
            if (null == data || data.size() <= 0) continue;
            map.put(t, data);
        }
        return map;
    }

    private static List<Object> queryTable(String tableName, String sbbid, String orgId, String type, Map<String, Object> extendParams) {
        QFilter qFilter;
        if (tableName.equals(TCVAT_NSRXX)) {
            qFilter = new QFilter(ID, "=", (Object)Long.parseLong(sbbid));
        } else {
            qFilter = new QFilter(SBBID, "=", (Object)sbbid);
            if (DeclareConstant.LONG_SBBID_ENTITIES.contains(tableName)) {
                qFilter = new QFilter(SBBID, "=", (Object)Long.parseLong(sbbid));
            }
            if (YbnsrServiceImpl.checkTableNeedGroupSubmitted(type, extendParams, tableName)) {
                qFilter = qFilter.and(new QFilter(ORGID, "=", (Object)Long.parseLong(orgId)));
            }
        }
        List temp = QueryServiceHelper.queryPrimaryKeys((String)tableName, (QFilter[])new QFilter[]{qFilter}, (String)"", (int)100000);
        return temp;
    }

    private static List<Object> queryTable(String tableName, String sbbid) {
        long fid = 0L;
        try {
            fid = Long.parseLong(sbbid);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        QFilter qFilter = tableName.equals(TCVAT_NSRXX) || tableName.equals("tcetr_declare_main") ? new QFilter(ID, "=", (Object)fid) : (DeclareConstant.LONG_SBBID_ENTITIES.contains(tableName) ? new QFilter(SBBID, "=", (Object)fid) : new QFilter(SBBID, "=", (Object)sbbid));
        List temp = null;
        try {
            temp = QueryServiceHelper.queryPrimaryKeys((String)tableName, (QFilter[])new QFilter[]{qFilter}, (String)"", (int)100000);
        }
        catch (Exception e) {
            logger.error("AllField=" + MetadataUtil.getAllFieldStringNoCollection((String)tableName));
            logger.error("qFilter=" + qFilter.toString());
            logger.error("tableName=" + tableName, (Object)e.getMessage());
        }
        return temp;
    }

    @Override
    public Boolean deleteYbnsrTable(String type, String sbbid, String orgId, Map<String, Object> extendParams) {
        QFilter qFilter = new QFilter(SBBID, "=", (Object)sbbid);
        QFilter qFilter1 = new QFilter(SBBID, "=", (Object)Long.parseLong(sbbid));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)Long.parseLong(orgId));
        Map tableMap = TemplateTypeConstant.DECLARE_TWO_TYPE.contains(type) ? TemplateUtils.queryEntityByTypeId((String)type) : TemplateUtilsOld.queryEntityByTypeId((String)type);
        for (String t : tableMap.keySet()) {
            if (t.equals(TCVAT_NSRXX) || t.equals("tcvat_prepay_declare_bill")) continue;
            if (YbnsrServiceImpl.checkTableNeedGroupSubmitted(type, extendParams, t)) {
                if (DeclareConstant.LONG_SBBID_ENTITIES.contains(t)) {
                    DeleteServiceHelper.delete((String)t, (QFilter[])new QFilter[]{qFilter1, orgFilter});
                    continue;
                }
                DeleteServiceHelper.delete((String)t, (QFilter[])new QFilter[]{qFilter, orgFilter});
                continue;
            }
            if (DeclareConstant.LONG_SBBID_ENTITIES.contains(t)) {
                DeleteServiceHelper.delete((String)t, (QFilter[])new QFilter[]{qFilter1});
                continue;
            }
            DeleteServiceHelper.delete((String)t, (QFilter[])new QFilter[]{qFilter});
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteYbnsrTableByTableMap(String type, String sbbid, String orgId, Map<String, Object> extendParams, Map<String, String> tableMap) {
        QFilter qFilter = new QFilter(SBBID, "=", (Object)sbbid);
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)Long.parseLong(orgId));
        if (tableMap != null) {
            for (String t : tableMap.keySet()) {
                if (t.equals(TCVAT_NSRXX) || t.equals("tcvat_prepay_declare_bill")) continue;
                if (YbnsrServiceImpl.checkTableNeedGroupSubmitted(type, extendParams, t)) {
                    DeleteServiceHelper.delete((String)t, (QFilter[])new QFilter[]{qFilter, orgFilter});
                    continue;
                }
                DeleteServiceHelper.delete((String)t, (QFilter[])new QFilter[]{qFilter});
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteYbnsrTableById(String sbbid) {
        if (StringUtils.isBlank((CharSequence)sbbid)) {
            return Boolean.FALSE;
        }
        DynamicObject declareMain = BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)TCVAT_NSRXX);
        String strTempId = declareMain.getString(TEMPLATE_ID);
        if (StringUtils.isNotBlank((CharSequence)strTempId)) {
            Long templateId = Long.parseLong(strTempId);
            Map metadataMap = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TemplateService", (String)"getMetadata", (Object[])new Object[]{templateId});
            DeleteServiceHelper.delete((String)TCVAT_NSRXX, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)Long.valueOf(sbbid))});
            QFilter qFilter = new QFilter(SBBID, "=", (Object)sbbid);
            if (metadataMap != null) {
                for (String t : metadataMap.keySet()) {
                    if (DeclareConstant.LONG_SBBID_ENTITIES.contains(t)) {
                        DeleteServiceHelper.delete((String)t, (QFilter[])new QFilter[]{new QFilter(SBBID, "=", (Object)Long.parseLong(sbbid))});
                        continue;
                    }
                    if (TCVAT_NSRXX.equals(t)) continue;
                    DeleteServiceHelper.delete((String)t, (QFilter[])new QFilter[]{qFilter});
                }
            }
            SourceOperateHelper.deleteSourceEntity((String)declareMain.getString(NSRTYPE), (Long)Long.parseLong(sbbid));
            DeleteServiceHelper.delete((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{qFilter});
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean resetYbnsrTable(String sbbid, String strTempId) {
        if (StringUtils.isBlank((CharSequence)sbbid)) {
            return Boolean.FALSE;
        }
        DynamicObject declareMain = BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)TCVAT_NSRXX);
        logger.info("\u91cd\u7f6e\u8be5\u6a21\u677f\u6570\u636e" + strTempId);
        if (StringUtils.isNotBlank((CharSequence)strTempId)) {
            Long templateId = Long.parseLong(strTempId);
            Map metadataMap = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TemplateService", (String)"getMetadata", (Object[])new Object[]{templateId});
            logger.info("\u91cd\u7f6e\u8be5\u6a21\u677f\u6570\u636e1" + (metadataMap == null ? "" : Integer.valueOf(metadataMap.size())));
            EntityInfo entityInfo = MetadataUtil.getEntityById((String)TCVAT_NSRXX);
            for (EntityField entityField : entityInfo.getFieldList()) {
                String fileId = entityField.getFieldId();
                if (!EWBLXH.equals(fileId)) continue;
                declareMain.set(fileId, null);
            }
            QFilter qFilter = new QFilter(SBBID, "=", (Object)sbbid);
            if (metadataMap != null) {
                for (String t : metadataMap.keySet()) {
                    if (DeclareConstant.LONG_SBBID_ENTITIES.contains(t)) {
                        logger.info("\u5220\u9664nxx\u8868\u4ee5\u5916\u7684\u6570\u636e");
                        DeleteServiceHelper.delete((String)t, (QFilter[])new QFilter[]{new QFilter(SBBID, "=", (Object)Long.parseLong(sbbid))});
                        continue;
                    }
                    if (TCVAT_NSRXX.equals(t)) continue;
                    logger.info("\u5220\u9664nxx\u8868\u4ee5\u5916\u7684\u6570\u636e");
                    DeleteServiceHelper.delete((String)t, (QFilter[])new QFilter[]{qFilter});
                }
            }
        }
        return Boolean.TRUE;
    }

    private static boolean checkGroupSubmmitted(String type, Map<String, Object> extendParams) {
        return StringUtils.equals((CharSequence)"qhjtbs", (CharSequence)type) && EmptyCheckUtils.isNotEmpty(extendParams) && StringUtils.isNotBlank((Object)extendParams.get("groupid"));
    }

    private static boolean checkTableNeedGroupSubmitted(String type, Map<String, Object> extendParams, String t) {
        return YbnsrServiceImpl.checkGroupSubmmitted(type, extendParams) && StringUtils.equals((CharSequence)GROUP_REGISTER_TABLE, (CharSequence)t);
    }
}

