/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.service.impl.upgrade;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.user.UserService;

public class ConditionFilterUtils {
    public static String buildFilterCondition(JSONArray filterRowArr, String entry) {
        int size = filterRowArr.size();
        if (size == 0) {
            return "";
        }
        ArrayList<SimpleFilterRow> filterRow = new ArrayList<SimpleFilterRow>(size);
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = filterRowArr.getJSONObject(i);
            String fieldName = jsonObject.getString("FieldName");
            String logicCode = jsonObject.getString("Logic");
            String rightBracket = jsonObject.getString("RightBracket");
            String leftBracket = jsonObject.getString("LeftBracket");
            String compareType = jsonObject.getString("CompareType");
            JSONArray value = jsonObject.getJSONArray("Value");
            JSONArray baseDataIds = jsonObject.getJSONArray("BaseDataIds");
            ArrayList<FilterValue> filterList = new ArrayList<FilterValue>();
            for (Object val : value) {
                FilterValue filterValue = new FilterValue();
                filterValue.setId(((JSONObject)val).getString("Id"));
                filterValue.setValue((Object)((JSONObject)val).getString("Value"));
                filterList.add(filterValue);
            }
            SimpleFilterRow row = new SimpleFilterRow(leftBracket, compareType, fieldName, rightBracket, logicCode, filterList);
            if (null != baseDataIds) {
                ArrayList<FilterValue> baseFilterList = new ArrayList<FilterValue>();
                for (Object val : baseDataIds) {
                    FilterValue filterValue = new FilterValue();
                    filterValue.setId(((JSONObject)val).getString("Id"));
                    filterValue.setValue((Object)((JSONObject)val).getString("Value"));
                    baseFilterList.add(filterValue);
                }
                row.setBaseDataIds(baseFilterList);
            }
            filterRow.add(row);
        }
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.setFilterRow(filterRow);
        filterCondition.createMetaData();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entry);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return filterBuilder.getFilterObject().getFilter();
    }
}

