/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.service.impl.upgrade;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.id.Base39Coder;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.enums.VoucherEnum;
import org.apache.commons.collections.CollectionUtils;

public class ContractRuleUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(ContractRuleUpgradeService.class);
    private static String contractRuleEntry = "tcsd_rule_yshtpz";
    private static String cqzysjRuleEntry = "tcsd_rule_cqzysj";
    private static String zjzbRuleEntry = "tcsd_rule_zjzb";
    private static String taxItemEntry = "tpo_tcsd_taxrateentry";
    private String[] allParams = new String[]{"001", "002", "003", "004", "005", "006", "007", "008", "009", "010", "011", "012", "013", "014", "01001", "01007", "01011"};
    private String[] oldAddParams = new String[]{"001", "002", "003", "004", "006", "005", "012"};
    private Map<String, Long> taxItemMap;
    private BiMap<String, String> numberMap;

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)this.upData(), (String)"ContractRuleUpgradeService_0", (String)"taxc-tcsd-mservice", (Object[])new Object[0]));
        return result;
    }

    public String upData() {
        this.taxItemMap = new HashMap<String, Long>();
        Map<String, List<DynamicObject>> yshtpzrRuleMap = this.getRule(contractRuleEntry);
        Map<String, List<DynamicObject>> cqzysjRuleMap = this.getRule(cqzysjRuleEntry);
        Map<String, List<DynamicObject>> zjzbRuleMap = this.getRule(zjzbRuleEntry);
        List<DynamicObject> oldAddRules = yshtpzrRuleMap.get("old");
        List<DynamicObject> zjzbRules = zjzbRuleMap.get("old");
        ArrayList<DynamicObject> newRules = new ArrayList<DynamicObject>(oldAddRules.size());
        ArrayList<DynamicObject> zjzbNewRules = new ArrayList<DynamicObject>(zjzbRules.size());
        for (DynamicObject rule : oldAddRules) {
            if (!this.existNewCard(rule, contractRuleEntry)) continue;
            newRules.add(this.structureRule(rule, contractRuleEntry));
        }
        for (DynamicObject rule : zjzbRules) {
            if (!this.existNewCard(rule, zjzbRuleEntry)) continue;
            zjzbNewRules.add(this.structureRule(rule, zjzbRuleEntry));
        }
        List<DynamicObject> newRule = this.updateOldRuleFilter(yshtpzrRuleMap.get("all"));
        List<DynamicObject> cqzysjNewRule = this.updateOldRuleFilter(cqzysjRuleMap.get("all"));
        List<DynamicObject> zjzbNewRule = this.updateOldRuleFilter(zjzbRuleMap.get("all"));
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])newRules.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])zjzbNewRules.toArray(new DynamicObject[0]));
                SaveServiceHelper.update((DynamicObject[])newRule.toArray(new DynamicObject[0]));
                SaveServiceHelper.update((DynamicObject[])cqzysjNewRule.toArray(new DynamicObject[0]));
                SaveServiceHelper.update((DynamicObject[])zjzbNewRule.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
        return ResManager.loadKDString((String)"\u8d22\u4ea7\u884c\u4e3a\u7a0e\u89c4\u5219\u5361\u7247\u65b0\u589e\u6210\u529f", (String)"ContractRuleUpgradeService_1", (String)"taxc-tpo-mservice", (Object[])new Object[0]);
    }

    private boolean existNewCard(DynamicObject rule, String entry) {
        String number = rule.getDynamicObject("taxitem").getString("number");
        String newNumber = this.getNewNumberByOldNumber(number);
        Long itemId = this.getItemIdByNumber(newNumber);
        return !QueryServiceHelper.exists((String)entry, (QFilter[])new QFilter[]{new QFilter("taxitem", "=", (Object)itemId)});
    }

    private List<DynamicObject> updateOldRuleFilter(List<DynamicObject> rules) {
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(rules.size());
        for (DynamicObject rule : rules) {
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
            List collect = entryentity.stream().filter(e -> e.getDynamicObject("table").getLong("id") == 942515893462684672L).filter(entiry -> StringUtil.isNotBlank((CharSequence)entiry.getString("conditionjson"))).filter(e -> e.getString("conditionjson").contains("vouchertype")).collect(Collectors.toList());
            if (collect.size() <= 0) continue;
            for (DynamicObject dynamicObject : collect) {
                String conditionJson = dynamicObject.getString("conditionjson");
                Map<String, String> resultMap = this.changedFilter(conditionJson, "");
                dynamicObject.set("conditionjson", (Object)resultMap.get("json"));
                dynamicObject.set("filtercondition", (Object)resultMap.get("name"));
            }
            rule.set("entryentity", (Object)entryentity);
            newList.add(rule);
        }
        return newList;
    }

    private Map<String, String> changedFilter(String conditionjson, String num) {
        HashMap<String, String> result = new HashMap<String, String>();
        JSONObject conditionjJson = JSONObject.parseObject((String)conditionjson);
        JSONArray BaseArr = new JSONArray();
        JSONObject BaseObj = new JSONObject();
        JSONArray filterRowArr = conditionjJson.getJSONArray("FilterRow");
        int arrSize = filterRowArr.size();
        for (int i = 0; i < arrSize; ++i) {
            JSONObject jsonObject = filterRowArr.getJSONObject(i);
            String fieldName = jsonObject.getString("FieldName");
            if (!"vouchertype".equals(fieldName)) continue;
            JSONArray value = jsonObject.getJSONArray("Value");
            String code = value.getJSONObject(0).getString("Value");
            String number = VoucherEnum.getNumberByCode(code);
            value.getJSONObject(0).put("Value", (Object)(StringUtil.isBlank((CharSequence)num) ? number : num));
            jsonObject.put("FieldName", (Object)"vouchertype.number");
            String compareType = this.getCompareType(jsonObject.getString("CompareType"));
            jsonObject.put("CompareType", (Object)compareType);
            BaseObj.put("_Type_", (Object)"FilterValue");
            BaseObj.put("Value", StringUtil.isBlank((CharSequence)num) ? this.numberMap.get((Object)number) : String.valueOf(this.getItemIdByNumber(num)));
            BaseObj.put("Id", (Object)Base39Coder.toString((long)IDService.get().genLongId()));
            BaseArr.add((Object)BaseObj);
            jsonObject.put("BaseDataIds", (Object)BaseArr);
        }
        String filtercondition = this.buildFilterCondition(filterRowArr);
        result.put("json", conditionjJson.toJSONString());
        result.put("name", filtercondition);
        return result;
    }

    private String getCompareType(String type) {
        switch (type) {
            case "105": {
                return "67";
            }
            case "106": {
                return "83";
            }
            case "17": {
                return "17";
            }
            case "34": {
                return "34";
            }
            case "1103": {
                return "37";
            }
            case "1104": {
                return "9";
            }
        }
        return type;
    }

    private String buildFilterCondition(JSONArray filterRowArr) {
        int size = filterRowArr.size();
        if (size == 0) {
            return "";
        }
        ArrayList<SimpleFilterRow> filterRow = new ArrayList<SimpleFilterRow>(size);
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = filterRowArr.getJSONObject(i);
            String fieldName = jsonObject.getString("FieldName");
            String logicCode = jsonObject.getString("Logic");
            String rightBracket = jsonObject.getString("RightBracket");
            String leftBracket = jsonObject.getString("LeftBracket");
            String compareType = jsonObject.getString("CompareType");
            JSONArray value = jsonObject.getJSONArray("Value");
            JSONArray baseDataIds = jsonObject.getJSONArray("BaseDataIds");
            ArrayList<FilterValue> filterList = new ArrayList<FilterValue>();
            for (Object val : value) {
                FilterValue filterValue = new FilterValue();
                filterValue.setId(((JSONObject)val).getString("Id"));
                filterValue.setValue((Object)((JSONObject)val).getString("Value"));
                filterList.add(filterValue);
            }
            SimpleFilterRow row = new SimpleFilterRow(leftBracket, compareType, fieldName, rightBracket, logicCode, filterList);
            if (null != baseDataIds) {
                ArrayList<FilterValue> baseFilterList = new ArrayList<FilterValue>();
                for (Object val : baseDataIds) {
                    FilterValue filterValue = new FilterValue();
                    filterValue.setId(((JSONObject)val).getString("Id"));
                    filterValue.setValue((Object)((JSONObject)val).getString("Value"));
                    baseFilterList.add(filterValue);
                }
                row.setBaseDataIds(baseFilterList);
            }
            filterRow.add(row);
        }
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.setFilterRow(filterRow);
        filterCondition.createMetaData();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"tdm_stamptax_voucher");
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return filterBuilder.getFilterObject().getFilter();
    }

    private DynamicObject structureRule(DynamicObject oldRule, String entry) {
        DynamicObject rule = BusinessDataServiceHelper.newDynamicObject((String)entry);
        String orgId = oldRule.getDynamicObject("org").getString("id");
        String oldNumber = oldRule.getDynamicObject("taxitem").getString("number");
        DynamicObject deductioncode = oldRule.getDynamicObject("deductioncode");
        String readNumber = CodeRuleServiceHelper.getNumber((String)entry, (DynamicObject)rule, (String)orgId);
        rule.set("number", (Object)readNumber);
        rule.set("org", (Object)Long.parseLong(orgId));
        rule.set("taxitem", (Object)this.getItemIdByNumber(oldNumber));
        rule.set("name", (Object)String.format(ResManager.loadKDString((String)"%s-\u65b0\u7248", (String)"ContractRuleUpgradeService_2", (String)"taxc-tpo-mservice", (Object[])new Object[0]), oldRule.getString("name")));
        rule.set("ruletype", (Object)oldRule.getString("ruletype"));
        rule.set("taxation", (Object)oldRule.getString("taxation"));
        rule.set("suitable", (Object)oldRule.getString("suitable"));
        rule.set("enable", (Object)oldRule.getString("enable"));
        rule.set("status", (Object)oldRule.getString("status"));
        if (contractRuleEntry.equals(entry)) {
            rule.set("verifyratio", (Object)oldRule.getString("verifyratio"));
        }
        rule.set("deductioncode", (Object)(deductioncode == null ? 0L : deductioncode.getLong("id")));
        DynamicObjectCollection oldData = oldRule.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection newData = rule.getDynamicObjectCollection("entryentity");
        for (DynamicObject oldset : oldData) {
            DynamicObject addNew = newData.addNew();
            addNew.set("seq", (Object)oldset.getString("seq"));
            addNew.set("bizname", (Object)oldset.getString("bizname"));
            addNew.set("table", (Object)(oldset.getDynamicObject("table") != null ? oldset.getDynamicObject("table").getLong("id") : 0L));
            addNew.set("amountfield", (Object)(oldset.getDynamicObject("amountfield") != null ? oldset.getDynamicObject("amountfield").getLong("id") : 0L));
            addNew.set("advancedconf", (Object)oldset.getString("advancedconf"));
            addNew.set("advancedconfjson", (Object)oldset.getString("advancedconfjson"));
            addNew.set("absolute", (Object)oldset.getString("absolute"));
            addNew.set("datatype", (Object)oldset.getString("datatype"));
            addNew.set("datadirection", (Object)oldset.getString("datadirection"));
            if (942515893462684672L == oldset.getDynamicObject("table").getLong("id") && oldset.getString("conditionjson").contains("vouchertype")) {
                String conditionJson = oldset.getString("conditionjson");
                Map<String, String> resultMap = this.changedFilter(conditionJson, this.getNewNumberByOldNumber(oldNumber));
                addNew.set("conditionjson", (Object)resultMap.get("json"));
                addNew.set("filtercondition", (Object)resultMap.get("name"));
                continue;
            }
            addNew.set("filtercondition", (Object)oldset.getString("filtercondition"));
            addNew.set("conditionjson", (Object)oldset.getString("conditionjson"));
        }
        rule.set("entryentity", (Object)newData);
        return rule;
    }

    private Map<String, String> structureFilter(String number, String id) {
        JSONObject condition = new JSONObject();
        condition.put("_Type_", (Object)"FilterCondition");
        JSONArray filterArr = new JSONArray();
        JSONObject filterObj = new JSONObject();
        filterObj.put("_Type_", (Object)"SimpleFilterRow");
        filterObj.put("RightBracket", (Object)"");
        filterObj.put("LeftBracket", (Object)"");
        filterObj.put("CompareType", (Object)"67");
        filterObj.put("Id", (Object)Base39Coder.toString((long)IDService.get().genLongId()));
        filterObj.put("Logic", (Object)"0");
        filterObj.put("FieldName", (Object)"vouchertype.number");
        JSONArray baseArr = new JSONArray();
        JSONObject baseObj = new JSONObject();
        baseObj.put("_Type_", (Object)"FilterValue");
        baseObj.put("Value", (Object)id);
        baseObj.put("Id", (Object)Base39Coder.toString((long)IDService.get().genLongId()));
        baseArr.add((Object)baseObj);
        JSONArray valueArr = new JSONArray();
        JSONObject valueObj = new JSONObject();
        valueObj.put("_Type_", (Object)"FilterValue");
        valueObj.put("Value", (Object)number);
        valueObj.put("Id", (Object)Base39Coder.toString((long)IDService.get().genLongId()));
        valueArr.add((Object)valueObj);
        filterObj.put("Value", (Object)valueArr);
        filterObj.put("BaseDataIds", (Object)baseArr);
        filterArr.add((Object)filterObj);
        condition.put("FilterRow", (Object)filterArr);
        HashMap<String, String> result = new HashMap<String, String>();
        String filterCondition = this.buildFilterCondition(filterArr);
        result.put("json", condition.toJSONString());
        result.put("name", filterCondition);
        return result;
    }

    private Long getItemIdByNumber(String number) {
        switch (number) {
            case "001": {
                return this.queryRuleByRule("01003");
            }
            case "002": {
                return this.queryRuleByRule("01004");
            }
            case "003": {
                return this.queryRuleByRule("01005");
            }
            case "004": {
                return this.queryRuleByRule("01005");
            }
            case "006": {
                return this.queryRuleByRule("01006");
            }
            case "005": {
                return this.queryRuleByRule("01008");
            }
            case "012": {
                return this.queryRuleByRule("03001");
            }
        }
        return this.queryRuleByRule(number);
    }

    private String getNewNumberByOldNumber(String number) {
        switch (number) {
            case "001": {
                return "01003";
            }
            case "002": {
                return "01004";
            }
            case "003": {
                return "01005";
            }
            case "004": {
                return "01005";
            }
            case "006": {
                return "01006";
            }
            case "005": {
                return "01008";
            }
            case "012": {
                return "03001";
            }
        }
        return number;
    }

    private Long queryRuleByRule(String number) {
        Long taxItemId = this.taxItemMap.get(number);
        if (null != taxItemId) {
            return taxItemId;
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)taxItemEntry, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (null == dynamicObject) {
            return 0L;
        }
        taxItemId = dynamicObject.getLong("id");
        this.taxItemMap.put(number, taxItemId);
        return taxItemId;
    }

    private Map<String, List<DynamicObject>> getRule(String entry) {
        DynamicObjectCollection allTaxItems = QueryServiceHelper.query((String)taxItemEntry, (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)this.allParams)});
        List allTaxItemIds = allTaxItems.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        Map<String, String> collect = allTaxItems.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e.getString("id")));
        this.numberMap = HashBiMap.create(collect);
        DynamicObjectCollection allRuleIdList = QueryServiceHelper.query((String)entry, (String)"id", (QFilter[])new QFilter[]{new QFilter("taxitem", "in", allTaxItemIds)});
        Object[] allRuleList = BusinessDataServiceHelper.load((Object[])allRuleIdList.stream().map(r -> r.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entry));
        DynamicObjectCollection taxItems = QueryServiceHelper.query((String)taxItemEntry, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)this.oldAddParams)});
        List taxItemIds = taxItems.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection ruleIdList = QueryServiceHelper.query((String)entry, (String)"id", (QFilter[])new QFilter[]{new QFilter("taxitem", "in", taxItemIds)});
        Object[] ruleList = BusinessDataServiceHelper.load((Object[])ruleIdList.stream().map(r -> r.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entry));
        HashMap<String, List<DynamicObject>> ruleMap = new HashMap<String, List<DynamicObject>>();
        ArrayList allRules = new ArrayList();
        CollectionUtils.addAll(allRules, (Object[])allRuleList);
        ruleMap.put("all", allRules);
        ArrayList rules = new ArrayList();
        CollectionUtils.addAll(rules, (Object[])ruleList);
        ruleMap.put("old", rules);
        return ruleMap;
    }
}

