/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.service.impl.upgrade;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.service.impl.upgrade.ConditionFilterUtils;

public class OldTaxitemFilterUpgrade
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(OldTaxitemFilterUpgrade.class);
    private static String contractRuleEntry = "tcsd_rule_yshtpz";
    private static String taxItemEntry = "tpo_tcsd_taxrateentry";
    private String[] allParams = new String[]{"01001", "01007", "01011"};

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)this.upData(), (String)"OldTaxitemFilterUpgrade_0", (String)"taxc-tcsd-mservice", (Object[])new Object[0]));
        return result;
    }

    private String upData() {
        List<DynamicObject> newRule = this.updateOldRuleFilter(this.getRule(contractRuleEntry));
        SaveServiceHelper.update((DynamicObject[])newRule.toArray(new DynamicObject[0]));
        return ResManager.loadKDString((String)"\u8d22\u4ea7\u884c\u4e3a\u7a0e\u89c4\u5219\u5361\u7247\u65b0\u589e\u6210\u529f", (String)"ContractRuleUpgradeService_1", (String)"taxc-tpo-mservice", (Object[])new Object[0]);
    }

    private List<DynamicObject> updateOldRuleFilter(DynamicObject[] ruleList) {
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(ruleList.length);
        for (DynamicObject rule : ruleList) {
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
            List collect = entryentity.stream().filter(e -> e.getDynamicObject("table").getLong("id") == 942515893462684672L).filter(entiry -> StringUtil.isNotBlank((CharSequence)entiry.getString("conditionjson"))).filter(e -> e.getString("conditionjson").contains("vouchertype.number")).collect(Collectors.toList());
            if (collect.size() <= 0) continue;
            for (DynamicObject dynamicObject : collect) {
                String conditionJson = dynamicObject.getString("conditionjson");
                Map<String, String> resultMap = this.changedFilter(conditionJson);
                dynamicObject.set("conditionjson", (Object)resultMap.get("json"));
                dynamicObject.set("filtercondition", (Object)resultMap.get("name"));
            }
            rule.set("entryentity", (Object)entryentity);
            newList.add(rule);
        }
        return newList;
    }

    private Map<String, String> changedFilter(String conditionJson) {
        HashMap<String, String> result = new HashMap<String, String>();
        JSONObject conditionjJson = JSONObject.parseObject((String)conditionJson);
        JSONArray filterRowArr = conditionjJson.getJSONArray("FilterRow");
        int arrSize = filterRowArr.size();
        for (int i = 0; i < arrSize; ++i) {
            JSONObject jsonObject = filterRowArr.getJSONObject(i);
            String fieldName = jsonObject.getString("FieldName");
            if (!"vouchertype.number".equals(fieldName)) continue;
            JSONArray value = jsonObject.getJSONArray("Value");
            String code = value.getJSONObject(0).getString("Value");
            String number = this.getNewNumberByOldNumber(code);
            value.getJSONObject(0).put("Value", (Object)number);
            JSONArray baseDataIds = jsonObject.getJSONArray("BaseDataIds");
            baseDataIds.getJSONObject(0).put("Value", (Object)this.queryRuleByRule(number));
        }
        String filtercondition = ConditionFilterUtils.buildFilterCondition(filterRowArr, "tdm_stamptax_voucher");
        result.put("json", conditionjJson.toJSONString());
        result.put("name", filtercondition);
        return result;
    }

    private String getNewNumberByOldNumber(String number) {
        switch (number) {
            case "008": {
                return "01001";
            }
            case "009": {
                return "01011";
            }
            case "010": {
                return "01007";
            }
        }
        return number;
    }

    private Long queryRuleByRule(String number) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)taxItemEntry, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (null == dynamicObject) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    private DynamicObject[] getRule(String entry) {
        DynamicObjectCollection allTaxItems = QueryServiceHelper.query((String)taxItemEntry, (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)this.allParams)});
        List allTaxItemIds = allTaxItems.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection allRuleIdList = QueryServiceHelper.query((String)entry, (String)"id", (QFilter[])new QFilter[]{new QFilter("taxitem", "in", allTaxItemIds)});
        return BusinessDataServiceHelper.load((Object[])allRuleIdList.stream().map(r -> r.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entry));
    }
}

