/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.assist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class AssistEntryListService {
    public static final String ENTITY = "entity";
    public static final String KEY = "key";
    public static final Map<String, List<String>> FIELD_HIDE_LIST = new HashMap<String, List<String>>();

    public static List<String> getFieldHideList(String cellId) {
        List<String> list;
        Map<String, String> cellData = AssistEntryListService.getCellData(cellId);
        String entity = cellData.get(ENTITY);
        if (StringUtil.isNotBlank((CharSequence)entity) && (list = FIELD_HIDE_LIST.get(entity)) != null) {
            return list;
        }
        return new ArrayList<String>();
    }

    public static String getKeyName(String cellId) {
        List fieldList;
        Optional<EntityField> field;
        EntityInfo metadata;
        Map<String, String> cellData = AssistEntryListService.getCellData(cellId);
        String entity = cellData.get(ENTITY);
        String key = cellData.get(KEY);
        if (StringUtil.isNotBlank((CharSequence)entity) && StringUtil.isNotBlank((CharSequence)key) && (metadata = MetadataUtil.getEntityById((String)entity)) != null && (field = (fieldList = metadata.getFieldList()).stream().filter(e -> key.equals(e.getFieldId())).findFirst()).isPresent()) {
            return field.get().getFieldName();
        }
        return null;
    }

    public static Map<String, String> getCellData(String cellId) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtil.isNotBlank((CharSequence)cellId)) {
            String entity = cellId.substring(0, cellId.indexOf("#"));
            result.put(ENTITY, entity);
            String key = cellId.substring(cellId.lastIndexOf("#") + 1);
            result.put(KEY, key);
        }
        return result;
    }

    static {
        FIELD_HIDE_LIST.put("tcvat_ybnsr_trccfhdncp", Arrays.asList("policy", "filterwhere", "startdate", "enddate"));
        FIELD_HIDE_LIST.put("tcvat_ybnsr_gjncpzjxshd", Arrays.asList("policy", "filterwhere", "startdate", "enddate"));
    }
}

