/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.declare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.enums.PayRecordTaxtypeEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.common.vo.ResultResponse;
import org.apache.commons.collections.CollectionUtils;

public class DeclarePayServiceHelper {
    private static Log logger = LogFactory.getLog(DeclarePayServiceHelper.class);
    public static final String PAY_RECORD_ENTITY = "bdtaxr_pay_record";
    private static final String SPLIT = "_";
    private static final Map<String, String> ZSPM_TAXTYPE_MAP = new HashMap<String, String>();

    public static ResultResponse setElectrictaxnoAndYspzno(List<Map<String, Object>> payInfoList) {
        try {
            logger.info("\u5f00\u59cb\u6267\u884c\u7a0e\u91d1\u7f34\u7eb3\u5355\u51ed\u8bc1\u53cd\u5199" + SerializationUtils.toJsonString(payInfoList));
            DynamicObject[] payRecords = DeclarePayServiceHelper.queryPayRecordByOrgAndTaxtype(payInfoList);
            Map<Long, String> zsxmMap = DeclarePayServiceHelper.queryZsxmName(payInfoList);
            Map<String, List<DynamicObject>> payRecordMap = Arrays.stream(payRecords).collect(Collectors.groupingBy(a -> a.get("org.id") + SPLIT + a.get("taxtype") + SPLIT + DateUtils.format((Date)a.getDate("skssqq")) + SPLIT + DateUtils.format((Date)a.getDate("skssqz"))));
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
            ArrayList resultList = new ArrayList();
            StringBuilder message = new StringBuilder();
            for (Map<String, Object> payInfo : payInfoList) {
                String msg;
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                String payInfoKeyByZsxm = payInfo.get("org") + SPLIT + PayRecordTaxtypeEnum.getTaxtypeByBaseTaxId((String)String.valueOf(payInfo.get("zsxm"))) + SPLIT + DateUtils.format((Date)((Date)payInfo.get("skssqq"))) + SPLIT + DateUtils.format((Date)((Date)payInfo.get("skssqz")));
                String payInfoKeyByZspm = payInfo.get("org") + SPLIT + DeclarePayServiceHelper.mappingTaxtypeByZspm(String.valueOf(payInfo.get("zspm"))) + SPLIT + DateUtils.format((Date)((Date)payInfo.get("skssqq"))) + SPLIT + DateUtils.format((Date)((Date)payInfo.get("skssqz")));
                List<DynamicObject> payRecordList = payRecordMap.get(payInfoKeyByZsxm);
                if (CollectionUtils.isEmpty(payRecordList)) {
                    payRecordList = payRecordMap.get(payInfoKeyByZspm);
                }
                if (CollectionUtils.isEmpty(payRecordList)) {
                    msg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u81f3%4$s\u3011\u51ed\u8bc1\u53cd\u5199\u5931\u8d25\uff1a\u8be5\u7a0e\u52a1\u7ec4\u7ec7\u5728\u5bf9\u5e94\u7684\u6240\u5c5e\u671f\u4e2d\u65e0\u8be5\u5f81\u6536\u9879\u76ee\u7684\u7f34\u6b3e\u5355\n", (String)"DeclarePayServiceHelper_0", (String)"taxc-tpo", (Object[])new Object[0]), String.valueOf(payInfo.get("orgname")), String.valueOf(zsxmMap.get(payInfo.get("zsxm"))), DateUtils.format((Date)((Date)payInfo.get("skssqq"))), DateUtils.format((Date)((Date)payInfo.get("skssqz"))));
                    resultMap.put("msg", msg);
                    resultMap.put("id", payInfo.get("id"));
                    resultList.add(resultMap);
                    message.append(msg);
                } else if (payRecordList.size() > 1) {
                    msg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u81f3%4$s\u3011\u51ed\u8bc1\u53cd\u5199\u5931\u8d25\uff1a\u8be5\u7a0e\u52a1\u7ec4\u7ec7\u5728\u5bf9\u5e94\u7684\u6240\u5c5e\u671f\u4e2d\u5b58\u5728\u591a\u5f20\u8be5\u5f81\u6536\u9879\u76ee\u7684\u7f34\u6b3e\u5355\uff0c\u65e0\u6cd5\u5339\u914d\n", (String)"DeclarePayServiceHelper_1", (String)"taxc-tpo", (Object[])new Object[0]), String.valueOf(payInfo.get("orgname")), String.valueOf(zsxmMap.get(payInfo.get("zsxm"))), DateUtils.format((Date)((Date)payInfo.get("skssqq"))), DateUtils.format((Date)((Date)payInfo.get("skssqz"))));
                    resultMap.put("msg", msg);
                    resultMap.put("id", payInfo.get("id"));
                    resultList.add(resultMap);
                    message.append(msg);
                } else {
                    DynamicObject payRecord = payRecordList.get(0);
                    if (StringUtil.isNotBlank((CharSequence)String.valueOf(payInfo.get("dzsph")))) {
                        payRecord.set("electrictaxno", payInfo.get("dzsph"));
                    }
                    if (StringUtil.isNotBlank((CharSequence)String.valueOf(payInfo.get("yzpzxh")))) {
                        payRecord.set("yspzno", payInfo.get("yzpzxh"));
                    }
                    updateList.add(payRecord);
                }
                logger.info("\u7a0e\u91d1\u7f34\u7eb3\u5355\u51ed\u8bc1\u53cd\u5199\u5f81\u6536\u9879\u76ee\u952e:" + payInfoKeyByZsxm);
                logger.info("\u7a0e\u91d1\u7f34\u7eb3\u5355\u51ed\u8bc1\u53cd\u5199\u5f81\u6536\u54c1\u76ee\u952e:" + payInfoKeyByZspm);
            }
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            if (CollectionUtils.isNotEmpty(resultList)) {
                return ResultResponse.fail(message.toString(), resultList);
            }
            logger.info("\u7a0e\u91d1\u7f34\u7eb3\u5355\u51ed\u8bc1\u53cd\u5199\u6210\u529f");
            return ResultResponse.success("success", resultList);
        }
        catch (Exception e) {
            logger.info("\u7a0e\u91d1\u7f34\u7eb3\u5355\u51ed\u8bc1\u53cd\u5199\u5f02\u5e38\uff1a" + e.getMessage());
            return ResultResponse.fail(e.getMessage(), new ArrayList());
        }
    }

    private static String mappingTaxtypeByZspm(String zspmId) {
        if (ZSPM_TAXTYPE_MAP.containsKey(zspmId)) {
            return ZSPM_TAXTYPE_MAP.get(zspmId);
        }
        return "";
    }

    private static DynamicObject[] queryPayRecordByOrgAndTaxtype(List<Map<String, Object>> payInfoList) {
        List orgIdList = payInfoList.stream().map(a -> a.get("org")).collect(Collectors.toList());
        List zsxmList = payInfoList.stream().map(a -> PayRecordTaxtypeEnum.getTaxtypeByBaseTaxId((String)String.valueOf(a.get("zsxm")))).collect(Collectors.toList());
        List zspmList = payInfoList.stream().map(a -> DeclarePayServiceHelper.mappingTaxtypeByZspm(String.valueOf(a.get("zspm")))).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        QFilter taxtypeFilter = new QFilter("taxtype", "in", zsxmList).or(new QFilter("taxtype", "in", zspmList));
        QFilter[] qFilters = new QFilter[]{orgFilter, taxtypeFilter};
        List pkids = QueryServiceHelper.queryPrimaryKeys((String)PAY_RECORD_ENTITY, (QFilter[])qFilters, null, (int)-1);
        DynamicObject[] payRecords = BusinessDataServiceHelper.load((Object[])pkids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)PAY_RECORD_ENTITY));
        return payRecords;
    }

    private static Map<Long, String> queryZsxmName(List<Map<String, Object>> payInfoList) {
        List zsxmList = payInfoList.stream().map(a -> a.get("zsxm")).collect(Collectors.toList());
        DynamicObjectCollection zspm = QueryServiceHelper.query((String)"bd_taxcategory", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", zsxmList)});
        Map<Long, String> zsxmMap = zspm.stream().collect(Collectors.toMap(a -> a.getLong("id"), b -> b.getString("name"), (m, n) -> m));
        return zsxmMap;
    }

    static {
        ZSPM_TAXTYPE_MAP.put(String.valueOf(ZspmConstant.ID_CZLJCLF_ZPSM), "ljclf");
        ZSPM_TAXTYPE_MAP.put(String.valueOf(ZspmConstant.ID_GHJH_ZPSM), "ghjf");
        ZSPM_TAXTYPE_MAP.put(String.valueOf(ZspmConstant.ID_GHCBJ_ZPSM), "ghcbj");
        ZSPM_TAXTYPE_MAP.put(String.valueOf(ZspmConstant.ID_CSSHLJCZF_ZPSM), "ljclf");
        ZSPM_TAXTYPE_MAP.put(String.valueOf(ZspmConstant.ID_DFSLJSJJ_ZPSM), "sljsjj");
        ZSPM_TAXTYPE_MAP.put(String.valueOf(ZspmConstant.ID_DWFHF_ZPSM), "dwfhf");
    }
}

