/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.declare;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.DeclareMainDataParamsDto;
import kd.taxc.bdtaxr.common.dto.DeclareMainTableQueryDto;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import org.apache.commons.collections.CollectionUtils;

public class NxxDeclareMainService {
    public static DynamicObject[] queryDeclareMain(DeclareMainDataParamsDto mainParams) {
        QFilter[] qFilters;
        switch (mainParams.getTaxType()) {
            case "qysds": {
                qFilters = NxxDeclareMainService.doSetQysdsNxxFilters(mainParams);
                break;
            }
            default: {
                qFilters = new QFilter[]{};
            }
        }
        return BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"id,org,skssqq,skssqz,type,billstatus", (QFilter[])qFilters);
    }

    public static Long queryDeclareMainId(List<QFilter> filterList) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
        return obj == null ? 0L : obj.getLong("id");
    }

    public static DynamicObject queryDeclareMainById(Long sbbId) {
        return BusinessDataServiceHelper.loadSingle((Object)sbbId, (String)"tcvat_nsrxx");
    }

    public static DynamicObject[] queryDeclareMainByIds(List<Long> sbbIds) {
        return BusinessDataServiceHelper.load((Object[])sbbIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx"));
    }

    private static QFilter[] doSetQysdsNxxFilters(DeclareMainDataParamsDto mainParams) {
        QFilter orgFilter = new QFilter("org", "=", (Object)mainParams.getOrgId());
        QFilter dateFilter = new QFilter("skssqq", ">=", (Object)mainParams.getStartDate()).and(new QFilter("skssqz", "<=", (Object)mainParams.getEndDate()));
        QFilter typeFilter = new QFilter("type", "=", (Object)mainParams.getDeclareType());
        return new QFilter[]{orgFilter, dateFilter, typeFilter};
    }

    public static DynamicObject queryLastDeclareMainWithinTaxPeriod(DeclareMainDataParamsDto mainParams) {
        DynamicObject[] mianObjs = NxxDeclareMainService.queryDeclareMain(mainParams);
        if (mianObjs.length == 0) {
            return null;
        }
        Optional<DynamicObject> first = Arrays.stream(mianObjs).filter(o -> NxxDeclareMainService.isTaxPeriodEquals(mainParams, o)).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        DynamicObject mainObj = mianObjs[0];
        for (DynamicObject obj : mianObjs) {
            if (!obj.getDate("skssqz").after(mainObj.getDate("skssqz"))) continue;
            mainObj = obj;
        }
        return mainObj;
    }

    private static boolean isTaxPeriodEquals(DeclareMainDataParamsDto mainParams, DynamicObject obj) {
        return mainParams.getStartDate().equals(obj.getDate("skssqq")) && mainParams.getEndDate().equals(obj.getDate("skssqz"));
    }

    public static Map<Long, String> getModelVersionByIds(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{filter});
        return dynamicObjects.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> ModelVersionEnum.MODEL2.getVersion()));
    }

    public static DynamicObject[] queryDeclareMainTable(DeclareMainTableQueryDto queryDto) {
        QFilter filter = NxxDeclareMainService.doSetDeclareMainTableQFilter(queryDto);
        String selectProperties = MetadataUtil.getAllFieldToQuery((String)"tcvat_nsrxx");
        return BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)selectProperties, (QFilter[])new QFilter[]{filter});
    }

    private static QFilter doSetDeclareMainTableQFilter(DeclareMainTableQueryDto queryDto) {
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getOrgIds())) {
            filter.and(new QFilter("org.id", "in", (Object)queryDto.getOrgIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getTypes())) {
            filter.and(new QFilter("type", "in", (Object)queryDto.getTypes()));
        }
        if (ObjectUtils.isNotEmpty((Object)queryDto.getCreateTime()) && queryDto.getCreateTime().length > 1) {
            if (queryDto.getCreateTime()[0] != null) {
                filter.and(new QFilter("createtime", ">=", (Object)queryDto.getCreateTime()[0]));
            }
            if (queryDto.getCreateTime()[1] != null) {
                filter.and(new QFilter("createtime", "<=", (Object)queryDto.getCreateTime()[1]));
            }
        }
        if (ObjectUtils.isNotEmpty((Object)queryDto.getSbsq()) && queryDto.getSbsq().length > 1) {
            if (queryDto.getSbsq()[0] != null) {
                filter.and(new QFilter("skssqq", ">=", (Object)queryDto.getSbsq()[0]));
            }
            if (queryDto.getSbsq()[1] != null) {
                filter.and(new QFilter("skssqq", "<=", (Object)queryDto.getSbsq()[1]));
            }
        }
        if (ObjectUtils.isNotEmpty((Object)queryDto.getSbrq()) && queryDto.getSbrq().length > 1) {
            if (queryDto.getSbrq()[0] != null) {
                filter.and(new QFilter("sbrq", ">=", (Object)queryDto.getSbrq()[0]));
            }
            if (queryDto.getSbrq()[1] != null) {
                filter.and(new QFilter("sbrq", "<=", (Object)queryDto.getSbrq()[1]));
            }
        }
        if (ObjectUtils.isNotEmpty((Object)queryDto.getPayDate()) && queryDto.getPayDate().length > 1) {
            if (queryDto.getPayDate()[0] != null) {
                filter.and(new QFilter("paydate", ">=", (Object)queryDto.getPayDate()[0]));
            }
            if (queryDto.getPayDate()[1] != null) {
                filter.and(new QFilter("paydate", "<=", (Object)queryDto.getPayDate()[1]));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getBillStatus())) {
            filter.and(new QFilter("billstatus", "in", (Object)queryDto.getBillStatus()));
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getDeclareStatus())) {
            filter.and(new QFilter("declarestatus", "in", (Object)queryDto.getDeclareStatus()));
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getPayStatus())) {
            filter.and(new QFilter("paystatus", "in", (Object)queryDto.getPayStatus()));
        }
        return filter;
    }
}

