/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.formula;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class FormulaService {
    public static final String fields = "formulakey,table,row,column,formula,title,content,celltype,formulatype,formulaname,name,describe";
    public static final String entry = "tpo_formula_edit";
    public static final String CELL_TYPE_F7 = "5";
    public static final String CELL_TYPE_COMBO = "4";
    public static final String CELL_TYPE_COMBOS = "3";

    public static FormulaVo getCellFormula(String tmpId, String cellKey) {
        QFilter filter1 = new QFilter("templateid", "=", (Object)tmpId);
        QFilter filter2 = new QFilter("formulakey", "=", (Object)cellKey);
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((String)entry, (String)fields, (QFilter[])new QFilter[]{filter1, filter2});
        return dynObj != null ? FormulaService.buildFormulaVo(dynObj) : null;
    }

    private static FormulaVo buildFormulaVo(DynamicObject dynObj) {
        FormulaVo formulaVo = new FormulaVo();
        String key = dynObj.getString("formulakey");
        String formula = dynObj.getString("formula");
        formulaVo.setFormula(formula);
        formulaVo.setFormulaKey(key);
        formulaVo.setFormulaType(dynObj.getString("formulatype"));
        formulaVo.setCellType(dynObj.getString("celltype"));
        String formulaname = dynObj.getString("formulaname");
        formulaVo.setFormulaName(StringUtil.isNotEmpty((CharSequence)formulaname) ? formulaname.replace("\t", "") : formulaname);
        formulaVo.setContent(dynObj.getString("content"));
        String title = dynObj.getString("title");
        formulaVo.setTitle(title);
        formulaVo.setName(dynObj.getString("name"));
        formulaVo.setTable(dynObj.getString("table"));
        formulaVo.setRow(dynObj.getString("row"));
        formulaVo.setColumn(dynObj.getString("column"));
        formulaVo.setDescribe(dynObj.getString("describe"));
        return formulaVo;
    }
}

