/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.formula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicCustomFormulaPlugin;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.formula.FormulaUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class MultiDynamicRowCheckFormulaService {
    private static Log logger = LogFactory.getLog(MultiDynamicRowCheckFormulaService.class);

    public Map<String, List<FormulaVo>> generateDynCheckFormula(Map<String, List<FormulaVo>> formulas, List<DynamicRowModel> dynList) {
        long time = System.currentTimeMillis();
        if (dynList != null && dynList.size() > 0) {
            Map<String, Map<String, List<FormulaVo>>> formulaMap = this.parseCheckFormula(formulas, dynList);
            Map<String, List<FormulaVo>> sum = MultiDynamicRowCheckFormulaService.sumFormula(formulaMap.get("sum"), dynList);
            formulas.putAll(sum);
            Map<String, List<FormulaVo>> customFormula = formulaMap.get("dynRowCustomFormula");
            Map<String, List<FormulaVo>> map = MultiDynamicRowCheckFormulaService.getCustomFormulas(customFormula, null, dynList);
            if (formulas != null && customFormula != null) {
                for (String key : customFormula.keySet()) {
                    formulas.remove(key);
                }
            }
            formulas.putAll(map);
            Map<String, List<FormulaVo>> seqMap = MultiDynamicRowCheckFormulaService.seqFormula(formulaMap.get("seq"), dynList);
            formulas.putAll(seqMap);
            Map<String, List<FormulaVo>> copyMap = MultiDynamicRowCheckFormulaService.copyFormula(formulaMap.get("copy"), dynList);
            formulas.putAll(copyMap);
        }
        if (dynList != null && formulas != null) {
            Map<String, List<DynamicRowModel>> nulldynlisMap = dynList.stream().filter(a -> EmptyCheckUtils.isEmpty((Object)a.getRowList())).collect(Collectors.groupingBy(a -> a.getDynRowNo()));
            List<String> list = formulas.keySet().stream().filter(a -> a.contains("#") && nulldynlisMap.containsKey(a.substring(0, a.lastIndexOf("#")))).collect(Collectors.toList());
            list.forEach(a -> {
                List cfr_ignored_0 = (List)formulas.remove(a);
            });
        }
        if (formulas == null || formulas.isEmpty()) {
            return formulas;
        }
        HashMap<String, List<FormulaVo>> normalFormulas = new HashMap<String, List<FormulaVo>>(formulas.size());
        HashMap<String, List<FormulaVo>> customFormulas = new HashMap<String, List<FormulaVo>>(16);
        for (Map.Entry entry : formulas.entrySet()) {
            String key = (String)entry.getKey();
            List formulaVos = (List)entry.getValue();
            for (FormulaVo formulaVo : formulaVos) {
                if (StringUtil.isNotBlank((CharSequence)key) && formulaVo.getFormula() != null && !formulaVo.getFormula().trim().startsWith("{[DynRowCustomFormula]")) {
                    normalFormulas.computeIfAbsent(key, k -> new ArrayList(1)).add(formulaVo);
                    continue;
                }
                customFormulas.computeIfAbsent(key, k -> new ArrayList(1)).add(formulaVo);
            }
        }
        if (!customFormulas.isEmpty()) {
            Map<String, List<FormulaVo>> dynRowCustomFormulas = MultiDynamicRowCheckFormulaService.getCustomFormulas(customFormulas, null, dynList);
            normalFormulas.putAll(dynRowCustomFormulas);
        }
        logger.info("\u52a8\u6001\u751f\u6210\u516c\u5f0f\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return normalFormulas;
    }

    private Map<String, Map<String, List<FormulaVo>>> parseCheckFormula(Map<String, List<FormulaVo>> formulas, List<DynamicRowModel> dynList) {
        HashMap<String, Map<String, List<FormulaVo>>> result = new HashMap<String, Map<String, List<FormulaVo>>>();
        HashMap<String, List> sumFormulas = new HashMap<String, List>();
        HashMap<String, List> seqFormulas = new HashMap<String, List>();
        HashMap<String, List> copyFormulas = new HashMap<String, List>();
        HashMap<String, List> dynRowCustomFormulas = new HashMap<String, List>();
        Iterator<Map.Entry<String, List<FormulaVo>>> it = formulas.entrySet().iterator();
        ArrayList<String> formulaList = new ArrayList<String>();
        while (it.hasNext()) {
            Map.Entry<String, List<FormulaVo>> entry = it.next();
            String key = (String)entry.getKey();
            List formulaVos = (List)entry.getValue();
            for (FormulaVo formulaVo : formulaVos) {
                try {
                    if (!StringUtil.isNotBlank((CharSequence)key) || formulaVo.getFormula() == null || formulaVo.getFormula().trim().startsWith("{[DynRowCustomFormula]") || !MultiDynamicRowCheckFormulaService.isDelKey(dynList, key)) continue;
                    formulaList.add(key);
                }
                catch (Exception e) {
                    logger.error("\u516c\u5f0f\u5b58\u5728\u5f02\u5e38\u6570\u636e{}", (Object)(formulaVo == null ? null : formulaVo.toString()));
                    throw e;
                }
            }
        }
        for (String key : formulaList) {
            formulas.remove(key);
        }
        for (Map.Entry<String, List<FormulaVo>> entry : formulas.entrySet()) {
            String key = entry.getKey();
            List<FormulaVo> formulaVos = entry.getValue();
            for (FormulaVo formulaVo : formulaVos) {
                String formula = formulaVo.getFormula();
                if (!StringUtil.isNotBlank((CharSequence)key) || formula == null) continue;
                if (FormulaUtils.isSumFormula((String)StringUtil.formatStringNoBlank((String)formula))) {
                    sumFormulas.computeIfAbsent(key, k -> new ArrayList(1)).add(formulaVo);
                    continue;
                }
                if (formula.trim().startsWith("seq")) {
                    seqFormulas.computeIfAbsent(key, k -> new ArrayList(1)).add(formulaVo);
                    continue;
                }
                if (formula.trim().startsWith("{[DynRowCustomFormula]")) {
                    dynRowCustomFormulas.computeIfAbsent(key, k -> new ArrayList(1)).add(formulaVo);
                    continue;
                }
                if (MultiDynamicRowCheckFormulaService.matchDyn(dynList, key) == null) continue;
                copyFormulas.computeIfAbsent(key, k -> new ArrayList(1)).add(formulaVo);
            }
        }
        result.put("sum", sumFormulas);
        result.put("seq", seqFormulas);
        result.put("copy", copyFormulas);
        result.put("dynRowCustomFormula", dynRowCustomFormulas);
        return result;
    }

    public static Map<String, List<FormulaVo>> copyFormula(Map<String, List<FormulaVo>> formulas, List<DynamicRowModel> dynList) {
        HashMap<String, List<FormulaVo>> result = new HashMap<String, List<FormulaVo>>();
        if (formulas == null || CollectionUtils.isEmpty(dynList)) {
            return result;
        }
        formulas.values().stream().flatMap(r -> r.stream()).forEach(v -> {
            String formula = v.getFormula();
            String formulaKey = v.getFormulaKey();
            Map<String, FormulaVo> map = MultiDynamicRowCheckFormulaService.copyFormula(MultiDynamicRowCheckFormulaService.matchDyn(dynList, formulaKey), v, dynList);
            logger.info("\u52a8\u6001\u884c\u590d\u5236\u516c\u5f0f\uff0c\u539f\u516c\u5f0f\u4e3a\uff1a" + formula + "\uff0c\u590d\u5236\u540e\u7684\u516c\u5f0f\u4e3a\uff1a" + map.toString());
            for (Map.Entry<String, FormulaVo> entry : map.entrySet()) {
                List formulaVos = result.computeIfAbsent(entry.getKey(), k -> new ArrayList(1));
                formulaVos.add(entry.getValue());
            }
        });
        return result;
    }

    private static Map<String, FormulaVo> copyFormula(DynamicRowModel rowModel, FormulaVo srcFormulaVo, List<DynamicRowModel> dynList) {
        List rowList = rowModel.getRowList();
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>(CollectionUtils.isEmpty((Collection)rowList) ? 0 : rowList.size());
        String formula = srcFormulaVo.getFormula();
        String formulaKey = srcFormulaVo.getFormulaKey();
        if (StringUtil.isBlank((CharSequence)formula) || StringUtil.isBlank((CharSequence)formulaKey)) {
            return result;
        }
        if (!CollectionUtils.isEmpty((Collection)rowList)) {
            long startRow = rowModel.getStartRow();
            for (int i = 0; i < rowList.size(); ++i) {
                String newKey = MultiDynamicRowCheckFormulaService.getNewKey(formulaKey, (long)i + startRow);
                String formulaTemp = MultiDynamicRowCheckFormulaService.handleCopyFormula(formula, formulaKey, rowModel, (long)i + startRow, dynList);
                result.put(newKey, MultiDynamicRowCheckFormulaService.bulidFormulaVo(newKey, formulaTemp, srcFormulaVo));
            }
        }
        return result;
    }

    private static String handleCopyFormula(String formula, String formulaKey, DynamicRowModel rowModel, long rowIndex, List<DynamicRowModel> dynList) {
        List list = ParseUtils.parseformula((String)formula);
        String formulaTemp = formula;
        String tableName = rowModel.getDynRowNo().split("#")[0];
        for (String formulaStr : list) {
            String newKey;
            Map map = ParseUtils.parseFormulaZKH((String)formulaStr);
            String key = ParseUtils.getValue((Map)map);
            String type = ParseUtils.getType((Map)map);
            if ("Q".equals(type) && MultiDynamicRowCheckFormulaService.matchDyn(dynList, key) != null) {
                formulaTemp = formulaTemp.replaceAll("Q\\[" + key + "\\]", "Q\\[" + MultiDynamicRowCheckFormulaService.getNewKey(key, rowIndex) + "\\]");
            }
            if (!"P".equals(type) || !key.contains("#")) continue;
            String[] ary = key.split("#");
            formulaTemp = newKey = MultiDynamicRowCheckFormulaService.getJoinKey("#", ary[0], rowIndex, ary[ary.length - 1]);
        }
        return formulaTemp;
    }

    public static Map<String, List<FormulaVo>> seqFormula(Map<String, List<FormulaVo>> formulas, List<DynamicRowModel> dynList) {
        HashMap<String, List<FormulaVo>> result = new HashMap<String, List<FormulaVo>>();
        if (formulas == null || CollectionUtils.isEmpty(dynList)) {
            return result;
        }
        long seqNo = 1L;
        String groupNo = "";
        String seq = "";
        for (DynamicRowModel rowModel : dynList) {
            List<FormulaVo> formulaList = MultiDynamicRowCheckFormulaService.findSeqFormulaVo(rowModel.getDynRowNo(), formulas);
            if (null == formulaList || formulaList.size() == 0) continue;
            for (FormulaVo formulaVo : formulaList) {
                String formula = formulaVo.getFormula();
                String formulaKey = formulaVo.getFormulaKey();
                if (StringUtil.isBlank((CharSequence)groupNo) || !groupNo.equals(rowModel.getGroupNo())) {
                    seqNo = 1L;
                }
                groupNo = rowModel.getGroupNo();
                List rowList = rowModel.getRowList();
                if (CollectionUtils.isEmpty((Collection)rowList)) continue;
                long startRow = rowModel.getStartRow();
                if (formula.substring(0, 4).equalsIgnoreCase("seq(") && formula.substring(formula.length() - 1).equalsIgnoreCase(")")) {
                    seq = formula.replace("seq(", "");
                    seq = seq.replace(")", "");
                }
                seqNo = MultiDynamicRowCheckFormulaService.getDefaultSeqNo(seq);
                for (int i = 0; i < rowList.size(); ++i) {
                    String newKey = MultiDynamicRowCheckFormulaService.getNewKey(formulaKey, (long)i + startRow);
                    if (seq.equals("00000001")) {
                        String zeroPrefix = "00000000".substring(0, 8 - String.valueOf(seqNo).length());
                        formula = "{C[" + zeroPrefix + seqNo + "]}";
                    } else {
                        formula = "{C[" + (seq.contains(".") ? seq.split("\\.")[0] + "." : "") + seqNo + "]}";
                    }
                    result.computeIfAbsent(newKey, k -> new ArrayList(1)).add(MultiDynamicRowCheckFormulaService.bulidFormulaVo(newKey, formula, formulaVo.getFormulaType()));
                    ++seqNo;
                }
            }
        }
        return result;
    }

    private static long getDefaultSeqNo(String seq) {
        long seqNo = 1L;
        if (StringUtil.isBlank((CharSequence)seq)) {
            return seqNo;
        }
        if (seq.contains(".")) {
            String[] seqs = seq.split("\\.");
            try {
                return Long.parseLong(seqs[seqs.length - 1]);
            }
            catch (Exception e) {
                logger.error("\u5e8f\u53f7\u516c\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + e.getMessage());
            }
        }
        if (seq.equals("00000001")) {
            return seqNo;
        }
        try {
            return Long.parseLong(seq);
        }
        catch (Exception e) {
            logger.error("\u5e8f\u53f7\u516c\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + e.getMessage());
            return seqNo;
        }
    }

    private static List<FormulaVo> findSeqFormulaVo(String dynRowNo, Map<String, List<FormulaVo>> formulas) {
        ArrayList<FormulaVo> formulaList = new ArrayList<FormulaVo>(1);
        for (Map.Entry<String, List<FormulaVo>> entry : formulas.entrySet()) {
            List<FormulaVo> formulaVos = entry.getValue();
            for (FormulaVo formulaVo : formulaVos) {
                if (!formulaVo.getFormulaKey().startsWith(dynRowNo) || !formulaVo.getFormula().contains("seq")) continue;
                formulaList.add(formulaVo);
            }
        }
        return formulaList;
    }

    @Deprecated
    private static FormulaVo bulidFormulaVo(String newKey, String formulaTemp, String formulaType) {
        FormulaVo formulaVo = new FormulaVo();
        formulaVo.setFormulaKey(newKey);
        formulaVo.setFormulaType(StringUtil.isBlank((CharSequence)formulaType) ? "1" : formulaType);
        formulaVo.setFormula(formulaTemp);
        formulaVo.setFormulaName(formulaTemp);
        return formulaVo;
    }

    private static FormulaVo bulidFormulaVo(String newKey, String formulaTemp, FormulaVo formula) {
        FormulaVo formulaVo = new FormulaVo();
        formulaVo.setFormulaKey(newKey);
        formulaVo.setFormulaType(StringUtil.isBlank((CharSequence)formula.getFormulaType()) ? "1" : formula.getFormulaType());
        formulaVo.setFormula(formulaTemp);
        formulaVo.setFormulaName(formulaTemp);
        formulaVo.setContent(formula.getContent());
        formulaVo.setTitle(formula.getTitle());
        return formulaVo;
    }

    public static Map<String, List<FormulaVo>> sumFormula(Map<String, List<FormulaVo>> formulas, List<DynamicRowModel> dynList) {
        HashMap<String, List<FormulaVo>> result = new HashMap<String, List<FormulaVo>>();
        if (formulas == null) {
            return result;
        }
        formulas.values().stream().flatMap(r -> r.stream()).forEach(v -> {
            String key = v.getFormulaKey();
            String sumFormula = StringUtil.formatStringNoBlank((String)v.getFormula());
            List sumFormulas = FormulaUtils.getSumFormula((String)sumFormula);
            for (String f : sumFormulas) {
                List sumMatchKey = FormulaUtils.getMatchKeyList((String)f);
                List<String> list = MultiDynamicRowCheckFormulaService.getSumFormulaList(dynList, sumMatchKey, key, f);
                if (CollectionUtils.isEmpty(list)) continue;
                StringBuilder formula = new StringBuilder();
                for (int i = 0; i < list.size(); ++i) {
                    if (i == list.size() - 1) {
                        formula.append("{Q[").append(list.get(i)).append("]}");
                        continue;
                    }
                    formula.append("{Q[").append(list.get(i)).append("]}, ");
                }
                sumFormula = sumFormula.replace(f, " sum(" + formula + ")");
            }
            v.setFormula(sumFormula);
            v.setParsed(false);
            result.computeIfAbsent(key, k -> new ArrayList(1)).add(v);
        });
        return result;
    }

    public static Map<String, List<FormulaVo>> getCustomFormulas(Map<String, List<FormulaVo>> formulas, DeclareRequestModel requestModel, List<DynamicRowModel> dynList) {
        HashMap<String, List<FormulaVo>> result = new HashMap<String, List<FormulaVo>>();
        if (formulas == null) {
            return result;
        }
        formulas.values().stream().flatMap(r -> r.stream()).forEach(v -> {
            String formula = v.getFormula();
            String pluginName = formula.replace("[DynRowCustomFormula]", "").replace("{", "").replace("}", "");
            logger.info("\u516c\u5f0f\u5904\u7406\u540e\u7684\u81ea\u5b9a\u4e49\u63d2\u4ef6\u4e3a\uff1a{}", (Object)pluginName);
            String resultFlag = "0";
            if (StringUtil.isNotEmpty((CharSequence)pluginName)) {
                try {
                    Class<?> aClass = Class.forName(pluginName);
                    if (AbstractDynamicCustomFormulaPlugin.class.isAssignableFrom(aClass)) {
                        AbstractDynamicCustomFormulaPlugin plugin = (AbstractDynamicCustomFormulaPlugin)aClass.newInstance();
                        logger.info("\u81ea\u5b9a\u4e49\u516c\u5f0f\u7684\u81ea\u5b9a\u4e49\u63d2\u4ef6\u5bf9\u8c61\u4e3a\uff1a{}", (Object)plugin);
                        Map value = plugin.queryByDeclareRequestModel(requestModel, dynList);
                        logger.info("\u81ea\u5b9a\u4e49\u516c\u5f0f\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)value);
                        if (!CollectionUtils.isEmpty((Map)value)) {
                            for (Map.Entry entry : value.entrySet()) {
                                result.computeIfAbsent((String)entry.getKey(), k -> new ArrayList(1)).add(entry.getValue());
                            }
                            resultFlag = "1";
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("\u516c\u5f0f\uff1a{}\u83b7\u53d6\u52a8\u6001\u884c\u81ea\u5b9a\u4e49\u516c\u5f0f\u5f02\u5e38\uff1a{}", (Object)formula, (Object)e);
                    resultFlag = "2";
                }
            }
            if ("2".equals(v.getFormulaType()) && "0".equals(resultFlag)) {
                v.setFormula("1");
            }
        });
        return result;
    }

    public static String getNewKey(String srcKey, long rowIndex) {
        String[] ary = srcKey.split("#");
        String newKey = MultiDynamicRowCheckFormulaService.getJoinKey("#", ary[0], rowIndex, ary[ary.length - 1]);
        return newKey;
    }

    public static String getJoinKey(String joinStr, Object ... split) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            if (i == split.length - 1) {
                stringBuilder.append(split[i]);
                continue;
            }
            stringBuilder.append(split[i]);
            stringBuilder.append(joinStr);
        }
        return stringBuilder.toString();
    }

    public static List<String> getSumFormulaList(List<DynamicRowModel> list, List<String> sumFormulaList, String formulaKey, String formula) {
        ArrayList<String> dataResult = new ArrayList<String>();
        if (CollectionUtils.isEmpty(list)) {
            return dataResult;
        }
        for (String sumFormula : sumFormulaList) {
            DynamicRowModel rowModel = MultiDynamicRowCheckFormulaService.matchDyn(list, sumFormula);
            if (rowModel != null) {
                List rowList = rowModel.getRowList();
                if (CollectionUtils.isEmpty((Collection)rowList)) continue;
                String dynRowNo = rowModel.getDynRowNo();
                String tableName = dynRowNo.split("#")[0];
                long startRow = rowModel.getStartRow();
                String[] ary = sumFormula.split("#");
                MultiDynamicRowCheckFormulaService.buildFormulaList(tableName, startRow, rowList, dataResult, ary[ary.length - 1]);
                continue;
            }
            logger.error("\u52a8\u6001\u884csum\u516c\u5f0f\uff0c\u914d\u7f6e\u6709\u8bef:formulaKey=" + formulaKey + ",formula=" + formula);
        }
        return dataResult;
    }

    public static DynamicRowModel matchDyn(List<DynamicRowModel> list, String key) {
        for (DynamicRowModel rowModel : list) {
            String dynRowNo = rowModel.getDynRowNo();
            int startRow = rowModel.getStartRow().intValue();
            String[] keys = key.split("#");
            if (!keys[0].equals(dynRowNo.split("#")[0])) continue;
            if (keys.length < 3) {
                return rowModel;
            }
            int rowIndex = 0;
            try {
                rowIndex = Integer.parseInt(keys[1]);
            }
            catch (NumberFormatException e) {
                logger.error("key\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff01");
            }
            if (rowIndex < startRow) continue;
            return rowModel;
        }
        return null;
    }

    public static boolean isDelKey(List<DynamicRowModel> list, String key) {
        for (DynamicRowModel rowModel : list) {
            String dynRowNo = rowModel.getDynRowNo();
            List rowList = rowModel.getRowList();
            if (!key.startsWith(dynRowNo) || !CollectionUtils.isEmpty((Collection)rowList) && rowList.size() != 0) continue;
            return true;
        }
        return false;
    }

    private static List<String> buildFormulaList(String tableName, long startRow, List<Map<String, String>> rowList, List<String> list, String fieldId) {
        if (!CollectionUtils.isEmpty(rowList)) {
            for (int i = 0; i < rowList.size(); ++i) {
                String colKey = MultiDynamicRowCheckFormulaService.getJoinKey("#", tableName, (long)i + startRow, fieldId);
                list.add(colKey);
            }
        }
        return list;
    }
}

