/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.formula;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.annotation.GlobalDynamicRowPluginFlag;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.formula.db.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicCustomFormulaPlugin;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.ObjectUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.formula.FormulaUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;

public class MultiDynamicRowService {
    private static Log logger = LogFactory.getLog(MultiDynamicRowService.class);
    private static final String DYNROWSET_ENTITY_NAME = "bdtaxr_template_dynrow";
    private static String DYNROWSET_ENTITY_NAME_ALL_FIELDS = "id,dynrow_no,rule_name,start_row,enable,rule_id,modifier,creator,template_id,modifytime,createtime,seq_no,group_no,type,pluginpath,disablefrontop,modeltype";
    private static final String FORMULA_ENTITY_NAME = "bdtaxr_formula_edit";
    private static final String KEY_FORMAT = "%s#%s#%s";
    private static final String START_ROW = "start_row";
    private static final String DYNROW_NO = "dynrow_no";
    private static final String RULE_ID = "rule_id";

    public static Map<String, FormulaVo> copyFormula(Map<String, FormulaVo> formulas, List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>();
        if (formulas == null || CollectionUtils.isEmpty(dynList)) {
            return result;
        }
        formulas.values().forEach(v -> {
            String formula = v.getFormula();
            String formulaKey = v.getFormulaKey();
            Map<String, FormulaVo> map = MultiDynamicRowService.copyFormula(MultiDynamicRowService.matchDyn(dynList, formulaKey), v, dynList);
            logger.info("\u52a8\u6001\u884c\u590d\u5236\u516c\u5f0f\uff0c\u539f\u516c\u5f0f\u4e3a\uff1a" + formula + "\uff0c\u590d\u5236\u540e\u7684\u516c\u5f0f\u4e3a\uff1a" + map.toString());
            result.putAll(map);
        });
        return result;
    }

    private static Map<String, FormulaVo> copyFormula(DynamicRowModel rowModel, FormulaVo srcFormulaVo, List<DynamicRowModel> dynList) {
        List rowList = rowModel.getRowList();
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>(CollectionUtils.isEmpty((Collection)rowList) ? 0 : rowList.size());
        String formula = srcFormulaVo.getFormula();
        String formulaKey = srcFormulaVo.getFormulaKey();
        if (StringUtil.isBlank((CharSequence)formula) || StringUtil.isBlank((CharSequence)formulaKey)) {
            return result;
        }
        if (!CollectionUtils.isEmpty((Collection)rowList)) {
            long startRow = rowModel.getStartRow();
            for (int i = 0; i < rowList.size(); ++i) {
                String newKey = MultiDynamicRowService.getNewKey(formulaKey, (long)i + startRow);
                String formulaTemp = MultiDynamicRowService.handleCopyFormula(formula, formulaKey, rowModel, (long)i + startRow, dynList);
                result.put(newKey, MultiDynamicRowService.bulidFormulaVo(newKey, formulaTemp, srcFormulaVo));
            }
        }
        return result;
    }

    private static String handleCopyFormula(String formula, String formulaKey, DynamicRowModel rowModel, long rowIndex, List<DynamicRowModel> dynList) {
        List list = ParseUtils.parseformula((String)formula);
        String formulaTemp = formula;
        String tableName = rowModel.getDynRowNo().split("#")[0];
        for (String formulaStr : list) {
            Map map = ParseUtils.parseFormulaZKH((String)formulaStr);
            String key = ParseUtils.getValue((Map)map);
            String type = ParseUtils.getType((Map)map);
            if ("Q".equals(type) && MultiDynamicRowService.matchDyn(dynList, key) != null) {
                formulaTemp = formulaTemp.replaceAll("Q\\[" + key + "\\]", "Q\\[" + MultiDynamicRowService.getNewKey(key, rowIndex) + "\\]");
            }
            if (!"P".equals(type) || !key.contains("#")) continue;
            String[] ary = key.split("#");
            String newKey = MultiDynamicRowService.getJoinKey("#", ary[0], rowIndex, ary[ary.length - 1]);
            formulaTemp = formulaTemp.replaceAll("P\\[" + key + "\\]", "P\\[" + tableName + "_" + newKey + "\\]");
        }
        return formulaTemp;
    }

    public static Map<String, FormulaVo> seqFormula(Map<String, FormulaVo> formulas, List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>();
        if (formulas == null || CollectionUtils.isEmpty(dynList)) {
            return result;
        }
        long seqNo = 1L;
        String groupNo = "";
        String seq = "";
        for (DynamicRowModel rowModel : dynList) {
            FormulaVo formulaVo = MultiDynamicRowService.findSeqFormulaVo(rowModel.getDynRowNo(), formulas);
            if (null == formulaVo) continue;
            String formula = formulaVo.getFormula();
            String formulaKey = formulaVo.getFormulaKey();
            if (StringUtil.isBlank((CharSequence)groupNo) || !groupNo.equals(rowModel.getGroupNo())) {
                seqNo = 1L;
            }
            groupNo = rowModel.getGroupNo();
            List rowList = rowModel.getRowList();
            if (CollectionUtils.isEmpty((Collection)rowList)) continue;
            long startRow = rowModel.getStartRow();
            if (formula.substring(0, 4).equalsIgnoreCase("seq(") && formula.substring(formula.length() - 1).equalsIgnoreCase(")")) {
                seq = formula.replace("seq(", "");
                seq = seq.replace(")", "");
            }
            seqNo = MultiDynamicRowService.getDefaultSeqNo(seq);
            for (int i = 0; i < rowList.size(); ++i) {
                String newKey = MultiDynamicRowService.getNewKey(formulaKey, (long)i + startRow);
                if (seq.equals("00000001")) {
                    String zeroPrefix = "00000000".substring(0, 8 - String.valueOf(seqNo).length());
                    formula = "{C[" + zeroPrefix + seqNo + "]}";
                } else {
                    formula = "{C[" + (seq.contains(".") ? seq.split("\\.")[0] + "." : "") + seqNo + "]}";
                }
                result.put(newKey, MultiDynamicRowService.bulidFormulaVo(newKey, formula, formulaVo.getFormulaType()));
                ++seqNo;
            }
        }
        return result;
    }

    private static long getDefaultSeqNo(String seq) {
        long seqNo = 1L;
        if (StringUtil.isBlank((CharSequence)seq)) {
            return seqNo;
        }
        if (seq.contains(".")) {
            String[] seqs = seq.split("\\.");
            try {
                return Long.parseLong(seqs[seqs.length - 1]);
            }
            catch (Exception e) {
                logger.error("\u5e8f\u53f7\u516c\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + e.getMessage());
            }
        }
        if (seq.equals("00000001")) {
            return seqNo;
        }
        try {
            return Long.parseLong(seq);
        }
        catch (Exception e) {
            logger.error("\u5e8f\u53f7\u516c\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + e.getMessage());
            return seqNo;
        }
    }

    private static FormulaVo findSeqFormulaVo(String dynRowNo, Map<String, FormulaVo> formulas) {
        for (Map.Entry<String, FormulaVo> entry : formulas.entrySet()) {
            FormulaVo formulaVo = entry.getValue();
            if (!formulaVo.getFormulaKey().startsWith(dynRowNo) || !formulaVo.getFormula().contains("seq")) continue;
            return formulaVo;
        }
        return null;
    }

    @Deprecated
    private static FormulaVo bulidFormulaVo(String newKey, String formulaTemp, String formulaType) {
        FormulaVo formulaVo = new FormulaVo();
        formulaVo.setFormulaKey(newKey);
        formulaVo.setFormulaType(StringUtil.isBlank((CharSequence)formulaType) ? "1" : formulaType);
        formulaVo.setFormula(formulaTemp);
        formulaVo.setFormulaName(formulaTemp);
        return formulaVo;
    }

    private static FormulaVo bulidFormulaVo(String newKey, String formulaTemp, FormulaVo formula) {
        FormulaVo formulaVo = new FormulaVo();
        formulaVo.setFormulaKey(newKey);
        formulaVo.setFormulaType(StringUtil.isBlank((CharSequence)formula.getFormulaType()) ? "1" : formula.getFormulaType());
        formulaVo.setFormula(formulaTemp);
        formulaVo.setFormulaName(formulaTemp);
        formulaVo.setContent(formula.getContent());
        formulaVo.setTitle(formula.getTitle());
        return formulaVo;
    }

    public static Map<String, FormulaVo> sumFormula(Map<String, FormulaVo> formulas, List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>();
        if (formulas == null) {
            return result;
        }
        formulas.values().forEach(v -> {
            String key = v.getFormulaKey();
            String sumFormula = StringUtil.formatStringNoBlank((String)v.getFormula());
            List sumFormulas = FormulaUtils.getSumFormula((String)sumFormula);
            for (String f : sumFormulas) {
                String formulaBody = f.substring(4, f.length() - 1);
                List sumMatchKey = FormulaUtils.getMatchKeyList((String)f);
                List<String[]> list = MultiDynamicRowService.getSumFormulaParams(dynList, key, f, sumMatchKey);
                if (CollectionUtils.isEmpty(list)) continue;
                StringBuilder formula = new StringBuilder();
                for (int i = 0; i < list.size(); ++i) {
                    StringBuffer formulaItem = FormulaUtils.getFormulaItem((String)formulaBody, (String[])list.get(i));
                    if (i == list.size() - 1) {
                        formula.append(formulaItem);
                        continue;
                    }
                    formula.append(formulaItem).append(", ");
                }
                sumFormula = sumFormula.replace(f, " sum(" + formula + ")");
            }
            v.setFormula(sumFormula);
            v.setParsed(false);
            result.put(key, (FormulaVo)v);
        });
        return result;
    }

    private static List<String[]> getSumFormulaParams(List<DynamicRowModel> dynList, String key, String f, List<String> sumMatchKey) {
        List<String> list = null;
        int listSize = 0;
        int rowSize = sumMatchKey.size();
        int colSize = 0;
        ArrayList<List<String>> paramList = new ArrayList<List<String>>(rowSize);
        for (String matchKey : sumMatchKey) {
            list = MultiDynamicRowService.getSumFormulaList(dynList, Collections.singletonList(matchKey), key, f);
            paramList.add(list);
            listSize = list.size();
            colSize = listSize > colSize ? listSize : colSize;
        }
        if (rowSize == 0 || colSize == 0) {
            return null;
        }
        ArrayList<String[]> result = new ArrayList<String[]>(colSize);
        for (int i = 0; i < colSize; ++i) {
            String[] value = new String[rowSize];
            for (int j = 0; j < rowSize; ++j) {
                value[j] = paramList.get(j) != null && i < ((List)paramList.get(j)).size() ? (String)((List)paramList.get(j)).get(i) : null;
            }
            result.add(value);
        }
        return result;
    }

    public static Map<String, FormulaVo> getCustomFormulas(Map<String, FormulaVo> formulas, DeclareRequestModel requestModel, List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>();
        if (formulas == null) {
            return result;
        }
        formulas.values().forEach(v -> {
            String formula = v.getFormula();
            String pluginName = formula.replace("[DynRowCustomFormula]", "").replace("{", "").replace("}", "");
            logger.info("\u516c\u5f0f\u5904\u7406\u540e\u7684\u81ea\u5b9a\u4e49\u63d2\u4ef6\u4e3a\uff1a{}", (Object)pluginName);
            String resultFlag = "0";
            if (StringUtil.isNotEmpty((CharSequence)pluginName)) {
                try {
                    Class<?> aClass = Class.forName(pluginName);
                    if (AbstractDynamicCustomFormulaPlugin.class.isAssignableFrom(aClass)) {
                        AbstractDynamicCustomFormulaPlugin plugin = (AbstractDynamicCustomFormulaPlugin)aClass.newInstance();
                        logger.info("\u81ea\u5b9a\u4e49\u516c\u5f0f\u7684\u81ea\u5b9a\u4e49\u63d2\u4ef6\u5bf9\u8c61\u4e3a\uff1a{}", (Object)plugin);
                        Map value = plugin.queryByDeclareRequestModel(requestModel, dynList);
                        logger.info("\u81ea\u5b9a\u4e49\u516c\u5f0f\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)value);
                        if (!CollectionUtils.isEmpty((Map)value)) {
                            result.putAll(value);
                            resultFlag = "1";
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("\u516c\u5f0f\uff1a{}\u83b7\u53d6\u52a8\u6001\u884c\u81ea\u5b9a\u4e49\u516c\u5f0f\u5f02\u5e38\uff1a{}", (Object)formula, (Object)e);
                    resultFlag = "2";
                }
            }
            if ("2".equals(v.getFormulaType()) && "0".equals(resultFlag)) {
                v.setFormula("1");
            }
        });
        return result;
    }

    public static String getNewKey(String srcKey, long rowIndex) {
        String[] ary = srcKey.split("#");
        String newKey = MultiDynamicRowService.getJoinKey("#", ary[0], rowIndex, ary[ary.length - 1]);
        return newKey;
    }

    public static String getJoinKey(String joinStr, Object ... split) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            if (i == split.length - 1) {
                stringBuilder.append(split[i]);
                continue;
            }
            stringBuilder.append(split[i]);
            stringBuilder.append(joinStr);
        }
        return stringBuilder.toString();
    }

    public static Map<String, Object> getDynRowData(List<DynamicRowModel> list) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(list)) {
            return dataMap;
        }
        for (DynamicRowModel rowModel : list) {
            List rowList = rowModel.getRowList();
            if (CollectionUtils.isEmpty((Collection)rowList)) continue;
            long startRow = rowModel.getStartRow();
            String tableName = rowModel.getDynRowNo().split("#")[0];
            for (int i = 0; i < rowList.size(); ++i) {
                Map map = (Map)rowList.get(i);
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.contains("#")) continue;
                    String[] ary = key.split("#");
                    dataMap.put(MultiDynamicRowService.getJoinKey("#", tableName + "_" + ary[0], (long)i + startRow, ary[ary.length - 1]), entry.getValue());
                }
            }
        }
        return dataMap;
    }

    public static List<String> getSumFormulaList(List<DynamicRowModel> list, List<String> sumFormulaList, String formulaKey, String formula) {
        ArrayList<String> dataResult = new ArrayList<String>();
        if (CollectionUtils.isEmpty(list)) {
            return dataResult;
        }
        for (String sumFormula : sumFormulaList) {
            DynamicRowModel rowModel = MultiDynamicRowService.matchDyn(list, sumFormula);
            if (rowModel != null) {
                List rowList = rowModel.getRowList();
                if (CollectionUtils.isEmpty((Collection)rowList)) continue;
                String dynRowNo = rowModel.getDynRowNo();
                String tableName = dynRowNo.split("#")[0];
                long startRow = rowModel.getStartRow();
                String[] ary = sumFormula.split("#");
                MultiDynamicRowService.buildFormulaList(tableName, startRow, rowList, dataResult, ary[ary.length - 1]);
                continue;
            }
            logger.error("\u52a8\u6001\u884csum\u516c\u5f0f\uff0c\u914d\u7f6e\u6709\u8bef:formulaKey=" + formulaKey + ",formula=" + formula);
        }
        return dataResult;
    }

    public static DynamicRowModel matchDyn(List<DynamicRowModel> list, String key) {
        for (DynamicRowModel rowModel : list) {
            String dynRowNo = rowModel.getDynRowNo();
            int startRow = rowModel.getStartRow().intValue();
            String[] keys = key.split("#");
            if (!keys[0].equals(dynRowNo.split("#")[0])) continue;
            if (keys.length < 3) {
                return rowModel;
            }
            int rowIndex = 0;
            try {
                rowIndex = Integer.parseInt(keys[1]);
            }
            catch (NumberFormatException e) {
                logger.error("key\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff01");
            }
            if (rowIndex < startRow) continue;
            return rowModel;
        }
        return null;
    }

    public static boolean isDelKey(List<DynamicRowModel> list, String key) {
        for (DynamicRowModel rowModel : list) {
            String dynRowNo = rowModel.getDynRowNo();
            List rowList = rowModel.getRowList();
            if (!key.startsWith(dynRowNo) || !CollectionUtils.isEmpty((Collection)rowList) && rowList.size() != 0) continue;
            return true;
        }
        return false;
    }

    private static List<String> buildFormulaList(String tableName, long startRow, List<Map<String, String>> rowList, List<String> list, String fieldId) {
        if (!CollectionUtils.isEmpty(rowList)) {
            for (int i = 0; i < rowList.size(); ++i) {
                String colKey = MultiDynamicRowService.getJoinKey("#", tableName, (long)i + startRow, fieldId);
                list.add(colKey);
            }
        }
        return list;
    }

    public static List<DynamicRowModel> getDynamicRowList(Long templateId, Map<String, Object> param) {
        List<DynamicRowModel> dynamicRowModelList = MultiDynamicRowService.getDynRowSetList(templateId);
        BussinessParamsVo bussinessParamsVo = new BussinessParamsVo();
        if (param != null) {
            bussinessParamsVo.setOrgId(String.valueOf(param.get("orgId")));
            bussinessParamsVo.setStartDate(param.get("skssqq") == null ? null : DateUtils.stringToDate((String)param.get("skssqq").toString(), (String)"yyyy-MM-dd"));
            bussinessParamsVo.setEndDate(param.get("skssqz") == null ? null : DateUtils.stringToDate((String)param.get("skssqz").toString(), (String)"yyyy-MM-dd"));
            bussinessParamsVo.setExtendParams(param);
        }
        ArrayList<String> pluginList = new ArrayList<String>(dynamicRowModelList.size());
        for (DynamicRowModel rowModel : dynamicRowModelList) {
            ArrayList dataList = new ArrayList();
            String type = rowModel.getType();
            List dynData = null;
            if (Objects.equals(type, "rule_fetch")) {
                Long ruleId = rowModel.getRuleId();
                dynData = MultiDynamicRowService.getRuleDataByTmpId(ruleId, param);
            } else if (Objects.equals(type, "plugin_fetch")) {
                String pluginpath = rowModel.getPluginpath();
                Map extendParams = bussinessParamsVo.getExtendParams();
                if (extendParams != null) {
                    extendParams.put("dynRowNo", rowModel.getDynRowNo());
                    extendParams.put("templateId", rowModel.getTemplateId());
                }
                logger.info("\u52a8\u6001\u884c\uff1a{}\u63d2\u4ef6pluginpath\uff1a{}", (Object)rowModel.getDynRowNo(), (Object)pluginpath);
                if (StringUtil.isNotEmpty((CharSequence)pluginpath)) {
                    try {
                        AbstractDynamicListBasePlugin plugin;
                        Class<?> aClass = Class.forName(pluginpath);
                        if (AbstractDynamicListBasePlugin.class.isAssignableFrom(aClass) && (plugin = (AbstractDynamicListBasePlugin)aClass.newInstance()).check(bussinessParamsVo)) {
                            long t1 = System.currentTimeMillis();
                            if (aClass.getAnnotation(GlobalDynamicRowPluginFlag.class) != null) {
                                if (pluginList.contains(pluginpath)) continue;
                                Method m = aClass.getMethod("globalDynrowQuery", BussinessParamsVo.class);
                                Object o = aClass.newInstance();
                                List dynamicRowModelListquery = (List)m.invoke(o, bussinessParamsVo);
                                for (DynamicRowModel d : dynamicRowModelList) {
                                    DynamicRowModel dyn = dynamicRowModelListquery.stream().filter(e -> e.getDynRowNo().equals(d.getDynRowNo())).findFirst().orElse(null);
                                    if (dyn == null) continue;
                                    d.setRowList(dyn.getRowList());
                                }
                                pluginList.add(pluginpath);
                                continue;
                            }
                            dynData = plugin.query(bussinessParamsVo);
                            long t2 = System.currentTimeMillis();
                            logger.info("\u63d2\u4ef6\uff1a{}\uff08{}\uff09\u6267\u884c\u8017\u65f6\uff1a{}", new Object[]{pluginpath, bussinessParamsVo.toString(), t2 - t1});
                        }
                    }
                    catch (Exception e2) {
                        logger.error("\u83b7\u53d6\u52a8\u6001\u884c\u6570\u636e\u5217\u8868\u5f02\u5e38\uff1a", (Throwable)e2);
                    }
                }
            }
            if (dynData != null && !CollectionUtils.isEmpty(dynData)) {
                for (Map<String, Object> map : dynData) {
                    HashMap temp = new HashMap();
                    map.entrySet().stream().forEach(v -> temp.put(v.getKey(), v.getValue() == null ? "" : ObjectUtils.getStringByType(v.getValue())));
                    dataList.add(temp);
                }
                logger.info("\u63d2\u4ef6\u6216\u89c4\u5219\uff1a{}\uff0c\u52a8\u6001\u884c\u6570\u636e\uff1a{}", (Object)(EmptyCheckUtils.isNotEmpty((Object)rowModel.getPluginpath()) ? rowModel.getPluginpath() : rowModel.getRuleName()), dynData);
            }
            rowModel.setRowList(dataList);
        }
        return dynamicRowModelList;
    }

    public static List<DynamicRowModel> getInitedDynData(Map<String, DynamicObjectCollection> data, Long templateId) {
        List<DynamicRowModel> dynDoc = MultiDynamicRowService.getDynRowSetList(templateId);
        for (DynamicRowModel dynObj : dynDoc) {
            String dynRowNo = dynObj.getDynRowNo();
            Long startRow = dynObj.getStartRow();
            String entityKey = dynRowNo.split("#")[0];
            DynamicObjectCollection doc = data.get(entityKey);
            if (doc == null) continue;
            ArrayList list = new ArrayList();
            for (DynamicObject d : doc) {
                int ewblxh;
                String ewblxhStr = d.getString("ewblxh");
                if (!FormulaUtils.isNumeric((String)ewblxhStr) || (long)(ewblxh = Integer.parseInt(ewblxhStr)) < startRow) continue;
                HashMap<String, String> map = new HashMap<String, String>(16);
                for (String fieldId : TemplateUtils.getEntityFieldList((String)entityKey)) {
                    map.put(MultiDynamicRowService.getJoinKey("#", entityKey, ewblxh, fieldId), d.getString(fieldId));
                }
                list.add(map);
            }
            dynObj.setRowList(list);
        }
        return dynDoc;
    }

    public static Map<String, String> getInitData(List<DynamicRowModel> list) {
        HashMap<String, String> data = new HashMap<String, String>();
        for (DynamicRowModel dynObj : list) {
            List rowList = dynObj.getRowList();
            if (rowList == null) continue;
            for (Map map : rowList) {
                data.putAll(map);
            }
        }
        return data;
    }

    public static List<DynamicRowModel> getDynRowSetList(Long templateId) {
        ArrayList<DynamicRowModel> result = new ArrayList<DynamicRowModel>();
        QFilter qFilter = new QFilter("template_id", "=", (Object)templateId);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)DYNROWSET_ENTITY_NAME, (String)DYNROWSET_ENTITY_NAME_ALL_FIELDS, (QFilter[])new QFilter[]{qFilter}, (String)"group_no,seq_no");
        if (null == doc) {
            return result;
        }
        for (DynamicObject dynamicObject : doc) {
            DynamicRowModel dynamicRowModel = new DynamicRowModel();
            dynamicRowModel.setTemplateId(Long.valueOf(dynamicObject.getLong("template_id")));
            dynamicRowModel.setDynRowNo(dynamicObject.getString(DYNROW_NO));
            dynamicRowModel.setStartRow(Long.valueOf(dynamicObject.getLong(START_ROW)));
            dynamicRowModel.setRuleId(Long.valueOf(dynamicObject.getLong(RULE_ID)));
            dynamicRowModel.setRuleName(dynamicObject.getString("rule_name"));
            dynamicRowModel.setSeqNo(Long.valueOf(dynamicObject.getLong("seq_no")));
            dynamicRowModel.setGroupNo(dynamicObject.getString("group_no"));
            String type = dynamicObject.getString("type");
            dynamicRowModel.setType(type);
            String pluginPath = dynamicObject.getString("pluginpath");
            dynamicRowModel.setPluginpath(pluginPath);
            dynamicRowModel.setDisablefrontop(dynamicObject.getBoolean("disablefrontop"));
            result.add(dynamicRowModel);
        }
        return result;
    }

    public static List<String> getDynRowNoList(Long templateId) {
        List<DynamicRowModel> doc = MultiDynamicRowService.getDynRowSetList(templateId);
        ArrayList<String> list = new ArrayList<String>(doc.size());
        for (int i = 0; i < doc.size(); ++i) {
            DynamicRowModel dynObj = doc.get(i);
            String dynRowNo = dynObj.getDynRowNo();
            list.add(dynRowNo);
        }
        return list;
    }

    private static List<Map<String, Object>> getRuleDataByTmpId(Long ruleId, Map<String, Object> param) {
        ArrayList<Map<String, Object>> rowList = new ArrayList();
        BussinessParamsVo bussinessParamsVo = new BussinessParamsVo();
        bussinessParamsVo.setOrgId(String.valueOf(param.get("orgId")));
        bussinessParamsVo.setExtendParams(param);
        logger.info("\u5f00\u59cbcalculateService.batchRuleCalService\uff0cbussinessParamsVo={}\uff0cruleId={}", (Object)JsonUtil.toJson((Object)bussinessParamsVo), (Object)ruleId);
        rowList = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleCalculateService", (String)"batchRuleCalService", (Object[])new Object[]{JsonUtil.toJson((Object)bussinessParamsVo), ruleId});
        logger.info("\u7ed3\u675fcalculateService.batchRuleCalService,result={}", (Object)JsonUtil.toJson(rowList));
        return rowList;
    }

    private static Map<String, String> getDynRowKeyMapping(Long templateId, String dynRowNo, boolean srcFlag) {
        DynamicObject[] dynamicObjects;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (StringUtil.isBlank((CharSequence)dynRowNo) || templateId == null) {
            return resultMap;
        }
        for (DynamicObject dynObj : dynamicObjects = QueryFormulaService.getFormulaList((Long)templateId)) {
            String key = dynObj.getString("formulakey");
            String formula = dynObj.getString("formula");
            if (!key.startsWith(dynRowNo)) continue;
            String value = "";
            if (srcFlag) {
                value = key.substring(key.lastIndexOf(35) + 1);
            } else if (formula.contains("{P[")) {
                String matchKey = FormulaUtils.getMatchKey((String)formula);
                if (matchKey.contains("#")) {
                    String[] ary = matchKey.split("#");
                    value = ary[0] + '#' + ary[ary.length - 1];
                } else {
                    value = matchKey;
                }
            }
            resultMap.put(key, value);
        }
        return resultMap;
    }

    public static Optional<String> checkDynRowDuplicate(Long templateId) {
        QFilter qFilter = new QFilter("template_id", "=", (Object)templateId);
        qFilter.and("modeltype", "=", (Object)Character.valueOf('3'));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)DYNROWSET_ENTITY_NAME, (String)DYNROW_NO, (QFilter[])new QFilter[]{qFilter});
        Map<Object, Object> uniqueMap = new HashMap(10);
        if (coll != null && coll.size() > 0) {
            uniqueMap = coll.stream().collect(Collectors.groupingBy(k -> k.getString(DYNROW_NO)));
        }
        ArrayList duplicateList = new ArrayList(10);
        for (Map.Entry entry : uniqueMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            duplicateList.add(entry.getKey());
        }
        if (duplicateList.size() > 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u52a8\u6001\u884c\uff1a%s \u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MultiDynamicRowService_0", (String)"taxc-tpo", (Object[])new Object[0]), duplicateList.stream().collect(Collectors.joining("\u3001")));
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    public static List<DynamicRowModel> getDynRowListData(Long templateId, Map<String, String> data) {
        List dynRowList = DynamicRowService.getDynRowSetList((Long)templateId);
        MultiDynamicRowService.setDynRowList(dynRowList, data);
        return dynRowList;
    }

    private static void setDynRowList(List<DynamicRowModel> dynRowList, Map<String, String> data) {
        if (EmptyCheckUtils.isNotEmpty(dynRowList)) {
            Map<String, DynamicRowModel> dynRowMap = dynRowList.stream().collect(Collectors.toMap(d -> d.getDynRowNo().split("#")[0], r -> r));
            HashMap<String, List> dynRowListEntityMap = new HashMap<String, List>();
            HashMap<String, Map> rowDataMap = new HashMap<String, Map>();
            for (Map.Entry<String, String> entry : data.entrySet()) {
                String[] split = entry.getKey().split("#");
                String entity = split[0];
                String ewblxh = split[1];
                List mapList = dynRowListEntityMap.computeIfAbsent(entity, t -> new ArrayList());
                Map rowMap = rowDataMap.computeIfAbsent(entity + "#" + ewblxh, t -> {
                    DynamicRowModel dynamicRowModel = (DynamicRowModel)dynRowMap.get(entity);
                    if (dynamicRowModel == null) {
                        HashMap objectObjectHashMap = new HashMap();
                        mapList.add(objectObjectHashMap);
                        return objectObjectHashMap;
                    }
                    try {
                        Long ewblxhInt = Long.parseLong(ewblxh);
                        if (ewblxhInt >= dynamicRowModel.getStartRow()) {
                            HashMap objectObjectHashMap = new HashMap();
                            mapList.add(objectObjectHashMap);
                            return objectObjectHashMap;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                });
                if (rowMap == null) continue;
                rowMap.put(entry.getKey(), entry.getValue());
            }
            for (DynamicRowModel dynamicRowModel : dynRowList) {
                String dynRowNo = dynamicRowModel.getDynRowNo();
                dynamicRowModel.setRowList((List)dynRowListEntityMap.get(dynRowNo.split("#")[0]));
            }
        }
    }
}

