/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.formula.db.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.formula.FormulaUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.business.formula.MultiDynamicRowService;

public class MultiParseFormulaService {
    private static Log logger = LogFactory.getLog(MultiParseFormulaService.class);
    private Map<String, FormulaVo> formulas = new HashMap<String, FormulaVo>();
    private Map<String, String> sformulas = new HashMap<String, String>();
    private Map<String, String> cformulas = new HashMap<String, String>();
    private Map<String, String> rformulas = new HashMap<String, String>();
    private Map<String, String> mformulas = new HashMap<String, String>();
    private Map<String, String> cpformulas = new HashMap<String, String>();
    private Map<String, Map<String, String>> qformulas = new HashMap<String, Map<String, String>>();
    private Long tmpId;
    private List<DynamicRowModel> dynList;

    public MultiParseFormulaService() {
    }

    public MultiParseFormulaService(Long tmpId, List<DynamicRowModel> dynList) {
        this.tmpId = tmpId;
        this.dynList = dynList;
    }

    public void parse() {
        this.formulas = QueryFormulaService.queryDBFormulaById((Long)this.tmpId);
        if (null == this.formulas) {
            this.formulas = new HashMap<String, FormulaVo>();
        }
        this.formulas = this.generateDynFormula(this.formulas, this.dynList);
        for (Map.Entry<String, FormulaVo> formula : this.formulas.entrySet()) {
            this.parse(formula.getValue());
        }
    }

    public void parse(Map<String, FormulaVo> dbCalFormulas) {
        this.formulas = dbCalFormulas;
        if (null == this.formulas) {
            this.formulas = new HashMap<String, FormulaVo>();
        }
        this.formulas = this.generateDynFormula(this.formulas, this.dynList);
        for (Map.Entry<String, FormulaVo> formula : this.formulas.entrySet()) {
            this.parse(formula.getValue());
        }
    }

    public Map<String, FormulaVo> generateDynFormula(Map<String, FormulaVo> formulas, List<DynamicRowModel> dynList) {
        return this.resolveFormulas(formulas, null, dynList);
    }

    public Map<String, FormulaVo> generateDynFormula(Map<String, FormulaVo> formulas, DeclareRequestModel requestModel, List<DynamicRowModel> dynList) {
        return this.resolveFormulas(formulas, requestModel, dynList);
    }

    private Map<String, FormulaVo> resolveFormulas(Map<String, FormulaVo> formulas, DeclareRequestModel requestModel, List<DynamicRowModel> dynList) {
        long time = System.currentTimeMillis();
        if (dynList != null && dynList.size() > 0) {
            Map<String, Map<String, FormulaVo>> formulaMap = this.parseFormula(formulas, dynList);
            Map<String, FormulaVo> sum = MultiDynamicRowService.sumFormula(formulaMap.get("sum"), dynList);
            formulas.putAll(sum);
            Map<String, FormulaVo> customFormula = formulaMap.get("dynRowCustomFormula");
            Map<String, FormulaVo> map = MultiDynamicRowService.getCustomFormulas(customFormula, requestModel, dynList);
            if (formulas != null && customFormula != null) {
                for (String key : customFormula.keySet()) {
                    formulas.remove(key);
                }
            }
            formulas.putAll(map);
            Map<String, FormulaVo> seqMap = MultiDynamicRowService.seqFormula(formulaMap.get("seq"), dynList);
            formulas.putAll(seqMap);
            Map<String, FormulaVo> copyMap = MultiDynamicRowService.copyFormula(formulaMap.get("copy"), dynList);
            formulas.putAll(copyMap);
        }
        if (dynList != null && formulas != null) {
            Map<String, List<DynamicRowModel>> nulldynlisMap = dynList.stream().filter(a -> EmptyCheckUtils.isEmpty((Object)a.getRowList())).collect(Collectors.groupingBy(a -> a.getDynRowNo()));
            List<String> list = formulas.keySet().stream().filter(a -> a.contains("#") && nulldynlisMap.containsKey(a.substring(0, a.lastIndexOf("#")))).collect(Collectors.toList());
            list.forEach(a -> {
                FormulaVo cfr_ignored_0 = (FormulaVo)formulas.remove(a);
            });
        }
        if (formulas == null || formulas.isEmpty()) {
            return formulas;
        }
        HashMap<String, FormulaVo> normalFormulas = new HashMap<String, FormulaVo>(formulas.size());
        HashMap<String, FormulaVo> customFormulas = new HashMap<String, FormulaVo>(16);
        for (Map.Entry entry : formulas.entrySet()) {
            String key = (String)entry.getKey();
            FormulaVo formulaVo = (FormulaVo)entry.getValue();
            if (StringUtil.isNotBlank((CharSequence)key) && formulaVo.getFormula() != null && !formulaVo.getFormula().trim().startsWith("{[DynRowCustomFormula]")) {
                normalFormulas.put(key, formulaVo);
                continue;
            }
            customFormulas.put(key, formulaVo);
        }
        if (!customFormulas.isEmpty()) {
            Map<String, FormulaVo> dynRowCustomFormulas = MultiDynamicRowService.getCustomFormulas(customFormulas, requestModel, dynList);
            normalFormulas.putAll(dynRowCustomFormulas);
        }
        logger.info("\u52a8\u6001\u751f\u6210\u516c\u5f0f\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return normalFormulas;
    }

    private Map<String, Map<String, FormulaVo>> parseFormula(Map<String, FormulaVo> formulas, List<DynamicRowModel> dynList) {
        HashMap<String, Map<String, FormulaVo>> result = new HashMap<String, Map<String, FormulaVo>>();
        HashMap<String, FormulaVo> sumFormulas = new HashMap<String, FormulaVo>();
        HashMap<String, FormulaVo> seqFormulas = new HashMap<String, FormulaVo>();
        HashMap<String, FormulaVo> copyFormulas = new HashMap<String, FormulaVo>();
        HashMap<String, FormulaVo> dynRowCustomFormulas = new HashMap<String, FormulaVo>();
        Iterator<Map.Entry<String, FormulaVo>> it = formulas.entrySet().iterator();
        ArrayList<String> formulaList = new ArrayList<String>();
        while (it.hasNext()) {
            Map.Entry<String, FormulaVo> entry = it.next();
            String key = (String)entry.getKey();
            FormulaVo formulaVo = (FormulaVo)entry.getValue();
            try {
                if (!StringUtil.isNotBlank((CharSequence)key) || formulaVo.getFormula() == null || formulaVo.getFormula().trim().startsWith("{[DynRowCustomFormula]") || !MultiDynamicRowService.isDelKey(dynList, key)) continue;
                formulaList.add(key);
            }
            catch (Exception e) {
                logger.error("\u516c\u5f0f\u5b58\u5728\u5f02\u5e38\u6570\u636e{}", (Object)(formulaVo == null ? null : formulaVo.toString()));
                throw e;
            }
        }
        for (String key : formulaList) {
            formulas.remove(key);
        }
        for (Map.Entry<String, FormulaVo> entry : formulas.entrySet()) {
            String key = entry.getKey();
            FormulaVo formulaVo = entry.getValue();
            String formula = formulaVo.getFormula();
            if (!StringUtil.isNotBlank((CharSequence)key) || formula == null) continue;
            if (FormulaUtils.isSumFormula((String)StringUtil.formatStringNoBlank((String)formula))) {
                sumFormulas.put(key, formulaVo);
                continue;
            }
            if (formula.trim().startsWith("seq")) {
                seqFormulas.put(key, formulaVo);
                continue;
            }
            if (formula.trim().startsWith("{[DynRowCustomFormula]")) {
                dynRowCustomFormulas.put(key, formulaVo);
                continue;
            }
            if (MultiDynamicRowService.matchDyn(dynList, key) == null) continue;
            copyFormulas.put(key, formulaVo);
        }
        result.put("sum", sumFormulas);
        result.put("seq", seqFormulas);
        result.put("copy", copyFormulas);
        result.put("dynRowCustomFormula", dynRowCustomFormulas);
        return result;
    }

    public void parse(FormulaVo formulaVo) {
        if (!StringUtils.isEmpty((String)formulaVo.getFormula())) {
            if (!formulaVo.isParsed()) {
                ArrayList<Map> parseInfos = new ArrayList<Map>(16);
                List list = ParseUtils.parseformula((String)formulaVo.getFormula());
                for (String formula : list) {
                    Map map = ParseUtils.parseFormulaZKH((String)formula);
                    String value = ParseUtils.getValue((Map)map);
                    String type = ParseUtils.getType((Map)map);
                    this.classFormula(formulaVo.getFormulaKey(), type, value);
                    parseInfos.add(map);
                }
                formulaVo.setParsed(true);
                formulaVo.setParseInfos(parseInfos);
            } else {
                for (Map parseInfo : formulaVo.getParseInfos()) {
                    String value = ParseUtils.getValue((Map)parseInfo);
                    String type = ParseUtils.getType((Map)parseInfo);
                    this.classFormula(formulaVo.getFormulaKey(), type, value);
                }
            }
        }
    }

    public static void parseDetail(FormulaVo formulaVo) {
        if (!StringUtils.isEmpty((String)formulaVo.getFormula()) && !formulaVo.isParsed()) {
            ArrayList<Map> parseInfos = new ArrayList<Map>(4);
            List list = ParseUtils.parseformula((String)formulaVo.getFormula());
            for (String formula : list) {
                Map map = ParseUtils.parseFormulaZKH((String)formula);
                parseInfos.add(map);
            }
            formulaVo.setParsed(true);
            formulaVo.setParseInfos(parseInfos);
        }
    }

    public void parseFormulas(String key, FormulaVo formulaVo) {
        if (formulaVo == null) {
            return;
        }
        formulaVo.setFormulaKey(key);
        if (!StringUtils.isEmpty((String)formulaVo.getFormula())) {
            List list = ParseUtils.parseformula((String)formulaVo.getFormula());
            ArrayList<Map> formulaList = new ArrayList<Map>(1);
            for (String formula : list) {
                Map map = ParseUtils.parseFormulaZKH((String)formula);
                formulaList.add(map);
                String value = ParseUtils.getValue((Map)map);
                String type = ParseUtils.getType((Map)map);
                this.classFormula(key, type, value);
                this.formulas.put(key, formulaVo);
            }
            formulaVo.setFormulaParseList(formulaList);
        }
    }

    private void classFormula(String key, String type, String value) {
        switch (type) {
            case "S": {
                this.sformulas.put(value, value);
                break;
            }
            case "C": {
                this.cformulas.put(key, value);
                break;
            }
            case "R": {
                this.rformulas.put(value, value);
                break;
            }
            case "M": {
                String md5 = StringUtil.hashFormulaStr((String)value);
                this.mformulas.put(md5, value);
                break;
            }
            case "CP": {
                this.cpformulas.put(value, value);
                break;
            }
            case "Q": {
                Map<String, String> temp = this.qformulas.get(value);
                if (null == temp) {
                    temp = new HashMap<String, String>();
                    this.qformulas.put(value, temp);
                }
                temp.put(key, key);
                break;
            }
        }
    }

    public Map<String, FormulaVo> getFormulas() {
        return this.formulas;
    }

    public void setFormulas(Map<String, FormulaVo> formulas) {
        this.formulas = formulas;
    }

    public Map<String, String> getSformulas() {
        return this.sformulas;
    }

    public Map<String, String> getMformulas() {
        return this.mformulas;
    }

    public Map<String, String> getCpformulas() {
        return this.cpformulas;
    }

    public Map<String, String> getCformulas() {
        return this.cformulas;
    }

    public Map<String, String> getRformulas() {
        return this.rformulas;
    }

    public Map<String, Map<String, String>> getQformulas() {
        return this.qformulas;
    }
}

