/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.multidideclare;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Style;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.pinyin.PinYinUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.common.vo.DeclareReportTemplateCellsVo;
import kd.taxc.tpo.common.vo.MemberTreeNode;
import kd.taxc.tpo.common.vo.TemplateCellVo;

public class BatchMemberSettingService {
    private static Log logger = LogFactory.getLog(BatchMemberSettingService.class);
    private static final String TEMPLATE_ENTITY_NAME = "tpo_template";
    private static final String REPORT_ITEM = "tpo_report_item";
    private static final String ROW_MEMBER_NUMBER = "RowDimension";
    private static final String COL_MEMBER_NUMBER = "ColumnDimension";
    private static final String DIMENSION = "tpo_dimension";
    public static final String ROW_MEMBER = "tpo_row_member";
    public static final String COL_MEMBER = "tpo_col_member";
    private static final String SPLIT_STRING = "#";
    public static final String MEMBER_PREVIEW = "tpo_batch_member_preview";
    public static final String BUTTON_BATCH_SETTING_GLOBAL = "globalsetting";
    public static final String BUTTON_BATCH_SETTING_DESIGNATED = "designatedsetting";

    public static void saveSpreadJson(long templateId, String spreadJson) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)TEMPLATE_ENTITY_NAME);
        obj.set("content_tag", (Object)spreadJson);
        DynamicObjectCollection col = new DynamicObjectCollection();
        col.add((Object)obj);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])col.toArray((Object[])new DynamicObject[0])));
    }

    public static String resetSpreadJson(String spreadJson, List<Map<String, Object>> reportItems) {
        JSONObject json = JSONObject.parseObject((String)spreadJson);
        JSONObject sheets = (JSONObject)json.get((Object)"sheets");
        LinkedHashMap jsonMap = (LinkedHashMap)JSON.parseObject((String)sheets.toJSONString(), (TypeReference)new TypeReference<LinkedHashMap<String, LinkedHashMap>>(){}, (Feature[])new Feature[0]);
        for (Map.Entry entry : jsonMap.entrySet()) {
            String sheetName = (String)entry.getKey();
            JSONObject rowList = ((JSONObject)((LinkedHashMap)entry.getValue()).get("data")).getJSONObject("dataTable");
            int rowCount = ((LinkedHashMap)entry.getValue()).get("rowCount") == null ? rowList.size() : ((Integer)((LinkedHashMap)entry.getValue()).get("rowCount")).intValue();
            int colCount = ((LinkedHashMap)entry.getValue()).get("columnCount") == null ? ((JSONObject)rowList.get((Object)0)).size() : ((Integer)((LinkedHashMap)entry.getValue()).get("columnCount")).intValue();
            for (int i = 0; i < rowCount; ++i) {
                JSONObject row = rowList.get((Object)("" + i)) == null ? new JSONObject() : (JSONObject)rowList.get((Object)("" + i));
                for (int j = 0; j < colCount; ++j) {
                    Map reportItem;
                    String cellKey = i + SPLIT_STRING + j;
                    JSONObject cellObj = row.getJSONObject("" + j);
                    if (cellObj != null && StringUtil.isNotBlank((CharSequence)cellObj.getString("value"))) continue;
                    if (cellObj == null) {
                        cellObj = new JSONObject();
                    }
                    if ((reportItem = (Map)reportItems.stream().filter(e -> e.get("sheeName").equals(sheetName) && e.get("cellKey").equals(cellKey)).findFirst().orElse(null)) == null) continue;
                    cellObj.put("value", (Object)("${" + reportItem.get("reportNumber") + "}"));
                    Style style = new Style();
                    if (cellObj.get((Object)"style") != null) {
                        style = (Style)SerializationUtils.fromJsonString((String)((JSONObject)cellObj.get((Object)"style")).toJSONString(), Style.class);
                    }
                    style.setBackColor("#d4ffaa");
                    cellObj.put("style", (Object)style);
                    row.put("" + j, (Object)cellObj);
                }
            }
        }
        json.put("sheets", (Object)jsonMap);
        return JSON.toJSONString((Object)json);
    }

    public static DynamicObjectCollection saveReportItems(long modelId, List<MemberTreeNode> rowMemberList, List<MemberTreeNode> colMemberList, List<Map<String, Object>> memberList) {
        for (MemberTreeNode rowNode : rowMemberList) {
            String rowFlag = rowNode.getMemberFlag();
            if (!StringUtil.isNotBlank((CharSequence)rowFlag)) continue;
            for (MemberTreeNode colNode : colMemberList) {
                String colFlag = colNode.getMemberFlag();
                if (!StringUtil.isNotBlank((CharSequence)colFlag) || !rowFlag.split(SPLIT_STRING)[0].equals(colFlag.split(SPLIT_STRING)[0])) continue;
                HashMap<String, Object> memberMap = new HashMap<String, Object>();
                String cellKey = rowFlag.split(SPLIT_STRING)[1] + SPLIT_STRING + colFlag.split(SPLIT_STRING)[1];
                String reportNumber = rowNode.getNumber() + SPLIT_STRING + colNode.getNumber();
                memberMap.put("sheeName", rowFlag.split(SPLIT_STRING)[0]);
                memberMap.put("cellKey", cellKey);
                memberMap.put("reportNumber", reportNumber);
                memberMap.put("rowMember", rowNode.getNumber());
                memberMap.put("rowMemberId", rowNode.getPkId());
                memberMap.put("colMember", colNode.getNumber());
                memberMap.put("colMemberId", colNode.getPkId());
                memberMap.put("reportName", rowNode.getText() + SPLIT_STRING + colNode.getText());
                memberMap.put("reportLongName", rowNode.getLongText() + SPLIT_STRING + colNode.getLongText());
                memberList.add(memberMap);
            }
        }
        DynamicObjectCollection repotItemCollection = new DynamicObjectCollection();
        MainEntityType reportItemEntityType = EntityMetadataCache.getDataEntityType((String)REPORT_ITEM);
        for (Map<String, Object> map : memberList) {
            QFilter filter = new QFilter("number", "=", map.get("reportNumber"));
            DynamicObject[] repotItem = BusinessDataServiceHelper.load((String)REPORT_ITEM, (String)"id", (QFilter[])new QFilter[]{filter});
            if (repotItem != null && repotItem.length > 0) {
                long id = repotItem[0].getLong("id");
                map.put("reportItemId", id);
                continue;
            }
            DynamicObject reportItemObj = new DynamicObject((DynamicObjectType)reportItemEntityType);
            long id = DBServiceHelper.genLongIds((String)REPORT_ITEM, (int)1)[0];
            map.put("reportItemId", id);
            reportItemObj.set("id", (Object)id);
            reportItemObj.set("number", map.get("reportNumber"));
            reportItemObj.set("model", (Object)modelId);
            reportItemObj.set("row", map.get("rowMemberId"));
            reportItemObj.set("col", map.get("colMemberId"));
            reportItemObj.set("name", map.get("reportName"));
            reportItemObj.set("longname", map.get("reportLongName"));
            reportItemObj.set("status", (Object)"A");
            reportItemObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            repotItemCollection.add((Object)reportItemObj);
        }
        return repotItemCollection;
    }

    public static DynamicObjectCollection saveMembers(long modelId, List<MemberTreeNode> memberList, String entityName) {
        String dimension = ROW_MEMBER_NUMBER;
        if (COL_MEMBER.equals(entityName)) {
            dimension = COL_MEMBER_NUMBER;
        }
        QFilter dimensionFilter2 = new QFilter("number", "=", (Object)dimension);
        DynamicObject[] dimensionObj = BusinessDataServiceHelper.load((String)DIMENSION, (String)"id", (QFilter[])new QFilter[]{dimensionFilter2});
        long dimensionId = dimensionObj[0].getLong("id");
        MainEntityType memberEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObjectCollection memberCollection = new DynamicObjectCollection();
        for (MemberTreeNode node : memberList) {
            QFilter filter2;
            QFilter filter1 = new QFilter("model", "=", (Object)modelId);
            DynamicObject[] rowMember = BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("number", "=", (Object)node.getNumber())});
            if (rowMember != null && rowMember.length > 0) {
                if (node.getPkId() != 0L) continue;
                node.setPkId(rowMember[0].getLong("id"));
                continue;
            }
            DynamicObject memberObj = new DynamicObject((DynamicObjectType)memberEntityType);
            long id = DBServiceHelper.genLongIds((String)entityName, (int)1)[0];
            node.setPkId(id);
            long prentId = node.getParentPkId();
            if (StringUtil.isNotBlank((CharSequence)node.getParentNumber()) && prentId == 0L) {
                prentId = ((MemberTreeNode)memberList.stream().filter(e -> e.getNumber().equals(node.getParentNumber())).findFirst().orElse(null)).getPkId();
            }
            memberObj.set("id", (Object)id);
            memberObj.set("model", (Object)modelId);
            memberObj.set("dimension", (Object)dimensionId);
            memberObj.set("parent", (Object)prentId);
            memberObj.set("number", (Object)node.getNumber());
            memberObj.set("name", (Object)node.getText());
            memberObj.set("longnumber", (Object)node.getLongNumber());
            memberObj.set("fullname", (Object)node.getLongText());
            memberObj.set("level", (Object)node.getLevel());
            memberObj.set("isleaf", (Object)node.isLeaf());
            memberObj.set("status", (Object)"A");
            memberObj.set("enable", (Object)"1");
            memberObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            memberCollection.add((Object)memberObj);
        }
        return memberCollection;
    }

    public static List<MemberTreeNode> getMemberList(MemberTreeNode rootNode, DynamicObjectCollection collection, String keyExt) {
        ArrayList<MemberTreeNode> memberTreeList = new ArrayList<MemberTreeNode>(10);
        ArrayList<String> members = new ArrayList<String>(10);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject obj = (DynamicObject)collection.get(i);
            String memberName = obj.getString("memberlist" + keyExt);
            String memberNumber = obj.getString("member" + keyExt);
            String memberFlag = obj.getString("memberflag" + keyExt);
            String firstName = obj.getString("firstmember" + keyExt);
            String secondName = obj.getString("secondmember" + keyExt);
            if (members.contains(memberNumber)) {
                String title = StringUtil.isBlank((CharSequence)keyExt) ? ResManager.loadKDString((String)"\u884c\u7ef4", (String)"BatchMemberSettingService_2", (String)"taxc-tpo", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5217\u7ef4", (String)"BatchMemberSettingService_3", (String)"taxc-tpo", (Object[])new Object[0]);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7b2c\u3010%2$s\u3011\u884c\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\uff01", (String)"BatchMemberSettingService_1", (String)"taxc-tpo", (Object[])new Object[0]), title, i + 1));
            }
            members.add(memberNumber);
            long rootId = 0L;
            int rootLevel = 0;
            String rootNumber = "";
            String rootLongNumber = "";
            String rootName = "";
            if (rootNode != null) {
                rootId = rootNode.getPkId();
                rootNumber = rootNode.getNumber();
                rootLongNumber = rootNode.getNumber() + ".";
                rootName = rootNode.getText() + ".";
                ++rootLevel;
            }
            String[] memberNumbers = memberNumber.split("_");
            if (StringUtil.isBlank((CharSequence)keyExt) && memberNumbers.length > 1) {
                String parentNumber = memberNumbers[0];
                if (memberTreeList.stream().noneMatch(e -> e.getNumber().equals(parentNumber))) {
                    MemberTreeNode parentTreeNode = new MemberTreeNode();
                    parentTreeNode.setParentPkId(rootId);
                    parentTreeNode.setParentNumber(rootNumber);
                    parentTreeNode.setNumber(parentNumber);
                    parentTreeNode.setLongNumber(rootLongNumber + parentNumber);
                    parentTreeNode.setText(firstName);
                    parentTreeNode.setLongText(rootName + firstName);
                    parentTreeNode.setLeaf(false);
                    parentTreeNode.setLevel(rootLevel + 1);
                    memberTreeList.add(parentTreeNode);
                }
                MemberTreeNode treeNode = new MemberTreeNode();
                treeNode.setMemberFlag(memberFlag);
                treeNode.setParentNumber(parentNumber);
                treeNode.setLongNumber(rootLongNumber + parentNumber + "." + memberNumber);
                treeNode.setNumber(memberNumber);
                String text = firstName + (StringUtil.isEmpty((CharSequence)secondName) ? "" : "_" + secondName);
                treeNode.setText(text);
                treeNode.setLongText(rootName + firstName + "." + text);
                treeNode.setLeaf(true);
                treeNode.setLevel(rootLevel + 2);
                memberTreeList.add(treeNode);
                continue;
            }
            MemberTreeNode treeNode = new MemberTreeNode();
            treeNode.setMemberFlag(memberFlag);
            treeNode.setParentPkId(rootId);
            treeNode.setParentNumber(rootNumber);
            treeNode.setLongNumber(rootNumber + "." + memberNumber);
            treeNode.setNumber(memberNumber);
            String text = firstName + (StringUtil.isEmpty((CharSequence)secondName) ? "" : "_" + secondName);
            treeNode.setText(text);
            treeNode.setLongText(rootName + text);
            treeNode.setLeaf(true);
            treeNode.setLevel(rootLevel + 1);
            memberTreeList.add(treeNode);
        }
        return memberTreeList;
    }

    public static boolean hasIdentifyCell(String jsonString, List<Integer> selRows, List<Integer> selCols, String currentSheetName) {
        LinkedHashMap jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString((String)jsonString);
        for (Map.Entry entry : jsonMap.entrySet()) {
            String sheetName = (String)entry.getKey();
            if (entry.getValue() == null || ((LinkedHashMap)entry.getValue()).isEmpty()) {
                logger.error("{} \u9875\u7b7e\u6570\u636e\u4e3a\u7a7a\uff01", entry.getKey());
                continue;
            }
            if (!StringUtil.isEmpty((CharSequence)currentSheetName) && !sheetName.equals(currentSheetName)) continue;
            JSONObject rowList = ((JSONObject)((LinkedHashMap)entry.getValue()).get("data")).getJSONObject("dataTable");
            int rowCount = ((LinkedHashMap)entry.getValue()).get("rowCount") == null ? rowList.size() : ((Integer)((LinkedHashMap)entry.getValue()).get("rowCount")).intValue();
            int colCount = ((LinkedHashMap)entry.getValue()).get("columnCount") == null ? ((JSONObject)rowList.get((Object)0)).size() : ((Integer)((LinkedHashMap)entry.getValue()).get("columnCount")).intValue();
            for (int i = 0; i < rowCount; ++i) {
                JSONObject row = rowList.get((Object)("" + i)) == null ? new JSONObject() : (JSONObject)rowList.get((Object)("" + i));
                for (int j = 0; j < colCount; ++j) {
                    JSONObject cellObj = row.getJSONObject("" + j);
                    if (!BatchMemberSettingService.isIdentifyCell(cellObj, i, j, selRows, selCols)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<DeclareReportTemplateCellsVo> paraJson(String jsonString, List<Integer> selRows, List<Integer> selCols, String currentSheetName) {
        JSONObject json = JSONObject.parseObject((String)jsonString);
        LinkedHashMap jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString((String)jsonString);
        ArrayList<DeclareReportTemplateCellsVo> cellsVoList = new ArrayList<DeclareReportTemplateCellsVo>(16);
        for (Map.Entry entry : jsonMap.entrySet()) {
            int i;
            DeclareReportTemplateCellsVo cellsVo = new DeclareReportTemplateCellsVo();
            String sheetName = (String)entry.getKey();
            if (entry.getValue() == null || ((LinkedHashMap)entry.getValue()).isEmpty()) {
                logger.error("{} \u9875\u7b7e\u6570\u636e\u4e3a\u7a7a\uff01", entry.getKey());
                continue;
            }
            if (!StringUtil.isEmpty((CharSequence)currentSheetName) && !sheetName.equals(currentSheetName)) continue;
            JSONObject rowList = ((JSONObject)((LinkedHashMap)entry.getValue()).get("data")).getJSONObject("dataTable");
            int rowCount = ((LinkedHashMap)entry.getValue()).get("rowCount") == null ? rowList.size() : ((Integer)((LinkedHashMap)entry.getValue()).get("rowCount")).intValue();
            int colCount = ((LinkedHashMap)entry.getValue()).get("columnCount") == null ? ((JSONObject)rowList.get((Object)0)).size() : ((Integer)((LinkedHashMap)entry.getValue()).get("columnCount")).intValue();
            JSONArray spans = (JSONArray)((LinkedHashMap)entry.getValue()).get("spans");
            HashMap<String, TemplateCellVo> cellsMap = new HashMap<String, TemplateCellVo>();
            for (i = 0; i < rowCount; ++i) {
                JSONObject row = rowList.get((Object)("" + i)) == null ? new JSONObject() : (JSONObject)rowList.get((Object)("" + i));
                for (int j = 0; j < colCount; ++j) {
                    JSONObject cellObj = row.getJSONObject("" + j);
                    String key = i + SPLIT_STRING + j;
                    TemplateCellVo cell = new TemplateCellVo();
                    cell.setCellKey(key);
                    cell.setSpan(false);
                    cell.setIdentifyCell(BatchMemberSettingService.isIdentifyCell(cellObj, i, j, selRows, selCols));
                    String value = cellObj == null ? null : cellObj.getString("value");
                    cell.setCellValue(value);
                    cellsMap.put(key, cell);
                }
            }
            for (i = 0; spans != null && i < spans.size(); ++i) {
                JSONObject jon = (JSONObject)spans.get(i);
                Integer rowCount1 = jon.getInteger("rowCount");
                Integer colCount1 = jon.getInteger("colCount");
                Integer row = jon.getInteger("row");
                Integer col = jon.getInteger("col");
                String firstCellKey = row + SPLIT_STRING + col;
                TemplateCellVo firstCell = (TemplateCellVo)cellsMap.get(firstCellKey);
                for (int r = 0; r < rowCount1; ++r) {
                    for (int c = 0; c < colCount1; ++c) {
                        int cellRow = row + r;
                        int cellCol = col + c;
                        String cellKey = cellRow + SPLIT_STRING + cellCol;
                        TemplateCellVo cell = (TemplateCellVo)cellsMap.get(cellKey);
                        cell.setCellValue(firstCell.getCellValue());
                        cell.setSpan(true);
                        cell.setSpanRowCount(rowCount1);
                        cell.setSpanColCount(colCount1);
                        cell.setIdentifyCell(firstCell.isIdentifyCell());
                        cell.setSpanKey(firstCellKey);
                        cellsMap.put(cellKey, cell);
                    }
                }
            }
            cellsVo.setCellsMap(cellsMap);
            cellsVo.setSheetName(sheetName);
            cellsVo.setRowCount(rowCount);
            cellsVo.setColCount(colCount);
            cellsVoList.add(cellsVo);
        }
        return cellsVoList;
    }

    private static boolean isIdentifyCell(JSONObject cellObj, int rowIndex, int columnIndex, List<Integer> selRows, List<Integer> selCols) {
        if (!(selRows == null || selCols == null || selRows.contains(rowIndex) && selCols.contains(columnIndex))) {
            return false;
        }
        return cellObj == null || StringUtil.isBlank((CharSequence)cellObj.getString("value"));
    }

    public static List<DeclareReportTemplateCellsVo> setMember(List<DeclareReportTemplateCellsVo> map) {
        ArrayList<DeclareReportTemplateCellsVo> identifyList = new ArrayList<DeclareReportTemplateCellsVo>(16);
        for (DeclareReportTemplateCellsVo entry : map) {
            DeclareReportTemplateCellsVo resultVo = new DeclareReportTemplateCellsVo();
            String sheetName = entry.getSheetName();
            Map<String, TemplateCellVo> cellsMap = entry.getCellsMap();
            HashMap<String, TemplateCellVo> identifyCells = new HashMap<String, TemplateCellVo>();
            for (Map.Entry<String, TemplateCellVo> e : cellsMap.entrySet()) {
                String startRowKey;
                TemplateCellVo cellVo;
                boolean startFlag;
                String startRowKey2;
                TemplateCellVo cellVo2;
                boolean startFlag2;
                if (!e.getValue().isIdentifyCell() || e.getValue().isSpan() && !e.getKey().equals(e.getValue().getSpanKey())) continue;
                String cellKey = e.getKey();
                TemplateCellVo identifyCellVo = e.getValue();
                String[] needSetIndex = cellKey.split(SPLIT_STRING);
                int rowIndex = Integer.parseInt(needSetIndex[0]);
                int colIndex = Integer.parseInt(needSetIndex[1]);
                ArrayList<TemplateCellVo> rowMemberList = new ArrayList<TemplateCellVo>();
                ArrayList<TemplateCellVo> colMemberList = new ArrayList<TemplateCellVo>();
                int startRowIndex = rowIndex;
                int startColIndex = colIndex;
                while (!(startFlag2 = (cellVo2 = cellsMap.get(startRowKey2 = startRowIndex + SPLIT_STRING + --startColIndex)) == null || cellVo2 != null && !cellVo2.isIdentifyCell() && StringUtil.isNotBlank((CharSequence)cellVo2.getCellValue()))) {
                }
                List<TemplateCellVo> rowMemberCells = BatchMemberSettingService.findMemberCells(cellsMap, rowMemberList, startRowIndex, startColIndex, "row");
                int nextRowIndex = rowIndex - 1;
                int startRowIndex1 = rowIndex;
                int startColIndex1 = colIndex;
                while (!(startFlag = (cellVo = cellsMap.get(startRowKey = --startRowIndex1 + SPLIT_STRING + startColIndex1)) == null || cellVo != null && !cellVo.isIdentifyCell() && StringUtil.isNotBlank((CharSequence)cellVo.getCellValue()))) {
                }
                List<TemplateCellVo> colMemberCells = BatchMemberSettingService.findMemberCells(cellsMap, colMemberList, startColIndex1, startRowIndex1, "col");
                identifyCellVo.setRowMemberList(rowMemberCells);
                identifyCellVo.setColMemberList(colMemberCells);
                identifyCells.put(cellKey, identifyCellVo);
            }
            resultVo.setSheetName(sheetName);
            resultVo.setCellsMap(identifyCells);
            identifyList.add(resultVo);
        }
        return identifyList;
    }

    public static List<Map<String, String>> cellsToMember(List<DeclareReportTemplateCellsVo> list) {
        ArrayList<Map<String, String>> rowMapList = new ArrayList<Map<String, String>>(list.size());
        for (DeclareReportTemplateCellsVo declareReportTemplateCellsVo : list) {
            StringBuilder memberStr = new StringBuilder();
            String sheetName = declareReportTemplateCellsVo.getSheetName();
            memberStr.append(sheetName);
            for (Map.Entry<String, TemplateCellVo> entry : declareReportTemplateCellsVo.getCellsMap().entrySet()) {
                int lastIndex;
                String cellValueStr;
                String cellValue;
                HashMap<String, String> rowMap = new HashMap<String, String>();
                ArrayList<String> rowMember = new ArrayList<String>(8);
                ArrayList<String> rowMemberStr = new ArrayList<String>(8);
                ArrayList<String> colMember = new ArrayList<String>(8);
                ArrayList<String> colMemberStr = new ArrayList<String>(8);
                TemplateCellVo cellVo = entry.getValue();
                List<TemplateCellVo> rowMemberList = cellVo.getRowMemberList();
                List<TemplateCellVo> colMemberList = cellVo.getColMemberList();
                String cellKey = entry.getKey();
                String[] cellKeys = cellKey.split(SPLIT_STRING);
                String rowFlag = sheetName + SPLIT_STRING + cellKeys[0];
                String colFlag = sheetName + SPLIT_STRING + cellKeys[1];
                rowMap.put("sheeName", sheetName);
                rowMap.put("cellKey", entry.getKey());
                rowMap.put("rowFlag", rowFlag);
                rowMap.put("colFlag", colFlag);
                for (TemplateCellVo vo : rowMemberList) {
                    cellValue = vo.getCellValue();
                    cellValueStr = StringUtil.removeSpecialCharacter((String)PinYinUtil.getPinYinHeadChar((String)vo.getCellValue()));
                    if (vo.isSpan()) {
                        rowMember.add(cellValue);
                        rowMemberStr.add(cellValueStr);
                        continue;
                    }
                    if (rowMember.size() == 0) {
                        rowMember.add(cellValue);
                    } else {
                        lastIndex = rowMember.size() - 1;
                        rowMember.set(lastIndex, (String)rowMember.get(lastIndex) + cellValue);
                    }
                    if (rowMemberStr.size() == 0) {
                        rowMemberStr.add(cellValueStr);
                        continue;
                    }
                    lastIndex = rowMemberStr.size() - 1;
                    rowMemberStr.set(lastIndex, (String)rowMemberStr.get(lastIndex) + cellValueStr);
                }
                rowMemberStr.add(StringUtil.removeSpecialCharacter((String)PinYinUtil.getPinYinHeadChar((String)sheetName)));
                for (TemplateCellVo vo : colMemberList) {
                    cellValue = vo.getCellValue();
                    cellValueStr = StringUtil.removeSpecialCharacter((String)PinYinUtil.getPinYinHeadChar((String)vo.getCellValue()));
                    if (vo.isSpan()) {
                        colMember.add(cellValue);
                        colMemberStr.add(cellValueStr);
                        continue;
                    }
                    if (colMember.size() == 0) {
                        colMember.add(cellValue);
                    } else {
                        lastIndex = colMember.size() - 1;
                        colMember.set(lastIndex, (String)colMember.get(lastIndex) + cellValue);
                    }
                    if (colMemberStr.size() == 0) {
                        colMemberStr.add(cellValueStr);
                        continue;
                    }
                    lastIndex = colMemberStr.size() - 1;
                    colMemberStr.set(lastIndex, (String)colMemberStr.get(lastIndex) + cellValueStr);
                }
                Collections.reverse(rowMember);
                Collections.reverse(rowMemberStr);
                Collections.reverse(colMember);
                Collections.reverse(colMemberStr);
                rowMap.put("rowMember", rowMember.stream().collect(Collectors.joining("_")));
                rowMap.put("rowMemberStr", rowMemberStr.stream().collect(Collectors.joining("_")));
                rowMap.put("colMember", colMember.stream().collect(Collectors.joining("_")));
                rowMap.put("colMemberStr", colMemberStr.stream().collect(Collectors.joining("_")));
                rowMapList.add(rowMap);
            }
        }
        return rowMapList;
    }

    private static List<TemplateCellVo> findMemberCells(Map<String, TemplateCellVo> cellMap, List<TemplateCellVo> rowMemberList, int currDimensionStartIndex, int anotherStartIndex, String dimension) {
        int colIndexNext = anotherStartIndex;
        if (colIndexNext < 0) {
            return rowMemberList;
        }
        if (colIndexNext >= 0) {
            TemplateCellVo tailNode;
            String nextCellKey = dimension.equalsIgnoreCase("row") ? currDimensionStartIndex + SPLIT_STRING + colIndexNext : colIndexNext + SPLIT_STRING + currDimensionStartIndex;
            TemplateCellVo nextCellVo = cellMap.get(nextCellKey);
            if (nextCellVo.isIdentifyCell() || nextCellVo == null) {
                return rowMemberList;
            }
            if (nextCellVo.isSpan()) {
                int spanCount;
                int n = spanCount = dimension.equalsIgnoreCase("row") ? nextCellVo.getSpanRowCount() : nextCellVo.getSpanColCount();
                if (spanCount > 1) {
                    rowMemberList.add(nextCellVo);
                    return rowMemberList;
                }
            }
            if (nextCellVo.isSpan() && rowMemberList.size() > 0 && (tailNode = rowMemberList.get(rowMemberList.size() - 1)).isSpan() && tailNode.getSpanKey().equals(nextCellVo.getSpanKey())) {
                return BatchMemberSettingService.findMemberCells(cellMap, rowMemberList, currDimensionStartIndex, --colIndexNext, dimension);
            }
            rowMemberList.add(nextCellVo);
            return BatchMemberSettingService.findMemberCells(cellMap, rowMemberList, currDimensionStartIndex, --colIndexNext, dimension);
        }
        return rowMemberList;
    }

    public static void saveTemplaterReportItemsRelation(long templateId, List<Map<String, Object>> reportItems) {
        String sql = "insert into t_tpo_temp_rep_relation (fid, fentryid, fseq, freportitemid, frowcol) values (?,?,?,?,?)";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        for (Map<String, Object> map : reportItems) {
            long id = DBUtils.getLongId((String)"t_tpo_temp_rep_relation");
            long reportItemId = (Long)map.get("reportItemId");
            String reportItemNumber = (String)map.get("reportNumber");
            paramList.add(new Object[]{templateId, id, 0, reportItemId, reportItemNumber});
        }
        DBUtils.executeBatch((String)"taxc", (String)sql, paramList);
    }
}

