/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.multidideclare;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.domain.MultiEntityField;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Style;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.file.FileUtils;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.GetTemplateVo;
import kd.taxc.tpo.business.multidideclare.MultiDataService;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.CollectionUtils;

public class ExportService {
    private static Log logger = LogFactory.getLog(MultiDataService.class);
    public static final String BASE_PATH = System.getProperty("user.home") + File.separator + "template" + File.separator;
    public static final String DEFAULT_DECIMAL_FORMAT = "#####0.00";
    public static final String MICROMETER_DECIMAL_INIT_FORMAT = "###,##0";
    public static final String BUILD_RESULT = "RESULT";
    public static final String DYN_ROW_NO_PRE = "dynRow#";
    public static final String HIDDEN_SHEET_NAME = "TEMPLATE_ID";
    private static final String[] DECIMAL_SCALE_SUFFIX = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "00000000000", "000000000000", "0000000000000", "00000000000000", "000000000000000", "0000000000000000", "00000000000000000", "000000000000000000", "0000000000000000000", "00000000000000000000"};

    public static String exportResultExcel(DynamicObject templateObject, GetTemplateVo getTemplateVo, Map<String, String> valMap, Map<String, MultiEntityField> fieldMap, Map<String, FormulaVo> formulaVoMap) {
        if (templateObject == null) {
            return null;
        }
        Long templateId = templateObject.getLong("id");
        String fileName = UUID.randomUUID().toString() + ".xlsx";
        File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)fileName))));
        file.getParentFile().mkdirs();
        String jsonString = templateObject.getString("content_tag");
        List dynRowList = DynamicRowService.getDynRowNoList((Long)templateId);
        logger.info("\u5f15\u51fatemplateId: {}", (Object)templateId);
        ExportService.buildExcel(BUILD_RESULT, templateId, jsonString, getTemplateVo, fieldMap, file, formulaVoMap, valMap, dynRowList);
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildExcel(String buildType, Long templateId, String jsonString, GetTemplateVo getTemplateVo, Map<String, MultiEntityField> fieldMap, File file, Map<String, FormulaVo> formulaVoMap, Map<String, String> valMap, List<String> dynRowList) {
        if (valMap == null) {
            valMap = new HashMap<String, String>(0);
        }
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFCellStyle cellStyle = wb.createCellStyle();
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            XSSFColor color = new XSSFColor(Color.BLACK, null);
            cellStyle.setBottomBorderColor(color);
            cellStyle.setLeftBorderColor(color);
            cellStyle.setTopBorderColor(color);
            cellStyle.setRightBorderColor(color);
            LinkedHashMap jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString((String)jsonString);
            Iterator iterator = jsonMap.entrySet().iterator();
            TreeMap<Integer, Map.Entry<String, LinkedHashMap>> sheetMap = new TreeMap<Integer, Map.Entry<String, LinkedHashMap>>();
            while (iterator.hasNext()) {
                Map.Entry<String, LinkedHashMap> entry = iterator.next();
                if (null == entry || ExportService.isContainsExcludeSheet(entry) || SpreadUtils.isSheetInvisible(entry)) continue;
                sheetMap.put(Integer.valueOf(entry.getValue().getOrDefault("index", "0").toString()), entry);
            }
            ArrayList rowList = new ArrayList();
            for (Map.Entry sheetEntry : sheetMap.entrySet()) {
                Map.Entry entry = (Map.Entry)sheetEntry.getValue();
                String name = (String)((LinkedHashMap)entry.getValue()).get("name");
                if (getTemplateVo != null && !CollectionUtils.isEmpty((Collection)getTemplateVo.getHideSheets()) && getTemplateVo.getHideSheets().contains(name)) continue;
                XSSFSheet sheet = wb.createSheet(name);
                sheet.setDefaultColumnWidth(20);
                Map<String, List<Cell>> dataMap = ExportService.getDataCell(entry, SpreadUtils.parseStyles((JSONObject)JSONObject.parseObject((String)jsonString)), dynRowList);
                List colWidthList = SpreadUtils.parseColumns((Map.Entry)entry, (int)30);
                int index = 0;
                for (Object width : colWidthList) {
                    int w = (Integer)width * 30;
                    if (w > 65280) {
                        sheet.setColumnWidth(index++, 65280);
                        continue;
                    }
                    sheet.setColumnWidth(index++, w);
                }
                HashMap<Integer, List<Integer>> rowTemplateRowMap = new HashMap<Integer, List<Integer>>();
                if (BUILD_RESULT.equals(buildType)) {
                    ExportService.buildExport(wb, sheet, dataMap, fieldMap, formulaVoMap, valMap, rowTemplateRowMap);
                } else {
                    Object width;
                    width = dataMap.entrySet().iterator();
                    while (width.hasNext()) {
                        Map.Entry data = (Map.Entry)width.next();
                        String dataRow = (String)data.getKey();
                        int createRow = dataRow.contains("#") ? Integer.parseInt(dataRow.substring(dataRow.indexOf(35) + 1)) : Integer.parseInt(dataRow);
                        ExportService.createSheetRow(wb, sheet, createRow, data, fieldMap, formulaVoMap, valMap, null);
                    }
                }
                List spanList = SpreadUtils.getSpanCell((Map.Entry)entry);
                if (BUILD_RESULT.equals(buildType)) {
                    for (Cell cell : spanList) {
                        rowList.clear();
                        int row = cell.getRow();
                        int rowCount = cell.getRowCount();
                        for (int i = 0; i < rowCount; ++i) {
                            List integers = (List)rowTemplateRowMap.get(row);
                            if (integers == null) continue;
                            rowList.addAll(integers);
                        }
                        if (rowList.size() <= 0) continue;
                        Integer firstRow = (Integer)rowList.get(0);
                        if (rowCount == 1) {
                            for (Integer fr : rowList) {
                                CellRangeAddress region = new CellRangeAddress(fr.intValue(), fr.intValue(), cell.getCol(), cell.getCol() + cell.getColCount() - 1);
                                sheet.addMergedRegion(region);
                            }
                            continue;
                        }
                        int lastRow = firstRow + rowList.size() - 1;
                        CellRangeAddress region = new CellRangeAddress(firstRow.intValue(), lastRow, cell.getCol(), cell.getCol() + cell.getColCount() - 1);
                        sheet.addMergedRegion(region);
                    }
                    continue;
                }
                for (Cell cell : spanList) {
                    CellRangeAddress region = new CellRangeAddress(cell.getRow(), cell.getRow() + cell.getRowCount() - 1, cell.getCol(), cell.getCol() + cell.getColCount() - 1);
                    sheet.addMergedRegion(region);
                }
            }
            ExportService.createHiddenSheet(wb, templateId);
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                wb.write((OutputStream)fout);
            }
            catch (Exception e) {
                logger.error("\u751f\u6210\u6a21\u677f\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException e) {
                        logger.error((Throwable)e);
                    }
                }
            }
        }
        return file.getAbsolutePath();
    }

    private static boolean isContainsExcludeSheet(Map.Entry<String, LinkedHashMap> entry) {
        boolean check = false;
        if (null != entry) {
            HashSet<String> set = new HashSet<String>();
            set.add(ResManager.loadKDString((String)"\u540d\u518c\u4fe1\u606f\u8868", (String)"ExportService_0", (String)"taxc-tpo", (Object[])new Object[0]));
            check = set.contains(entry.getKey());
        }
        return check;
    }

    private static void buildExport(XSSFWorkbook wb, XSSFSheet sheet, Map<String, List<Cell>> dataMap, Map<String, MultiEntityField> fieldMap, Map<String, FormulaVo> formulaVoMap, Map<String, String> valMap, Map<Integer, List<Integer>> rowTemplateRowMap) {
        Set rowSet = valMap.keySet().stream().map(s -> s.substring(0, s.lastIndexOf(35))).collect(Collectors.toSet());
        int index = -1;
        for (Map.Entry<String, List<Cell>> data : dataMap.entrySet()) {
            int createRow;
            String dataRow = data.getKey();
            boolean isDynRow = false;
            if (dataRow.contains("#")) {
                createRow = Integer.parseInt(dataRow.substring(dataRow.indexOf(35) + 1));
                isDynRow = true;
            } else {
                createRow = Integer.parseInt(dataRow);
            }
            if (index == -1) {
                index = createRow;
            }
            if (isDynRow) {
                List<Cell> cells = data.getValue();
                Cell cell = cells.get(cells.size() - 1);
                String text = cell.getText();
                String dynRowNo = text.substring(text.indexOf(35) + 1);
                if (!StringUtils.isNotBlank((CharSequence)dynRowNo)) continue;
                String[] split = dynRowNo.split("#");
                int ewblxh = Integer.parseInt(split[1]);
                String dynRowId = split[0] + "#" + ewblxh;
                while (rowSet.contains(dynRowId)) {
                    ExportService.createSheetRow(wb, sheet, index, data, fieldMap, formulaVoMap, valMap, ewblxh);
                    List integers = rowTemplateRowMap.computeIfAbsent(createRow, k -> new ArrayList());
                    integers.add(index);
                    ++index;
                    dynRowId = split[0] + "#" + ++ewblxh;
                }
                continue;
            }
            ExportService.createSheetRow(wb, sheet, index, data, fieldMap, formulaVoMap, valMap, null);
            List integers = rowTemplateRowMap.computeIfAbsent(createRow, k -> new ArrayList());
            integers.add(index);
            ++index;
        }
    }

    private static void createSheetRow(XSSFWorkbook wb, XSSFSheet sheet, int index, Map.Entry<String, List<Cell>> data, Map<String, MultiEntityField> fieldMap, Map<String, FormulaVo> formulaVoMap, Map<String, String> valMap, Integer ewblxh) {
        XSSFRow row = sheet.createRow(index);
        for (Cell cell : data.getValue()) {
            XSSFCell hSSFCell = row.createCell(cell.getCol());
            String text = cell.getText();
            if (StringUtils.isNotBlank((CharSequence)text)) {
                text = text.trim();
            }
            if (StringUtils.isNotEmpty((CharSequence)text) && text.endsWith("%")) {
                text = text.substring(0, text.length() - 1);
            }
            if (StringUtils.isNotBlank((CharSequence)text) && text.startsWith(DYN_ROW_NO_PRE)) continue;
            MultiEntityField field = null;
            String cellKey = "";
            if (StringUtils.isNotEmpty((CharSequence)text) && text.contains("#")) {
                cellKey = text.replace("${", "").replace("}", "");
                String[] keys = cellKey.split("#");
                String key = keys[keys.length - 1];
                field = fieldMap.get(key);
            }
            if (field == null) {
                if (StringUtil.isNotEmpty((CharSequence)text) && text.contains("#")) {
                    text = CollectionUtils.isEmpty(valMap) ? "" : valMap.getOrDefault(cellKey, "");
                }
            } else {
                Map<String, String> itemMap;
                String fieldId = cellKey;
                String[] s = fieldId.split("#");
                if (ewblxh != null) {
                    fieldId = s[0] + "#" + ewblxh + "#" + s[s.length - 1];
                }
                FormulaVo formulaVo = formulaVoMap.get(fieldId);
                String string = text = CollectionUtils.isEmpty(valMap) ? "" : valMap.getOrDefault(fieldId, "");
                if (formulaVo != null && ("2".equals(formulaVo.getCellType()) || "3".equals(formulaVo.getCellType()) || "4".equals(formulaVo.getCellType()))) {
                    Map<String, String> stringStringMap = ExportService.parseCellType(formulaVo.getFormulaName());
                    text = stringStringMap.getOrDefault(text, "");
                    if (stringStringMap.values().stream().collect(Collectors.joining()).length() > 200) {
                        ExportService.setDropDownBox(wb, sheet.getSheetName(), stringStringMap.values().toArray(new String[0]), cell.getRow(), cell.getRow(), cell.getCol(), cell.getCol());
                    } else {
                        CellRangeAddressList regions = new CellRangeAddressList(cell.getRow(), cell.getRow(), cell.getCol(), cell.getCol());
                        DataValidationHelper helper = sheet.getDataValidationHelper();
                        DataValidationConstraint constraint = helper.createExplicitListConstraint(stringStringMap.values().toArray(new String[0]));
                        DataValidation validation = helper.createValidation(constraint, regions);
                        sheet.addValidationData(validation);
                    }
                }
                if ("Combo".equals(field.getFieldType())) {
                    String v = "[" + valMap.getOrDefault(fieldId, "").replaceAll(",", "],[") + "]";
                    ArrayList<String> itemList = new ArrayList<String>();
                    for (ValueMapItem item : field.getComboItems()) {
                        if (!v.contains("[" + item.getValue() + "]")) continue;
                        itemList.add(item.getName().getLocaleValue());
                    }
                    text = String.join((CharSequence)",", itemList);
                } else if ((null != formulaVo && "5".equals(formulaVo.getCellType()) || null != formulaVo && "Unit".equals(field.getFieldType())) && (itemMap = ExportService.parseCellType(formulaVo.getFormulaName())) != null) {
                    Map.Entry<String, String> cellTypeEntry = itemMap.entrySet().iterator().next();
                    String key = cellTypeEntry.getKey();
                    List<String> selectFieldList = ExportService.parseBaseDataFieldList(cellTypeEntry.getValue());
                    DynamicObject object = QueryServiceHelper.queryOne((String)key, (String)String.join((CharSequence)",", selectFieldList), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(StringUtils.isNumeric((CharSequence)text) ? Long.parseLong(text) : 0L))});
                    text = ExportService.getDisplayText(cellTypeEntry.getValue(), object);
                }
                text = ExportService.dataFormat(text, field);
            }
            ExportService.setCellStyleAndValue(wb, field, cell.getStyle(), text, hSSFCell);
        }
    }

    public static String dataFormat(Object dataObj, MultiEntityField fieldType) {
        if (dataObj == null) {
            return null;
        }
        if (fieldType != null) {
            if ("decimal".equals(fieldType.getFieldType())) {
                try {
                    BigDecimal bd = new BigDecimal(dataObj.toString());
                    String format = fieldType.getFormat();
                    if (StringUtil.isBlank((CharSequence)format)) {
                        format = DEFAULT_DECIMAL_FORMAT;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat(format);
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(bd);
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if (dataObj instanceof Date && "time".equals(fieldType.getFieldType())) {
                String format = fieldType.getFormat();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
                return DateUtils.format((Date)((Date)dataObj), (String)format);
            }
            if (dataObj instanceof Date && "date".equals(fieldType.getFieldType())) {
                String format = fieldType.getFormat();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd";
                }
                return DateUtils.format((Date)((Date)dataObj), (String)format);
            }
            if (dataObj instanceof String && "date".equals(fieldType.getFieldType())) {
                String format = fieldType.getFormat();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd";
                }
                try {
                    dataObj = DateUtils.format((Date)DateUtils.stringToDate((String)dataObj.toString()), (String)format);
                }
                catch (Exception e) {
                    logger.error("{}format illigal! {}", dataObj, (Object)e);
                }
            } else if ("integer".equals(fieldType.getFieldType())) {
                return DataFormatUtils.formatInteger((Object)dataObj, (String)MICROMETER_DECIMAL_INIT_FORMAT);
            }
        }
        return dataObj.toString();
    }

    private static void createHiddenSheet(XSSFWorkbook wb, Long templateId) {
        XSSFSheet sheet = wb.createSheet(HIDDEN_SHEET_NAME);
        sheet.setDefaultColumnWidth(20);
        XSSFRow row = sheet.createRow(0);
        XSSFCell cell = row.createCell(0);
        cell.setCellValue(templateId.toString());
        wb.setSheetHidden(wb.getSheetIndex(HIDDEN_SHEET_NAME), true);
    }

    public static Map<String, String> parseCellType(String json) {
        LinkedHashMap<String, String> itemMap = new LinkedHashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            Object jsonObject = JSONObject.parse((String)json);
            if (jsonObject instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)jsonObject;
                for (int i = 0; i < jSONArray.size(); ++i) {
                    JSONObject jon = (JSONObject)jSONArray.get(i);
                    itemMap.put(jon.getString("val"), jon.getString("text"));
                }
            } else if (jsonObject instanceof JSONObject) {
                JSONObject jon = (JSONObject)jsonObject;
                itemMap.put(jon.getString("val"), jon.getString("text"));
            }
        }
        return itemMap;
    }

    public static List<String> parseBaseDataFieldList(String basetext) {
        ArrayList<String> selectFieldList = new ArrayList<String>();
        selectFieldList.add("id");
        if (basetext.contains("{")) {
            String[] str;
            for (String s : str = basetext.split("\\{")) {
                String selectField;
                int index = s.indexOf(125);
                if (index <= 0 || selectFieldList.contains(selectField = s.substring(0, index))) continue;
                selectFieldList.add(selectField);
            }
        }
        return selectFieldList;
    }

    public static String getDisplayText(String display, DynamicObject result) {
        if (result == null) {
            return "";
        }
        String displayEmpty = display;
        IDataEntityType objType = result.getDataEntityType();
        DataEntityPropertyCollection propertyCollection = objType.getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            String replaceStr = result.getString(property.getName());
            if (replaceStr == null) {
                replaceStr = "";
            }
            display = display.replace("{" + property.getName() + "}", replaceStr);
            displayEmpty = displayEmpty.replace("{" + property.getName() + "}", "");
        }
        if (!display.equals(displayEmpty)) {
            return display;
        }
        return "";
    }

    public static void setDropDownBox(XSSFWorkbook wb, String typeName, String[] values, Integer firstRow, Integer lastRow, Integer firstCol, Integer lastCol) {
        int sheetTotal = wb.getNumberOfSheets();
        if (values != null && values.length != 0) {
            String hiddenSheetName = "hiddenSheet";
            XSSFSheet hiddenSheet = wb.getSheet(hiddenSheetName);
            if (hiddenSheet == null) {
                hiddenSheet = wb.createSheet(hiddenSheetName);
                for (int i = 0; i < values.length; ++i) {
                    XSSFRow row = hiddenSheet.createRow(i);
                    XSSFCell cell = row.createCell(0);
                    cell.setCellValue(values[i]);
                }
                wb.setSheetHidden(sheetTotal, true);
            }
            String strFormula = hiddenSheetName + "!$A$1:$A$65535";
            XSSFDataValidationConstraint constraint = new XSSFDataValidationConstraint(3, strFormula);
            CellRangeAddressList regions = new CellRangeAddressList(firstRow.intValue(), lastRow.intValue(), firstCol.intValue(), lastCol.intValue());
            XSSFDataValidationHelper help = new XSSFDataValidationHelper(hiddenSheet);
            DataValidation validation = help.createValidation((DataValidationConstraint)constraint, regions);
            XSSFSheet sheet1 = wb.getSheet(typeName);
            sheet1.addValidationData(validation);
        }
    }

    public static void setCellStyleAndValue(XSSFWorkbook wb, MultiEntityField field, Style style, String value, XSSFCell cell) {
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        XSSFColor color = new XSSFColor(Color.BLACK, null);
        cellStyle.setBottomBorderColor(color);
        cellStyle.setLeftBorderColor(color);
        cellStyle.setTopBorderColor(color);
        cellStyle.setRightBorderColor(color);
        XSSFDataFormat fmt = wb.createDataFormat();
        cellStyle.setDataFormat(fmt.getFormat("TEXT"));
        cell.setCellValue(value);
        if (field != null) {
            if ("Text".equalsIgnoreCase(field.getFieldType()) || "string".equalsIgnoreCase(field.getFieldType())) {
                cellStyle.setDataFormat(fmt.getFormat("TEXT"));
            } else if ("Date".equalsIgnoreCase(field.getFieldType())) {
                cellStyle.setDataFormat(fmt.getFormat("TEXT"));
            } else if ("Decimal".equalsIgnoreCase(field.getFieldType()) || "integer".equalsIgnoreCase(field.getFieldType())) {
                String format = field.getFormat();
                if (format == null) {
                    format = "0";
                    if (field.getScale() > 0) {
                        String formatSuffix = DECIMAL_SCALE_SUFFIX[field.getScale()];
                        format = "0." + formatSuffix;
                    }
                }
                cellStyle.setDataFormat(fmt.getFormat(format));
                BigDecimal bigDecimal = new BigDecimal(value != null && StringUtil.isNumeric((String)value.replace(",", "")) ? value.replace(",", "") : "0");
                cell.setCellValue(bigDecimal.doubleValue());
            } else if ("Basedata".equalsIgnoreCase(field.getFieldType())) {
                cellStyle.setDataFormat(fmt.getFormat("TEXT"));
            }
        }
        if (style != null && "@".equals(style.getFormatter())) {
            cellStyle.setDataFormat(fmt.getFormat("TEXT"));
        }
        if (style != null) {
            if (style.gethAlign() != null) {
                switch (style.gethAlign()) {
                    case 0: {
                        cellStyle.setAlignment(HorizontalAlignment.LEFT);
                        break;
                    }
                    case 1: {
                        cellStyle.setAlignment(HorizontalAlignment.CENTER);
                        break;
                    }
                    case 2: {
                        cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                        break;
                    }
                    default: {
                        ExportService.setCellDefaultAlignmentByFieldType(cellStyle, null, field, 1);
                    }
                }
            }
            if (style.getvAlign() != null) {
                cellStyle.setVerticalAlignment(VerticalAlignment.forInt((int)style.getvAlign()));
            }
        } else {
            ExportService.setCellDefaultAlignmentByFieldType(cellStyle, null, field, 1);
            ExportService.setCellDefaultAlignmentByFieldType(cellStyle, null, field, 2);
        }
        cell.setCellStyle((CellStyle)cellStyle);
    }

    public static XSSFCellStyle getCellStyle(XSSFWorkbook wb, MultiEntityField field, Style style) {
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        XSSFColor color = new XSSFColor(Color.BLACK, null);
        cellStyle.setBottomBorderColor(color);
        cellStyle.setLeftBorderColor(color);
        cellStyle.setTopBorderColor(color);
        cellStyle.setRightBorderColor(color);
        XSSFDataFormat fmt = wb.createDataFormat();
        cellStyle.setDataFormat(fmt.getFormat("TEXT"));
        if (field != null) {
            if ("Text".equals(field.getFieldType())) {
                cellStyle.setDataFormat(fmt.getFormat("TEXT"));
            } else if ("Date".equals(field.getFieldType())) {
                cellStyle.setDataFormat(fmt.getFormat("TEXT"));
            } else if ("Decimal".equals(field.getFieldType())) {
                if (field.getScale() < 1) {
                    cellStyle.setDataFormat(fmt.getFormat("0"));
                } else {
                    cellStyle.setDataFormat(fmt.getFormat("0.00"));
                }
            } else if ("Basedata".equals(field.getFieldType())) {
                cellStyle.setDataFormat(fmt.getFormat("TEXT"));
            }
        }
        if (style != null && "@".equals(style.getFormatter())) {
            cellStyle.setDataFormat(fmt.getFormat("TEXT"));
        }
        if (style != null) {
            if (style.gethAlign() != null) {
                switch (style.gethAlign()) {
                    case 0: {
                        cellStyle.setAlignment(HorizontalAlignment.LEFT);
                        break;
                    }
                    case 1: {
                        cellStyle.setAlignment(HorizontalAlignment.CENTER);
                        break;
                    }
                    case 2: {
                        cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                        break;
                    }
                    default: {
                        ExportService.setCellDefaultAlignmentByFieldType(cellStyle, null, field, 1);
                    }
                }
            }
            if (style.getvAlign() != null) {
                cellStyle.setVerticalAlignment(VerticalAlignment.forInt((int)style.getvAlign()));
            }
        } else {
            ExportService.setCellDefaultAlignmentByFieldType(cellStyle, null, field, 1);
            ExportService.setCellDefaultAlignmentByFieldType(cellStyle, null, field, 2);
        }
        return cellStyle;
    }

    private static void setCellDefaultAlignmentByFieldType(XSSFCellStyle cellStyle, Style style, MultiEntityField fieldType, int alignmentType) {
        if (cellStyle != null) {
            if (fieldType != null) {
                if (1 == alignmentType) {
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                }
                if (2 == alignmentType) {
                    cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                }
            } else {
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            }
        }
        if (style != null) {
            if (fieldType != null) {
                if (1 == alignmentType) {
                    if ("Decimal".equals(fieldType.getFieldType())) {
                        style.sethAlign(Integer.valueOf(2));
                    } else {
                        style.sethAlign(Integer.valueOf(1));
                    }
                }
                if (2 == alignmentType) {
                    style.setvAlign(Integer.valueOf(1));
                }
            } else {
                style.sethAlign(Integer.valueOf(1));
                style.setvAlign(Integer.valueOf(1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getbuildExcelPath(String buildType, Long templateId, Map<String, MultiEntityField> fieldMap, Map<String, FormulaVo> formulaVoMap, String name) {
        String templateHtml = ExportService.buildExcel(buildType, templateId, fieldMap, formulaVoMap);
        FileInputStream in = null;
        String filename = FilenameUtils.getName((String)templateHtml);
        File file = new File(FilenameUtils.normalize((String)(TemplateShowUtils.BASE_PATH + filename)));
        String urls = "";
        try {
            in = new FileInputStream(file);
            urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(name + ".xlsx", (InputStream)in, 5000);
        }
        catch (FileNotFoundException e) {
            try {
                logger.error(e.getMessage());
            }
            catch (Throwable throwable) {
                FileUtils.safeClose(in);
                throw throwable;
            }
            FileUtils.safeClose((InputStream)in);
        }
        FileUtils.safeClose((InputStream)in);
        return urls;
    }

    public static String buildExcel(String buildType, Long templateId, Map<String, MultiEntityField> fieldMap, Map<String, FormulaVo> formulaVoMap) {
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"tpo_template");
        String fileName = templateId.toString();
        if (templateObject != null) {
            Date updateTime = (Date)templateObject.get("modifytime");
            if (updateTime != null) {
                fileName = fileName + DateUtils.format((Date)updateTime, (String)"yyyyMMddHHmmssSS");
            }
            fileName = fileName + ".xlsx";
            File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)fileName))));
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                String jsonString = templateObject.getString("content_tag");
                List dynRowList = DynamicRowService.getDynRowNoList((Long)templateId);
                ExportService.buildExcel(buildType, templateId, jsonString, null, fieldMap, file, formulaVoMap, null, dynRowList);
            }
        }
        return fileName;
    }

    public static Map<String, List<Cell>> getDataCell(Map.Entry<String, LinkedHashMap> entry, Map<String, Style> styleMap, List<String> dynRowList) {
        LinkedHashMap<String, List<Cell>> cellMap = new LinkedHashMap<String, List<Cell>>();
        JSONObject data = (JSONObject)entry.getValue().get("data");
        JSONObject dataTable = (JSONObject)data.get((Object)"dataTable");
        if (dataTable != null) {
            List keyList = dataTable.keySet().stream().map(TemplateShowUtils::getInteger).sorted().collect(Collectors.toList());
            for (Integer key : keyList) {
                int rownum = key;
                JSONObject colObject = (JSONObject)dataTable.get((Object)key.toString());
                Set colKeySet = colObject.keySet();
                Iterator colIt = colKeySet.iterator();
                ArrayList<Cell> list = new ArrayList<Cell>(colKeySet.size());
                String dynamicRowNo = null;
                while (colIt.hasNext()) {
                    String colKey = (String)colIt.next();
                    Integer colNum = ExportService.getInteger(colKey);
                    JSONObject col = (JSONObject)colObject.get((Object)colKey);
                    Object valObj = col.get((Object)"value");
                    Cell cell = new Cell();
                    cell.setRow(rownum);
                    cell.setCol(colNum.intValue());
                    if (valObj != null) {
                        String content = valObj.toString();
                        if (StringUtils.isNotEmpty((CharSequence)content) && content.contains("#")) {
                            String dynRowNo = "";
                            dynRowNo = content.startsWith("${") && content.endsWith("}") ? content.substring(2, content.indexOf(35)) + "#1" : content.split("#")[0] + "#1";
                            if (dynRowList.contains(dynRowNo)) {
                                dynamicRowNo = dynRowNo;
                            }
                        }
                        SpreadUtils.handleCellRichText((Object)valObj, (Cell)cell);
                    }
                    SpreadUtils.parseCellStyle(styleMap, (Cell)cell, (String)col.getString("style"));
                    list.add(cell);
                }
                if (StringUtils.isNotBlank(dynamicRowNo)) {
                    int colNum = colKeySet.size();
                    Cell cell = new Cell();
                    cell.setRow(rownum);
                    cell.setCol(colNum);
                    cell.setText(DYN_ROW_NO_PRE + dynamicRowNo);
                    list.add(cell);
                    cellMap.put(DYN_ROW_NO_PRE + rownum, list);
                    continue;
                }
                cellMap.put(rownum + "", list);
            }
        }
        return cellMap;
    }

    private static Integer getInteger(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

