/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.multidideclare;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;

public class ImportService {
    private static Log logger = LogFactory.getLog(ImportService.class);
    public static final String BASE_PATH = System.getProperty("user.home") + File.separator + "template" + File.separator;

    public static Map<String, EntityField> queryTemplateField(DynamicObject templateObject) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        if (templateObject != null) {
            DynamicObject typeObject = (DynamicObject)templateObject.get("type");
            HashMap<String, EntityField> fieldMap = new HashMap<String, EntityField>(16);
            Long templateID = (Long)templateObject.get("id");
            QFilter filter = new QFilter("id", "=", (Object)templateID);
            DynamicObjectCollection reportItem = QueryServiceHelper.query((String)"tpo_template", (String)"entryentity.rowcol,entryentity.reportitem.name", (QFilter[])new QFilter[]{filter});
            HashMap<String, String> listTab = new HashMap<String, String>(reportItem.size());
            HashMap<String, String> listNameTab = new HashMap<String, String>(reportItem.size());
            for (DynamicObject object : reportItem) {
                String key = object.getString("entryentity.rowcol");
                if (key == null) continue;
                String row = key.split("#")[0];
                listTab.put(key, row);
                String name = object.getString("entryentity.reportitem.name");
                listNameTab.put(key, name == null ? "" : name);
            }
            for (Map.Entry entity : listTab.entrySet()) {
                EntityField e = new EntityField();
                e.setEntityId((String)entity.getValue());
                e.setFieldId((String)entity.getKey());
                e.setFieldName((String)listNameTab.get(entity.getKey()));
                fieldMap.put((String)entity.getKey(), e);
            }
            String jsonString = templateObject.getString("content_tag");
            return ImportService.queryTemplateField(fieldMap, jsonString);
        }
        return map;
    }

    public static Map<String, EntityField> queryTemplateField(Map<String, EntityField> fieldMap, String jsonString) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        LinkedHashMap jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString((String)jsonString);
        for (Map.Entry<String, LinkedHashMap> entry : jsonMap.entrySet()) {
            if (null == entry || ImportService.isContainsExcludeSheet(entry) || SpreadUtils.isSheetInvisible(entry)) continue;
            String sheetName = (String)entry.getValue().get("name");
            Map dataMap = SpreadUtils.getDataCell(entry, (Map)SpreadUtils.parseStyles((JSONObject)JSONObject.parseObject((String)jsonString)), new ArrayList());
            for (Map.Entry data : dataMap.entrySet()) {
                for (Cell cell : (List)data.getValue()) {
                    EntityField entityField;
                    String text = cell.getText();
                    if (text == null || !text.contains("#")) continue;
                    if (text.contains("{")) {
                        text = text.replace("${", "").replace("}", "");
                    }
                    if ((entityField = fieldMap.get(text)) == null) continue;
                    if (cell.getStyle() != null) {
                        entityField.setExcelFormatter(cell.getStyle().getFormatter());
                    }
                    map.put(sheetName + "#" + cell.getRow() + "#" + cell.getCol(), entityField);
                }
            }
        }
        return map;
    }

    private static boolean isContainsExcludeSheet(Map.Entry<String, LinkedHashMap> entry) {
        boolean check = false;
        if (null != entry) {
            HashSet<String> set = new HashSet<String>();
            set.add(ResManager.loadKDString((String)"\u540d\u518c\u4fe1\u606f\u8868", (String)"ExportService_0", (String)"taxc-tpo", (Object[])new Object[0]));
            check = set.contains(entry.getKey());
        }
        return check;
    }
}

