/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.multidideclare;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class MultiBaseDataService {
    private static final Log logger = LogFactory.getLog(MultiBaseDataService.class);
    private static final String MATCH_ENTITY_KEY = "\"val\":\"%s\"";

    public static Map<String, Boolean> checkReferenceBatch(Map<String, List<Long>> paramMap) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(paramMap.size());
        for (Map.Entry<String, List<Long>> entry : paramMap.entrySet()) {
            String entityName = entry.getKey();
            List<Long> ids = entry.getValue();
            boolean checkReference = MultiBaseDataService.checkReference(entityName, ids);
            result.put(entityName, checkReference);
        }
        return result;
    }

    public static Boolean checkReference(String entityName, List<Long> ids) {
        for (Map.Entry entry : MultiTableEnum.MODEL_MAP.entrySet()) {
            MultiTableEnum multiTableEnum;
            String modelId = (String)entry.getKey();
            if (!MultiBaseDataService.checkReferenceByModel(entityName, ids, modelId, multiTableEnum = MultiTableEnum.getMultiTableByModelNumber((String)((String)entry.getValue())))) continue;
            return true;
        }
        return false;
    }

    public static Map<Long, Boolean> checkSingleReference(String entityName, List<Long> ids) {
        Map<Long, Boolean> result = ids.stream().collect(Collectors.toMap(key -> key, value -> false));
        for (Map.Entry entry : MultiTableEnum.MODEL_MAP.entrySet()) {
            String modelId = (String)entry.getKey();
            MultiTableEnum multiTableEnum = MultiTableEnum.getMultiTableByModelNumber((String)((String)entry.getValue()));
            MultiBaseDataService.checkSingleReferenceByModel(entityName, ids, modelId, multiTableEnum, result);
        }
        return result;
    }

    private static boolean checkReferenceByModel(String entityName, List<Long> ids, String modelId, MultiTableEnum multiTableEnum) {
        if (ids == null || ids.size() == 0) {
            return false;
        }
        List idList = ids.stream().map(v -> String.valueOf(v)).collect(Collectors.toList());
        DataSet detailJoinDataSet = MultiBaseDataService.getRows(entityName, modelId, multiTableEnum);
        QFilter valueFilter = new QFilter("value", "in", idList);
        try (DataSet valueDataSet = detailJoinDataSet.copy().filter(valueFilter.toString());){
            boolean isEmpty = valueDataSet.isEmpty();
            if (!isEmpty) {
                boolean bl = true;
                return bl;
            }
        }
        QFilter multiValueFilter = new QFilter("value", "like", (Object)"%\u3001%");
        try (DataSet multiValueDataSet = detailJoinDataSet.filter(multiValueFilter.toString());){
            Row row = null;
            while (multiValueDataSet.hasNext()) {
                row = multiValueDataSet.next();
                String value = row.getString("value");
                if (!StringUtil.isNotEmpty((CharSequence)value)) continue;
                boolean contains = Stream.of(value.split("\u3001")).anyMatch(idList::contains);
                if (!contains) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static void checkSingleReferenceByModel(String entityName, List<Long> ids, String modelId, MultiTableEnum multiTableEnum, Map<Long, Boolean> result) {
        List idList = ids.stream().map(v -> String.valueOf(v)).collect(Collectors.toList());
        DataSet detailJoinDataSet = MultiBaseDataService.getRows(entityName, modelId, multiTableEnum);
        QFilter valueFilter = new QFilter("value", "in", idList);
        try (DataSet valueDataSet = detailJoinDataSet.copy().filter(valueFilter.toString());){
            Row row = null;
            while (valueDataSet.hasNext()) {
                row = valueDataSet.next();
                String value = row.getString("value");
                Long id = Long.parseLong(value);
                result.put(id, true);
            }
        }
        QFilter multiValueFilter = new QFilter("value", "like", (Object)"%\u3001%");
        try (DataSet multiValueDataSet = detailJoinDataSet.filter(multiValueFilter.toString());){
            Row row = null;
            while (multiValueDataSet.hasNext()) {
                row = multiValueDataSet.next();
                String value = row.getString("value");
                if (!StringUtil.isNotEmpty((CharSequence)value)) continue;
                List values = Stream.of(value.split("\u3001")).filter(idList::contains).collect(Collectors.toList());
                for (String val : values) {
                    Long id = Long.parseLong(val);
                    result.put(id, true);
                }
            }
        }
    }

    private static DataSet getRows(String entityName, String modelId, MultiTableEnum multiTableEnum) {
        QFilter modelFilter = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        String matchKey = String.format(MATCH_ENTITY_KEY, entityName);
        String styleSelectFields = "id";
        QFilter styleFilter = new QFilter("celltype", "=", (Object)"5");
        styleFilter.and(modelFilter);
        styleFilter.and(new QFilter("formula", "like", (Object)("%" + matchKey + "%")));
        DataSet styleDataSet = QueryServiceHelper.queryDataSet((String)MultiBaseDataService.class.getName(), (String)"tpo_rule_style", (String)styleSelectFields, (QFilter[])new QFilter[]{styleFilter}, (String)"id");
        String tstyleSelectFields = "template.id,reportitem.id,formula.id";
        QFilter tstyleFilter = modelFilter.copy();
        DataSet tstyleDataSet = QueryServiceHelper.queryDataSet((String)MultiBaseDataService.class.getName(), (String)"tpo_template_rule_style", (String)tstyleSelectFields, (QFilter[])new QFilter[]{tstyleFilter}, (String)"id");
        DataSet tstyleJoinDataSet = styleDataSet.join(tstyleDataSet).on("id", "formula.id").select(new String[]{"template.id", "reportitem.id"}).finish();
        String itemSelectFields = "id,row.id,col.id";
        QFilter itemFilter = new QFilter("enable", "=", (Object)"1");
        itemFilter.and(modelFilter);
        DataSet itemDataSet = QueryServiceHelper.queryDataSet((String)MultiBaseDataService.class.getName(), (String)"tpo_report_item", (String)itemSelectFields, (QFilter[])new QFilter[]{itemFilter}, (String)"id");
        DataSet itemJoinDataSet = tstyleJoinDataSet.join(itemDataSet).on("reportitem.id", "id").select(new String[]{"row.id", "col.id", "template.id"}).finish();
        String mainSelectFields = "id mainid,templateid.id templateid";
        QFilter mainFilter = new QFilter("1", "=", (Object)1);
        DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)MultiBaseDataService.class.getName(), (String)multiTableEnum.getDeclareMainTable(), (String)mainSelectFields, (QFilter[])new QFilter[]{mainFilter}, (String)"id");
        DataSet mainJoinDataSet = itemJoinDataSet.join(mainDataSet).on("template.id", "templateid").select(new String[]{"mainid", "row.id", "col.id", "template.id"}).finish();
        String detailSelectFields = "id,entryid,row.id rowid,column.id columnid,value";
        QFilter detailFilter = new QFilter("1", "=", (Object)1);
        DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)MultiBaseDataService.class.getName(), (String)multiTableEnum.getDeclareDetailTabled(), (String)detailSelectFields, (QFilter[])new QFilter[]{detailFilter}, (String)"id");
        return mainJoinDataSet.join(detailDataSet).on("mainid", "entryid").on("row.id", "rowid").on("col.id", "columnid").select(new String[]{"value"}).finish();
    }

    public static Long queryModelIdByNumber(String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject d = BusinessDataServiceHelper.loadSingle((String)"tpo_model", (String)"id", (QFilter[])qFilter.toArray());
        if (d == null) {
            return 0L;
        }
        return d.getLong("id");
    }
}

