/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.multidideclare;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.business.domain.MultiEntityField;
import kd.taxc.bdtaxr.business.multidideclare.MultiDeclareBizBusiness;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.DeclareReportCalculateFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.DeclareReportCalculateService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportopen.DeclareReportOpenFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportopen.service.DeclareReportOpenService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsavehis.DeclareReportSaveHisFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsavehis.service.DeclareReportSaveHisService;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.initparam.InitParamsService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.dto.TaxDeclareSaveDataDto;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.mq.accrual.AccrualMQSender;
import kd.taxc.bdtaxr.common.multidimension.MultiDiConstant;
import kd.taxc.bdtaxr.common.refactor.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.refactor.formula.context.CalFormulaContext;
import kd.taxc.bdtaxr.common.refactor.formula.context.CheckFormulaContext;
import kd.taxc.bdtaxr.common.refactor.formula.context.StyleFormulaContext;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.DeclareReportFactory;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.FormulaCalVo;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import kd.taxc.tpo.business.formula.MultiDynamicRowService;
import kd.taxc.tpo.business.multidideclare.DeclareCellKeyService;
import kd.taxc.tpo.business.multidideclare.MultiDiBusinessRuleHelper;
import kd.taxc.tpo.business.multidideclare.MultiDiTemplateHelper;
import kd.taxc.tpo.common.vo.DeclareCellKeyVo;
import org.apache.commons.collections.map.HashedMap;

public class MultiDataService {
    private static Log logger = LogFactory.getLog(MultiDataService.class);
    private static final String MODEL_FIELD_TYPE = "fieldType_%s";
    private static final String TEMPLATE_FIELD_TYPE = "fieldType_%s_%s_%s";
    protected static final String REGETDATA_KEY = "regetdata";
    private static List<String> editSaveExcludeFields = Lists.newArrayList((Object[])new String[]{"billstatus", "billno", "org", "skssqq", "skssqz", "templateid", "createtime", "creator", "attachment", "sbrq", "paydate"});
    private static List<String> SHORT_TIME = Lists.newArrayList((Object[])new String[]{"skssqq", "skssqz"});
    private static DeclareReportService declareReportService;

    public static DeclareResponseModel queryData(DeclareRequestModel declareModel) {
        DeclareResponseModel responseModel = new DeclareResponseModel();
        if (null == declareModel) {
            return responseModel;
        }
        Long id = declareModel.getId();
        HashMap<String, String> data = new HashMap<String, String>(16);
        Long templateId = declareModel.getTemplateId();
        if (null == templateId) {
            return responseModel;
        }
        List dynamicRowModelList = DynamicRowService.getDynRowSetList((Long)templateId);
        declareModel.setTemplateId(templateId);
        Long fid = declareModel.getId();
        QFilter mianqFilter = new QFilter("id", "=", (Object)fid);
        QFilter qFilter = new QFilter("entryid", "=", (Object)fid);
        Long modelId = declareModel.getModelId();
        DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)modelId);
        String mainTable = declareTable.getMainTable();
        String detailTable = declareTable.getDetalTable();
        String queryFieds = MetadataUtil.getAllFieldToQuery((String)mainTable);
        DynamicObject mainObj = QueryServiceHelper.queryOne((String)mainTable, (String)queryFieds, (QFilter[])new QFilter[]{mianqFilter});
        if (mainObj == null) {
            return responseModel;
        }
        long taxSystem = 1L;
        String dataSource = "";
        EntityInfo entityInfo = MetadataUtil.getEntityById((String)mainTable);
        Map<Object, Object> typeMap = new HashMap(10);
        if (entityInfo != null) {
            typeMap = entityInfo.getFieldList().stream().collect(Collectors.toMap(k -> k.getFieldId(), v -> v, (k1, k2) -> k1));
        }
        for (String field : queryFieds.split(",")) {
            data.put(mainTable + "#" + field, TemplateUtils.dataFormatPreSave((Object)mainObj.get(field), (EntityField)((EntityField)typeMap.get(field))));
            if ("taxsystem".equals(field) && Objects.equals(taxSystem = mainObj.getLong("taxsystem"), 0L)) {
                taxSystem = 1L;
            }
            if (!"datatype".equals(field)) continue;
            dataSource = mainObj.getString(field);
        }
        try {
            long orgId = mainObj.getLong("org");
            data.putAll(YbnsrService.getOrgInfoById((long)orgId, (long)taxSystem, (String)mainTable, (Map)declareModel.getExtendParams()));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        DynamicObjectCollection temp = QueryServiceHelper.query((String)detailTable, (String)"cellnumber, dynrowno, index, value, valuetype", (QFilter[])new QFilter[]{qFilter}, (String)"index");
        HashMap dyMap = new HashMap();
        List rowList = new ArrayList();
        for (DynamicObject d : temp) {
            String cellKey = d.getString("cellnumber");
            String cellValue = d.getString("value");
            data.put(cellKey, cellValue);
            String dynrowno = d.getString("dynrowno");
            if (!StringUtils.isNotEmpty((CharSequence)dynrowno)) continue;
            rowList = (List)dyMap.get(dynrowno);
            if (rowList == null) {
                rowList = new ArrayList();
            }
            boolean find = false;
            block4: for (Map map : rowList) {
                for (Map.Entry entry : map.entrySet()) {
                    if (!DeclareCellKeyService.isSameRow((String)entry.getKey(), cellKey)) continue;
                    map.put(cellKey, cellValue);
                    find = true;
                    continue block4;
                }
            }
            if (!find) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(cellKey, cellValue);
                rowList.add(map);
            }
            dyMap.put(dynrowno, rowList);
        }
        for (DynamicRowModel dyn : dynamicRowModelList) {
            dyn.setRowList((List)dyMap.get(dyn.getDynRowNo()));
        }
        responseModel.setId(id);
        responseModel.setTemplateId(templateId);
        responseModel.setData(data);
        responseModel.setDynRowList(dynamicRowModelList);
        responseModel.setParamMap(declareModel.getBusinessMap());
        responseModel.setDataSource(dataSource);
        temp = null;
        return responseModel;
    }

    public static DeclareResponseModel refreshData(DeclareRequestModel declareModel, FormulaCollectionVo formulas, List<DynamicRowModel> dynRowList, Map<String, EntityField> typeMap) {
        DeclareReportCalculateService calculateService;
        Map preDataMap;
        DeclareResponseModel responseModel = new DeclareResponseModel();
        if (null == declareModel) {
            return responseModel;
        }
        Long id = declareModel.getId();
        Map<String, String> data = new HashMap<String, String>();
        Long templateId = declareModel.getTemplateId();
        Map metaMap = declareModel.getMetaDataMap();
        Map businessMap = declareModel.getBusinessMap();
        HashMap paramMap = new HashMap();
        Map ruleParamMap = declareModel.getRuleParamMap();
        if (declareModel.getExtendParams() == null || declareModel.getExtendParams().size() > 0) {
            // empty if block
        }
        if (businessMap != null) {
            paramMap.putAll(businessMap);
        }
        if ((declareReportService = DeclareReportFactory.createHandler((String)declareModel.getTemplateType())) != null) {
            paramMap.putAll(declareReportService.getFormmulaParams());
        }
        Map nsrxxMap = YbnsrService.createMutiCnDeclareMain((long)declareModel.getModelId(), (String)String.valueOf(declareModel.getId()), (String)declareModel.getBillNo(), (String)declareModel.getTemplateType(), (String)String.valueOf(declareModel.getOrgId()), (String)declareModel.getSkssqq(), (String)declareModel.getSkssqz(), (boolean)true, (Map)declareModel.getExtendParams(), (Long)declareModel.getTemplateId());
        FormulaCalVo formulaModel = new FormulaCalVo(paramMap, ruleParamMap, nsrxxMap, metaMap, templateId, dynRowList);
        formulaModel.setMetaTypeMap(typeMap);
        formulaModel.getParamMap().putAll(nsrxxMap);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dynRowList)) {
            Map dynMap = DynamicRowService.getDynRowData(dynRowList);
            formulaModel.getParamMap().putAll(dynMap);
        }
        if ((preDataMap = declareModel.getPreData()) != null && !preDataMap.isEmpty()) {
            formulaModel.getDataMap().putAll(preDataMap);
            formulas = MultiDataService.removeFormulaByPreData(formulas, preDataMap);
        }
        formulaModel.setFormulas(formulas);
        long t1 = System.currentTimeMillis();
        logger.info("\u5f00\u59cb\u8c03\u7528\u516c\u5f0f\u670d\u52a1\u8ba1\u7b97----");
        ConcurrentHashMap dataMap = new ConcurrentHashMap();
        CalFormulaContext calFormulaContext = new CalFormulaContext();
        dataMap.putAll(nsrxxMap);
        if (preDataMap != null && !preDataMap.isEmpty()) {
            dataMap.putAll(preDataMap);
        }
        if ((calculateService = DeclareReportCalculateFactory.createHandler((String)declareModel.getTemplateType())) != null) {
            calculateService.beforeCalFormula(declareModel, calFormulaContext, dataMap, formulaModel, formulas, null);
        }
        Map calMap = calFormulaContext.initCal(formulaModel, dataMap, formulas.getFormulas(), formulas.getRformulas(), formulas.getMformulas());
        if (calculateService != null) {
            calculateService.afterCalFormula(declareModel, calFormulaContext, dataMap, formulaModel, formulas, null);
        }
        long t2 = System.currentTimeMillis();
        logger.info("\u8c03\u7528\u516c\u5f0f\u670d\u52a1\u8ba1\u7b97\u8017\u65f6\uff1a{}", (Object)(t2 - t1));
        data.putAll(calMap);
        data = MultiDataService.changeToShow(data, formulas.getCelltypeFormulas(), typeMap);
        responseModel.setId(id);
        responseModel.setTemplateId(templateId);
        responseModel.setData(data);
        responseModel.setDynRowList(dynRowList);
        return responseModel;
    }

    private static FormulaCollectionVo removeFormulaByPreData(FormulaCollectionVo allFormulas, Map<String, String> preData) {
        if (preData == null || preData.isEmpty()) {
            return allFormulas;
        }
        Map formulaVoMap = allFormulas.getFormulas();
        Map ruleFormulasMap = allFormulas.getRformulas();
        Map mFormulasMap = allFormulas.getMformulas();
        Map qformulasMap = allFormulas.getQformulas();
        for (String key : preData.keySet()) {
            formulaVoMap.remove(key);
            ruleFormulasMap.remove(key);
            mFormulasMap.remove(key);
            qformulasMap.remove(key);
        }
        allFormulas.setFormulas(formulaVoMap);
        allFormulas.setRformulas(ruleFormulasMap);
        allFormulas.setMformulas(mFormulasMap);
        allFormulas.setQformulas(qformulasMap);
        return allFormulas;
    }

    public static Map<String, String> changeData(DeclareResponseModel responseModel, DeclareRequestModel requestModel, Map<String, String> variableKeys, Map<String, String> currentMap, Map<String, EntityField> typeMap) {
        HashMap<String, String> resultMap = new HashMap();
        logger.info("\u5f00\u59cb\u8fdb\u884ccalExec\u8ba1\u7b97(\u542b\u7ea7\u8054).....");
        long time = System.currentTimeMillis();
        HashedMap dataMap = new HashedMap();
        if (requestModel.getBusinessMap() != null) {
            dataMap.putAll(requestModel.getBusinessMap());
            dataMap.putAll(currentMap);
        }
        FormulaCalVo formulaCalVo = new FormulaCalVo();
        HashedMap dataMapObj = new HashedMap((Map)dataMap);
        formulaCalVo.setParamMap((Map)dataMapObj);
        formulaCalVo.setDataMap((Map)dataMap);
        declareReportService = DeclareReportFactory.createHandler((String)requestModel.getTemplateType());
        if (declareReportService != null) {
            formulaCalVo.getParamMap().putAll(declareReportService.getFormmulaParams());
        }
        formulaCalVo.setBusinessParam(requestModel.getRuleParamMap());
        FormulaCollectionVo allFormulas = responseModel.getAllFormulas();
        Map formulaVoMap = allFormulas.getFormulas();
        Map<String, String> dynamicChangeData = MultiDataService.dynamicChangeData(currentMap, variableKeys, formulaVoMap);
        if (!dynamicChangeData.isEmpty()) {
            formulaCalVo.getParamMap().putAll(dynamicChangeData);
        }
        Map cformulasMap = allFormulas.getCformulas();
        Map rformulaMap = allFormulas.getRformulas();
        for (Map.Entry map : cformulasMap.entrySet()) {
            if (!map.getKey().toString().endsWith("rownumber") && !map.getKey().toString().endsWith("seqno") && !map.getKey().toString().endsWith("cjrxh")) continue;
            dataMap.put(map.getKey().toString(), map.getValue().toString());
        }
        formulaCalVo.setMetaTypeMap(typeMap);
        CalFormulaContext calFormulaContext = new CalFormulaContext();
        DeclareReportCalculateService calculateService = DeclareReportCalculateFactory.createHandler((String)requestModel.getTemplateType());
        if (calculateService != null) {
            calculateService.beforeCalFormula(requestModel, calFormulaContext, (Map)dataMap, formulaCalVo, allFormulas, variableKeys);
        }
        resultMap = calFormulaContext.linkageCal(variableKeys, (Map)dataMap, formulaCalVo, formulaVoMap, rformulaMap, new String[0]);
        if (calculateService != null) {
            calculateService.afterCalFormula(requestModel, calFormulaContext, (Map)dataMap, formulaCalVo, allFormulas, variableKeys);
        }
        logger.info("\u7ed3\u675fcalExec\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return resultMap;
    }

    private static Map<String, String> dynamicChangeData(Map<String, String> currentMap, Map<String, String> variableKeys, Map<String, FormulaVo> formulaVoMap) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (variableKeys != null) {
            for (Map.Entry<String, String> entry : variableKeys.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                boolean isDyn = true;
                String[] splits = k.split("#");
                if (splits.length != 3) continue;
                try {
                    Integer.parseInt(splits[1]);
                }
                catch (Exception e) {
                    isDyn = false;
                }
                if (!isDyn) continue;
                FormulaVo formulaVo = formulaVoMap.get(k);
                String newKey = splits[0] + "_" + k;
                if (formulaVo == null || formulaVo.getFormula() == null || !formulaVo.getFormula().contains("{P[")) continue;
                String dynValue = currentMap.get(k);
                resultMap.put(newKey, dynValue);
            }
        }
        return resultMap;
    }

    @Deprecated
    public static Map<String, MultiEntityField> getAllFieldTypeToShow(Long modeId) {
        String cacheKey = String.format(MODEL_FIELD_TYPE, modeId);
        HashMap<String, MultiEntityField> result = null;
        if (result != null) {
            return result;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modeId);
        DynamicObject[] fieldTypes = BusinessDataServiceHelper.load((String)"tpo_col_member", (String)"name,number, datatype, defaultvalue, format, minlength, maxlength", (QFilter[])qFilter.toArray());
        if (fieldTypes == null || fieldTypes.length == 0) {
            return new HashMap<String, MultiEntityField>(1);
        }
        result = new HashMap<String, MultiEntityField>(fieldTypes.length);
        for (DynamicObject b : fieldTypes) {
            MultiEntityField entityField = new MultiEntityField();
            entityField.setFieldType(b.getString("datatype"));
            entityField.setDefaultValue(b.getString("defaultvalue"));
            entityField.setFormat(b.getString("format"));
            entityField.setMaxLength(b.getInt("maxlength"));
            entityField.setFieldName(b.getString("name"));
            result.put(b.getString("number"), entityField);
        }
        if (result != null) {
            CacheUtils.put((String)cacheKey, result);
        }
        fieldTypes = null;
        return result;
    }

    private static DynamicObjectCollection filterEffective(DynamicObject obj, Date startDate, Date endDate) {
        if (startDate == null) {
            return null;
        }
        DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
        if (entries.size() == 0) {
            return null;
        }
        DynamicObjectCollection newEntries = new DynamicObjectCollection();
        for (DynamicObject entry : entries) {
            Date endTime;
            Date beginTime = DateUtils.trunc((Date)entry.getDate("startdate"), (String)"yyyy-MM-dd");
            if (DateUtils.checkTimeRepeat((Date)beginTime, (Date)(endTime = DateUtils.trunc((Date)entry.getDate("enddate"), (String)"yyyy-MM-dd")), (Date)startDate, (Date)endDate)) continue;
            newEntries.add((Object)entry);
        }
        return newEntries;
    }

    public static Map<String, EntityField> getFieldsTypeToShow(Long modeId, Long templateId, List<DynamicRowModel> dynList) {
        QFilter templateFilter = new QFilter("id", "=", (Object)templateId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"tpo_template", (String)"modifytime", (QFilter[])new QFilter[]{templateFilter});
        String cacheKey = String.format(TEMPLATE_FIELD_TYPE, modeId, templateId, obj.get("modifytime") == null ? "" : Long.valueOf(((Date)obj.get("modifytime")).getTime()));
        HashMap<String, EntityField> result = null;
        QFilter qFilter = new QFilter("model", "=", (Object)modeId);
        DynamicObject[] fieldTypes = BusinessDataServiceHelper.load((String)"tpo_col_member", (String)"number, datatype, defaultvalue,format, minlength, maxlength", (QFilter[])qFilter.toArray());
        if (fieldTypes == null || fieldTypes.length == 0) {
            return new HashMap<String, EntityField>(1);
        }
        HashMap<String, EntityField> colEntityFields = new HashMap<String, EntityField>(fieldTypes.length);
        for (DynamicObject b : fieldTypes) {
            if (StringUtil.isBlank((CharSequence)b.getString("number"))) continue;
            EntityField entityField = new EntityField();
            entityField.setFieldType(b.getString("datatype"));
            entityField.setDefaultValue((Object)b.getString("defaultvalue"));
            entityField.setFormatStr(b.getString("format"));
            entityField.setMaxLength(b.getInt("maxlength"));
            colEntityFields.put(b.getString("number"), entityField);
        }
        Map<String, DynamicObject> reportItems = MultiDiTemplateHelper.getReportItemsByTemplate(templateId.toString());
        result = new HashMap<String, EntityField>(reportItems.size());
        for (String cellKey : reportItems.keySet()) {
            DeclareCellKeyVo cellKeyVo;
            EntityField e;
            if (!cellKey.contains("#") || (e = (EntityField)colEntityFields.get((cellKeyVo = DeclareCellKeyService.getMembersByCellKey(cellKey)).getColMember())) == null) continue;
            e.setFieldId(cellKey);
            result.put(cellKey, e);
        }
        Map<String, String> dataFormatRules = MultiDiBusinessRuleHelper.getDataFormatRuleByTemplate(templateId);
        if (dataFormatRules != null && dataFormatRules.size() > 0) {
            for (Map.Entry<String, String> dataFormatRule : dataFormatRules.entrySet()) {
                String key = dataFormatRule.getKey();
                String formula = dataFormatRule.getValue();
                try {
                    EntityField entityField = (EntityField)JsonUtil.fromJson((String)formula, EntityField.class);
                    result.put(key, entityField);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    logger.error("{}:{}\u516c\u5f0f\u914d\u7f6e\u9519\u8bef!", (Object)key, (Object)formula);
                }
            }
        }
        if (result != null) {
            CacheUtils.put((String)cacheKey, result);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dynList)) {
            return MultiDataService.getAllFieldsType(result, dynList);
        }
        fieldTypes = null;
        reportItems = null;
        return result;
    }

    public static Map<String, EntityField> getFieldsTypeToShowByVersion(Long modeId, Long templateId, List<DynamicRowModel> dynList, Date startDate, Date endDate) {
        QFilter templateFilter = new QFilter("id", "=", (Object)templateId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"tpo_template", (String)"modifytime", (QFilter[])new QFilter[]{templateFilter});
        String cacheKey = String.format(TEMPLATE_FIELD_TYPE, modeId, templateId, obj.get("modifytime") == null ? "" : Long.valueOf(((Date)obj.get("modifytime")).getTime()));
        HashMap<String, EntityField> result = null;
        QFilter qFilter = new QFilter("model", "=", (Object)modeId);
        DynamicObject[] fieldTypes = BusinessDataServiceHelper.load((String)"tpo_col_member", (String)MultiDiConstant.TPO_ROW_MEMBER_QUERY_FIELDS, (QFilter[])qFilter.toArray());
        if (fieldTypes == null || fieldTypes.length == 0) {
            return new HashMap<String, EntityField>(1);
        }
        HashMap<String, EntityField> colEntityFields = new HashMap<String, EntityField>(fieldTypes.length);
        for (DynamicObject b : fieldTypes) {
            if (StringUtil.isBlank((CharSequence)b.getString("number"))) continue;
            EntityField entityField = new EntityField();
            entityField.setFieldType(b.getString("datatype"));
            entityField.setDefaultValue((Object)b.getString("defaultvalue"));
            DynamicObjectCollection fitEntries = MultiDataService.filterEffective(b, startDate, endDate);
            if (fitEntries != null && fitEntries.size() > 0) {
                DynamicObject entry = (DynamicObject)fitEntries.get(0);
                entityField.setFormatStr(entry.getString("entryformat"));
                entityField.setMaxLength(entry.getInt("entrymaxlength"));
            } else {
                entityField.setFormatStr(b.getString("format"));
                entityField.setMaxLength(b.getInt("maxlength"));
            }
            colEntityFields.put(b.getString("number"), entityField);
        }
        Map<String, DynamicObject> reportItems = MultiDiTemplateHelper.getReportItemsByTemplate(templateId.toString());
        result = new HashMap<String, EntityField>(reportItems.size());
        for (String cellKey : reportItems.keySet()) {
            DeclareCellKeyVo cellKeyVo;
            EntityField e;
            if (!cellKey.contains("#") || (e = (EntityField)colEntityFields.get((cellKeyVo = DeclareCellKeyService.getMembersByCellKey(cellKey)).getColMember())) == null) continue;
            e.setFieldId(cellKey);
            result.put(cellKey, e);
        }
        Map<String, String> dataFormatRules = MultiDiBusinessRuleHelper.getDataFormatRuleByTemplate(templateId);
        if (dataFormatRules != null && dataFormatRules.size() > 0) {
            for (Map.Entry<String, String> dataFormatRule : dataFormatRules.entrySet()) {
                String key = dataFormatRule.getKey();
                String formula = dataFormatRule.getValue();
                try {
                    EntityField entityField = (EntityField)JsonUtil.fromJson((String)formula, EntityField.class);
                    result.put(key, entityField);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    logger.error("{}:{}\u516c\u5f0f\u914d\u7f6e\u9519\u8bef!", (Object)key, (Object)formula);
                }
            }
        }
        if (result != null) {
            CacheUtils.put((String)cacheKey, result);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dynList)) {
            return MultiDataService.getAllFieldsType(result, dynList);
        }
        fieldTypes = null;
        reportItems = null;
        return result;
    }

    public static Map<String, EntityField> getAllFieldsType(Map<String, EntityField> typeMap, List<DynamicRowModel> dynList) {
        if (typeMap == null) {
            return new HashMap<String, EntityField>(0);
        }
        if (dynList == null || dynList.size() == 0 || typeMap.isEmpty()) {
            return typeMap;
        }
        HashMap<String, EntityField> addedMetaTypeMap = new HashMap<String, EntityField>();
        for (Map.Entry<String, EntityField> entry : typeMap.entrySet()) {
            String key;
            DynamicRowModel dyn;
            if (entry.getValue() == null || (dyn = DeclareCellKeyService.matchDynamicRow(dynList, key = entry.getKey().toString())) == null || dyn.getRowList() == null || dyn.getRowList().size() <= 0) continue;
            for (int i = 0; i < dyn.getRowList().size(); ++i) {
                String newKey = DeclareCellKeyService.newCellKeyByRowIndex(key, i + 1);
                addedMetaTypeMap.put(newKey, entry.getValue());
            }
        }
        if (addedMetaTypeMap != null) {
            typeMap.putAll(addedMetaTypeMap);
        }
        return typeMap;
    }

    public static Map<String, Long> getRowColMember(Long modeId, String entry) {
        if (modeId == null || !entry.equals("tpo_row_member") && !entry.equals("tpo_col_member")) {
            return null;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modeId);
        DynamicObject[] cols = BusinessDataServiceHelper.load((String)entry, (String)"number, id", (QFilter[])qFilter.toArray());
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (DynamicObject b : cols) {
            if (StringUtils.isEmpty((CharSequence)b.getString("number"))) continue;
            result.put(b.getString("number"), b.getLong("id"));
        }
        return result;
    }

    public static Map<String, String> changeToShow(Map<String, String> srcMap, Map<String, FormulaVo> celltypeFormulas, Map<String, EntityField> typeMap) {
        if (srcMap == null) {
            return null;
        }
        if (celltypeFormulas != null) {
            // empty if block
        }
        if (typeMap != null) {
            for (Map.Entry<String, String> entry : srcMap.entrySet()) {
                String key = entry.getKey();
                if (StringUtil.isEmpty((CharSequence)key)) continue;
                String value = entry.getValue();
                value = DataFormatUtils.dataFormatByFieldType((Object)entry.getValue(), (EntityField)typeMap.get(key));
                srcMap.put(entry.getKey(), value);
            }
        }
        return srcMap;
    }

    @Deprecated
    public static String checkData(Map<String, Object> argsMap, Map<String, FormulaVo> celltypeFormulas, Map<String, EntityField> typeMap) {
        EntityField entityField;
        String msg = "";
        if (argsMap == null) {
            return msg;
        }
        String cell = (String)argsMap.get("cellKey");
        String[] array = null;
        if (null != cell) {
            array = cell.split("#");
        }
        if (null != array && array.length == 3 && (entityField = typeMap.get(cell)) != null) {
            String fieldType = entityField.getFieldType();
            if ("Text".equals(fieldType)) {
                if (entityField.getMaxLength() > 0) {
                    msg = MultiDataService.checkLength(argsMap, entityField);
                }
            } else if ("Date".equals(fieldType)) {
                msg = MultiDataService.checkDateFormat(argsMap);
            }
        }
        return msg;
    }

    private static String checkLength(Map<String, Object> argsMap, EntityField entityField) {
        String value = (String)argsMap.get("value");
        int maxLength = entityField.getMaxLength();
        int currentLength = value.length();
        if (currentLength > maxLength) {
            String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5f97\u8d85\u8fc7%2$s\u5b57\u7b26", (String)"MultiDataService_0", (String)"taxc-tpo", (Object[])new Object[0]), argsMap.get("key"), maxLength);
            return msg;
        }
        return "";
    }

    private static String checkDateFormat(Map<String, Object> argsMap) {
        String value = (String)argsMap.get("value");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        SimpleDateFormat barDf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat chinessDf = new SimpleDateFormat(DateUtils.YYYYMMDD_CHINESE);
        try {
            if (value.contains("-")) {
                barDf.parse(value);
            } else {
                chinessDf.parse(value);
            }
        }
        catch (ParseException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:yyyy-MM-dd", (String)"MultiDataService_1", (String)"taxc-tpo", (Object[])new Object[0]), value);
            return msg;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseResult saveTaxDeclareData(TaxDeclareSaveDataDto saveDataDto) {
        BaseResult result = new BaseResult();
        Long modelId = saveDataDto.getModelId();
        long orgId = saveDataDto.getOrgId();
        String skssqq = saveDataDto.getSkssqq();
        String skssqz = saveDataDto.getSkssqz();
        Long sbbId = saveDataDto.getSbbId();
        Map updateMap = saveDataDto.getUpdateMap();
        Map currMap = saveDataDto.getCurrMap();
        Map remarkMap = saveDataDto.getRemarkMap();
        HashMap<String, EntityField> typeMap = saveDataDto.getTypeMap();
        Map updateNsrxxMap = saveDataDto.getUpdateNsrxxMap();
        Boolean isRefresh = saveDataDto.getRefresh();
        DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)modelId);
        String mainTable = declareTable.getMainTable();
        String detailTable = declareTable.getDetalTable();
        if (typeMap == null) {
            typeMap = new HashMap<String, EntityField>(1);
        }
        String templateType = saveDataDto.getTemplateType();
        HashMap newMaps = saveDataDto.getNewMaps();
        if (newMaps == null) {
            newMaps = new HashMap(10);
        }
        if (updateMap != null) {
            newMaps.putAll(updateMap);
        }
        if (updateNsrxxMap != null) {
            for (Map.Entry entry : updateNsrxxMap.entrySet()) {
                if (!StringUtil.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                newMaps.put(mainTable + "#" + (String)entry.getKey(), entry.getValue());
            }
        }
        if (CollectionUtils.isEmpty(newMaps)) {
            result.setData((Object)currMap);
            result.setCode(BaseResult.OK);
            return result;
        }
        HashMap resultMap = new HashMap(currMap.size());
        resultMap.putAll(currMap);
        if (newMaps != null) {
            resultMap.putAll(newMaps);
        }
        Map<String, Long> rowMember = MultiDataService.getRowColMember(modelId, "tpo_row_member");
        Map<String, Long> colMember = MultiDataService.getRowColMember(modelId, "tpo_col_member");
        QFilter sbbidFlter = new QFilter("entryid", "=", (Object)sbbId);
        if (saveDataDto.getExtendParams() != null) {
            saveDataDto.getExtendParams().put("sbbid", sbbId);
        }
        boolean createNew = false;
        DLock lock = null;
        if ("add".equals(saveDataDto.getCustomEvent())) {
            if (StringUtil.isEmpty((CharSequence)saveDataDto.getUniKey())) {
                throw new KDBizException("uniKey is null!");
            }
            lock = DLock.create((String)saveDataDto.getUniKey());
            boolean getLock = lock.tryLock();
            if (!getLock) {
                result.setCode(BaseResult.FAIL);
                result.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u62ff\u5230\u9501\uff01", (String)"MultiDataService_2", (String)"taxc-tpo", (Object[])new Object[0]));
                return result;
            }
        }
        DynamicObject mainObj = null;
        try {
            mainObj = YbnsrService.queryMultiDeclareMain((String)mainTable, (long)orgId, (String)templateType, (String)skssqq, (String)skssqz, (Map)saveDataDto.getExtendParams());
            if (mainObj != null && "add".equals(saveDataDto.getCustomEvent())) {
                result.setCode(BaseResult.FAIL);
                result.setMessage(ResManager.loadKDString((String)"\u65b0\u589e\u64cd\u4f5c\u65f6\u5f53\u524d\u4e3b\u8868\u6570\u636e\u4e0d\u4e3a\u7a7a\uff01", (String)"MultiDataService_3", (String)"taxc-tpo", (Object[])new Object[0]));
                BaseResult baseResult = result;
                return baseResult;
            }
            DataEntityPropertyCollection propertyCollection = null;
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)mainTable);
            propertyCollection = mainEntityType.getProperties();
            if (mainObj == null) {
                mainObj = new DynamicObject((DynamicObjectType)mainEntityType);
                mainObj.set("id", (Object)sbbId);
                mainObj.set("templatetype", (Object)templateType);
                DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId).getData();
                if (MultiTableEnum.TSCOO1.getDeclareMainTable().equals(mainTable)) {
                    mainObj.set("taxauthority", taxMain != null ? taxMain.get("taxoffice.id") : Long.valueOf(0L));
                    mainObj.set("versiontype", (Object)"zcsb");
                    mainObj.set("archivestatus", (Object)"unfiled");
                }
                createNew = true;
            }
            DynamicObjectCollection coll = QueryServiceHelper.query((String)detailTable, (String)"cellnumber, value", (QFilter[])new QFilter[]{sbbidFlter});
            ArrayList<Object> deleteList = new ArrayList<Object>(1);
            if (newMaps == null) {
                newMaps = new HashMap(currMap.size());
                for (Map.Entry entry : currMap.entrySet()) {
                    if (!entry.getKey().toString().startsWith(mainTable + "#")) continue;
                    newMaps.put(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            ArrayList keys = new ArrayList(newMaps.keySet());
            for (String key : keys) {
                if (!key.contains("#")) {
                    newMaps.remove(key);
                    continue;
                }
                if (!key.startsWith(mainTable + "#")) continue;
                String[] keySplit = key.split("#");
                String string = keySplit[keySplit.length - 1];
                if (createNew || !editSaveExcludeFields.contains(string)) {
                    String propertType = "";
                    if (propertyCollection == null) {
                        newMaps.remove(key);
                        continue;
                    }
                    if (propertyCollection.get((Object)string) == null) {
                        newMaps.remove(key);
                        continue;
                    }
                    if (((IDataEntityProperty)propertyCollection.get((Object)string)).getPropertyType() == null) {
                        newMaps.remove(key);
                        continue;
                    }
                    try {
                        propertType = ((IDataEntityProperty)propertyCollection.get((Object)string)).getPropertyType().getName();
                    }
                    catch (Exception e2) {
                        logger.error("\u5143\u6570\u636e\u4e0d\u5b58\u5728\u6b64\u5c5e\u6027!" + e2);
                    }
                    Object value = newMaps.remove(key);
                    if (propertType == null || value == null) continue;
                    if (propertType.equals("java.util.Date")) {
                        try {
                            String dateFormat;
                            String string2 = dateFormat = SHORT_TIME.contains(keySplit[1]) ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss";
                            if (typeMap != null && typeMap.get(key) != null && StringUtil.isNotEmpty((CharSequence)((EntityField)typeMap.get(key)).getFormatStr())) {
                                dateFormat = ((EntityField)typeMap.get(key)).getFormatStr();
                            }
                            value = DateUtils.stringToDate((String)value.toString(), (String)dateFormat);
                        }
                        catch (Exception e3) {
                            logger.error("{}: \u683c\u5f0f\u8f6c\u6362\u5931\u8d25\uff01 {}", value, (Object)e3);
                        }
                    }
                    if (propertType.equals("long") || propertType.equals("kd.bos.dataentity.entity.DynamicObject")) {
                        try {
                            value = Long.valueOf(value.toString());
                        }
                        catch (Exception e4) {
                            logger.error("{}: \u683c\u5f0f\u8f6c\u6362\u5931\u8d25\uff01 {}", value, (Object)e4);
                        }
                    }
                    mainObj.set(string, value);
                }
                newMaps.remove(key);
            }
            if (coll != null) {
                for (DynamicObject obj : coll) {
                    String number = obj.getString("cellnumber");
                    String string = obj.getString("value");
                    if (newMaps.get(number) != null && ((String)newMaps.get(number)).equals(string)) {
                        newMaps.remove(number);
                        continue;
                    }
                    if (newMaps.containsKey(number)) continue;
                    deleteList.add(number);
                    resultMap.remove(number);
                }
                deleteList.addAll(newMaps.keySet());
            }
            coll = null;
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(newMaps.size());
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)detailTable);
            for (Map.Entry entry : newMaps.entrySet()) {
                String key = entry.getKey().toString();
                DeclareCellKeyVo cellKeyVo = DeclareCellKeyService.getMembersByCellKey(key);
                String row = cellKeyVo.getRowMember();
                String col = cellKeyVo.getColMember();
                int index = cellKeyVo.getIndex();
                DynamicObject obj = new DynamicObject((DynamicObjectType)entityType);
                obj.set("id", (Object)UUID.randomUUID());
                obj.set("entryid", (Object)sbbId);
                if (rowMember.get(row) != null) {
                    obj.set("row", (Object)rowMember.get(row));
                }
                if (colMember.get(col) != null) {
                    obj.set("column", (Object)colMember.get(col));
                }
                obj.set("cellnumber", (Object)key);
                String fieldType = "";
                EntityField field = (EntityField)typeMap.get(key);
                if (field != null && !StringUtils.isEmpty((CharSequence)field.getFieldType())) {
                    fieldType = field.getFieldType();
                }
                obj.set("valuetype", (Object)fieldType);
                obj.set("value", entry.getValue());
                if (index != 0) {
                    obj.set("dynrowno", (Object)(row + "#1"));
                    obj.set("index", (Object)index);
                }
                list.add(obj);
            }
            Throwable throwable = null;
            try (TXHandle h = TX.requiresNew();){
                try {
                    DynamicObject[] dataEntities = new DynamicObject[]{mainObj};
                    SaveServiceHelper.save((DynamicObject[])dataEntities);
                    if (deleteList.size() > 0) {
                        List deleteListNew = Lists.partition(deleteList, (int)900);
                        deleteListNew.forEach(e -> {
                            QFilter numberFilter = new QFilter("cellnumber", "in", e);
                            DeleteServiceHelper.delete((String)detailTable, (QFilter[])new QFilter[]{sbbidFlter, numberFilter});
                        });
                        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                    }
                    DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)mainObj.getPkValue(), (String)mainTable);
                    if (MultiTableEnum.TSD001.getDeclareMainTable().equals(mainTable)) {
                        AccrualMQSender.sendMQ((DynamicObject)object);
                    }
                    MultiDeclareMQSender.sendMQ((DynamicObject[])new DynamicObject[]{object}, (String)"save");
                    DeclareMainServiceHelper.fireModel3DeclareMainChangeEvent((DynamicObject[])new DynamicObject[]{object}, (DeclareOperationEnum)DeclareOperationEnum.SAVE);
                }
                catch (Exception e5) {
                    h.markRollback();
                    logger.error("taxc-DeferPayRptPlugin pay fail:", (Object)e5.getMessage());
                    result.setCode(BaseResult.FAIL);
                    result.setMessage(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4fdd\u5b58\u5f02\u5e38\uff0c\u5df2\u56de\u6eda\uff01", (String)"MultiDataService_4", (String)"taxc-tpo", (Object[])new Object[0]));
                    BaseResult baseResult = result;
                    if (h != null) {
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            h.close();
                        }
                    }
                    if (lock != null) {
                        lock.unlock();
                    }
                    return baseResult;
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e6) {
            logger.error((Throwable)e6);
            result.setCode(BaseResult.FAIL);
            result.setMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f02\u5e38\uff01", (String)"MultiDataService_5", (String)"taxc-tpo", (Object[])new Object[0]));
            BaseResult baseResult = result;
            return baseResult;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        try {
            MultiDataService.updateHisData(sbbId, updateMap, currMap, typeMap, remarkMap, isRefresh);
        }
        catch (Exception e7) {
            logger.error("edit history data update fail!");
        }
        result.setData(resultMap);
        result.setCode(BaseResult.OK);
        rowMember = null;
        colMember = null;
        mainObj = null;
        return result;
    }

    private static void updateHisData(long ssbId, Map<String, String> updateData, Map<String, String> currMap, Map<String, EntityField> typeMap, Map<String, String> remarkMap, Boolean isRefresh) {
        if (typeMap == null) {
            typeMap = new HashMap<String, EntityField>(1);
        }
        ArrayList<DynamicObject> hisList = new ArrayList<DynamicObject>();
        if (isRefresh.booleanValue()) {
            MultiDataService.doConvertRecaleCellEditHis(String.valueOf(ssbId), currMap, typeMap, hisList, remarkMap, updateData);
        }
        MultiDataService.doConvertCellEditHis(ssbId, updateData, currMap, typeMap, remarkMap, hisList);
        if (!CollectionUtils.isEmpty(hisList)) {
            DynamicObject[] arrInsertDobj = new DynamicObject[hisList.size()];
            arrInsertDobj = hisList.toArray(arrInsertDobj);
            SaveServiceHelper.save((DynamicObject[])arrInsertDobj);
        }
    }

    private static void doConvertCellEditHis(long ssbId, Map<String, String> updateData, Map<String, String> currMap, Map<String, EntityField> typeMap, Map<String, String> remarkMap, ArrayList<DynamicObject> hisList) {
        if (updateData == null || updateData.size() == 0) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tctb_declare_his");
        for (Map.Entry<String, String> entry : updateData.entrySet()) {
            DynamicObject dObj = new DynamicObject((DynamicObjectType)mainEntityType);
            dObj.set("sbbid", (Object)ssbId);
            dObj.set("cellid", (Object)entry.getKey());
            dObj.set("modifytype", (Object)"2");
            EntityField cellType = typeMap.get(entry.getKey());
            String formatValue = DataFormatUtils.dataFormatByFieldType((Object)entry.getValue(), (EntityField)cellType);
            if (null != typeMap.get(entry.getKey()) && "Decimal".equals(cellType.getFieldType()) && StringUtils.isNotBlank((CharSequence)formatValue)) {
                formatValue = formatValue.replaceAll(",", "");
            }
            String originalvalue = null;
            if (null != currMap) {
                originalvalue = currMap.get(entry.getKey());
                if (null != typeMap.get(entry.getKey()) && "Decimal".equals(cellType.getFieldType()) && StringUtils.isNotBlank((CharSequence)originalvalue)) {
                    originalvalue = originalvalue.replaceAll(",", "");
                }
            }
            dObj.set("originalvalue", originalvalue);
            dObj.set("targetvalue", (Object)formatValue);
            if (remarkMap != null) {
                dObj.set("remark", (Object)remarkMap.get(entry.getKey()));
            }
            RequestContext context = RequestContext.get();
            dObj.set("modifierfield", (Object)context.getUserId());
            dObj.set("modifydatefield", (Object)new Date());
            hisList.add(dObj);
        }
    }

    public static void doConvertRecaleCellEditHis(String sbbId, Map<String, String> curData, Map<String, EntityField> typeMap, List<DynamicObject> hisList, Map<String, String> remarkMap, Map<String, String> updateMap) {
        Object changeUpdateMap;
        Map<String, String> cellEditHistoryMap = MultiDataService.doQueryCellEditHistory(sbbId);
        Map<String, String> changedCellMap = cellEditHistoryMap.entrySet().stream().filter(k -> !((String)k.getValue()).equals(curData.get(k.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> k2));
        if (!CollectionUtils.isEmpty(updateMap) && !CollectionUtils.isEmpty((Map)(changeUpdateMap = updateMap.entrySet().stream().filter(v -> !cellEditHistoryMap.containsKey(v.getKey())).collect(Collectors.toMap(Map.Entry::getKey, v -> "", (k1, k2) -> k2))))) {
            changedCellMap.putAll((Map<String, String>)changeUpdateMap);
        }
        if (CollectionUtils.isEmpty(changedCellMap)) {
            return;
        }
        for (Map.Entry<String, String> entry : changedCellMap.entrySet()) {
            DynamicObject dObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctb_declare_his"));
            dObj.set("sbbid", (Object)sbbId);
            dObj.set("cellid", (Object)entry.getKey());
            dObj.set("modifytype", (Object)"1");
            String originalvalue = DataFormatUtils.dataFormatByFieldType((Object)entry.getValue(), (EntityField)typeMap.get(entry.getKey()));
            if (null != typeMap.get(entry.getKey()) && "Decimal".equals(typeMap.get(entry.getKey()).getFieldType()) && StringUtils.isNotBlank((CharSequence)originalvalue)) {
                originalvalue = originalvalue.replaceAll(",", "");
            }
            String targetvalue = curData.get(entry.getKey());
            if (updateMap != null && updateMap.containsKey(entry.getKey())) {
                dObj.set("modifytype", (Object)"2");
                targetvalue = updateMap.get(entry.getKey());
            }
            if (null != typeMap.get(entry.getKey()) && "Decimal".equals(typeMap.get(entry.getKey()).getFieldType()) && StringUtils.isNotBlank((CharSequence)targetvalue)) {
                targetvalue = targetvalue.replaceAll(",", "");
            }
            if (StringUtil.isBlank((CharSequence)originalvalue) && StringUtil.isBlank((CharSequence)targetvalue)) continue;
            if (remarkMap != null) {
                dObj.set("remark", (Object)remarkMap.get(entry.getKey()));
            }
            dObj.set("originalvalue", (Object)originalvalue);
            dObj.set("targetvalue", (Object)targetvalue);
            dObj.set("modifierfield", (Object)RequestContext.get().getUserId());
            dObj.set("modifydatefield", (Object)new Date());
            hisList.add(dObj);
        }
        if (!CollectionUtils.isEmpty(updateMap)) {
            Map<String, String> temp = updateMap.entrySet().stream().filter(k -> !changedCellMap.containsKey(k.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> k2));
            updateMap.clear();
            updateMap.putAll(temp);
        }
    }

    private static Map<String, String> doQueryCellEditHistory(String sbbid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tctb_declare_his");
        DynamicObjectCollection changedCells = QueryServiceHelper.query((String)"tctb_declare_his", (String)"id,cellid,sbbid,targetvalue,remark,modifytype,originalvalue,modifierfield,modifydatefield", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)});
        if (CollectionUtils.isEmpty((Collection)changedCells)) {
            return new HashMap<String, String>();
        }
        return changedCells.stream().collect(Collectors.groupingBy(c -> c.getString("cellid"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((List)v.getValue()).stream().max(Comparator.comparing(d -> d.getLong("id"))).orElseGet(() -> new DynamicObject((DynamicObjectType)mainEntityType)).getString("targetvalue"), (v1, v2) -> v1));
    }

    public static List<Map<String, String>> calCheckFormulas(DeclareRequestModel requestModel, Map<String, String> data, Map<String, List<FormulaVo>> formula, Map<String, EntityField> typeMap) {
        long time = System.currentTimeMillis();
        List list = new CheckFormulaContext().calCheckFormulas(data, requestModel.getBusinessMap(), formula, typeMap);
        logger.info("\u98ce\u9669\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return list;
    }

    public static Map<String, String> calStyleFormulas(Map<String, String> data, Map param, Map<String, EntityField> typeMap, List<DynamicRowModel> dynRowList, List<FormulaVo> formulaVos) {
        long time = System.currentTimeMillis();
        Map map = new StyleFormulaContext().cal(data, param, typeMap, dynRowList, formulaVos);
        logger.info("\u6837\u5f0f\u516c\u5f0f\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return map;
    }

    public static BaseResult saveHisTaxDeclareData(Long sbbid, Map<String, Object> requestParams) {
        Map exParams;
        String causedesc = (String)requestParams.get("causedesc");
        Long modelId = ObjectUtils.toLong((Object)requestParams.get("modelId"));
        DynamicObject declares = MultiDeclareBizBusiness.queryMultiDeclareById((Long)sbbid);
        String type = declares.getString("templatetype.id");
        long orgid = ((DynamicObject)declares.get("org")).getLong("id");
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setTemplateId(Long.valueOf(declares.getLong("templateid.id")));
        requestModel.setOrgId(Long.valueOf(orgid));
        requestModel.setModelId(modelId);
        requestModel.setTemplateType(type);
        requestModel.setSkssqq(DateUtils.format((Date)declares.getDate("skssqq")));
        requestModel.setSkssqz(DateUtils.format((Date)declares.getDate("skssqz")));
        requestModel.setId(Long.valueOf(declares.getLong("id")));
        HashMap<String, Object> extendParams = new HashMap<String, Object>(10);
        extendParams.put("versiontype", declares.get("versiontype"));
        extendParams.put("causedesc", causedesc);
        requestModel.setExtendParams(extendParams);
        DeclareReportOpenService declareReportOpenService = DeclareReportOpenFactory.createHandler((String)type);
        if (declareReportOpenService != null && (exParams = declareReportOpenService.getExtendParams(type, declares, false)) != null && !exParams.isEmpty()) {
            extendParams.putAll(exParams);
        }
        DeclareResponseModel responseModel = MultiDataService.queryData(requestModel);
        Map olddata = responseModel.getData();
        String declaredata = JsonUtil.toJson((Object)olddata);
        DynamicObject hisData = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tpo_history_sbb"));
        DataEntityPropertyCollection headProps = hisData.getDynamicObjectType().getProperties();
        headProps.forEach(property -> {
            if (declares.containsProperty(property.getName())) {
                hisData.set(property.getName(), declares.get(property.getName()));
                if (property instanceof LargeTextProp) {
                    hisData.set(property.getName() + "_tag", declares.get(property.getName()));
                }
            }
        });
        DynamicObject currentUserDO = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        hisData.set("id", (Object)DB.genLongId((String)"t_tpo_history_sbb"));
        hisData.set("creator", (Object)currentUserDO);
        hisData.set("createtime", (Object)new Date(System.currentTimeMillis()));
        hisData.set("modifier", (Object)currentUserDO);
        hisData.set("modifytime", (Object)new Date(System.currentTimeMillis()));
        hisData.set("declaredata_tag", (Object)declaredata);
        hisData.set("declareid", (Object)declares.getLong("id"));
        hisData.set("versiontype", declares.get("versiontype"));
        hisData.set("causedesc", (Object)causedesc);
        BaseResult result = new BaseResult();
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{hisData});
                DeclareReportSaveHisService declareReportSaveHisService = DeclareReportSaveHisFactory.createHandler((String)type);
                if (declareReportSaveHisService != null) {
                    declareReportSaveHisService.saveBusinessData(declares, hisData, requestParams);
                }
                result.setCode(BaseResult.OK);
                result.setData((Object)hisData.getLong("id"));
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("saveHisTaxDeclareData fail:", (Object)e.getMessage());
                result.setCode(BaseResult.FAIL);
                BaseResult baseResult = result;
                if (h != null) {
                    if (var19_18 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var19_18.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return baseResult;
            }
        }
        return result;
    }

    public static DeclareResponseModel queryHistoryData(DeclareRequestModel requestModel, Map<String, Object> customParams) {
        DeclareResponseModel responseModel = new DeclareResponseModel();
        Long sbbid = ObjectUtils.toLong((Object)customParams.get("sbbid"));
        DynamicObject historySbb = MultiDeclareBizBusiness.queryMultiHisDecalreById((Long)sbbid);
        if (historySbb == null) {
            return responseModel;
        }
        Map<String, Object> originalData = new HashMap(100);
        if (StringUtil.isNotEmpty((CharSequence)historySbb.getString("declaredata_tag"))) {
            originalData = (Map)JsonUtil.fromJson((String)historySbb.getString("declaredata_tag"), Map.class);
        }
        HashMap<String, String> data = new HashMap<String, String>(originalData.size());
        originalData.forEach((k, v) -> data.put((String)k, v != null ? v.toString() : null));
        Long templateId = Long.valueOf(historySbb.getString("templateid.id"));
        Map businessMap = requestModel.getBusinessMap().size() == 0 ? InitParamsService.getInitParams((String)requestModel.getTemplateType()).buildBizParam(requestModel) : requestModel.getBusinessMap();
        responseModel.setId(sbbid);
        responseModel.setTemplateId(templateId);
        responseModel.setData(data);
        responseModel.setDynRowList(MultiDynamicRowService.getDynRowListData(templateId, data));
        responseModel.setParamMap(businessMap);
        return responseModel;
    }
}

