/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.multidideclare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class MultiDiBusinessRuleHelper {
    private static final String CAL_FORMULA = "calFormula_%s";
    private static final String CHECK_FORMULA = "checkFormula_%s";
    private static final String CELL_TYPE_FORMULA = "cellTypeFormula_%s";

    public static void removeFormulaCache(Long templateId) {
    }

    public static Map<String, FormulaVo> getFetchRuleByTemplate(Long templateId) {
        QFilter qFilter = new QFilter("template", "=", (Object)templateId).and(QFilter.isNotNull((String)"reportitem.number"));
        DynamicObject[] formulas = BusinessDataServiceHelper.load((String)"tpo_template_rule_fetch", (String)"id,template,reportitem,formula,model", (QFilter[])qFilter.toArray());
        Map<String, FormulaVo> result = Arrays.stream(formulas).filter(a -> StringUtil.isNotEmpty((CharSequence)a.getString("reportitem.number"))).collect(Collectors.toMap(a -> a.getString("reportitem.number"), b -> {
            FormulaVo formulaVo = new FormulaVo();
            formulaVo.setFormulaKey(b.getString("reportitem.number"));
            formulaVo.setFormulaType("1");
            formulaVo.setFormula(b.getString("formula.formula"));
            formulaVo.setFormulaName(b.getString("formula.name"));
            formulaVo.setDatatype(b.getString("formula.datatype"));
            return formulaVo;
        }, (m, n) -> m));
        return result;
    }

    public static Map<String, List<FormulaVo>> getCheckRuleByTemplate(Long templateId) {
        QFilter qFilter = new QFilter("template", "=", (Object)templateId);
        DynamicObject[] formulas = BusinessDataServiceHelper.load((String)"tpo_template_rule_check", (String)"id,template,reportitem,formula,model", (QFilter[])qFilter.toArray());
        HashMap<String, List<FormulaVo>> result = new HashMap<String, List<FormulaVo>>(formulas.length * 2);
        for (DynamicObject b : formulas) {
            if (StringUtil.isEmpty((CharSequence)b.getString("reportitem.number"))) continue;
            List orDefault = result.getOrDefault(b.getString("reportitem.number"), new ArrayList());
            FormulaVo formulaVo = new FormulaVo();
            formulaVo.setFormulaKey(b.getString("reportitem.number"));
            formulaVo.setFormulaType("2");
            formulaVo.setFormula(b.getString("formula.formula"));
            formulaVo.setFormulaName(b.getString("formula.name"));
            formulaVo.setTitle(b.getString("formula.title"));
            formulaVo.setContent(b.getString("formula.content"));
            formulaVo.setChecktype(b.getString("formula.checktype"));
            orDefault.add(formulaVo);
            result.put(b.getString("reportitem.number"), orDefault);
        }
        return result;
    }

    public static Map<String, List<FormulaVo>> getCheckRuleByTemplate(Long templateId, String checkType) {
        QFilter qFilter = new QFilter("template", "=", (Object)templateId);
        qFilter.and(new QFilter("formula.checktype", "=", (Object)checkType));
        DynamicObject[] formulas = BusinessDataServiceHelper.load((String)"tpo_template_rule_check", (String)"id,template,reportitem,formula,model", (QFilter[])qFilter.toArray());
        HashMap<String, List<FormulaVo>> result = new HashMap<String, List<FormulaVo>>(formulas.length * 2);
        for (DynamicObject b : formulas) {
            if (StringUtil.isEmpty((CharSequence)b.getString("reportitem.number"))) continue;
            List orDefault = result.getOrDefault(b.getString("reportitem.number"), new ArrayList());
            FormulaVo formulaVo = new FormulaVo();
            formulaVo.setFormulaKey(b.getString("reportitem.number"));
            formulaVo.setFormulaType("2");
            formulaVo.setFormula(b.getString("formula.formula"));
            formulaVo.setFormulaName(b.getString("formula.name"));
            formulaVo.setTitle(b.getString("formula.title"));
            formulaVo.setContent(b.getString("formula.content"));
            formulaVo.setChecktype(b.getString("formula.checktype"));
            orDefault.add(formulaVo);
            result.put(b.getString("reportitem.number"), orDefault);
        }
        return result;
    }

    public static Map<String, FormulaVo> getStyleRuleByTemplate(Long templateId) {
        QFilter qFilter = new QFilter("template", "=", (Object)templateId);
        DynamicObject[] formulas = BusinessDataServiceHelper.load((String)"tpo_template_rule_style", (String)"id,template,reportitem,formula,model", (QFilter[])qFilter.toArray());
        Map<String, FormulaVo> result = Arrays.stream(formulas).filter(a -> StringUtil.isNotEmpty((CharSequence)a.getString("reportitem.number"))).collect(Collectors.toMap(a -> a.getString("reportitem.number"), b -> {
            FormulaVo formulaVo = new FormulaVo();
            formulaVo.setFormulaKey(b.getString("reportitem.number"));
            formulaVo.setFormulaType("3");
            String formulaName = b.getString("formula.formula");
            formulaVo.setFormula(formulaName);
            formulaVo.setFormulaName(StringUtil.isNotEmpty((CharSequence)formulaName) ? formulaName.replace("\t", "") : formulaName);
            formulaVo.setCellType(b.getString("formula.celltype"));
            return formulaVo;
        }, (m, n) -> m));
        return result;
    }

    public static Map<String, String> getDataFormatRuleByTemplate(Long templateId) {
        QFilter qFilter = new QFilter("template", "=", (Object)templateId);
        QFilter qFilter1 = new QFilter("formula.celltype", "=", (Object)"9");
        DynamicObject[] formulas = BusinessDataServiceHelper.load((String)"tpo_template_rule_style", (String)"id,template,reportitem,formula,model", (QFilter[])new QFilter[]{qFilter, qFilter1});
        int initSize = 16;
        if (formulas == null || formulas.length == 0) {
            return new HashMap<String, String>(initSize);
        }
        initSize = formulas.length + 16;
        HashMap<String, String> result = new HashMap<String, String>(initSize);
        for (DynamicObject obj : formulas) {
            result.put(obj.getString("reportitem.number"), obj.getString("formula.formula"));
        }
        return result;
    }
}

