/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.multidideclare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.business.domain.TemplateCacheParams;
import kd.taxc.bdtaxr.common.refactor.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.TemplateBuildOptions;
import kd.taxc.bdtaxr.common.vo.TemplateStructureVo;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.GetTemplateVo;
import kd.taxc.tpo.business.multidideclare.DeclareCellKeyService;
import kd.taxc.tpo.business.multidideclare.MultiDataService;
import kd.taxc.tpo.business.multidideclare.MultiFormulaService;
import kd.taxc.tpo.common.vo.DeclareCellKeyVo;
import kd.taxc.tpo.common.vo.GetTemplateOptions;
import kd.taxc.tpo.common.vo.TemplateDynamicRowVo;

public class MultiDiTemplateHelper {
    private static final String TEMPLATE_SHEETS = "template_sheets_%s_%s_%s_%s_%s";
    private static final List<String> COLOR_BLACK_LIST = Collections.singletonList("#d4ffaa");
    private static final List<String> TEMPLATE_WHITE_LIST = Arrays.asList("sdsjt_bd", "sdsjt_jt", "jtysbbd_bd", "jtysbbd_jt");

    public static Map<String, DynamicObject> getReportItemsByTemplate(String templateId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(templateId), (String)"tpo_template");
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        Set collect = entryentity.stream().map(a -> a.get("reportitem.id")).collect(Collectors.toSet());
        DynamicObject[] cells = BusinessDataServiceHelper.load((String)"tpo_report_item", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,model,row,col,longname", (QFilter[])new QFilter("id", "in", collect).toArray());
        Map<String, DynamicObject> result = Stream.of(cells).collect(Collectors.toMap(a -> a.getString("number"), b -> b, (m, n) -> m));
        return result;
    }

    public static DynamicObject getTemplateByConfig(Long modelId, String templateType, String orgid, Date startDate, Date endDate) {
        String templateEntity = "bdtaxr_template_main";
        QFilter filter = null;
        if (modelId != null) {
            filter = new QFilter("model", "=", (Object)modelId);
            templateEntity = "tpo_template";
        }
        return TemplateUtils.getTemplateObjectByConfig((String)templateType, (String)orgid, (Date)startDate, (Date)endDate, (String)templateEntity, (QFilter)filter);
    }

    public static void refreshTemplateCache(TemplateCacheParams params) {
        if (!params.valitParam()) {
            return;
        }
        String templateCacheKey = String.format(TEMPLATE_SHEETS, params.getModelId(), params.getTemplateType(), params.getOrgid(), params.getStartDate(), params.getEndDate());
        List sheets = SpreadUtils.getSheets((String)params.getTemplateContent(), null);
        TemplateVo templateVo = new TemplateVo();
        templateVo.setTemplateId(params.getTemplateId());
        templateVo.setTemplateNumber(params.getTemplateNumber());
        templateVo.setTemplate(sheets);
        CacheUtils.put((String)templateCacheKey, (Object)templateVo);
    }

    public static TemplateVo getBaseTemplate(Long modelId, String templateType, String orgid, Date startDate, Date endDate) {
        String templateCacheKey = String.format(TEMPLATE_SHEETS, modelId, templateType, orgid, startDate, endDate);
        DynamicObject templateObj = MultiDiTemplateHelper.getTemplateByConfig(modelId, templateType, orgid, startDate, endDate);
        if (templateObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u67e5\u65e0\u53ef\u7528\u62a5\u8868\u6a21\u677f\u3002", (String)"MultiDiTemplateHelper_0", (String)"taxc-tpo", (Object[])new Object[0]));
        }
        TemplateVo templateVo = MultiDiTemplateHelper.getTemplateVo(templateObj);
        CacheUtils.put((String)templateCacheKey, (Object)templateVo);
        return templateVo;
    }

    public static TemplateVo getBaseTemplateByNumber(Long modelId, String templateNumber) {
        DynamicObject templateObj;
        String templateEntity = "bdtaxr_template_main";
        QFilter filter = new QFilter("number", "=", (Object)templateNumber);
        if (modelId != null) {
            filter.and(new QFilter("model", "=", (Object)modelId));
            templateEntity = "tpo_template";
        }
        if ((templateObj = TemplateUtils.getTemplateObjectByConfig(null, null, null, null, (String)templateEntity, (QFilter)filter)) == null) {
            throw new RuntimeException("No template Data!");
        }
        TemplateVo templateVo = MultiDiTemplateHelper.getTemplateVo(templateObj);
        return templateVo;
    }

    private static TemplateVo getTemplateVo(DynamicObject templateObj) {
        Long templateId = templateObj.getLong("id");
        ArrayList sheets = new ArrayList();
        String templateNumber = templateObj.getString("number");
        String templateContent = templateObj.getString("content_tag");
        sheets.addAll(SpreadUtils.getSheets((String)templateContent, null));
        TemplateVo templateVo = new TemplateVo();
        templateVo.setTemplateId(templateId);
        templateVo.setTemplateNumber(templateNumber);
        templateVo.setTemplate(sheets);
        return templateVo;
    }

    public static TemplateVo parseTemplate(GetTemplateVo getTemplateVo) {
        return MultiDiTemplateHelper.parseTemplate(new GetTemplateOptions(getTemplateVo));
    }

    private static TemplateVo parseTemplate(GetTemplateOptions options) {
        Long templateId = options.getTemplateId();
        String templateType = options.getTemplateType();
        List<Sheet> sheets = options.getSheets();
        Map<String, FormulaVo> cellTypeMap = options.getCellTypeMap();
        List<DynamicRowModel> dynamicRowList = options.getDynamicRowList();
        List<String> hideRows = options.getHideRows();
        Map<String, List<Integer>> hideRowByRowNum = options.getHideRowByRowNum();
        List<String> hideCols = options.getHideCols();
        List<String> hideModificationNotes = options.getHideModificationNotes();
        List<String> hideSheets = options.getHideSheets();
        List<String> lockCellKeys = options.getLockCellKeys();
        Map<String, DynamicObject> reportItems = MultiDiTemplateHelper.getReportItemsByTemplate(templateId.toString());
        HashMap<String, String> showItems = new HashMap<String, String>(100);
        if (null != hideSheets) {
            Iterator<Sheet> iterator = sheets.iterator();
            while (iterator.hasNext()) {
                Sheet sheet = iterator.next();
                if (!hideSheets.contains(sheet.getName())) continue;
                iterator.remove();
            }
        }
        HashMap<String, String> sheetIdNames = new HashMap<String, String>(sheets.size());
        ArrayList<TemplateDynamicRowVo> templateDynamicRowList = new ArrayList<TemplateDynamicRowVo>(16);
        ArrayList<Integer> hideColIndex = null;
        for (Sheet e : sheets) {
            sheetIdNames.put(e.getId(), e.getName());
            hideColIndex = new ArrayList<Integer>(10);
            String sheetName = e.getName();
            List<Integer> hideRowList = null;
            if (hideRowByRowNum != null) {
                hideRowList = hideRowByRowNum.get(sheetName);
            }
            List rowList = e.getRowList();
            for (int i = 0; i < rowList.size(); ++i) {
                boolean isHideRowByRowKey;
                List cellList = (List)rowList.get(i);
                boolean isHideRowByRowNum = hideRowList != null && !CollectionUtils.isEmpty(hideRowList) && hideRowList.contains(i);
                boolean bl = isHideRowByRowKey = !CollectionUtils.isEmpty(hideRows) && cellList.stream().anyMatch(c -> c.getCellKey() != null && c.getCellKey().contains("#") && hideRows.contains(c.getCellKey().split("#")[0]));
                if (isHideRowByRowNum || isHideRowByRowKey) {
                    cellList.forEach(c -> c.setHide(true));
                }
                boolean dynamicRow = false;
                for (Cell cell2 : cellList) {
                    boolean isShowItem;
                    int hideCol;
                    String cellKey = cell2.getCellKey();
                    if (StringUtil.isBlank((CharSequence)cellKey) || !cellKey.contains("#")) {
                        if (cell2.getStyle() == null) continue;
                        if (cell2.getStyle().gethAlign() == null) {
                            cell2.getStyle().sethAlign(Integer.valueOf(0));
                        }
                        cell2.getStyle().setLocked(Boolean.TRUE);
                        continue;
                    }
                    cell2.setCellKey(cellKey);
                    DynamicObject reportItem = reportItems.get(cellKey);
                    if (reportItem != null) {
                        cell2.setDimensionCell(true);
                        cell2.setRowName(reportItem.getDynamicObject("row") != null ? reportItem.getDynamicObject("row").getString("name") : "");
                        cell2.setColumnName(reportItem.getDynamicObject("col") != null ? reportItem.getDynamicObject("col").getString("name") : "");
                    }
                    DeclareCellKeyVo cellKeyVo = DeclareCellKeyService.getMembersByCellKey(cellKey);
                    if (!CollectionUtils.isEmpty(hideCols) && hideCols.contains(cellKeyVo.getColMember()) && !hideColIndex.contains(hideCol = cell2.getCol())) {
                        hideColIndex.add(hideCol);
                    }
                    if (!CollectionUtils.isEmpty(hideModificationNotes) && hideModificationNotes.contains(cellKeyVo.getColMember())) {
                        cell2.setHideModificationNote(true);
                    }
                    if (!(!CollectionUtils.isEmpty(hideRows) && hideRows.contains(cellKeyVo.getRowMember()) || !CollectionUtils.isEmpty(hideCols) && hideCols.contains(cellKeyVo.getColMember()))) {
                        showItems.put(cellKey, "1");
                    }
                    cell2.setFormulaVo(cellTypeMap.get(cell2.getCellKey()));
                    if (cell2.getStyle() != null && COLOR_BLACK_LIST.contains(cell2.getStyle().getBackColor()) && cell2.getStyle().getBackColor() != null) {
                        cell2.getStyle().setBackColor(null);
                    }
                    if (cell2.getStyle() != null && !TEMPLATE_WHITE_LIST.contains(templateType)) {
                        if (cell2.getStyle().getBackColor() != null) {
                            cell2.getStyle().setBackColor(null);
                        }
                        if (cell2.getStyle().getForeColor() != null) {
                            cell2.getStyle().setForeColor(null);
                        }
                        if (cell2.getStyle().getFont() != null) {
                            cell2.getStyle().setFont(null);
                        }
                    }
                    String rowMember = cellKeyVo.getRowMember();
                    TemplateDynamicRowVo templateDynamicRowVo = templateDynamicRowList.stream().filter(t -> t.getRowMember().equals(rowMember)).findAny().orElse(null);
                    int startRowNum = 0;
                    String dynamicRowNo = "";
                    boolean isDisablefronto = false;
                    if (templateDynamicRowVo == null) {
                        DynamicRowModel dynamicRowModel = DeclareCellKeyService.matchDynamicRowByMembers(dynamicRowList, cellKeyVo);
                        if (dynamicRowModel == null) continue;
                        startRowNum = dynamicRowModel.getStartRow().intValue();
                        dynamicRowNo = dynamicRowModel.getDynRowNo();
                        isDisablefronto = dynamicRowModel.isDisablefrontop();
                        int rowListSize = 0;
                        if (dynamicRowModel.getRowList() != null) {
                            rowListSize = dynamicRowModel.getRowList().size();
                        }
                        templateDynamicRowVo = new TemplateDynamicRowVo();
                        templateDynamicRowVo.setRowMember(rowMember);
                        templateDynamicRowVo.setDynamicRowNo(dynamicRowNo);
                        templateDynamicRowVo.setCellList(cellList);
                        templateDynamicRowVo.setDisablefrontop(isDisablefronto);
                        templateDynamicRowVo.setStartRowNum(startRowNum);
                        templateDynamicRowVo.setDynRowSize(rowListSize);
                        templateDynamicRowList.add(templateDynamicRowVo);
                    } else {
                        startRowNum = templateDynamicRowVo.getStartRowNum();
                        dynamicRowNo = templateDynamicRowVo.getDynamicRowNo();
                        isDisablefronto = templateDynamicRowVo.isDisablefrontop();
                    }
                    dynamicRow = true;
                    String newKey = DeclareCellKeyService.newCellKeyByRowIndex(cellKey, startRowNum);
                    FormulaVo f = cellTypeMap.get(newKey);
                    if (f != null) {
                        f.setFormulaKey(newKey);
                    }
                    cell2.setFormulaVo(f);
                    cell2.setText(cell2.getText().replace(cellKey, newKey));
                    String newCellKey = cell2.getCellKey();
                    cell2.setCellKey(newCellKey);
                    cell2.setDynRowCell(dynamicRow);
                    cell2.setDynRowNo(dynamicRowNo);
                    cell2.setDisablefrontop(isDisablefronto);
                    boolean bl2 = isShowItem = !(!CollectionUtils.isEmpty(hideRows) && hideRows.contains(cellKeyVo.getRowMember()) || !CollectionUtils.isEmpty(hideCols) && hideCols.contains(cellKeyVo.getColMember()));
                    if (cell2.isHide() || !isShowItem) continue;
                    showItems.put(newKey, "1");
                }
            }
            if (!CollectionUtils.isEmpty(hideColIndex)) {
                for (List list : rowList) {
                    for (Cell cell3 : list) {
                        if (!hideColIndex.contains(cell3.getCol())) continue;
                        cell3.setHide(true);
                    }
                }
            }
            if (CollectionUtils.isEmpty(lockCellKeys)) continue;
            for (List list : rowList) {
                for (Cell cell4 : list) {
                    if (cell4.getCellKey() == null || !lockCellKeys.contains(cell4.getCellKey()) || cell4.getStyle() == null) continue;
                    cell4.getStyle().setLocked(Boolean.valueOf(true));
                }
            }
        }
        Map<String, List<List<Cell>>> templateDynamicRowMap = MultiDiTemplateHelper.setDynamicRowMap(templateDynamicRowList);
        if (!CollectionUtils.isEmpty(templateDynamicRowMap)) {
            templateDynamicRowMap.values().stream().flatMap(Collection::stream).flatMap(Collection::stream).forEach(cell -> MultiDiTemplateHelper.handleDynCell(cell, hideRows, hideCols, hideModificationNotes, lockCellKeys, showItems));
        }
        TemplateVo templateVo = new TemplateVo();
        templateVo.setTemplate(sheets);
        templateVo.setDynamicRow(templateDynamicRowMap);
        templateVo.setShowItems(showItems);
        templateVo.setSheetIdNames(sheetIdNames);
        return templateVo;
    }

    private static void handleDynCell(Cell cell, List<String> hideRows, List<String> hideCols, List<String> hideModificationNotes, List<String> lockCellKeys, Map<String, String> showItems) {
        boolean isShowItem;
        if (cell.getCellKey() == null) {
            return;
        }
        DeclareCellKeyVo cellKeyVo = DeclareCellKeyService.getMembersByCellKey(cell.getCellKey());
        if (!CollectionUtils.isEmpty(hideRows) && hideRows.contains(cellKeyVo.getRowMember())) {
            cell.setHide(true);
        }
        if (!CollectionUtils.isEmpty(hideCols) && hideCols.contains(cellKeyVo.getColMember())) {
            cell.setHide(true);
        }
        if (!CollectionUtils.isEmpty(lockCellKeys) && lockCellKeys.contains(cell.getCellKey()) && cell.getStyle() != null) {
            cell.getStyle().setLocked(Boolean.valueOf(true));
        }
        if (!CollectionUtils.isEmpty(hideModificationNotes) && hideModificationNotes.contains(cellKeyVo.getColMember())) {
            cell.setHideModificationNote(true);
        }
        boolean bl = isShowItem = !(!CollectionUtils.isEmpty(hideRows) && hideRows.contains(cellKeyVo.getRowMember()) || !CollectionUtils.isEmpty(hideCols) && hideCols.contains(cellKeyVo.getColMember()));
        if (!cell.isHide() && isShowItem) {
            showItems.put(cell.getCellKey(), "1");
        }
    }

    private static Map<String, List<List<Cell>>> setDynamicRowMap(List<TemplateDynamicRowVo> templateDynamicRowList) {
        if (CollectionUtils.isEmpty(templateDynamicRowList)) {
            return null;
        }
        HashMap<String, List<List<Cell>>> dynamicRowMap = new HashMap<String, List<List<Cell>>>(templateDynamicRowList.size());
        for (TemplateDynamicRowVo templateDynamicRowVo : templateDynamicRowList) {
            int rowListSize = templateDynamicRowVo.getDynRowSize();
            List<Cell> cellList = templateDynamicRowVo.getCellList();
            ArrayList<List<Object>> dynamicList = new ArrayList<List<Object>>(rowListSize == 0 ? 1 : rowListSize);
            int startRowNum = templateDynamicRowVo.getStartRowNum();
            String dynamicRowNo = templateDynamicRowVo.getDynamicRowNo();
            dynamicList.add(cellList);
            for (int j = 2; j <= rowListSize; ++j) {
                ArrayList<Cell> cellListCopy = new ArrayList<Cell>(cellList.size());
                Cell cell = null;
                for (Cell c : cellList) {
                    cell = new Cell(c);
                    cell.setFormulaVo(c.getFormulaVo() == null ? null : c.getFormulaVo().clone());
                    cellListCopy.add(cell);
                }
                int num = startRowNum + j - 1;
                for (Cell el : cellListCopy) {
                    el.setText(el.getText().replace(new StringBuilder("#").append(startRowNum).append("#"), new StringBuilder("#").append(num).append("#")));
                    String cellKey = el.getCellKey();
                    el.setCellKey(cellKey);
                    FormulaVo vo = el.getFormulaVo();
                    if (vo == null) continue;
                    vo.setFormulaKey(el.getCellKey());
                    el.setFormulaVo(vo);
                }
                dynamicList.add(cellListCopy);
            }
            dynamicRowMap.put(dynamicRowNo, dynamicList);
        }
        templateDynamicRowList = null;
        return dynamicRowMap;
    }

    public static TemplateStructureVo getTemplateStructrue(Long templateId, TemplateBuildOptions buildOptions) {
        DynamicObject templateObj = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"tpo_template");
        String templateType = templateObj.getString("type");
        Long modelId = templateObj.getLong("model.id");
        TemplateVo baseTemplate = MultiDiTemplateHelper.getTemplateVo(templateObj);
        List sheets = baseTemplate.getTemplate();
        Map<String, FormulaVo> cellTypeMap = MultiFormulaService.getCellTypeFormulas(templateId, null);
        GetTemplateOptions options = new GetTemplateOptions();
        options.setSheets(sheets);
        options.setCellTypeMap(cellTypeMap);
        options.setTemplateType(templateType);
        options.setTemplateId(templateId);
        TemplateVo templateVo = MultiDiTemplateHelper.parseTemplate(options);
        Map<String, EntityField> typeMap = MultiDataService.getFieldsTypeToShowByVersion(modelId, templateId, null, buildOptions.getStartDate(), buildOptions.getEndDate());
        TemplateStructureVo result = new TemplateStructureVo();
        result.setTemplate(templateVo);
        result.setTypeMap(typeMap);
        return result;
    }
}

