/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.multidideclare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.tpo.business.formula.MultiDynamicRowCheckFormulaService;
import kd.taxc.tpo.business.formula.MultiDynamicRowService;
import kd.taxc.tpo.business.formula.MultiParseFormulaService;
import kd.taxc.tpo.business.multidideclare.DeclareCellKeyService;
import kd.taxc.tpo.business.multidideclare.MultiDiBusinessRuleHelper;
import kd.taxc.tpo.common.vo.DeclareCellKeyVo;

public class MultiFormulaService {
    public static FormulaCollectionVo getCalFormulas(DeclareRequestModel requestModel, List<DynamicRowModel> dynamicRowList) {
        MultiParseFormulaService p = new MultiParseFormulaService();
        Map<String, FormulaVo> formulas = MultiDiBusinessRuleHelper.getFetchRuleByTemplate(requestModel.getTemplateId());
        if (formulas == null || formulas.isEmpty()) {
            return new FormulaCollectionVo();
        }
        Map<String, FormulaVo> newFormulas = new HashMap<String, FormulaVo>(formulas.size());
        for (Map.Entry<String, FormulaVo> entry : formulas.entrySet()) {
            String cellKey = entry.getKey();
            DynamicRowModel d = DeclareCellKeyService.matchDynamicRow(dynamicRowList, cellKey);
            if (d != null) {
                String newKey = DeclareCellKeyService.newCellKeyByRowIndex(cellKey, Integer.parseInt(d.getStartRow().toString()));
                entry.getValue().setFormulaKey(newKey);
                newFormulas.put(newKey, entry.getValue());
                continue;
            }
            newFormulas.put(entry.getKey(), entry.getValue());
        }
        newFormulas = p.generateDynFormula(newFormulas, requestModel, dynamicRowList);
        for (Map.Entry<String, FormulaVo> formula : newFormulas.entrySet()) {
            p.parseFormulas(formula.getKey(), formula.getValue());
        }
        return new FormulaCollectionVo(newFormulas, p.getCformulas(), p.getRformulas(), p.getMformulas(), p.getCpformulas(), p.getQformulas());
    }

    public static Map<String, FormulaVo> getCellTypeFormulas(Long templateId, List<DynamicRowModel> dynamicRowList) {
        Map<String, FormulaVo> formulas = MultiDiBusinessRuleHelper.getStyleRuleByTemplate(templateId);
        HashMap<String, FormulaVo> cellTypeMap = new HashMap<String, FormulaVo>();
        for (FormulaVo formulaVo : formulas.values()) {
            String celltype = formulaVo.getCellType();
            if (!"2".equals(celltype) && !"3".equals(celltype) && !"4".equals(celltype) && !"5".equals(celltype) && !"6".equals(celltype) && !"7".equals(celltype)) continue;
            if (CollectionUtils.isEmpty(dynamicRowList)) {
                cellTypeMap.put(formulaVo.getFormulaKey(), formulaVo);
                continue;
            }
            String cellKey = formulaVo.getFormulaKey();
            DeclareCellKeyVo cellKeyVo = DeclareCellKeyService.getMembersByCellKey(cellKey);
            DynamicRowModel dynamicRowModel = DeclareCellKeyService.matchDynamicRowByMembers(dynamicRowList, cellKeyVo);
            if (null != dynamicRowModel) {
                int startRow;
                int dynamicRowSize = dynamicRowModel.getRowList() == null || dynamicRowModel.getRowList().size() == 0 ? 1 : dynamicRowModel.getRowList().size();
                for (int i = startRow = dynamicRowModel.getStartRow().intValue(); i <= dynamicRowSize + startRow - 1; ++i) {
                    String formulakey = cellKeyVo.getRowMember() + "#" + i + "#" + cellKeyVo.getColMember();
                    FormulaVo newFormulaVo = new FormulaVo(formulaVo);
                    newFormulaVo.setFormulaKey(formulakey);
                    cellTypeMap.put(formulakey, newFormulaVo);
                }
                continue;
            }
            cellTypeMap.put(formulaVo.getFormulaKey(), formulaVo);
        }
        return cellTypeMap;
    }

    public static Map<String, List<FormulaVo>> getCheckFormulas(Long templateId, List<DynamicRowModel> dynamicRowList) {
        Map<String, List<FormulaVo>> formulas = MultiDiBusinessRuleHelper.getCheckRuleByTemplate(templateId);
        return MultiFormulaService.getDynamicRowCheckFormulas(formulas, dynamicRowList);
    }

    public static Map<String, List<FormulaVo>> getCheckFormulasByCheckType(Long templateId, String checkType, List<DynamicRowModel> dynamicRowList) {
        Map<String, List<FormulaVo>> formulas = MultiDiBusinessRuleHelper.getCheckRuleByTemplate(templateId, checkType);
        return MultiFormulaService.getDynamicRowCheckFormulas(formulas, dynamicRowList);
    }

    private static Map<String, List<FormulaVo>> getDynamicRowCheckFormulas(Map<String, List<FormulaVo>> formulas, List<DynamicRowModel> dynamicRowList) {
        if (CollectionUtils.isEmpty(formulas)) {
            return new HashMap<String, List<FormulaVo>>(0);
        }
        MultiDynamicRowCheckFormulaService p = new MultiDynamicRowCheckFormulaService();
        HashMap<String, List<FormulaVo>> newFormulas = new HashMap<String, List<FormulaVo>>(formulas.size());
        for (Map.Entry<String, List<FormulaVo>> entry : formulas.entrySet()) {
            if (entry.getValue() == null || entry.getValue().size() == 0) continue;
            String cellKey = entry.getKey().toString();
            DynamicRowModel d = DeclareCellKeyService.matchDynamicRow(dynamicRowList, cellKey);
            if (d != null) {
                cellKey = DeclareCellKeyService.newCellKeyByRowIndex(cellKey, Integer.parseInt(d.getStartRow().toString()));
            }
            newFormulas.put(cellKey, entry.getValue());
        }
        Map<String, List<FormulaVo>> result = p.generateDynCheckFormula(newFormulas, dynamicRowList);
        ArrayList<String> deleteFormulas = new ArrayList<String>();
        for (String key : newFormulas.keySet()) {
            if (!MultiDynamicRowService.isDelKey(dynamicRowList, key)) continue;
            deleteFormulas.add(key);
        }
        deleteFormulas.forEach(e -> {
            List cfr_ignored_0 = (List)result.remove(e);
        });
        return result;
    }
}

