/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.rule;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.db.DynamicObjectUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.common.enums.RuleTypeStrategyEnum;

public class RuleService {
    public static final String TPO_RULE = "tpo_rule";
    public static final String DOWNLOAD_PERM = "45H/O1=4C4D7";
    public static final String VIEWDOWNLOAD_PERM = "45H/TA/UW5/8";
    private static Map<String, String> ruleBtnPerm = new HashMap<String, String>(){
        {
            this.put("download", RuleService.DOWNLOAD_PERM);
            this.put("viewdownload", RuleService.VIEWDOWNLOAD_PERM);
        }
    };
    private static List<String> SPECIAL_FORMIDS = new ArrayList<String>(){
        {
            this.add("1870264820906220544");
            this.add("1870265525532515328");
            this.add("1870266309020112896");
            this.add("1870265821113505792");
            this.add("1890543755803520000");
            this.add("1890632930188217344");
            this.add("1891260790015877120");
            this.add("1891260951278477312");
            this.add("1891379881984783360");
            this.add("1891408507782290432");
            this.add("1891408824250915840");
        }
    };

    public static boolean isybnsr(DynamicObjectCollection list, String ruletype, boolean existTypeChange) {
        if ("public".equals(ruletype) || existTypeChange) {
            return true;
        }
        if (EmptyCheckUtils.isNotEmpty((Object)list)) {
            DynamicObject dy = (DynamicObject)list.get(0);
            if ("ybnsr".equals(dy.getString("taxpayertype"))) {
                return true;
            }
            if ("xgmnsr".equals(dy.getString("taxpayertype"))) {
                return false;
            }
        }
        return false;
    }

    public static String getPermIdByBtnKey(String btnKey) {
        return ruleBtnPerm.getOrDefault(btnKey, "");
    }

    public static Long getCreateOrgId(List<Long> selectedMainOrgIds) {
        Long orgId = selectedMainOrgIds.size() != 1 ? Long.valueOf(RequestContext.get().getOrgId()) : selectedMainOrgIds.get(0);
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId).getData()).booleanValue()) {
            if (orgId.compareTo(PermissionUtils.getDefaultOrgId()) == 0) {
                return 0L;
            }
            if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)PermissionUtils.getDefaultOrgId()).getData()).booleanValue()) {
                return 0L;
            }
            orgId = PermissionUtils.getDefaultOrgId();
        }
        return orgId;
    }

    public static String downloadRule(List<Long> ruleList, List<Long> orgList, String ruleType) {
        StringBuilder message = new StringBuilder();
        DynamicObject[] ruleCollection = BusinessDataServiceHelper.load((Object[])ruleList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TPO_RULE));
        TaxResult orgInfo = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(orgList);
        List list = new ArrayList(0);
        if (orgInfo.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)orgInfo.getData())) {
            list = (List)orgInfo.getData();
        }
        for (Long org : orgList) {
            for (DynamicObject rule : ruleCollection) {
                DynamicObjectCollection categoryentryentity;
                DynamicObject orgObject;
                Date starttime = new Date();
                String ruleName = rule.getString("name");
                String group = rule.getString("group.id");
                RuleTypeStrategyEnum ruleTypeStrategyEnum = RuleTypeStrategyEnum.getStrategyByGroupId(group);
                String formId = ruleTypeStrategyEnum.getFormId();
                if (StringUtil.isBlank((CharSequence)formId)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u89c4\u5219\uff1a\u201c%s\u201d\u6570\u636e\u683c\u5f0f\u9519\u8bef\u3002", (String)"RuleDownloadConfirm_2", (String)"taxc-tpo", (Object[])new Object[0]), ruleName)).append("\n");
                    continue;
                }
                if ("tcvat".equals(ruleTypeStrategyEnum.getTaxType()) && SPECIAL_FORMIDS.contains(group) && "private".equals(ruleType) && (orgObject = (DynamicObject)list.stream().filter(e -> org.equals(e.getLong("orgid.id"))).findFirst().orElse(null)) != null && EmptyCheckUtils.isNotEmpty((Object)(categoryentryentity = orgObject.getDynamicObjectCollection("categoryentryentity"))) && "xgmnsr".equals(((DynamicObject)categoryentryentity.get(0)).getString("taxpayertype"))) {
                    String failMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u4e3a\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\uff0c\u65e0\u9700\u4e0b\u8f7d\u81ea\u7528\u7684\u201c%2$s\u201d\u3002", (String)"RuleDownloadConfirm_5", (String)"taxc-tpo", (Object[])new Object[0]), orgObject.getString("orgid.name"), ruleName);
                    message.append(failMsg).append("\n");
                    RuleService.downloadHistory(rule, starttime, null, org, ruleType, 0L, "", failMsg);
                    continue;
                }
                String ruledetail = rule.getString("ruledetail_tag");
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
                DynamicObject obj = null;
                try {
                    obj = DynamicObjectUtils.serializeToDataEntity((String)ruledetail, (String)formId);
                }
                catch (Exception e2) {
                    String failMsg = String.format(ResManager.loadKDString((String)"\u89c4\u5219\uff1a\u201c%s\u201d\u6570\u636e\u683c\u5f0f\u9519\u8bef\u3002", (String)"RuleDownloadConfirm_2", (String)"taxc-tpo", (Object[])new Object[0]), ruleName);
                    message.append(failMsg).append("\n");
                    RuleService.downloadHistory(rule, starttime, null, org, ruleType, 0L, "", failMsg);
                    continue;
                }
                if (obj == null) {
                    String failMsg = String.format(ResManager.loadKDString((String)"\u89c4\u5219\uff1a\u201c%s\u201d\u6570\u636e\u683c\u5f0f\u9519\u8bef\u3002", (String)"RuleDownloadConfirm_2", (String)"taxc-tpo", (Object[])new Object[0]), ruleName);
                    message.append(failMsg).append("\n");
                    RuleService.downloadHistory(rule, starttime, null, org, ruleType, 0L, "", failMsg);
                    continue;
                }
                QFilter orgFilter = new QFilter("org", "=", (Object)org);
                QFilter ruleFilter = new QFilter("name", "=", (Object)ruleName);
                boolean existData = QueryServiceHelper.exists((String)formId, (QFilter[])new QFilter[]{orgFilter, ruleFilter});
                if (existData) {
                    String failMsg = String.format(ResManager.loadKDString((String)"\u89c4\u5219\uff1a\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"RuleDownloadConfirm_3", (String)"taxc-tpo", (Object[])new Object[0]), ruleName);
                    message.append(failMsg).append("\r");
                    RuleService.downloadHistory(rule, starttime, null, org, ruleType, 0L, "", failMsg);
                    continue;
                }
                obj.set("org_id", (Object)org);
                obj.set("ruletype", (Object)ruleType);
                obj.set("enable", (Object)0);
                DynamicObject newRuleObject = BeanCopyUtils.copyDataExcludePKId((DynamicObject)obj);
                TaxResult result = (TaxResult)DispatchServiceHelper.invokeBizService((String)"taxc", (String)ruleTypeStrategyEnum.getTaxType(), (String)"ApiRuleService", (String)"saveRule", (Object[])new Object[]{newRuleObject, "1"});
                if (!result.isSuccess() || result.getData() == null) continue;
                DynamicObject resultObject = (DynamicObject)result.getData();
                message.append(String.format(ResManager.loadKDString((String)"\u89c4\u5219\uff1a\u201c%s\u201d\u4e0b\u8f7d\u6210\u529f\u3002", (String)"RuleDownloadConfirm_4", (String)"taxc-tpo", (Object[])new Object[0]), ruleName)).append("\n");
                Date endtime = new Date();
                RuleService.downloadHistory(rule, starttime, endtime, org, ruleType, resultObject.getLong("id"), resultObject.getString("number"), "");
            }
        }
        return message.toString();
    }

    public static void downloadHistory(DynamicObject rule, Date starttime, Date endtime, Long org, String ruleType, Long targetRuleId, String targetRuleNumber, String failMsg) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tpo_download_history");
        DynamicObject downloadLogObj = new DynamicObject((DynamicObjectType)mainEntityType);
        downloadLogObj.set("sourserule", (Object)rule);
        downloadLogObj.set("targetrule", (Object)targetRuleId);
        downloadLogObj.set("number", (Object)targetRuleNumber);
        downloadLogObj.set("starttime", (Object)starttime);
        downloadLogObj.set("endtime", (Object)endtime);
        downloadLogObj.set("org", (Object)org);
        downloadLogObj.set("ruletype", (Object)ruleType);
        RequestContext context = RequestContext.get();
        downloadLogObj.set("operator", (Object)context.getUserId());
        downloadLogObj.set("operatetime", (Object)new Date());
        downloadLogObj.set("detailmsg", (Object)failMsg);
        downloadLogObj.set("issuccess", (Object)(StringUtil.isBlank((CharSequence)targetRuleNumber) ? 0 : 1));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downloadLogObj});
        rule.set("dowloadhistory", (Object)"1");
        SaveServiceHelper.update((DynamicObject)rule);
    }
}

