/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.business.taxrefund;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tpo.common.vo.ResultResponse;
import org.apache.commons.collections.CollectionUtils;

public class TaxRefundInfoServer {
    private String entryName = "tpo_tax_refund_info";
    private static Log logger = LogFactory.getLog(TaxRefundInfoServer.class);

    public List<Long> queryTaxRefundInfo(List<Long> orgIds, List<String> declareTypes, List<Long> taxTypes, Map<Date, Date> periods) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter taxTypeFilter = new QFilter("taxcategory", "in", taxTypes);
        QFilter declareTypeFilter = new QFilter("declaretype", "in", declareTypes);
        qFilters.add(orgFilter);
        qFilters.add(taxTypeFilter);
        qFilters.add(declareTypeFilter);
        if (CollectionUtils.isNotEmpty(periods.entrySet())) {
            ArrayList dateFilters = new ArrayList();
            periods.forEach((key, value) -> {
                QFilter startdateQ = new QFilter("startdate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)key));
                QFilter enddateQ = new QFilter("enddate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)value));
                dateFilters.add(startdateQ.and(enddateQ));
            });
            QFilter dateFilter = (QFilter)dateFilters.get(0);
            for (int i = 1; i < dateFilters.size(); ++i) {
                dateFilter.or((QFilter)dateFilters.get(i));
            }
            qFilters.add(dateFilter);
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.entryName, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        return collection.stream().map(c -> c.getLong("id")).collect(Collectors.toList());
    }

    public ResultResponse saveTaxRefundInfo(List<Map<String, Object>> taxRefundInfoList) {
        ArrayList<Map<String, Object>> enableSaveInfoList = new ArrayList<Map<String, Object>>(taxRefundInfoList.size());
        ArrayList<Map> resultList = new ArrayList<Map>();
        for (Map<String, Object> taxRefundInfo : taxRefundInfoList) {
            ResultResponse checkResult = this.checkTaxRefundInfo(taxRefundInfo);
            if (!checkResult.getSuccess().booleanValue()) {
                resultList.add((Map)checkResult.getData());
                continue;
            }
            enableSaveInfoList.add(taxRefundInfo);
        }
        if (CollectionUtils.isNotEmpty(enableSaveInfoList)) {
            this.save(enableSaveInfoList);
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            return ResultResponse.fail("fail", resultList);
        }
        return ResultResponse.success("ok", resultList);
    }

    public ResultResponse saveOrUpdateTaxRefund(List<Map<String, Object>> taxRefundInfoList) {
        ArrayList<Map<String, Object>> enableSaveInfoList = new ArrayList<Map<String, Object>>(taxRefundInfoList.size());
        ArrayList<Map> resultList = new ArrayList<Map>();
        for (Map<String, Object> taxRefundInfo : taxRefundInfoList) {
            ResultResponse checkResult = this.checkTaxRefundInfo2(taxRefundInfo);
            if (!checkResult.getSuccess().booleanValue()) {
                resultList.add((Map)checkResult.getData());
                continue;
            }
            enableSaveInfoList.add(taxRefundInfo);
        }
        if (CollectionUtils.isNotEmpty(enableSaveInfoList)) {
            this.save2(enableSaveInfoList);
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            return ResultResponse.fail("fail", resultList);
        }
        return ResultResponse.success("ok", resultList);
    }

    public ResultResponse deleteTaxRefundInfo(List<String> declareNumList) {
        logger.info("\u9700\u5220\u9664\u7f16\u7801\u96c6\u5408deleteDeclareNumList\uff1a%s", (Object)String.join((CharSequence)",", declareNumList));
        QFilter statusFilter = new QFilter("taxrefundstatus", "=", (Object)"1").or("isvoucher", "=", (Object)"1");
        DynamicObjectCollection notDelRefundInfos = QueryServiceHelper.query((String)this.entryName, (String)"id,declarenum,taxrefundstatus,isvoucher", (QFilter[])new QFilter[]{new QFilter("declarenum", "in", declareNumList), statusFilter});
        ArrayList resultList = new ArrayList();
        for (DynamicObject taxRefundInfo : notDelRefundInfos) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            String declarenum = taxRefundInfo.getString("declarenum");
            if ("1".equals(taxRefundInfo.getString("taxrefundstatus"))) {
                resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u7533\u62a5\u8868\u7f16\u53f7\uff1a%s \u7684\u4e0b\u6e38\u9000\u7a0e\u4fe1\u606f\u4e3a\u672a\u9000\u7a0e\u6216\u672a\u751f\u6210\u51ed\u8bc1\u65f6\u624d\u80fd\u64cd\u4f5c", (String)"TaxRefundInfoServer_0", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
                resultMap.put("failnum", declarenum);
                resultList.add(resultMap);
                continue;
            }
            if (!"1".equals(taxRefundInfo.getString("isvoucher"))) continue;
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \u9000\u7a0e\u4fe1\u606f\u51ed\u8bc1\u72b6\u6001\u4e3a\u5df2\u751f\u6210\u51ed\u8bc1\u4e0d\u5141\u8bb8\u5220\u9664", (String)"TaxRefundInfoServer_1", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            resultMap.put("failnum", declarenum);
            resultList.add(resultMap);
        }
        List notDelDeclareNum = notDelRefundInfos.stream().map(e -> e.getString("declarenum")).collect(Collectors.toList());
        List canDelDeclareNum = declareNumList.stream().filter(e -> !notDelDeclareNum.contains(e)).collect(Collectors.toList());
        logger.info("\u53ef\u5220\u9664\u7f16\u7801\u96c6\u5408deleteDeclareNumList\uff1a%s", (Object)String.join((CharSequence)",", canDelDeclareNum));
        DeleteServiceHelper.delete((String)this.entryName, (QFilter[])new QFilter[]{new QFilter("declarenum", "in", canDelDeclareNum)});
        if (CollectionUtils.isNotEmpty(resultList)) {
            return ResultResponse.fail("fail", resultList);
        }
        return ResultResponse.success("ok", resultList);
    }

    private void save(List<Map<String, Object>> enableSaveInfoList) {
        ArrayList<DynamicObject> saveObjectList = new ArrayList<DynamicObject>(enableSaveInfoList.size());
        for (Map<String, Object> taxRefundInfo : enableSaveInfoList) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)this.entryName);
            taxRefundInfo.forEach((arg_0, arg_1) -> ((DynamicObject)object).set(arg_0, arg_1));
            String billno = DeclareServiceHelper.generateSBBNo((String)this.entryName);
            object.set("billno", (Object)billno);
            object.set("billstatus", (Object)"C");
            object.set("datasource", (Object)"0");
            object.set("taxrefundstatus", (Object)"0");
            object.set("isvoucher", (Object)"0");
            saveObjectList.add(object);
        }
        SaveServiceHelper.save((DynamicObject[])saveObjectList.toArray(new DynamicObject[0]));
    }

    private void save2(List<Map<String, Object>> enableSaveInfoList) {
        logger.info("save2\uff0cenableSaveInfoList:{}", (Object)enableSaveInfoList.size());
        ArrayList<Object> ids = new ArrayList<Object>(enableSaveInfoList.size());
        ArrayList<DynamicObject> saveObjectList = new ArrayList<DynamicObject>(enableSaveInfoList.size());
        for (Map<String, Object> taxRefundInfo : enableSaveInfoList) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)this.entryName);
            taxRefundInfo.forEach((arg_0, arg_1) -> ((DynamicObject)object).set(arg_0, arg_1));
            if (Objects.isNull(taxRefundInfo.get("id"))) {
                Object[] billno = DeclareServiceHelper.generateSBBNo((String)this.entryName);
                object.set("billno", (Object)billno);
            } else {
                ids.add(taxRefundInfo.get("id"));
            }
            saveObjectList.add(object);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.entryName);
        if (CollectionUtils.isNotEmpty(ids)) {
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])ids.toArray());
        }
        if (CollectionUtils.isNotEmpty(saveObjectList)) {
            logger.info("CollectionUtils.isNotEmpty(saveObjectList)");
            Object[] save = SaveServiceHelper.save((DynamicObject[])saveObjectList.toArray(new DynamicObject[0]));
            if (save != null) {
                logger.info("save != null");
                ArrayList<Long> pkIdList = new ArrayList<Long>(16);
                for (Object o : save) {
                    DynamicObject obj = (DynamicObject)o;
                    pkIdList.add(obj.getLong("id"));
                }
                Boolean audit = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)this.entryName, (String)"audit", pkIdList, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.INSERTWRITE);
                logger.info("\u51ed\u8bc1\u767d\u540d\u5355\uff0centity:{},id:{},result:{}", new Object[]{this.entryName, pkIdList.toArray(), audit});
            }
        }
    }

    private ResultResponse checkTaxRefundInfo(Map<String, Object> taxRefundInfo) {
        ResultResponse checkFiledResult = this.checkFiled(taxRefundInfo);
        if (!checkFiledResult.getSuccess().booleanValue()) {
            return checkFiledResult;
        }
        ResultResponse checkAmountFiledResult = this.checkAmountFiled(taxRefundInfo);
        if (!checkAmountFiledResult.getSuccess().booleanValue()) {
            return checkAmountFiledResult;
        }
        ResultResponse existData = this.checkExistData(taxRefundInfo);
        if (!existData.getSuccess().booleanValue()) {
            return existData;
        }
        return ResultResponse.success("ok", Boolean.TRUE);
    }

    private ResultResponse checkTaxRefundInfo2(Map<String, Object> taxRefundInfo) {
        ResultResponse existData;
        ResultResponse checkFiledResult = this.checkFiled(taxRefundInfo);
        if (!checkFiledResult.getSuccess().booleanValue()) {
            return checkFiledResult;
        }
        ResultResponse checkAmountFiledResult = this.checkAmountFiled(taxRefundInfo);
        if (!checkAmountFiledResult.getSuccess().booleanValue()) {
            return checkAmountFiledResult;
        }
        if (Objects.isNull(taxRefundInfo.get("id")) && !(existData = this.checkExistData(taxRefundInfo)).getSuccess().booleanValue()) {
            return existData;
        }
        return ResultResponse.success("ok", Boolean.TRUE);
    }

    private ResultResponse checkExistData(Map<String, Object> taxRefundInfo) {
        String declarenum = (String)taxRefundInfo.get("declarenum");
        Long taxcategory = (Long)taxRefundInfo.get("taxcategory");
        QFilter filter = new QFilter("declarenum", "=", (Object)declarenum).and("taxcategory", "=", (Object)taxcategory);
        boolean exists = QueryServiceHelper.exists((String)this.entryName, (QFilter[])new QFilter[]{filter});
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (exists) {
            resultMap.put("failnum", declarenum);
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u5df2\u7ecf\u751f\u6210\u8fc7\u5bf9\u5e94\u7684\u9000\u7a0e\u4fe1\u606f\u6570\u636e\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210", (String)"TaxRefundInfoServer_2", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        return ResultResponse.success("ok", resultMap);
    }

    private ResultResponse checkAmountFiled(Map<String, Object> taxRefundInfo) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        BigDecimal refundableamount = (BigDecimal)taxRefundInfo.get("refundableamount");
        String declarenum = (String)taxRefundInfo.get("declarenum");
        String amountStr = refundableamount.toString();
        String[] amountArr = amountStr.split("[.]");
        resultMap.put("failnum", declarenum);
        if (amountArr[0].length() > 13) {
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u5e94\u9000\u91d1\u989d\u6574\u6570\u4f4d\u4e0d\u5f97\u8d85\u8fc713\u4f4d", (String)"TaxRefundInfoServer_3", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        if (amountArr[1].length() > 10) {
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u5e94\u9000\u91d1\u989d\u5c0f\u6570\u4f4d\u4e0d\u5f97\u8d85\u8fc710\u4f4d", (String)"TaxRefundInfoServer_4", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        return ResultResponse.success("ok", Boolean.TRUE);
    }

    private ResultResponse checkFiled(Map<String, Object> taxRefundInfo) {
        Set<String> keySet = taxRefundInfo.keySet();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (!keySet.contains("declarenum")) {
            return ResultResponse.fail(ResManager.loadKDString((String)"\u7f3a\u5c11\u7533\u62a5\u8868\u7f16\u53f7\u5b57\u6bb5", (String)"TaxRefundInfoServer_5", (String)"taxc-tpo", (Object[])new Object[0]), Boolean.FALSE);
        }
        String declarenum = (String)taxRefundInfo.get("declarenum");
        resultMap.put("failnum", declarenum);
        if (!keySet.contains("taxcategory")) {
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u7f3a\u5c11\u7a0e\u79cd\u5b57\u6bb5", (String)"TaxRefundInfoServer_6", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        if (!keySet.contains("org")) {
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u7f3a\u5c11\u7ec4\u7ec7\u5b57\u6bb5", (String)"TaxRefundInfoServer_7", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        if (!keySet.contains("startdate")) {
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u7f3a\u5c11\u6240\u5c5e\u7a0e\u671f\u8d77\u5b57\u6bb5", (String)"TaxRefundInfoServer_8", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        if (!keySet.contains("enddate")) {
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u7f3a\u5c11\u6240\u5c5e\u7a0e\u671f\u6b62\u5b57\u6bb5", (String)"TaxRefundInfoServer_9", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        if (!keySet.contains("applicationdate")) {
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u7f3a\u5c11\u7533\u8bf7\u65e5\u671f\u5b57\u6bb5", (String)"TaxRefundInfoServer_10", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        if (!keySet.contains("currency")) {
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u7f3a\u5c11\u5e01\u522b\u5b57\u6bb5", (String)"TaxRefundInfoServer_11", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        if (!keySet.contains("refundableamount")) {
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u7f3a\u5c11\u5e94\u9000\u91d1\u989d\u5b57\u6bb5", (String)"TaxRefundInfoServer_12", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        if (!keySet.contains("taxoffice")) {
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u7f3a\u5c11\u7a0e\u52a1\u673a\u5173\u5b57\u6bb5", (String)"TaxRefundInfoServer_13", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        if (!keySet.contains("declaretype")) {
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u7f3a\u5c11\u7533\u62a5\u8868\u7c7b\u578b\u5b57\u6bb5", (String)"TaxRefundInfoServer_14", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        if (!keySet.contains("creator")) {
            resultMap.put("errormsg", String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7\uff1a%s \uff0c\u7f3a\u5c11\u521b\u5efa\u4eba\u5b57\u6bb5", (String)"TaxRefundInfoServer_15", (String)"taxc-tpo", (Object[])new Object[0]), declarenum));
            return ResultResponse.fail("fail", resultMap);
        }
        return ResultResponse.success("ok", resultMap);
    }
}

