/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.common.dataexport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DataExportUtil {
    private static Log logger = LogFactory.getLog(DataExportUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] zipFiles(Map<String, byte[]> param) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ZipOutputStream out = new ZipOutputStream(bos);){
            for (Map.Entry<String, byte[]> one : param.entrySet()) {
                ZipEntry entry = new ZipEntry(one.getKey());
                entry.setMethod(8);
                out.putNextEntry(entry);
                out.write(one.getValue());
                out.closeEntry();
                out.flush();
            }
            out.close();
            byte[] bytes = bos.toByteArray();
            bos.close();
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            logger.error("DataExportUtil zipFiles exception:", (Throwable)e);
            return null;
        }
    }
}

