/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.user.UserService;

public class AssistWhereFilterOperPlugin
extends AbstractFormPlugin {
    public static final String BillFilter_entityNumber = "entityNumber";
    public static final String CustParamKey_FilterJson = "sdfasdfasdfasd";
    public static final String KEY_FILTERDESCRIPTION = "filterdescription";
    public static final String KEY_FILTER_VALUE = "filtervalue";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_BTNOK = "btnok";
    private static final String Key_filtergridap = "filtergridap";
    private static final Set<String> types = new HashSet<String>(Arrays.asList("105", "106"));
    private static final Set<String> vouchertypes = new HashSet<String>(Arrays.asList("105", "106", "17", "34"));
    private static final Map<String, String> key = new HashMap<String, String>();
    private static final Map<String, String> tcvat_tax_refund = new HashMap<String, String>();

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTNCANCEL, KEY_BTNOK});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityNumber);
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        this.initFilterCondition(entityNumber);
        String filterJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_FilterJson);
        if (!StringUtils.isBlank((CharSequence)filterJson)) {
            this.setDataFilter(filterJson);
        }
    }

    private void initFilterCondition(String entityNumber) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.getFilterRow().clear();
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List<Map<String, Object>> filterColumns = this.removeFilterColumns(entityTypeUtil.getFilterColumns((IDataEntityType)entityType));
        this.renameFieldCaption(filterColumns);
        this.removeCompareTypes(filterColumns);
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityNumber);
        filterGrid.SetValue(fc);
        this.getView().updateView(Key_filtergridap);
    }

    private List<Map<String, Object>> removeFilterColumns(List<Map<String, Object>> filterColumns) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> filterColumn : filterColumns) {
            String fieldName = (String)filterColumn.get("fieldName");
            if (null != key.get(fieldName)) {
                if (fieldName.equals("retiredsoldiers") || fieldName.equals("keygroup") || fieldName.equals("armyrelatives") || fieldName.equals("militarycadres") || fieldName.equals("others")) {
                    Object opt = filterColumn.get("fieldCaption");
                    filterColumn.put("fieldCaption", String.format(ResManager.loadKDString((String)"\u6cd5\u4eba/\u4e1a\u4e3b\u8eab\u4efd\u4fe1\u606f(%s)", (String)"AssistWhereFilterOperPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]), opt));
                    list.add(filterColumn);
                } else {
                    list.add(filterColumn);
                }
            }
            if (null == tcvat_tax_refund.get(fieldName)) continue;
            list.add(filterColumn);
        }
        return list;
    }

    private void removeCompareTypes(List<Map<String, Object>> filterColumns) {
        for (Map<String, Object> filterColumn : filterColumns) {
            List compareTypes = (List)filterColumn.get("compareTypes");
            if ("type".equals(filterColumn.get("fieldName"))) {
                compareTypes.removeIf(t -> !types.contains(t.getId()));
                continue;
            }
            if (!"vouchertype".equals(filterColumn.get("fieldName"))) continue;
            compareTypes.removeIf(t -> !vouchertypes.contains(t.getId()));
        }
    }

    private void renameFieldCaption(List<Map<String, Object>> filterColumns) {
        for (Map<String, Object> filterColumn : filterColumns) {
            Object type = filterColumn.get("type");
            String caption = (String)filterColumn.get("fieldCaption");
            if (!caption.contains(".")) continue;
            if ("basedata".equals(type)) {
                filterColumn.put("fieldCaption", caption.replaceAll("\\.", ""));
                continue;
            }
            if (caption.split("\\.").length > 1) {
                filterColumn.put("fieldCaption", caption.split("\\.")[1]);
                continue;
            }
            filterColumn.put("fieldCaption", caption.split("\\.")[0]);
        }
    }

    private void setDataFilter(String dataFilter) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)dataFilter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        filterGrid.SetValue(filterCondition);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTNOK.equalsIgnoreCase(key)) {
            this.returnDataToParent();
        } else if (KEY_BTNCANCEL.equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private void returnDataToParent() {
        Map<String, Object> ret = this.getConfig();
        String err = (String)ret.get("err");
        if (!StringUtils.isBlank((CharSequence)err)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6761\u4ef6\u914d\u7f6e\u4e0d\u5b8c\u6574", (String)"AssistWhereFilterOperPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]), err, MessageTypes.Default);
        } else {
            this.getView().returnDataToParent(ret);
            this.getView().close();
        }
    }

    private Map<String, Object> getConfig() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filteList = filterCondition.getFilterRow();
        if (filteList == null || filteList.isEmpty()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(KEY_FILTER_VALUE, "");
            data.put(KEY_FILTERDESCRIPTION, "");
            return data;
        }
        List filterColumns = filterGrid.getFilterColumns();
        this.renameFieldCaption(filterColumns);
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityNumber);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        String desc = filterBuilder.getFilterObject().getFilter();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(KEY_FILTER_VALUE, filterJson);
        data.put(KEY_FILTERDESCRIPTION, desc.replaceAll(ResManager.loadKDString((String)"\u5355\u636e\u4f53.", (String)"AssistWhereFilterOperPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]), ""));
        return data;
    }

    static {
        key.put("registertype.number", "registertype.number");
        key.put("registertype.longnumber", "registertype.longnumber");
        key.put("registertime", "registertime");
        key.put("codeandname.number", "codeandname.number");
        key.put("codeandname.longnumber", "codeandname.longnumber");
        key.put("baseregisteraddress.longnumber", "baseregisteraddress.longnumber");
        key.put("actualaddress", "actualaddress");
        key.put("taxoffice.longnumber", "taxoffice.longnumber");
        key.put("retiredsoldiers", "retiredsoldiers");
        key.put("keygroup", "keygroup");
        key.put("armyrelatives", "armyrelatives");
        key.put("militarycadres", "militarycadres");
        key.put("others", "others");
        key.put("accountingstandards", "accountingstandards");
        key.put("levytype", "levytype");
        key.put("deadline", "deadline");
        key.put("apitudetype", "apitudetype");
        key.put("companytype", "companytype");
        key.put("exporttype", "exporttype");
        key.put("taxtype", "taxtype");
        key.put("orgplace", "orgplace");
        key.put("taxpayertype", "taxpayertype");
        tcvat_tax_refund.put("sndzzsysxsehj", "sndzzsysxsehj");
        tcvat_tax_refund.put("snmzcze", "snmzcze");
    }
}

