/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tpo.business.keysrc.KeySrcBusiness;

public class KeySrcPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit parent = (BasedataEdit)this.getView().getControl("parent");
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && this.getModel().getValue("parent") != null) {
            QFilter filter = new QFilter("id", "=", ((DynamicObject)this.getModel().getValue("parent")).getPkValue());
            DynamicObject parent = BusinessDataServiceHelper.loadSingle((String)"tpo_keytaxsrc", (String)"type", (QFilter[])filter.toArray());
            String type = (String)this.getModel().getValue("type");
            if (!type.equals(parent.getString("type"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b50\u62a5\u8868\u9879\u76ee\u9700\u4e0e\u4e0a\u7ea7\u540c\u4e00\u7c7b\u578b\u3002", (String)"KeySrcPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String type = (String)this.getModel().getValue("type");
        Date cur = new Date();
        QFilter f1 = new QFilter("type", "=", (Object)type);
        QFilter f2 = new QFilter("validfrom", "<=", (Object)cur);
        QFilter f3 = new QFilter("validto", ">=", (Object)DateUtils.addDay((Date)cur, (int)-1));
        QFilter f4 = new QFilter("validto", "=", null);
        QFilter f = type == null ? f2.and(f3.or(f4)) : f1.and(f2.and(f3.or(f4)));
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(f);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.getModel().getValue("parent") != null) {
            QFilter filter = new QFilter("id", "=", ((DynamicObject)this.getModel().getValue("parent")).getPkValue());
            DynamicObject parent = BusinessDataServiceHelper.loadSingle((String)"tpo_keytaxsrc", (String)"type", (QFilter[])filter.toArray());
            String type = (String)this.getModel().getValue("type");
            if (parent != null && type == null) {
                this.getModel().setValue("type", (Object)parent.getString("type"));
            }
        }
        if ("type".equalsIgnoreCase(e.getProperty().getName())) {
            this.getModel().setValue("parent", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue("parent"))) {
            Long id = ((DynamicObject)this.getModel().getValue("parent")).getLong("id");
            String type = KeySrcBusiness.queryParentType(id);
            this.getModel().setValue("type", (Object)type);
        }
    }
}

