/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class RuleConfigsPlugin
extends AbstractFormPlugin {
    private static final Map<String, Set<String>> dfs = new HashMap<String, Set<String>>(){
        {
            this.put("gl_balance", new HashSet<String>(Arrays.asList("account", "booktype", "period")));
            this.put("gl_voucher", new HashSet<String>(Arrays.asList("account", "booktype", "vouchertype", "period")));
            this.put("entries", new HashSet<String>(Collections.singletonList("account")));
        }
    };
    private static final Map<String, String> field2Entity = new HashMap<String, String>(){
        {
            this.put("booktype", "bd_accountbookstype");
            this.put("account", "bd_accountview");
            this.put("vouchertype", "gl_vouchertype");
            this.put("period", "bd_period");
        }
    };
    private static final Map<String, Set<String>> entity2FilesShow = new HashMap<String, Set<String>>(){
        {
            this.put("bd_accountbookstype", new HashSet<String>(Arrays.asList("number", "name")));
            this.put("bd_accountview", new HashSet<String>(Arrays.asList("number", "name")));
            this.put("gl_vouchertype", new HashSet<String>(Arrays.asList("number", "name")));
            this.put("bd_period", new HashSet<String>(Collections.singletonList("begindate")));
        }
    };
    private static final String MAIN_KEY = "main";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (key.equals("generate")) {
            String main = (String)this.getModel().getValue("name");
            String sub = (String)this.getModel().getValue("subname");
            this.getView().getPageCache().put(MAIN_KEY, main);
            this.createEntry(main, sub, null);
        }
    }

    public void createEntry(String main, String sub, String parentFieldName) {
        boolean flag;
        if (StringUtils.isNotEmpty((CharSequence)main) && !(flag = this.entry(main, sub, parentFieldName))) {
            this.entry(sub, "", parentFieldName);
        }
    }

    public boolean entry(String entryId, String sub, String parentFieldName) {
        if (StringUtils.isEmpty((CharSequence)entryId)) {
            return false;
        }
        Map<String, DynamicObject> map = this.getEntryList();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entryId);
        boolean flag = false;
        Map entityMap = mainEntityType.getAllEntities();
        for (Map.Entry entry : entityMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!flag && key.equals(sub)) {
                flag = true;
            }
            if (!key.equals(entryId) && !key.equals(sub)) continue;
            EntityType entityType = (EntityType)entry.getValue();
            DataEntityPropertyCollection pros = entityType.getProperties();
            for (IDataEntityProperty property : pros) {
                Set<String> fieldsShow = entity2FilesShow.get(key);
                if (null != fieldsShow && !fieldsShow.contains(property.getName())) continue;
                this.setColumnValue(property, map, key, parentFieldName);
            }
        }
        return flag;
    }

    private void setColumnValue(IDataEntityProperty property, Map<String, DynamicObject> map, String key, String parentFieldName) {
        String bizsubname;
        String descrice;
        if (property instanceof EntryProp || null == property.getDisplayName()) {
            return;
        }
        String fieldname = null == parentFieldName ? property.getName() : parentFieldName + "." + property.getName();
        boolean isamount = false;
        if (this.needExpand(key, fieldname)) {
            this.createEntry(field2Entity.get(fieldname), "", fieldname);
            return;
        }
        Class propertyType = property.getPropertyType();
        if (propertyType.isAssignableFrom(BigDecimal.class)) {
            isamount = true;
        }
        if (null != property.getDisplayName()) {
            descrice = property.getDisplayName().getLocaleValue();
            bizsubname = property.getDisplayName().getLocaleValue();
        } else {
            descrice = fieldname;
            bizsubname = fieldname;
        }
        if (null == map.get(this.getkey(key, fieldname))) {
            this.setValue(key, fieldname, descrice, bizsubname, isamount);
        }
    }

    public void setValue(String fieldsubname, String fieldname, String descrice, String bizsubname, Boolean isamount) {
        int index = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("fieldsubname", (Object)fieldsubname, index);
        this.getModel().setValue("fieldname", (Object)fieldname, index);
        this.getModel().setValue("descrice", (Object)descrice, index);
        this.getModel().setValue("bizsubname", (Object)bizsubname, index);
        this.getModel().setValue("state", (Object)"0", index);
        this.getModel().setValue("wherestate", (Object)"0", index);
        this.getModel().setValue("isamount", (Object)isamount, index);
    }

    public Map<String, DynamicObject> getEntryList() {
        DynamicObjectCollection ds = this.getModel().getEntryEntity("entryentity");
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        for (DynamicObject d : ds) {
            map.put(this.getkey(d.getString("fieldsubname"), d.getString("fieldname")), d);
        }
        return map;
    }

    private String getkey(String fieldsubname, String fieldname) {
        return fieldsubname + "_" + fieldname;
    }

    private boolean needExpand(String key, String fieldname) {
        if ("entries".equals(key)) {
            return "gl_voucher".equals(this.getPageCache().get(MAIN_KEY)) && "account".equals(fieldname);
        }
        Set<String> fields = dfs.get(key);
        return null != fields && fields.contains(fieldname);
    }
}

