/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;

public class TableTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String CURRENT_NODE = "current_node";
    private static final String TREE = "treeviewap";
    private static final String BILL_LIST = "billlistap";

    public void initialize() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"cancel", "ok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Boolean istjsjqs = false;
        if (null != map.get("istjsjqs")) {
            istjsjqs = true;
        }
        this.loadTree(istjsjqs);
        Object nodeId = map.get("tableid");
        if (null != map.get("tableid")) {
            TreeView treeView = (TreeView)this.getView().getControl(TREE);
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)nodeId.toString());
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.getPageCache().put(CURRENT_NODE, nodeId);
        this.refreshByClickTreeNode();
    }

    private void loadTree(Boolean istjsjqs) {
        QFilter[] qfilterArr;
        DynamicObjectCollection collection;
        Map map;
        Object orgs;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("group.number", "=", (Object)(istjsjqs == true ? "ds_tjsjqs" : "ds_yscj")));
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tctb_custom_datasource");
        ComboProp d = (ComboProp)mainEntityType.getProperty("type");
        List list = d.getComboItems();
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(list.size());
        TreeNode customNode = null;
        for (ValueMapItem v : list) {
            TreeNode node = new TreeNode();
            node.setId(v.getValue());
            node.setText(v.getName().getLocaleValue_zh_CN());
            node.setParentid("-1");
            if ("0".equals(v.getValue())) {
                customNode = node;
                continue;
            }
            nodeList.add(node);
        }
        if (customNode != null) {
            nodeList.add(customNode);
        }
        if (StringUtils.isNotBlank(orgs = (map = this.getView().getFormShowParameter().getCustomParams()).get("orgs"))) {
            String[] orgArr;
            for (String orgId : orgArr = String.valueOf(orgs).split(",")) {
                qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)"tctb_custom_datasource", (Long)Long.valueOf(orgId)));
            }
        }
        if ((collection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"id,bizname,type", (QFilter[])qFilters.toArray(qfilterArr = new QFilter[qFilters.size()]))) != null && !collection.isEmpty()) {
            TreeView treeView = (TreeView)this.getView().getControl(TREE);
            treeView.deleteAllNodes();
            for (DynamicObject entry : collection) {
                String id = entry.getString("id");
                String name = entry.getString("bizname");
                String parentid = entry.getString("type");
                TreeNode node = new TreeNode();
                node.setId(id);
                node.setText(name);
                node.setParentid(parentid);
                nodeList.add(node);
            }
            TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)this.getPageCache(), (boolean)true);
            TreeUtils.checkFirstNode((IPageCache)this.getPageCache(), (TreeView)treeView);
        }
    }

    private void refreshByClickTreeNode() {
        String nodeId = this.getPageCache().get(CURRENT_NODE);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        billList.clearSelection();
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(nodeId)).and(new QFilter("entryentity.isamount", "=", (Object)"1"));
        billList.setFilter(filter);
        billList.refresh();
        Map map = this.getView().getFormShowParameter().getCustomParams();
        final Object aaa = map.get("fieldid");
        billList.addAfterBindDataListener(new AfterBindDataListener(){

            public void afterBindData(AfterBindDataEvent arg0) {
                BillList b = (BillList)arg0.getSource();
                ListSelectedRowCollection c = b.getCurrentListAllRowCollection();
                for (int i = 0; i < c.size(); ++i) {
                    if (!c.get(i).getEntryPrimaryKeyValue().toString().equals(aaa)) continue;
                    b.selectRows(i);
                }
            }
        });
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("ok".equalsIgnoreCase(key)) {
            this.returnDataToParent();
        } else if ("cancel".equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private void returnDataToParent() {
        String nodeId = this.getPageCache().get(CURRENT_NODE);
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8868", (String)"TableTreePlugin_0", (String)"taxc-tpo", (Object[])new Object[0]), "", MessageTypes.Default);
            return;
        }
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        ListSelectedRowCollection c = billList.getSelectedRows();
        String field = "";
        if (c.size() > 0) {
            field = c.get(0).getEntryPrimaryKeyValue().toString();
        }
        if (StringUtils.isBlank((CharSequence)field)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"TableTreePlugin_1", (String)"taxc-tpo", (Object[])new Object[0]), "", MessageTypes.Default);
            return;
        }
        map.put("tableid", nodeId);
        map.put("fieldid", field);
        this.getView().returnDataToParent(map);
        this.getView().close();
    }
}

