/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin;

import com.google.common.collect.Lists;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.TextColumnDesc;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;

public class TaxRateDateFilterPlugin
extends StandardTreeListPlugin
implements CreateListDataProviderListener {
    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        TreeListModel source = (TreeListModel)e.getSource();
        source.getTreeFilter().add(this.buildTaxRangeFilter());
    }

    public void initialize() {
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    private List<Long> initData() {
        Object taxpayertype = this.getParam("taxpayertype");
        Map<Object, DynamicObject> conditionjson = this.queryConditionJson(taxpayertype);
        List<Long> parentTableIdList = this.getParentTableId(conditionjson);
        return parentTableIdList;
    }

    private Object getParam(String param) {
        Object taxpayertype = null != this.getView().getParentView() && this.getView().getParentView().getControl(param) != null ? this.getView().getParentView().getModel().getValue(param) : this.getView().getFormShowParameter().getCustomParams().get(param);
        return taxpayertype;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(this.buildTaxRangeFilter());
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow"});
    }

    private QFilter buildTaxRangeFilter() {
        Date now = new Date();
        QFilter startdate = new QFilter("startdate", "<=", (Object)now);
        QFilter enddate = new QFilter("enddate", ">=", (Object)now).or(QFilter.isNull((String)"enddate"));
        QFilter taxpayertype = new QFilter("taxpayertype", "=", this.getParam("taxpayertype"));
        QFilter general = new QFilter("general", "=", (Object)"1");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tpo_tcvat_taxrate", (String)"id", (QFilter[])new QFilter[]{startdate, enddate, taxpayertype, general});
        QFilter qFilter = dynamicObject != null ? new QFilter("taxrange", "in", (Object)dynamicObject.getLong("id")) : new QFilter("taxrange", "is null", null);
        return qFilter;
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
        List<Long> parentTableIdList = this.initData();
        QFilter idFilter = new QFilter("taxrange", "in", parentTableIdList);
        if (!CollectionUtils.isEmpty(parentTableIdList)) {
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tpo_tcvat_taxrateentry", (String)"taxmethod,taxrate,mergecode,taxrange", (QFilter[])new QFilter[]{idFilter});
            final Map<String, List<DynamicObject>> mergecodeMap = dynamicObjects.stream().collect(Collectors.groupingBy(a -> a.getString("mergecode")));
            args.setListDataProvider((IListDataProvider)new ListDataProvider(){

                public DynamicObjectCollection getData(int start, int limit) {
                    DynamicObjectCollection collection = super.getData(start, limit);
                    for (DynamicObject object : collection) {
                        List allNeedMergedCollection = (List)mergecodeMap.get(object.getString("mergecode"));
                        if (allNeedMergedCollection == null || allNeedMergedCollection.size() <= 0) continue;
                        List taxRateList = allNeedMergedCollection.stream().map(r -> r.getString("taxrate")).collect(Collectors.toList());
                        taxRateList.add(object.getString("taxrate"));
                        object.set("taxrate", (Object)taxRateList.stream().distinct().collect(Collectors.joining("\u3001")));
                        List taxMethodList = allNeedMergedCollection.stream().map(r -> r.getString("taxmethod")).collect(Collectors.toList());
                        taxMethodList.add(object.getString("taxmethod"));
                        object.set("taxmethod", (Object)taxMethodList.stream().distinct().collect(Collectors.joining("\u3001")));
                    }
                    return collection;
                }
            });
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object taxpayertype = this.getParam("taxpayertype");
        ListView source = (ListView)e.getSource();
        Field field = ReflectionUtils.findField(source.getClass(), (String)"returnToParentData");
        AccessibleObject.setAccessible(new AccessibleObject[]{field}, true);
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)ReflectionUtils.getField((Field)field, (Object)source);
        if (!CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            List ids = listSelectedRows.stream().map(lsr -> Long.parseLong(lsr.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            Map taxrates = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"tpo_tcvat_taxrateentry");
            ArrayList rateList = null;
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            boolean flag5 = false;
            for (Map.Entry entry : taxrates.entrySet()) {
                String taxrate = ((DynamicObject)entry.getValue()).getString("taxrate");
                ArrayList list = Lists.newArrayList((Object[])taxrate.split("\u3001"));
                if (rateList == null) {
                    rateList = list;
                } else {
                    rateList.removeIf(next -> !list.contains(next));
                }
                String number = ((DynamicObject)entry.getValue()).getString("number");
                if (number.startsWith("1")) {
                    flag1 = true;
                    continue;
                }
                if (number.startsWith("2")) {
                    flag2 = true;
                    continue;
                }
                if (number.startsWith("5")) {
                    flag5 = true;
                    continue;
                }
                flag3 = true;
            }
            if (Objects.equals("ybnsr", taxpayertype)) {
                if (flag1 && flag2) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d27\u7269\u7c7b\u548c\u52b3\u52a1\u7c7b\u7a0e\u6536\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5141\u8bb8\u540c\u65f6\u9009\u62e9\uff0c\u8bf7\u5206\u522b\u914d\u7f6e\u89c4\u5219\uff01", (String)"TaxRateDateFilterPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (flag1 && (flag3 || flag5)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d27\u7269\u7c7b\u548c\u9500\u552e\u670d\u52a1\u3001\u65e0\u5f62\u8d44\u4ea7\u3001\u4e0d\u52a8\u4ea7\u7c7b\u7a0e\u6536\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5141\u8bb8\u540c\u65f6\u9009\u62e9\uff0c\u8bf7\u5206\u522b\u914d\u7f6e\u89c4\u5219\uff01", (String)"TaxRateDateFilterPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (flag2 && (flag3 || flag5)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52b3\u52a1\u7c7b\u548c\u9500\u552e\u670d\u52a1\u3001\u65e0\u5f62\u8d44\u4ea7\u3001\u4e0d\u52a8\u4ea7\u7c7b\u7a0e\u6536\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5141\u8bb8\u540c\u65f6\u9009\u62e9\uff0c\u8bf7\u5206\u522b\u914d\u7f6e\u89c4\u5219\uff01", (String)"TaxRateDateFilterPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
            }
            if (Objects.equals("xgmnsr", taxpayertype)) {
                if ((flag1 || flag2) && flag3) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d27\u7269\u7c7b\u3001\u52b3\u52a1\u7c7b\u548c\u9500\u552e\u670d\u52a1\u3001\u65e0\u5f62\u8d44\u4ea7\u3001\u4e0d\u52a8\u4ea7\u7c7b\u7a0e\u6536\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5141\u8bb8\u540c\u65f6\u9009\u62e9\uff0c\u8bf7\u5206\u522b\u914d\u7f6e\u89c4\u5219\uff01", (String)"TaxRateDateFilterPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if ((flag1 || flag2) && flag5) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d27\u7269\u7c7b\u3001\u52b3\u52a1\u7c7b\u548c\u9500\u552e\u4e0d\u52a8\u4ea7\u7c7b\u7a0e\u6536\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5141\u8bb8\u540c\u65f6\u9009\u62e9\uff0c\u8bf7\u5206\u522b\u914d\u7f6e\u89c4\u5219\uff01", (String)"TaxRateDateFilterPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (flag3 && flag5) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9500\u552e\u670d\u52a1\u3001\u65e0\u5f62\u8d44\u4ea7\u548c\u9500\u552e\u4e0d\u52a8\u4ea7\u7c7b\u7a0e\u6536\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5141\u8bb8\u540c\u65f6\u9009\u62e9\uff0c\u8bf7\u5206\u522b\u914d\u7f6e\u89c4\u5219\uff01", (String)"TaxRateDateFilterPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
            }
            if (CollectionUtils.isEmpty(rateList)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u7a0e\u6536\u4e1a\u52a1\u5206\u7c7b\u6ca1\u6709\u76f8\u540c\u7684\u7a0e\u7387, \u8bf7\u91cd\u65b0\u9009\u62e9\uff01", (String)"TaxRateDateFilterPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        Object taxpayertype = this.getParam("taxpayertype");
        if (e.getSource() instanceof TextColumnDesc && ((TextColumnDesc)e.getSource()).getKey().equals("taxmethod")) {
            DynamicObject rowData = e.getRowData();
            String taxmethod = rowData.getString("taxmethod");
            StringBuilder sb = new StringBuilder();
            if ("ybnsr".equals(taxpayertype)) {
                sb.append(ResManager.loadKDString((String)"\u3010\u4e00\u822c\u8ba1\u7a0e\u3011", (String)"TaxRateDateFilterPlugin_7", (String)"taxc-tpo", (Object[])new Object[0]));
            }
            if (taxmethod.contains(ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536", (String)"TaxRateDateFilterPlugin_8", (String)"taxc-tpo", (Object[])new Object[0]))) {
                sb.append(ResManager.loadKDString((String)"\u3010\u63095%\u7b80\u6613\u5f81\u6536\u3011", (String)"TaxRateDateFilterPlugin_9", (String)"taxc-tpo", (Object[])new Object[0]));
            }
            if (taxmethod.contains(ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536", (String)"TaxRateDateFilterPlugin_10", (String)"taxc-tpo", (Object[])new Object[0]))) {
                sb.append(ResManager.loadKDString((String)"\u3010\u63093%\u7b80\u6613\u5f81\u6536\u3011", (String)"TaxRateDateFilterPlugin_11", (String)"taxc-tpo", (Object[])new Object[0]));
            }
            if (taxmethod.contains(ResManager.loadKDString((String)"\u514d\u7a0e", (String)"TaxRateDateFilterPlugin_12", (String)"taxc-tpo", (Object[])new Object[0]))) {
                sb.append(ResManager.loadKDString((String)"\u3010\u514d\u7a0e\u3011", (String)"TaxRateDateFilterPlugin_13", (String)"taxc-tpo", (Object[])new Object[0]));
            }
            e.setFormatValue((Object)sb.toString());
        } else if (e.getSource() instanceof TextColumnDesc && ((TextColumnDesc)e.getSource()).getKey().equals("taxrate")) {
            DynamicObject rowData = e.getRowData();
            String taxmethod = rowData.getString("taxmethod");
            String taxrate = rowData.getString("taxrate");
            String[] split = taxrate.split("\u3001");
            ArrayList<String> rateList = new ArrayList<String>();
            for (String rate : split) {
                if ("16%".equals(rate) || "17%".equals(rate) || "11%".equals(rate)) continue;
                rateList.add(rate);
            }
            if (taxmethod.contains(ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536", (String)"TaxRateDateFilterPlugin_8", (String)"taxc-tpo", (Object[])new Object[0])) && !rateList.contains("5%")) {
                rateList.add("5%");
            }
            if (taxmethod.contains(ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536", (String)"TaxRateDateFilterPlugin_10", (String)"taxc-tpo", (Object[])new Object[0])) && !rateList.contains("3%")) {
                rateList.add("3%");
            }
            e.setFormatValue((Object)String.join((CharSequence)"\u3001", rateList));
        }
    }

    private Map<Object, DynamicObject> queryConditionJson(Object taxpayertype) {
        Date now = new Date();
        QFilter startdate = new QFilter("startdate", "<=", (Object)now);
        QFilter enddate = new QFilter("enddate", ">=", (Object)now).or(QFilter.isNull((String)"enddate"));
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", taxpayertype);
        QFilter general = new QFilter("general", "=", (Object)"0");
        Map conditionjson = BusinessDataServiceHelper.loadFromCache((String)"tpo_tcvat_taxrate", (String)"id,conditionjson", (QFilter[])new QFilter[]{startdate, enddate, taxpayertypeFilter, general});
        return conditionjson;
    }

    private List<Long> getParentTableId(Map<Object, DynamicObject> conditionjson) {
        ArrayList<Long> parentTableIdList = new ArrayList<Long>();
        Object org_id = this.getParam("org_id");
        for (DynamicObject object : conditionjson.values()) {
            String conditionStr = object.get("conditionjson").toString();
            boolean exists = (Boolean)TaxcMainDataServiceHelper.queryTaxcMainByOrgIdAndWhereJson((Long)Long.parseLong(String.valueOf(org_id)), (String)conditionStr).getData();
            if (!exists) continue;
            parentTableIdList.add(object.getLong("id"));
        }
        return parentTableIdList;
    }
}

