/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.tpo.common.utils.EndDateUpdateUtil;

public class TccitBizDefEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String SUB_NUMBER = "subnumber";
    private static final String PROJECT_NAME = "projectname";
    private static final String PARENTID = "parent.number";
    private static final String LEVEL = "level";
    private static final String ISLEAF = "isleaf";
    private static final String LONGNUMBER = "longnumber";
    private static final String FULLNAME = "fullname";
    private static final String TAXATIONSYS = "taxationsys";
    private static final String SUPER_ROOT = "0";
    private static final String TREEENTRYENTITY = "entry_detail";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<String, Map<String, String>> map = this.getTreeMap();
        if (!ObjectUtils.isEmpty(map)) {
            this.updateTreeEntity(map);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey)) {
            EndDateUpdateUtil.doUpdateEndDate(this.getModel().getEntryEntity(TREEENTRYENTITY), "expired");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Map<String, Map<String, String>> map;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && !ObjectUtils.isEmpty(map = this.getTreeMap())) {
            try {
                this.updateTreeEntity(map);
            }
            catch (KDBizException e) {
                args.setCancel(true);
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    private void updateTreeEntity(Map<String, Map<String, String>> map) {
        List<String> noLeafList = this.getNoLeafList(map);
        DynamicObjectCollection treeNotes = this.getModel().getEntryEntity(TREEENTRYENTITY);
        String parentNumber = (String)this.getModel().getValue("number");
        for (DynamicObject treeNote : treeNotes) {
            String subnumber = treeNote.getString(SUB_NUMBER);
            String longnumber = treeNote.getString(LONGNUMBER);
            if (StringUtils.isBlank((CharSequence)longnumber)) {
                treeNote.set(LONGNUMBER, (Object)StringUtils.join((Object[])this.getLongValue(subnumber, map, SUB_NUMBER).toArray(), (String)"."));
                treeNote.set(FULLNAME, (Object)StringUtils.join((Object[])this.getLongValue(subnumber, map, PROJECT_NAME).toArray(), (String)"."));
                treeNote.set(LEVEL, (Object)this.getLevel(subnumber, map));
                treeNote.set(ISLEAF, (Object)(!noLeafList.contains(subnumber) ? 1 : 0));
            }
            treeNote.set("parentnumber", (Object)parentNumber);
        }
    }

    private Map<String, Map<String, String>> getTreeMap() {
        HashMap<String, Map<String, String>> treesMap = new HashMap<String, Map<String, String>>(10);
        DynamicObjectCollection treeNotes = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (DynamicObject treeNote : treeNotes) {
            String subnumber = treeNote.getString(SUB_NUMBER);
            if (treesMap.containsKey(subnumber)) continue;
            HashMap<String, String> node = new HashMap<String, String>();
            node.put(SUB_NUMBER, treeNote.getString(SUB_NUMBER));
            node.put(PROJECT_NAME, treeNote.getString(PROJECT_NAME));
            node.put(LEVEL, treeNote.getString(LEVEL));
            node.put(PARENTID, treeNote.getString(PARENTID));
            treesMap.put(subnumber, node);
        }
        return treesMap;
    }

    private List<String> getLongValue(String subNumber, Map<String, Map<String, String>> treeMap, String type) {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, String> node = treeMap.get(subNumber);
        if (!ObjectUtils.isEmpty(node)) {
            String parentId = node.get(PARENTID);
            if (!ObjectUtils.isEmpty((Object)parentId) || !StringUtils.equalsIgnoreCase((CharSequence)parentId, (CharSequence)SUPER_ROOT)) {
                try {
                    list.addAll(this.getLongValue(parentId, treeMap, type));
                }
                catch (StackOverflowError e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7236\u7ea7ID\u5b58\u5728\u5faa\u73af\u5f15\u7528", (String)"TccitBizDefEdit_0", (String)"taxc-tpo", (Object[])new Object[0]));
                }
            }
            list.add(node.get(type));
        }
        return list;
    }

    private int getLevel(String subNumber, Map<String, Map<String, String>> treeMap) {
        int level = 1;
        Map<String, String> node = treeMap.get(subNumber);
        if (null == node) {
            return level;
        }
        String parentId = node.get(PARENTID);
        if (!ObjectUtils.isEmpty((Object)parentId) && !StringUtils.equalsIgnoreCase((CharSequence)parentId, (CharSequence)SUPER_ROOT)) {
            level += this.getLevel(parentId, treeMap);
        }
        return level;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxationsys = (BasedataEdit)this.getControl(TAXATIONSYS);
        taxationsys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private List<String> getNoLeafList(Map<String, Map<String, String>> map) {
        ArrayList<String> list = new ArrayList<String>();
        map.forEach((key, value) -> {
            if (!StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)value.get(PARENTID)), (CharSequence)SUPER_ROOT)) {
                list.add((String)value.get(PARENTID));
            }
        });
        return list;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        Date currentDate = new Date();
        QFilter nullQ = QFilter.isNull((String)"expdate").and("activedate", "<=", (Object)currentDate);
        QFilter dateQ = new QFilter("expdate", ">=", (Object)currentDate).and(new QFilter("activedate", "<=", (Object)currentDate));
        QFilter notNullQ = QFilter.isNotNull((String)"expdate").and(dateQ);
        QFilter lastDateQ = nullQ.or(notNullQ);
        listShowParameter.getListFilterParameter().setFilter(lastDateQ);
    }
}

