/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TccitItemDateFilterPlugin
extends StandardTreeListPlugin
implements CreateListDataProviderListener {
    private static final List<String> EXCLUDE_NUMBERS = Lists.newArrayList((Object[])new String[]{"1010113", "1010114", "10102", "1020113", "1020114", "10202", "10302", "1040207", "1040208", "1040209", "1040210", "1040211", "1040212", "10402", "2010122", "2010323", "2010506", "2010605", ""});

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String caption = (String)e.getFormShowParameter().getCustomParam("caption");
        if (StringUtil.isNotBlank((CharSequence)caption)) {
            e.getFormShowParameter().setCaption(caption);
        }
    }

    public void afterCreateNewData(EventObject e) {
        TreeListModel model = (TreeListModel)this.getTreeModel();
        model.getQueryParas().put("order", "number asc");
    }

    public void initialize() {
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void setFilter(SetFilterEvent e) {
        List<QFilter> filters = this.getFiltersByType(1);
        e.getQFilters().addAll(filters);
        e.getQFilters().add(new QFilter("number", "not in", EXCLUDE_NUMBERS));
        TreeListModel treeModel = (TreeListModel)this.getTreeModel();
        TreeNode treeNode = treeModel.getRoot();
        this.setTreeNodePro(treeNode);
    }

    private void setTreeNodePro(TreeNode treeNode) {
        List childrens = treeNode.getChildren();
        if (childrens != null && "824589280931283968".equals(treeNode.getId())) {
            TreeNode zyywsr = null;
            TreeNode qtywsr = null;
            LinkedList<TreeNode> newList = new LinkedList<TreeNode>();
            for (TreeNode node : childrens) {
                if ("1129036084823461888".equals(node.getId())) {
                    zyywsr = node;
                    continue;
                }
                if (!"1129039718541956096".equals(node.getId())) continue;
                qtywsr = node;
            }
            for (TreeNode node : childrens) {
                if ("824589593314658304".equals(node.getId())) {
                    newList.add(zyywsr);
                } else if ("824591207098288128".equals(node.getId())) {
                    newList.add(qtywsr);
                }
                if ("1129036084823461888".equals(node.getId()) || "1129039718541956096".equals(node.getId())) continue;
                newList.add(node);
            }
            treeNode.setChildren(newList);
        } else if (childrens != null && "825141121339659264".equals(treeNode.getId())) {
            TreeNode zyywcb = null;
            TreeNode qtywcb = null;
            LinkedList<TreeNode> newList = new LinkedList<TreeNode>();
            for (TreeNode node : childrens) {
                if ("1129520519159263232".equals(node.getId())) {
                    zyywcb = node;
                    continue;
                }
                if (!"1129521845322690560".equals(node.getId())) continue;
                qtywcb = node;
            }
            for (TreeNode node : childrens) {
                if ("825141632197320704".equals(node.getId())) {
                    newList.add(zyywcb);
                } else if ("825143437257990144".equals(node.getId())) {
                    newList.add(qtywcb);
                }
                if ("1129520519159263232".equals(node.getId()) || "1129521845322690560".equals(node.getId())) continue;
                newList.add(node);
            }
            treeNode.setChildren(newList);
        } else if (childrens != null && "825148721108128768".equals(treeNode.getId())) {
            TreeNode yhywsr = null;
            TreeNode lxsr = null;
            TreeNode sxfsr = null;
            TreeNode zqywsr = null;
            TreeNode zqywsxfsr = null;
            TreeNode yzbf = null;
            LinkedList<TreeNode> newList = new LinkedList<TreeNode>();
            for (TreeNode node : childrens) {
                if ("1129530247495070720".equals(node.getId())) {
                    yhywsr = node;
                    continue;
                }
                if ("1129732028019828736".equals(node.getId())) {
                    lxsr = node;
                    continue;
                }
                if ("1129733304187152384".equals(node.getId())) {
                    sxfsr = node;
                    continue;
                }
                if ("1129734057962256384".equals(node.getId())) {
                    zqywsr = node;
                    continue;
                }
                if ("1129734672905988096".equals(node.getId())) {
                    zqywsxfsr = node;
                    continue;
                }
                if (!"1129735514618914816".equals(node.getId())) continue;
                yzbf = node;
            }
            for (TreeNode node : childrens) {
                if ("825149047751958528".equals(node.getId())) {
                    newList.add(yhywsr);
                    newList.add(lxsr);
                } else if ("825150622570504192".equals(node.getId())) {
                    newList.add(sxfsr);
                } else if ("825151884880024576".equals(node.getId())) {
                    newList.add(zqywsr);
                    newList.add(zqywsxfsr);
                } else if ("825153285257289728".equals(node.getId())) {
                    newList.add(yzbf);
                }
                if ("1129530247495070720".equals(node.getId()) || "1129732028019828736".equals(node.getId()) || "1129733304187152384".equals(node.getId()) || "1129734057962256384".equals(node.getId()) || "1129734672905988096".equals(node.getId()) || "1129735514618914816".equals(node.getId())) continue;
                newList.add(node);
            }
            treeNode.setChildren(newList);
        } else if (childrens != null && "825226439455708160".equals(treeNode.getId())) {
            TreeNode yhywzc = null;
            TreeNode yhlxzc = null;
            TreeNode yhsxfzc = null;
            TreeNode bxywzc = null;
            TreeNode zqywzc = null;
            TreeNode zqywsxfzc = null;
            LinkedList<TreeNode> newList = new LinkedList<TreeNode>();
            for (TreeNode node : childrens) {
                if ("1130234390866052096".equals(node.getId())) {
                    yhywzc = node;
                    continue;
                }
                if ("1130234782681153536".equals(node.getId())) {
                    yhlxzc = node;
                    continue;
                }
                if ("1130235179487477760".equals(node.getId())) {
                    yhsxfzc = node;
                    continue;
                }
                if ("1130235509403042816".equals(node.getId())) {
                    bxywzc = node;
                    continue;
                }
                if ("1130235771085668352".equals(node.getId())) {
                    zqywzc = node;
                    continue;
                }
                if (!"1130236003022291968".equals(node.getId())) continue;
                zqywsxfzc = node;
            }
            for (TreeNode node : childrens) {
                if ("825226630237642752".equals(node.getId())) {
                    newList.add(yhywzc);
                    newList.add(yhlxzc);
                } else if ("825227812352070656".equals(node.getId())) {
                    newList.add(yhsxfzc);
                } else if ("825228643017023488".equals(node.getId())) {
                    newList.add(bxywzc);
                } else if ("825230282100872192".equals(node.getId())) {
                    newList.add(zqywzc);
                    newList.add(zqywsxfzc);
                }
                if ("1130234390866052096".equals(node.getId()) || "1130234782681153536".equals(node.getId()) || "1130235179487477760".equals(node.getId()) || "1130235509403042816".equals(node.getId()) || "1130235771085668352".equals(node.getId()) || "1130236003022291968".equals(node.getId())) continue;
                newList.add(node);
            }
            treeNode.setChildren(newList);
        } else if (childrens != null && "825278216108545024".equals(treeNode.getParentid())) {
            List newList = childrens.stream().sorted(Comparator.comparing(TreeNode::getLongNumber)).collect(Collectors.toList());
            treeNode.setChildren(newList);
        } else if (childrens != null && childrens.size() > 0) {
            for (TreeNode node : childrens) {
                this.setTreeNodePro(node);
            }
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow"});
        List<QFilter> filters = this.getFiltersByType(2);
        TreeListModel source = (TreeListModel)e.getSource();
        source.getTreeFilter().addAll(filters);
    }

    private List<QFilter> getFiltersByType(Integer num) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object type = customParams.get("type");
        Object costtype = customParams.get("costtype");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (type != null) {
            Object suzclbNumber;
            QFilter filter = new QFilter("type", "=", type);
            filters.add(filter);
            Object ptNumbers = customParams.get("ptNumbers");
            if (ptNumbers != null) {
                List ptNumbersList = (List)ptNumbers;
                ptNumbersList.add("70102");
                Object isSpeed = customParams.get("isSpeed");
                if (num == 2 && isSpeed == null) {
                    ptNumbersList.add("7010201");
                    ptNumbersList.add("7010202");
                    ptNumbersList.add("7010203");
                    ptNumbersList.add("7010204");
                    ptNumbersList.add("7010205");
                } else if (num == 2 && isSpeed != null) {
                    ptNumbersList.add("7010206");
                }
                QFilter filterNumbers = new QFilter("number", "in", (Object)ptNumbersList);
                filters.add(filterNumbers);
            }
            if ((suzclbNumber = customParams.get("suzclbNumber")) != null) {
                List suzclbNumberList = (List)suzclbNumber;
                suzclbNumberList.add("70102");
                if (num == 2) {
                    suzclbNumberList.add("7010201");
                    suzclbNumberList.add("7010202");
                    suzclbNumberList.add("7010203");
                    suzclbNumberList.add("7010204");
                    suzclbNumberList.add("7010205");
                }
                QFilter filterNumbers2 = new QFilter("number", "in", (Object)suzclbNumberList);
                filters.add(filterNumbers2);
            }
            if ("period".equals(costtype)) {
                filters.add(new QFilter("costcollect", "=", costtype));
            }
        }
        return filters;
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                Map customParams = TccitItemDateFilterPlugin.this.getView().getFormShowParameter().getCustomParams();
                Object orgid = customParams.get("orgid");
                DynamicObjectCollection data = super.getData(start, limit);
                data.removeIf(d -> {
                    String filter = d.getString("filter");
                    if (StringUtil.isNotBlank((CharSequence)filter)) {
                        return (Boolean)TaxcMainDataServiceHelper.queryTaxcMainByOrgIdAndWhereJson((Long)Long.parseLong(String.valueOf(orgid)), (String)filter).getData() == false;
                    }
                    return false;
                });
                return data;
            }
        });
    }
}

