/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TysbsfBizDefEdit
extends AbstractBasePlugIn {
    private void getParentProjectnameMap(Map<String, List<Map<String, String>>> collectrateMap, String number, String projectname, Date validfrom, Date expired) {
        HashMap<String, String> dateMap = new HashMap<String, String>();
        dateMap.put("validfrom", DateUtils.format((Date)validfrom));
        dateMap.put("expired", DateUtils.format((Date)expired));
        if (Objects.isNull(collectrateMap.get(number + projectname))) {
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(dateMap);
            collectrateMap.put(number + projectname, list);
        } else {
            List<Map<String, String>> numberList = collectrateMap.get(number + projectname);
            numberList.add(dateMap);
        }
    }

    private boolean match(String projectStartTime1, String projectEndTime1, String projectStartTime2, String projectEndTime2) {
        LocalDate startTime1 = this.formatDate(projectStartTime1);
        LocalDate endTime1 = this.formatDate(projectEndTime1);
        LocalDate startTime2 = this.formatDate(projectStartTime2);
        LocalDate endTime2 = this.formatDate(projectEndTime2);
        if (Objects.isNull(startTime1) || Objects.isNull(startTime2)) {
            return Boolean.FALSE;
        }
        if (Objects.isNull(endTime1) && Objects.isNull(endTime2)) {
            return Boolean.TRUE;
        }
        if (Objects.isNull(endTime1) && Objects.nonNull(endTime2) && Objects.nonNull(startTime1)) {
            return endTime2.isAfter(startTime1);
        }
        if (Objects.nonNull(endTime1) && Objects.isNull(endTime2) && Objects.nonNull(startTime2)) {
            return !startTime2.isAfter(endTime1);
        }
        return !startTime2.isAfter(endTime1) && !startTime1.isAfter(endTime2);
    }

    private LocalDate formatDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        return LocalDate.parse(date);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && (entryEntity = this.getModel().getEntryEntity("entry_detail")) != null && entryEntity.size() > 0) {
            entryEntity = entryEntity.stream().filter(s -> s.getDynamicObject("parent") != null).collect(Collectors.toCollection(DynamicObjectCollection::new));
            HashMap<String, List<Map<String, String>>> parentprojectnamemap = new HashMap<String, List<Map<String, String>>>();
            for (DynamicObject dynamicObject : entryEntity) {
                DynamicObject parent = dynamicObject.getDynamicObject("parent");
                String number = (String)parent.get("number");
                String projectname = dynamicObject.getString("projectname");
                Date validfrom = dynamicObject.getDate("validfrom");
                Date expired = dynamicObject.getDate("expired");
                this.getParentProjectnameMap(parentprojectnamemap, number, projectname, validfrom, expired);
            }
            for (Map.Entry entryMap : parentprojectnamemap.entrySet()) {
                List list = (List)entryMap.getValue();
                if (list.size() <= 1) continue;
                for (int i = 0; i < list.size(); ++i) {
                    String validfrom = (String)((Map)list.get(i)).get("validfrom");
                    String expired = (String)((Map)list.get(i)).get("expired");
                    for (int j = 0; j < list.size(); ++j) {
                        String expired2;
                        String validfrom2;
                        boolean flag;
                        if (i == j || !(flag = this.match(validfrom, expired, validfrom2 = (String)((Map)list.get(j)).get("validfrom"), expired2 = (String)((Map)list.get(j)).get("expired")))) continue;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6709\u4e24\u4e2a\u6216\u4ee5\u4e0a\u76f8\u540c\u5f81\u6536\u54c1\u76ee\u5b58\u5728\u4e8e\u540c\u4e00\u6709\u6548\u671f\u8d77\u6b62\u8303\u56f4", (String)"TysbsfBizDefEdit_1", (String)"taxc-tpo", (Object[])new Object[0]), new Object[0]));
                        args.setCancel(true);
                    }
                }
            }
        }
    }
}

