/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.assetlossmapping;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.taxc.tpo.common.utils.EndDateUpdateUtil;

public class AssetlossMappingEdit
extends AbstractBillPlugIn {
    private static final String NUMBER = "pnumber";
    private static final String NAME = "pname";
    private static final String PARENTID = "pid";
    private static final String LEVEL = "level";
    private static final String ISLEAF = "isleaf";
    private static final String LONGNUMBER = "longnumber";
    private static final String FULLNAME = "fullname";
    private static final String SUPER_ROOT = "0";
    private static final String TREEENTRYENTITY = "treeentryentity";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY);
        grid.setCollapse(false);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Date enddate;
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey) && EndDateUpdateUtil.needUpdate(enddate = (Date)this.getModel().getValue("enddate"))) {
            this.getModel().setValue("enddate", (Object)EndDateUpdateUtil.calEndDate(enddate));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Map<String, Map<String, String>> map;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && !ObjectUtils.isEmpty(map = this.getTreeMap())) {
            this.updateTreeEntity(map);
        }
    }

    private void updateTreeEntity(Map<String, Map<String, String>> map) {
        List<String> noLeafList = this.getNoLeafList(map);
        DynamicObjectCollection treeNotes = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (DynamicObject treeNote : treeNotes) {
            String id = treeNote.getString("id");
            treeNote.set(LONGNUMBER, (Object)StringUtils.join((Object[])this.getLongValue(id, map, NUMBER).toArray(), (String)"."));
            treeNote.set(FULLNAME, (Object)StringUtils.join((Object[])this.getLongValue(id, map, NAME).toArray(), (String)"."));
            treeNote.set(LEVEL, (Object)this.getLevel(id, map));
            treeNote.set(ISLEAF, (Object)(!noLeafList.contains(id) ? 1 : 0));
        }
    }

    private Map<String, Map<String, String>> getTreeMap() {
        HashMap<String, Map<String, String>> treesMap = new HashMap<String, Map<String, String>>(10);
        DynamicObjectCollection treeNotes = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (DynamicObject treeNote : treeNotes) {
            String id = treeNote.getString("id");
            if (treesMap.containsKey(id)) continue;
            HashMap<String, String> node = new HashMap<String, String>();
            node.put(NUMBER, treeNote.getString(NUMBER));
            node.put(NAME, treeNote.getString(NAME));
            node.put(LEVEL, treeNote.getString(LEVEL));
            node.put(PARENTID, treeNote.getString(PARENTID));
            treesMap.put(id, node);
        }
        return treesMap;
    }

    private List getLongValue(String id, Map<String, Map<String, String>> treeMap, String type) {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, String> node = treeMap.get(id);
        if (!ObjectUtils.isEmpty(node)) {
            String parentId = node.get(PARENTID);
            if (!ObjectUtils.isEmpty((Object)parentId) || !StringUtils.equalsIgnoreCase((CharSequence)parentId, (CharSequence)SUPER_ROOT)) {
                list.addAll(this.getLongValue(parentId, treeMap, type));
            }
            list.add(node.get(type));
        }
        return list;
    }

    private int getLevel(String id, Map<String, Map<String, String>> treeMap) {
        int level = 1;
        Map<String, String> node = treeMap.get(id);
        String parentId = node.get(PARENTID);
        if (!ObjectUtils.isEmpty((Object)parentId) && !StringUtils.equalsIgnoreCase((CharSequence)parentId, (CharSequence)SUPER_ROOT)) {
            level += this.getLevel(parentId, treeMap);
        }
        return level;
    }

    private List<String> getNoLeafList(Map<String, Map<String, String>> map) {
        ArrayList<String> list = new ArrayList<String>();
        map.forEach((key, value) -> {
            if (!StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)value.get(PARENTID)), (CharSequence)SUPER_ROOT)) {
                list.add((String)value.get(PARENTID));
            }
        });
        return list;
    }
}

