/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.bbbs.zdsy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class ZdsyDefEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String SUB_NUMBER = "subnumber";
    private static final String PROJECT_NAME = "projectname";
    private static final String PARENTID = "parent.number";
    private static final String LEVEL = "level";
    private static final String ISLEAF = "isleaf";
    private static final String LONGNUMBER = "longnumber";
    private static final String FULLNAME = "fullname";
    private static final String TPO_ZDSY_BIZDEF = "tpo_zdsy_bizdef";
    private static final String TPO_ZDSY_BIZDEFEN_TREE = "tpo_zdsy_bizdefen_tree";
    private static final String SUPER_ROOT = "0";
    private static final String TREEENTRYENTITY = "entry_detail";

    public void initialize() {
        BasedataEdit parentid = (BasedataEdit)this.getView().getControl("parent");
        parentid.addBeforeF7SelectListener(this::beforeF7Select);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<String, Map<String, String>> map = this.getTreeMap();
        if (!ObjectUtils.isEmpty(map)) {
            this.updateTreeEntity(map);
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            Map<String, Map<String, String>> map = this.getTreeMap();
            if (!ObjectUtils.isEmpty(map)) {
                try {
                    this.updateTreeEntity(map);
                }
                catch (KDBizException e) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(e.getMessage());
                }
            }
        } else if (args.getSource() instanceof DeleteEntry) {
            args.setCancel(true);
            int[] selectRows = ((EntryGrid)this.getControl(TREEENTRYENTITY)).getSelectRows();
            DynamicObjectCollection colls = this.getModel().getEntryEntity(TREEENTRYENTITY);
            ArrayList<Long> sids = new ArrayList<Long>();
            for (int selectRow : selectRows) {
                if (this.getModel().getEntryRowEntity(TREEENTRYENTITY, selectRow) == null) continue;
                DynamicObject entry_detail = this.getModel().getEntryRowEntity(TREEENTRYENTITY, selectRow);
                sids.add(entry_detail.getLong("id"));
            }
            HashSet<Long> refids = new HashSet<Long>();
            for (DynamicObject dynamicObject : colls) {
                if (dynamicObject.get("id") == null || dynamicObject.getLong("id") != 0L || dynamicObject.get("parent") == null) continue;
                refids.add(dynamicObject.getLong("parent.id"));
            }
            if (!refids.contains(sids.get(0))) {
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)TPO_ZDSY_BIZDEFEN_TREE, (String)"id,number,name,enable,parent,isleaf,longnumber,fullname", (QFilter[])new QFilter[]{new QFilter("id", "in", sids)});
                OperationResult delete = OperationServiceHelper.executeOperate((String)"delete", (String)TPO_ZDSY_BIZDEFEN_TREE, (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
                if (delete.isSuccess()) {
                    this.getModel().deleteEntryRow(TREEENTRYENTITY, selectRows[0]);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"ZdsyDefEdit_0", (String)"taxc-tpo", (Object[])new Object[0]));
                } else {
                    ValidateResultCollection validateResult = delete.getValidateResult();
                    List validateErrors = validateResult.getValidateErrors();
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\uff0c\u5220\u9664\u5931\u8d25", (String)"ZdsyDefEdit_1", (String)"taxc-tpo", (Object[])new Object[0]));
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\uff0c\u5220\u9664\u5931\u8d25", (String)"ZdsyDefEdit_1", (String)"taxc-tpo", (Object[])new Object[0]));
            }
        }
    }

    private void updateTreeEntity(Map<String, Map<String, String>> map) {
        List<String> noLeafList = this.getNoLeafList(map);
        DynamicObjectCollection treeNotes = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (DynamicObject treeNote : treeNotes) {
            String subnumber = treeNote.getString(SUB_NUMBER);
            String longnumber = treeNote.getString(LONGNUMBER);
            if (!StringUtils.isBlank((CharSequence)longnumber)) continue;
            treeNote.set(LONGNUMBER, (Object)StringUtils.join((Object[])this.getLongValue(subnumber, map, SUB_NUMBER).toArray(), (String)"."));
            treeNote.set(FULLNAME, (Object)StringUtils.join((Object[])this.getLongValue(subnumber, map, PROJECT_NAME).toArray(), (String)"."));
            treeNote.set(LEVEL, (Object)this.getLevel(subnumber, map));
            treeNote.set(ISLEAF, (Object)(!noLeafList.contains(subnumber) ? 1 : 0));
        }
    }

    private Map<String, Map<String, String>> getTreeMap() {
        HashMap<String, Map<String, String>> treesMap = new HashMap<String, Map<String, String>>(10);
        DynamicObjectCollection treeNotes = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (DynamicObject treeNote : treeNotes) {
            String subnumber = treeNote.getString(SUB_NUMBER);
            if (treesMap.containsKey(subnumber)) continue;
            HashMap<String, String> node = new HashMap<String, String>();
            node.put(SUB_NUMBER, treeNote.getString(SUB_NUMBER));
            node.put(PROJECT_NAME, treeNote.getString(PROJECT_NAME));
            node.put(LEVEL, treeNote.getString(LEVEL));
            node.put(PARENTID, treeNote.getString(PARENTID));
            treesMap.put(subnumber, node);
        }
        return treesMap;
    }

    private List<String> getLongValue(String subNumber, Map<String, Map<String, String>> treeMap, String type) {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, String> node = treeMap.get(subNumber);
        if (!ObjectUtils.isEmpty(node)) {
            String parentId = node.get(PARENTID);
            if (!ObjectUtils.isEmpty((Object)parentId) || !StringUtils.equalsIgnoreCase((CharSequence)parentId, (CharSequence)SUPER_ROOT)) {
                try {
                    list.addAll(this.getLongValue(parentId, treeMap, type));
                }
                catch (StackOverflowError e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7236\u7ea7ID\u5b58\u5728\u5faa\u73af\u5f15\u7528", (String)"ZdsyDefEdit_2", (String)"taxc-tpo", (Object[])new Object[0]));
                }
            }
            list.add(node.get(type));
        }
        return list;
    }

    private int getLevel(String subNumber, Map<String, Map<String, String>> treeMap) {
        int level = 1;
        Map<String, String> node = treeMap.get(subNumber);
        if (null == node) {
            return level;
        }
        String parentId = node.get(PARENTID);
        if (!ObjectUtils.isEmpty((Object)parentId) && !StringUtils.equalsIgnoreCase((CharSequence)parentId, (CharSequence)SUPER_ROOT)) {
            level += this.getLevel(parentId, treeMap);
        }
        return level;
    }

    private List<String> getNoLeafList(Map<String, Map<String, String>> map) {
        ArrayList<String> list = new ArrayList<String>();
        map.forEach((key, value) -> {
            if (!StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)value.get(PARENTID)), (CharSequence)SUPER_ROOT)) {
                list.add((String)value.get(PARENTID));
            }
        });
        return list;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("parent".equalsIgnoreCase(name)) {
            long id = this.getModel().getDataEntity().getLong("id");
            QFilter filter = null;
            if (id != 0L) {
                DynamicObject bizdef = BusinessDataServiceHelper.loadSingle((String)TPO_ZDSY_BIZDEF, (String)"id,entry_detail", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                if (!ObjectUtils.isEmpty((Object)bizdef)) {
                    DynamicObjectCollection entry_details = bizdef.getDynamicObjectCollection(TREEENTRYENTITY);
                    List ids = entry_details.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                    filter = new QFilter("id", "in", ids);
                    BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
                    String longnumber = basedataEdit.getModel().getValue(LONGNUMBER).toString();
                    if (StringUtils.isNotBlank((CharSequence)longnumber)) {
                        StringBuilder longnumbersb = new StringBuilder(longnumber).append("%");
                        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)TPO_ZDSY_BIZDEFEN_TREE, (String)"id,number", (QFilter[])new QFilter[]{new QFilter(LONGNUMBER, "like", (Object)longnumbersb).and("id", "in", ids)});
                        List numbers = Arrays.stream(dynamicObjects).map(o -> o.getString("number")).collect(Collectors.toList());
                        filter.and("number", "not in", numbers);
                    }
                }
            } else {
                filter = new QFilter("id", "=", (Object)-1L);
            }
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(filter);
            listShowParameter.getTreeFilterParameter().getQFilters().add(filter);
        }
    }
}

