/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.depreciation;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxarea.TaxcAreaDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bd.taxationsys.TaxAtionsysDataServiceHelper;

public class TaxDepreciationPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String NUM_TAXAREA_CHINA = "001";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxarea = (BasedataEdit)this.getControl("taxarea");
        taxarea.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Optional<DynamicObject> taxarea;
        TaxResult taxationsysTaxResult = TaxAtionsysDataServiceHelper.querySingleTaxAtionsysByNum((String)NUM_TAXAREA_CHINA);
        TaxResult taxareaTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaAvailable();
        if (taxationsysTaxResult != null && taxationsysTaxResult.getData() != null) {
            this.getModel().setValue("taxationsys", (Object)new Long[]{((DynamicObject)taxationsysTaxResult.getData()).getLong("id")});
        }
        if (taxareaTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)taxareaTaxResult.getData())) && (taxarea = ((List)taxareaTaxResult.getData()).stream().filter(a -> NUM_TAXAREA_CHINA.equals(a.getString("group.number"))).findFirst()).isPresent()) {
            this.getModel().setValue("taxarea", (Object)new Long[]{taxarea.get().getLong("group.id")});
        }
    }

    public void afterBindData(EventObject e) {
        String isSystem = (String)this.getModel().getValue("issystem");
        if ("1".equals(isSystem)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name", "taxationsys", "taxarea", "depreciationformula"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObjectCollection taxationsys = (DynamicObjectCollection)this.getModel().getValue("taxationsys");
        List taxationsysCountryIds = taxationsys.stream().map(a -> a.getDynamicObject("fbasedataid").getLong("countryid.id")).collect(Collectors.toList());
        if ("taxarea".equals(name)) {
            if (taxationsys.size() > 0) {
                List areaGroupIds;
                TaxResult taxareaTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaAvailable();
                if (taxareaTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)taxareaTaxResult.getData())) && !CollectionUtils.isEmpty(areaGroupIds = ((List)taxareaTaxResult.getData()).stream().filter(o -> taxationsysCountryIds.contains(o.getLong("country.id"))).map(o -> o.getLong("group.id")).collect(Collectors.toList()))) {
                    QFilter idQfilter = new QFilter("id", "in", areaGroupIds);
                    listShowParameter.getListFilterParameter().setFilter(idQfilter);
                }
            } else {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"TaxDepreciationPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        DynamicObjectCollection taxationsys;
        String name = args.getProperty().getName();
        if ("taxationsys".equals(name) && (taxationsys = (DynamicObjectCollection)this.getModel().getValue("taxationsys")).size() == 0) {
            this.getModel().setValue("taxarea", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        String operateKey = ((AbstractOperate)source).getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObjectCollection taxationsys = (DynamicObjectCollection)this.getModel().getValue("taxationsys");
            List taxationsysIds = taxationsys.stream().map(a -> a.getLong("fbasedataid.id")).collect(Collectors.toList());
            List taxationsysCountryIds = taxationsys.stream().map(a -> a.getDynamicObject("fbasedataid").getLong("countryid.id")).collect(Collectors.toList());
            TaxResult taxationsysTaxResult = TaxAtionsysDataServiceHelper.queryTaxAtionsysByIds(taxationsysIds);
            if (taxationsysTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)taxationsysTaxResult.getData()))) {
                List availables = ((List)taxationsysTaxResult.getData()).stream().map(o -> o.getString("enable")).collect(Collectors.toList());
                if (taxationsysIds.size() != availables.size()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u7981\u7528\u7684\u7a0e\u6536\u5236\u5ea6\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxDepreciationPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u7981\u7528\u7684\u7a0e\u6536\u5236\u5ea6\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxDepreciationPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection taxarea = (DynamicObjectCollection)this.getModel().getValue("taxarea");
            List taxareaIds = taxarea.stream().map(a -> a.getLong("fbasedataid.id")).collect(Collectors.toList());
            TaxResult taxareaTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaAvailable();
            if (taxareaTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)taxareaTaxResult.getData()))) {
                List areaAvailableGroupIds = ((List)taxareaTaxResult.getData()).stream().map(o -> o.getLong("group.id")).collect(Collectors.toList());
                if (taxarea.size() > 0 && !areaAvailableGroupIds.containsAll(taxareaIds)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u7981\u7528\u7684\u7a0e\u6536\u8f96\u533a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxDepreciationPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                List areaGroupIds = ((List)taxareaTaxResult.getData()).stream().filter(o -> taxationsysCountryIds.contains(o.getLong("country.id"))).map(o -> o.getLong("group.id")).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(areaGroupIds) && !areaGroupIds.containsAll(taxareaIds)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0e\u7a0e\u6536\u8f96\u533a\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxDepreciationPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u7981\u7528\u7684\u7a0e\u6536\u8f96\u533a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxDepreciationPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }
}

