/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.depreciation;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxarea.TaxcAreaDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bd.taxationsys.TaxAtionsysDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tpo.business.depreciation.TaxDepreciationServiceHelper;

public class TaxDepreciationPolicyPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String NUM_TAXAREA_CHINESEMAINLAND = "CHN";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxarea = (BasedataEdit)this.getControl("taxarea");
        taxarea.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Optional<DynamicObject> taxarea;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object depreciationtype = customParams.get("depreciationtype");
        if (null == depreciationtype) {
            this.getModel().setValue("depreciationtype", (Object)"ybzj");
        } else {
            this.getModel().setValue("depreciationtype", depreciationtype);
        }
        TaxResult taxationsysTaxResult = TaxAtionsysDataServiceHelper.querySingleTaxAtionsysByNum((String)"001");
        TaxResult taxareaTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaAvailable();
        if (taxationsysTaxResult != null && taxationsysTaxResult.getData() != null) {
            this.getModel().setValue("taxationsys", (Object)((DynamicObject)taxationsysTaxResult.getData()).getLong("id"));
        }
        if (taxareaTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)taxareaTaxResult.getData())) && (taxarea = ((List)taxareaTaxResult.getData()).stream().filter(a -> NUM_TAXAREA_CHINESEMAINLAND.equals(a.getString("group.number"))).findFirst()).isPresent()) {
            this.getModel().setValue("taxarea", (Object)taxarea.get().getLong("group.id"));
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"depreciationclass"});
        String isSystem = (String)this.getModel().getValue("issystem");
        if ("1".equals(isSystem)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name", "taxationsys", "taxarea", "entryentity", "advconbaritemap", "advconbaritemap1"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
        if ("taxarea".equals(name)) {
            if (taxationsys != null) {
                List areaGroupIds;
                TaxResult listTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaByCountryId((Long)taxationsys.getLong("countryid.id"));
                if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData())) && !CollectionUtils.isEmpty(areaGroupIds = ((List)listTaxResult.getData()).stream().map(o -> o.getLong("group.id")).collect(Collectors.toList()))) {
                    QFilter idQfilter = new QFilter("id", "in", areaGroupIds);
                    listShowParameter.getListFilterParameter().setFilter(idQfilter);
                }
            } else {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"TaxDepreciationPolicyPlugin_11", (String)"taxc-tpo", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject taxationsys;
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        if ("startdate".equals(name) || "enddate".equals(name)) {
            int rowIndex = changeData.getRowIndex();
            Date startdate = (Date)this.getModel().getValue("startdate", rowIndex);
            Date enddate = (Date)this.getModel().getValue("enddate", rowIndex);
            this.checkDate(startdate, enddate);
        }
        if ("taxationsys".equals(name) && (taxationsys = (DynamicObject)this.getModel().getValue("taxationsys")) == null) {
            this.getModel().setValue("taxarea", null);
        }
    }

    private boolean checkDate(Date skssqq, Date skssqz) {
        if (skssqq == null) {
            return false;
        }
        int dayOfDate = DateUtils.getDayOfDate((Date)skssqq);
        if (dayOfDate != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u5fc5\u987b\u662f\u6708\u521d\u3002", (String)"TaxDepreciationPolicyPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]));
            return false;
        }
        if (skssqz != null) {
            int dayOfDate2;
            int dayOfDate1 = DateUtils.getDayOfDate((Date)DateUtils.getLastDateOfMonth((Date)skssqz));
            if (dayOfDate1 != (dayOfDate2 = DateUtils.getDayOfDate((Date)skssqz))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u5fc5\u987b\u662f\u6708\u672b\u3002", (String)"TaxDepreciationPolicyPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]));
                return false;
            }
            if (skssqq.after(skssqz)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u671f\u6b62\u3002", (String)"TaxDepreciationPolicyPlugin_7", (String)"taxc-tpo", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object depreciationtype = customParams.get("depreciationtype");
        if (args.getSource() instanceof Save) {
            TaxResult listTaxResult;
            DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
            DynamicObject taxarea = (DynamicObject)this.getModel().getValue("taxarea");
            TaxResult taxareaTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaAvailable();
            if (taxareaTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)taxareaTaxResult.getData()))) {
                List areaAvailableGroupIds = ((List)taxareaTaxResult.getData()).stream().map(o -> o.getLong("group.id")).collect(Collectors.toList());
                if (taxarea != null && !areaAvailableGroupIds.contains(taxarea.getLong("id"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7a0e\u6536\u8f96\u533a\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxDepreciationPolicyPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7a0e\u6536\u8f96\u533a\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxDepreciationPolicyPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (taxationsys != null && (listTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaByCountryId((Long)taxationsys.getLong("countryid.id"))) != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
                List areaGroupIds = ((List)listTaxResult.getData()).stream().map(o -> o.getLong("group.id")).collect(Collectors.toList());
                if (taxarea != null && !areaGroupIds.contains(taxarea.getLong("id"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0e\u7a0e\u6536\u8f96\u533a\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxDepreciationPolicyPlugin_12", (String)"taxc-tpo", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            for (Object entity : entryentity) {
                Date date;
                Date startdate = (Date)this.getModel().getValue("startdate", entity.getInt("seq") - 1);
                if (this.checkDate(startdate, date = (Date)this.getModel().getValue("enddate", entity.getInt("seq") - 1))) continue;
                args.setCancel(true);
                return;
            }
            String type = "";
            if (depreciationtype != null) {
                if ("ybzj".equals(depreciationtype)) {
                    type = ResManager.loadKDString((String)"\u7a0e\u52a1\u8d44\u4ea7\u7c7b\u522b", (String)"TaxDepreciationPolicyPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]);
                } else if ("jszj".equals(depreciationtype)) {
                    type = ResManager.loadKDString((String)"\u52a0\u901f\u6298\u65e7\u7c7b\u522b", (String)"TaxDepreciationPolicyPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]);
                }
            }
            if (entryentity.size() > 1) {
                Map<String, List<DynamicObject>> entryentityGroupByClassNumber = entryentity.stream().collect(Collectors.groupingBy(p -> p.getString("classnumber")));
                for (Map.Entry entry : entryentityGroupByClassNumber.entrySet()) {
                    Map<String, List<DynamicObject>> entryentityGroupByClass;
                    if (((List)entry.getValue()).size() > 1 && (entryentityGroupByClass = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(p -> p.getString("class")))).size() > 1) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5%1$s\u7f16\u7801\u4e0b\u5b58\u5728\u540d\u79f0\u4e0d\u540c\u7684%2$s\uff0c\u8bf7\u6838\u5bf9\u4fe1\u606f\u3002", (String)"TaxDepreciationPolicyPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]), type, type));
                        args.setCancel(true);
                        return;
                    }
                    if (this.checkDate((List)entry.getValue())) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5%s\u5728\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u6298\u65e7\u653f\u7b56\uff0c\u8bf7\u6838\u5bf9\u4fe1\u606f\u3002", (String)"TaxDepreciationPolicyPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]), type));
                    args.setCancel(true);
                    return;
                }
            }
            if (taxationsys != null && taxarea != null) {
                String number;
                Object entity;
                entity = this.getModel().getDataEntityType().getName();
                boolean bl = TaxDepreciationServiceHelper.isExistDepreciation((String)entity, number = (String)this.getModel().getValue("number"), taxationsys.getLong("id"), taxarea.getLong("id"), depreciationtype);
                if (bl) {
                    this.getModel().setValue("enable", (Object)"0");
                } else {
                    this.getModel().setValue("enable", (Object)"1");
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String enable;
        FormOperate operate = (FormOperate)evt.getSource();
        String key = evt.getOperateKey();
        if ("save".equals(key) && evt.getOperationResult().isSuccess() && "0".equals(enable = (String)this.getModel().getValue("enable"))) {
            operate.getOption().setVariableValue("isshowmessage", "fasle");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff0c\u4f46\u76f8\u540c\u7a0e\u5236\u548c\u8f96\u533a\u5df2\u5b58\u5728\u53ef\u7528\u7684\u52a0\u901f\u6298\u65e7\u653f\u7b56\uff0c\u6682\u5b58\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"TaxDepreciationPolicyPlugin_10", (String)"taxc-tpo", (Object[])new Object[0]));
        }
    }

    private boolean checkDate(List<DynamicObject> list) {
        if (list.size() > 1) {
            for (int i = 0; i < list.size(); ++i) {
                Date startdate = list.get(i).getDate("startdate");
                Date enddate = list.get(i).getDate("enddate");
                for (int j = 0; j < list.size(); ++j) {
                    Date enddate2;
                    Date startdate2;
                    boolean flag;
                    if (i == j || (flag = DateUtils.checkTimeRepeat((Date)startdate, (Date)enddate, (Date)(startdate2 = list.get(j).getDate("startdate")), (Date)(enddate2 = list.get(j).getDate("enddate"))))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

