/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.ictm;

import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class IctmBizDefEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String PARENT = "parent";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit parentBasedata = (BasedataEdit)this.getView().getControl(PARENT);
        parentBasedata.addBeforeF7SelectListener(this::beforeF7Select);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (PARENT.equalsIgnoreCase(name)) {
            QFilter filter;
            long id = this.getModel().getDataEntity().getLong("id");
            if (id != 0L) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                String subNumber = (String)this.getModel().getValue("subnumber", rowIndex);
                filter = new QFilter("bizdef", "=", (Object)id).and(new QFilter("number", "!=", (Object)subNumber));
            } else {
                filter = new QFilter("id", "=", (Object)-1L);
            }
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
            formShowParameter.setMultiSelect(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof DeleteEntry) {
            OperationResult delete;
            args.setCancel(true);
            int[] selectRows = ((EntryGrid)this.getControl("entryentity")).getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c", (String)"IctmBizDefEdit_0", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            int rowIndex = selectRows[0];
            DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            Long rowId = rowObj != null ? rowObj.getLong("id") : 0L;
            DynamicObjectCollection colls = this.getModel().getEntryEntity("entryentity");
            Set parentIds = colls.stream().filter(o -> o.get(PARENT) != null).map(o -> o.getLong("parent.id")).collect(Collectors.toSet());
            if (parentIds.contains(rowId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\uff0c\u5220\u9664\u5931\u8d25", (String)"IctmBizDefEdit_1", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            if (rowId != 0L && !(delete = OperationServiceHelper.executeOperate((String)"delete", (String)"tpo_ictm_bizdef_entry", (Object[])new Object[]{rowId}, (OperateOption)OperateOption.create())).isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\uff0c\u5220\u9664\u5931\u8d25", (String)"IctmBizDefEdit_1", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            this.getModel().deleteEntryRow("entryentity", rowIndex);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"IctmBizDefEdit_2", (String)"taxc-tpo", (Object[])new Object[0]));
        }
    }
}

