/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tpo.common.enums.MainTableMetaMatchEnum;
import org.apache.commons.collections4.CollectionUtils;

public class TaxRefundInfoListPlugin
extends AbstractListPlugin {
    private static final String TCETR_DECLARE_MAIN = "tcetr_declare_main";
    private static final String TPO_TAX_REFUND_INFO = "tpo_tax_refund_info";
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private boolean isClickSearch = false;
    private List<String> filterFieldList = new ArrayList<String>();

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String columnDescKey = columnDesc.getKey();
        if ("startdate".equals(columnDescKey)) {
            String date = DateUtils.getStartToEndDate((Date)data.getDate("startdate"), (Date)data.getDate("enddate"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        BillList billlist = (BillList)this.getControl("billlistap");
        String operateKey = args.getOperateKey();
        if ("confirmtaxrefund".equals(operateKey) || "canceltaxrefund".equals(operateKey) || "generatevoucher".equals(operateKey) || "deletevoucher".equals(operateKey)) {
            billlist.refresh();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        String name;
        List fieldNames;
        int i;
        this.isClickSearch = true;
        this.filterFieldList.add("declaretype");
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        List schemeFiterList = (List)filterValues.get("schemefilter");
        List fastFiterList = (List)filterValues.get("fastfilter");
        if (fastFiterList != null) {
            this.filterFieldList.add("1");
        }
        if (customFiterList != null) {
            for (i = customFiterList.size() - 1; i >= 0; --i) {
                Map customFiter = (Map)customFiterList.get(i);
                fieldNames = (List)customFiter.get("FieldName");
                if (fieldNames == null || fieldNames.isEmpty()) continue;
                name = (String)fieldNames.get(0);
                this.filterFieldList.add(name);
            }
        }
        if (schemeFiterList != null) {
            for (i = schemeFiterList.size() - 1; i >= 0; --i) {
                Map schemeFiter = (Map)schemeFiterList.get(i);
                fieldNames = (List)schemeFiter.get("FieldName");
                if (fieldNames == null || fieldNames.isEmpty()) continue;
                name = (String)fieldNames.get(0);
                this.filterFieldList.add(name);
                if (name.contains(".")) {
                    String[] split = name.split("\\.");
                    name = name.replace(split[1], "id");
                }
                this.filterFieldList.add(name);
            }
        }
        super.filterContainerSearchClick(args);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgDefault = customParams.getOrDefault("orgdefault", "false");
        Object startdate = customParams.get("startdate");
        List columnList = args.getCommonFilterColumns();
        List schemeList = args.getSchemeFilterColumns();
        for (FilterColumn filterColumn : columnList) {
            String fieldName = filterColumn.getFieldName();
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"org.name") && "false".equals(orgDefault)) {
                filterColumn.setDefaultValues(Collections.singletonList(""));
            }
            if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"startdate") || !Objects.nonNull(startdate)) continue;
            filterColumn.setDefaultValues(Collections.singletonList(startdate));
        }
        String declaretypeStr = (String)customParams.get("declaretype");
        for (FilterColumn filterColumn : schemeList) {
            String fieldName = filterColumn.getFieldName();
            if (!"declaretype".equals(fieldName) || !StringUtils.isNotBlank((CharSequence)declaretypeStr)) continue;
            String[] declaretypes = declaretypeStr.split(",");
            List<String> declareList = Arrays.asList(declaretypes);
            List comboItems = ((SchemeFilterColumn)filterColumn).getComboItems();
            comboItems.removeIf(next -> !declareList.contains(next.getValue()));
        }
        super.filterContainerInit(args);
    }

    public void setFilter(SetFilterEvent e) {
        if (this.isClickSearch) {
            e.getQFilters().removeIf(next -> !this.filterFieldList.contains(next.getProperty()));
        }
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String declaretypeStr = (String)customParams.get("declaretype");
        if (StringUtils.isNotBlank((CharSequence)declaretypeStr)) {
            String[] declaretypes = declaretypeStr.split(",");
            resultFilter.add(new QFilter("declaretype", "in", (Object)declaretypes));
        }
        for (QFilter eQFilter : e.getQFilters()) {
            for (QFilter filter : eQFilter.recombine()) {
                if ("startdate".equals(filter.getProperty())) {
                    if ("<".equals(filter.getCP())) {
                        resultFilter.add(new QFilter("enddate", "<=", filter.getValue()));
                        continue;
                    }
                    resultFilter.add(filter);
                    continue;
                }
                resultFilter.add(filter);
            }
        }
        e.getQFilters().addAll(resultFilter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("declarenum".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            DynamicObject taxRefundInfo = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)TPO_TAX_REFUND_INFO);
            String declarenum = taxRefundInfo.getString("declarenum");
            String declareType = taxRefundInfo.getString("declaretype");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)MainTableMetaMatchEnum.getMainTableMetaByDeclareType(declareType), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)declarenum)});
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            if ("3".equals(MainTableMetaMatchEnum.getVersionByDeclareType(declareType))) {
                this.buildCustomerVersion3(object, customParams, "tcvat_taxrefund".equals(declareType));
            } else {
                this.buildCustomerVersion2(object, customParams);
            }
            this.addPrivateField(customParams, object, declareType);
            this.showDeclarePage(StringUtils.trimToEmpty((String)declareType), customParams, object);
        }
    }

    private void buildCustomerVersion3(DynamicObject object, Map<String, Object> customParams, boolean isldts) {
        customParams.put("entryid", object.getString("id"));
        customParams.put("billno", object.getString("billno"));
        this.buildDefualtCustomer(object, customParams);
        if (isldts) {
            return;
        }
        DynamicObjectCollection jzjtdraft = object.getDynamicObjectCollection("jzjtdraft");
        if (CollectionUtils.isNotEmpty((Collection)jzjtdraft)) {
            customParams.put("draftIds", jzjtdraft.stream().map(j -> j.getString("fbasedataid.id")).collect(Collectors.joining(",")));
        }
    }

    private String buildCustomerVersion2(DynamicObject object, Map<String, Object> customParams) {
        this.buildDefualtCustomer(object, customParams);
        Date skssqq = object.getDate(SKSSQQ);
        Date skssqz = object.getDate(SKSSQZ);
        String type = object.getString("type");
        customParams.put("sbbid", object.getString("id"));
        customParams.put("type", type);
        customParams.put("templatetype", type);
        customParams.put("taxlimit", DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz));
        customParams.put("taxperiod", DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd").substring(0, 7));
        return type;
    }

    private void buildDefualtCustomer(DynamicObject object, Map<String, Object> customParams) {
        Date skssqq = object.getDate(SKSSQQ);
        Date skssqz = object.getDate(SKSSQZ);
        customParams.put(ORGID_KEY, object.getDynamicObject("org").getString("id"));
        customParams.put(ORGNAME_KEY, object.getDynamicObject("org").getString("name"));
        customParams.put(SKSSQQ, DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd"));
        customParams.put(SKSSQZ, DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        customParams.put("from", "history");
        customParams.put("readonly", Boolean.TRUE);
        customParams.put("modifytime", object.getDate("modifytime"));
    }

    private void addPrivateField(Map<String, Object> customParams, DynamicObject object, String declareType) {
        for (String field : MainTableMetaMatchEnum.getFieldsByDeclareType(declareType)) {
            customParams.put(field, object.get(field));
        }
    }

    private void showDeclarePage(String type, Map<String, Object> customParams, DynamicObject object) {
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        if (object.containsProperty("declarestatus") && "declared".equals(object.getString("declarestatus"))) {
            param.setFormId(templateEnum.getDeclareShowPage());
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setOrgId(Long.valueOf(Long.parseLong((String)customParams.get(ORGID_KEY))));
            requestModel.setTemplateType(type);
            requestModel.setId(Long.valueOf(object.getLong("id")));
            requestModel.setSkssqq(DateUtils.format((Date)object.getDate(SKSSQQ)));
            requestModel.setSkssqz(DateUtils.format((Date)object.getDate(SKSSQZ)));
            requestModel.setOperation("read");
            requestModel.setRefresh(Boolean.FALSE);
            customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        customParams.put("declarenumber", object.getString("billno"));
        param.setCustomParams(customParams);
        if (StringUtils.isNotBlank((CharSequence)MainTableMetaMatchEnum.getCaptionByDeclareType(type))) {
            param.setCaption(MainTableMetaMatchEnum.getCaptionByDeclareType(type));
        } else {
            param.setCaption(String.format(ResManager.loadKDString((String)"%s\u7533\u62a5", (String)"TaxRefundInfoListPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]), TemplateTypeConstant.getNsrtypemap().get(type)));
        }
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }
}

