/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.model2;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.FormulaTempEditOpenPageEnum;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;

public class FormulaTempEditPlugin
extends AbstractFormPlugin {
    private static final String FORMULAKEY = "formulakey";
    private static final String FORMULA = "formula";
    private static final String FORMULANAME = "formulaname";
    private static final String ENTITYID = "entityid";
    private static final String LARGETEXTFIELD = "largetextfield";
    private static final String TAX_TYPE = "taxtype";
    private static final String CONTENT = "content";
    private static final String[] FORMULAFIELDS = new String[]{"taxtype", "templatenum", "templateid", "formulakey", "table", "row", "column", "formula", "title", "content", "celltype", "name", "formulaname", "formulatype", "describe"};
    private static final String[] MUSTINPUTFIELDS = new String[]{"taxtype", "formulakey", "formulatype", "templatenum"};
    private static final String TEMPLATE_NUM = "templatenum";
    private static final String TEMPLATE_ID = "templateid";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{FORMULAKEY, FORMULANAME, CONTENT});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"celltype", CONTENT, "title"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("templateForm".equals(customParams.get("from"))) {
            String formulatype = (String)customParams.get("formulatype");
            for (String string : FORMULAFIELDS) {
                this.getModel().setValue(string, customParams.get(string));
                if (!FORMULA.equals(string)) continue;
                this.getPageCache().put(formulatype, (String)this.getModel().getValue(FORMULA));
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{TEMPLATE_NUM});
            this.getView().setEnable(Boolean.FALSE, new String[]{TAX_TYPE});
            this.setVisible(formulatype);
        } else {
            IFormView parentView = this.getView().getParentView();
            String[] types = null;
            if (null != parentView) {
                customParams = parentView.getFormShowParameter().getCustomParams();
                String type = (String)customParams.get(TAX_TYPE);
                types = (String[])TemplateTypeConstant.getTypeMap().get(type);
            }
            ComboItem item = null;
            if (null != types) {
                for (String tt : types) {
                    item = new ComboItem();
                    item.setValue(tt);
                    item.setCaption(new LocaleString(TemplateTypeConstant.getMap().getOrDefault(tt, tt)));
                }
            } else {
                for (Map.Entry entry : TemplateTypeConstant.getMap().entrySet()) {
                    item = new ComboItem();
                    item.setValue((String)entry.getKey());
                    item.setCaption(new LocaleString((String)entry.getValue()));
                }
            }
            String formulatype = (String)this.getView().getModel().getValue("formulatype");
            this.setVisible(formulatype);
        }
    }

    public void afterBindData(EventObject e) {
        String formulatype = (String)this.getView().getModel().getValue("formulatype");
        this.setVisible(formulatype);
        this.getPageCache().put(formulatype, (String)this.getModel().getValue(FORMULA));
        this.createCombo(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("formulatype".equals(name)) {
            String formulatype = (String)this.getView().getModel().getValue("formulatype");
            if (StringUtils.equals((CharSequence)formulatype, (CharSequence)"3")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"celltype", CONTENT, FORMULANAME});
                this.getView().setVisible(Boolean.FALSE, new String[]{FORMULA, "title", "formulaview"});
            } else if (StringUtils.equals((CharSequence)formulatype, (CharSequence)"1") || StringUtils.equals((CharSequence)formulatype, (CharSequence)"4")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FORMULANAME, FORMULA, "formulaview"});
                this.getView().setVisible(Boolean.FALSE, new String[]{CONTENT, "celltype", "title"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"celltype"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"title", CONTENT, FORMULANAME, FORMULA});
            }
            String formulaEntity = this.getModel().getDataEntityType().getExtendName();
            DynamicObject[] dObj = this.getFormulaFromDb(formulaEntity);
            if (dObj != null && dObj.length > 0) {
                this.getView().getModel().setValue(FORMULA, (Object)dObj[0].getString(FORMULA));
                this.getView().getModel().setValue(FORMULANAME, (Object)dObj[0].getString(FORMULANAME));
                this.getView().getModel().setValue(CONTENT, (Object)dObj[0].getString(CONTENT));
                this.getView().getModel().setValue("title", (Object)dObj[0].getString("title"));
                if (StringUtils.equals((CharSequence)formulatype, (CharSequence)"3")) {
                    this.getView().getModel().setValue("celltype", (Object)dObj[0].getString("celltype"));
                }
                this.getPageCache().put(formulatype, dObj[0].getString(FORMULA));
            } else {
                this.getView().getModel().setValue(FORMULA, (Object)this.getPageCache().get(formulatype));
                this.getView().getModel().setValue(FORMULANAME, (Object)"");
                this.getView().getModel().setValue(CONTENT, (Object)"");
                this.getView().getModel().setValue("title", (Object)"");
            }
        } else if ("celltype".equals(name)) {
            this.setTips();
        } else if (FORMULA.equals(name)) {
            this.getPageCache().put((String)this.getModel().getValue("formulatype"), (String)this.getModel().getValue(FORMULA));
        } else if (TAX_TYPE.equals(name)) {
            this.createCombo(true);
        } else if (TEMPLATE_NUM.equals(name)) {
            this.setTemplate();
        }
    }

    private void setTemplate() {
        String templateNum = (String)this.getView().getModel().getValue(TEMPLATE_NUM);
        Map map = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"templateList", Map.class);
        if (null != map) {
            this.getModel().setValue(TEMPLATE_ID, map.get(templateNum));
        }
    }

    private void createCombo(boolean isSetSelect) {
        ArrayList<ComboItem> comboItemList;
        QFilter qFilter3;
        String formulaEntity = this.getModel().getDataEntityType().getExtendName();
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(TEMPLATE_NUM);
        DynamicObject taxType = (DynamicObject)this.getModel().getValue(TAX_TYPE);
        DynamicObject[] dynamicObjects = null;
        if ("tpo_formula_edit".equals(formulaEntity)) {
            qFilter3 = new QFilter("type", "=", (Object)(null == taxType ? "null" : ((DynamicObject)this.getModel().getValue(TAX_TYPE)).getString("id")));
            dynamicObjects = BusinessDataServiceHelper.load((String)"bdtaxr_template_main", (String)"id,number", (QFilter[])new QFilter[]{qFilter3});
        } else {
            qFilter3 = new QFilter("group", "=", (Object)(null == taxType ? "null" : ((DynamicObject)this.getModel().getValue(TAX_TYPE)).getString("id")));
            dynamicObjects = BusinessDataServiceHelper.load((String)"bdtaxr_template", (String)"id,number", (QFilter[])new QFilter[]{qFilter3});
        }
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            comboItemList = new ArrayList<ComboItem>();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            comboItemList.add(new ComboItem(new LocaleString((String)customParams.get(TEMPLATE_NUM)), (String)customParams.get(TEMPLATE_NUM)));
            comboEdit = (ComboEdit)this.getView().getControl(TEMPLATE_NUM);
            comboEdit.setComboItems(comboItemList);
            this.getModel().setValue(TEMPLATE_NUM, (Object)((ComboItem)comboItemList.get(0)).getValue());
        } else {
            comboItemList = new ArrayList();
            HashMap map = new HashMap();
            Arrays.stream(dynamicObjects).forEach(v -> {
                String templateNum = v.getString("number");
                String templateId = v.getString("id");
                if (!map.containsKey(templateNum)) {
                    comboItemList.add(new ComboItem(new LocaleString(templateNum), templateNum));
                }
                map.put(templateNum, templateId);
                TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"templateList", (Object)map);
            });
            comboEdit.setComboItems(comboItemList);
            if (isSetSelect) {
                this.getModel().setValue(TEMPLATE_NUM, (Object)((ComboItem)comboItemList.get(0)).getValue());
            }
        }
    }

    private void setTips() {
        String celltype = (String)this.getView().getModel().getValue("celltype");
        if ("2".equals(celltype) || "3".equals(celltype) || "4".equals(celltype)) {
            this.addTips(FORMULANAME, ResManager.loadKDString((String)"\u586b\u5199\u8bf4\u660e", (String)"FormulaTempEditPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]), ResManager.loadKDString((String)"val:\u9009\u9879\u503c\r\ntext:\u9009\u9879\u663e\u793a\u6587\u672c\r\n\u914d\u7f6ejson\u6837\u4f8b:[{\"val\":\"\u9009\u9879\u503c1\",\"text\":\"\u9009\u9879\u540d\u79f01\"}]", (String)"FormulaTempEditPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]));
        }
        if ("5".equals(celltype)) {
            this.addTips(FORMULANAME, ResManager.loadKDString((String)"\u586b\u5199\u8bf4\u660e", (String)"FormulaTempEditPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]), ResManager.loadKDString((String)"val:\u57fa\u7840\u8d44\u6599\u914d\u7f6e\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\r\ntext:\u663e\u793a\u5c5e\u6027,\u53ef\u4ee5\u591a\u4e2a\u5c5e\u6027\u4efb\u610f\u62fc\u63a5\uff0c\u5982\uff1a\"\u7f16\u7801\u662f{number}\uff0c\u540d\u79f0{name}\"\r\n\u914d\u7f6ejson\u6837\u4f8b:[{\"val\":\"\u57fa\u7840\u8d44\u6599\u5b9e\u4f53id\",\"text\":\"{\u663e\u793a\u5b57\u6bb5\u5c5e\u60271}\"}]", (String)"FormulaTempEditPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
        }
        this.addTips(CONTENT, ResManager.loadKDString((String)"\u586b\u5199\u8bf4\u660e", (String)"FormulaTempEditPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5c55\u793a\u5355\u5143\u683c\u503c\u914d\u7f6e\"{{\u5355\u5143\u683cid}}\"\uff0c\u5355\u5143\u683cid\u5b9e\u4f53\u540d\u3001\u884c\u53f7\u3001\u5b57\u6bb5\u7528\"_\"\u5206\u5272\r\n\u914d\u7f6e\u6837\u4f8b:\u5355\u5143\u683cxxx\u662f{{tcut_sb_fjsf_jz_1_textfield3}}", (String)"FormulaTempEditPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
    }

    private void addTips(String textEdit, String title, String content) {
        TextEdit formulaname = (TextEdit)this.getControl(textEdit);
        Tips tips = new Tips("text", new LocaleString(title), new LocaleString(content), false, null);
        formulaname.addTips(tips);
    }

    public void click(EventObject evt) {
        TextEdit k;
        FormulaTempEditOpenPageEnum pageEnum;
        Object key = evt.getSource();
        if (key instanceof TextEdit && null != (pageEnum = FormulaTempEditOpenPageEnum.getInstanceByKey((String)(k = (TextEdit)key).getKey()))) {
            this.openPage(pageEnum);
        }
    }

    private void openPage(FormulaTempEditOpenPageEnum pageEnum) {
        if (this.getModel().getValue(TAX_TYPE) == null) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(pageEnum.getPageId());
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String entityid = (String)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)ENTITYID, String.class);
        showParameter.setCustomParam(ENTITYID, (Object)entityid);
        if (FormulaTempEditOpenPageEnum.ROW_KEY.getKey().equals(pageEnum.getKey())) {
            showParameter.setCustomParam("templateType", ((DynamicObject)this.getModel().getValue(TAX_TYPE)).get("id"));
            showParameter.setCustomParam("formulatype", this.getModel().getValue("formulatype"));
        }
        IFormView parentView = this.getView().getParentView();
        Object types = null;
        if (null != parentView) {
            Map customParams = parentView.getFormShowParameter().getCustomParams();
            showParameter.setCustomParam("orgId", customParams.get("orgId"));
            showParameter.setCustomParam("country", customParams.get("country"));
        }
        FormulaVo formulaVo = new FormulaVo();
        formulaVo.setFormula((String)this.getModel().getValue(FORMULA));
        formulaVo.setFormulaName((String)this.getModel().getValue(FORMULANAME));
        showParameter.setCustomParam("calculate", (Object)formulaVo);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, pageEnum.getCallbackId());
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        String id = event.getActionId();
        if (id.equals(FormulaTempEditOpenPageEnum.ROW_KEY.getCallbackId())) {
            Map<String, String> value;
            Map returnData2 = (Map)event.getReturnData();
            if (null != returnData2 && (value = this.getValue(returnData2)) != null) {
                this.getModel().setValue(FORMULAKEY, (Object)value.get("id"));
                this.getModel().setValue("name", (Object)value.get("name"));
            }
        } else if (id.equals(FormulaTempEditOpenPageEnum.FORMULA.getCallbackId())) {
            Map returnData3 = (Map)event.getReturnData();
            if (null != returnData3) {
                FormulaVo formulaVo = (FormulaVo)returnData3.get("calculate");
                this.getModel().setValue(FORMULA, (Object)formulaVo.getFormula());
                this.getModel().setValue(FORMULANAME, (Object)formulaVo.getFormulaName());
            }
        } else if (id.equals(FormulaTempEditOpenPageEnum.TIPS_CONTEXT.getCallbackId()) && null != (returnData = (Map)event.getReturnData())) {
            String n = (String)returnData.get(LARGETEXTFIELD);
            this.getModel().setValue(CONTENT, (Object)n);
        }
    }

    private Map<String, String> getValue(Map<String, Object> returnData) {
        HashMap<String, String> data = new HashMap<String, String>();
        Boolean rowfill = (Boolean)returnData.get("rowfill");
        Boolean columnfill = (Boolean)returnData.get("columnfill");
        List column = (List)returnData.get("column");
        List row = (List)returnData.get("row");
        String entityid = (String)returnData.get(ENTITYID);
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)ENTITYID, (Object)entityid);
        String entityname = (String)returnData.get("entityname");
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"entityname", (Object)entityname);
        for (Map rowMap : row) {
            String rowValueId = (String)rowMap.get("id");
            if ("ROOT".equals(rowValueId)) continue;
            for (Map colMap : column) {
                String colValueId = (String)rowMap.get("id");
                if ("ROOT".equals(colValueId)) continue;
                String valText = entityname + '#' + (String)colMap.get("text") + '#' + (String)rowMap.get("text");
                if (rowValueId.startsWith(entityid)) {
                    valText = (String)rowMap.get("id") + '#' + (String)colMap.get("id");
                    data.put("id", valText);
                    valText = entityname + "#" + (String)rowMap.get("text") + "#" + (String)colMap.get("text");
                    data.put("name", valText);
                }
                if (StringUtils.isNotBlank((CharSequence)valText)) {
                    return data;
                }
                if (columnfill.booleanValue()) continue;
                break;
            }
            if (rowfill.booleanValue()) continue;
            break;
        }
        return null;
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("add".equals(key)) {
            for (String field : FORMULAFIELDS) {
                if (TEMPLATE_NUM.equals(field) || TEMPLATE_ID.equals(field) || TAX_TYPE.equals(field) || "formulatype".equals(field)) continue;
                this.getModel().setValue(field, null);
            }
        } else if ("save".equals(key)) {
            String celltype;
            for (String field : MUSTINPUTFIELDS) {
                if (!StringUtils.isBlank((Object)this.getModel().getValue(field)) && null != this.getModel().getValue(field)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5b57\u6bb5\u672a\u5f55\u5165\uff0c\u8bf7\u8865\u5145\u5b8c\u6574!", (String)"FormulaTempEditPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            String formulatype = (String)this.getView().getModel().getValue("formulatype");
            if (formulatype.equals("3") && ("2".equals(celltype = (String)this.getView().getModel().getValue("celltype")) || "3".equals(celltype) || "4".equals(celltype) || "5".equals(celltype) || "6".equals(celltype))) {
                String formulaname = (String)this.getView().getModel().getValue(FORMULANAME);
                boolean flag = true;
                try {
                    JSONObject jon;
                    Object jsonObject = JSONObject.parse((String)formulaname);
                    if (jsonObject instanceof JSONArray) {
                        JSONArray jSONArray = (JSONArray)jsonObject;
                        for (int i = 0; i < jSONArray.size(); ++i) {
                            JSONObject jon2 = (JSONObject)jSONArray.get(i);
                            if (jon2.containsKey((Object)"val") && jon2.containsKey((Object)"text")) continue;
                            flag = false;
                        }
                    } else if (!(!(jsonObject instanceof JSONObject) || (jon = (JSONObject)jsonObject).containsKey((Object)"val") && jon.containsKey((Object)"text"))) {
                        flag = false;
                    }
                }
                catch (Exception e) {
                    flag = false;
                }
                if (!flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u5f0f\u540d\u79f0\u683c\u5f0f\u914d\u7f6e\u9519\u8bef", (String)"FormulaTempEditPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]), Integer.valueOf(2000));
                }
            }
            this.saveFormula();
        } else if ("formulaview".equals(key)) {
            Object formulatype = this.getModel().getValue("formulatype");
            if ("1".equals(formulatype) || "4".equals(formulatype)) {
                String formula = (String)this.getModel().getValue(FORMULA);
                HashMap<String, String> customeMap = new HashMap<String, String>();
                customeMap.put(FORMULA, formula);
                PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"bdtaxr_formulaview", (IFormView)this.getView(), customeMap, (IFormPlugin)this);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u8ba1\u7b97\u516c\u5f0f\u548c\u5b57\u7b26\u4e32\u516c\u5f0f\u9884\u89c8", (String)"FormulaTempEditPlugin_8", (String)"taxc-tpo", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        }
    }

    private void saveFormula() {
        String formulaEntity = this.getModel().getDataEntityType().getExtendName();
        DynamicObject[] formulaObjs = this.getFormulaFromDb(formulaEntity);
        DynamicObject dObj = null;
        if (formulaObjs == null || formulaObjs.length == 0) {
            dObj = BusinessDataServiceHelper.newDynamicObject((String)formulaEntity);
        } else if (formulaObjs.length == 1) {
            dObj = formulaObjs[0];
        } else {
            String templatenum = String.valueOf(this.getModel().getValue(TEMPLATE_NUM));
            String formulakey = String.valueOf(this.getModel().getValue(FORMULAKEY));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u6a21\u677f\u5b58\u5728\u591a\u4e2a\u6807\u8bc6\u4e3a\u201c%2$s\u201d\u7684\u540c\u7c7b\u578b\u516c\u5f0f\uff01", (String)"FormulaTempEditPlugin_7", (String)"taxc-tpo", (Object[])new Object[0]), templatenum, formulakey));
            return;
        }
        for (String filed : FORMULAFIELDS) {
            dObj.set(filed, this.getModel().getValue(filed));
        }
        dObj.set("updatetime", (Object)new Date());
        Object[] ids = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObj});
        this.getModel().setDataChanged(false);
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"FormulaTempEditPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]), Integer.valueOf(3000));
        this.getView().close();
        if (this.getView().getParentView() instanceof ListView) {
            ((ListView)this.getView().getParentView()).refresh();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private DynamicObject[] getFormulaFromDb(String formulaEntity) {
        QFilter qFilter = new QFilter(TEMPLATE_ID, "=", (Object)String.valueOf(this.getModel().getValue(TEMPLATE_ID)));
        QFilter qFilter2 = new QFilter("formulatype", "=", (Object)String.valueOf(this.getModel().getValue("formulatype")));
        QFilter qFilter3 = new QFilter(TAX_TYPE, "=", ((DynamicObject)this.getModel().getValue(TAX_TYPE)).get("id"));
        QFilter qFilter4 = new QFilter(FORMULAKEY, "=", (Object)String.valueOf(this.getModel().getValue(FORMULAKEY)));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)formulaEntity, (String)"id,taxtype,templatenum,templateid,formulakey,table,row,column,formula,title,content,celltype,name,formulaname,formulatype,updatetime,describe", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3, qFilter4});
        return load;
    }

    private void setVisible(String formulatype) {
        if (StringUtils.equals((CharSequence)formulatype, (CharSequence)"3")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"celltype", CONTENT, FORMULANAME});
            this.getView().setVisible(Boolean.FALSE, new String[]{FORMULA, "title"});
            this.setTips();
        } else if (StringUtils.equals((CharSequence)formulatype, (CharSequence)"1") || StringUtils.equals((CharSequence)formulatype, (CharSequence)"4")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FORMULANAME, FORMULA});
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTENT, "celltype", "title"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"celltype"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"title", CONTENT, FORMULANAME, FORMULA});
        }
    }
}

