/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.multidimension;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.pinyin.PinYinUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.business.multidideclare.BatchMemberSettingService;
import kd.taxc.tpo.common.vo.DeclareReportTemplateCellsVo;
import kd.taxc.tpo.common.vo.MemberTreeNode;

public class BatchMemberSettingPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(BatchMemberSettingPlugin.class);
    private static final String ROW_MEMBER_ENTITY = "entryentity";
    private static final String COL_MEMBER_ENTITY = "entryentity1";
    private IPageCache pageCache = this.getPageCache();

    public void initialize() {
        this.addClickListeners(new String[]{"preview", "update"});
        this.pageCache = this.getPageCache();
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String spreadJson = (String)customParams.get("preadJson");
        if (StringUtil.isBlank((CharSequence)spreadJson)) {
            this.getView().showErrorNotification("Template Is Null!");
            return;
        }
        JSONObject modelObj = (JSONObject)customParams.get("model");
        long modelId = modelObj.getLong("id");
        long templateId = ((JSONObject)customParams).getLong("templateId");
        String settingKey = ((JSONObject)customParams).getString("settingKey");
        List selRows = null;
        List selCols = null;
        String currentSheetName = null;
        if ("designatedsetting".equals(settingKey)) {
            selRows = (List)customParams.get("selectRows");
            selCols = (List)customParams.get("selectCols");
            currentSheetName = (String)customParams.get("currentSheetName");
        }
        List<DeclareReportTemplateCellsVo> map1 = BatchMemberSettingService.paraJson(spreadJson, selRows, selCols, currentSheetName);
        List<DeclareReportTemplateCellsVo> member = BatchMemberSettingService.setMember(map1);
        List<Map<String, String>> memberList = BatchMemberSettingService.cellsToMember(member);
        ArrayList<Map<String, String>> rowMemberList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> colMemberList = new ArrayList<Map<String, String>>();
        for (Map<String, String> map : memberList) {
            if (rowMemberList.stream().noneMatch(el -> ((String)el.get("rowFlag")).equals(map.get("rowFlag")))) {
                rowMemberList.add(map);
            }
            if (!colMemberList.stream().noneMatch(el -> ((String)el.get("colFlag")).equals(map.get("colFlag")))) continue;
            colMemberList.add(map);
        }
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"modelId", (Object)modelId);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"templateId", (Object)templateId);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"spreadJson", (Object)spreadJson);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"rowMemberList", rowMemberList);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"colMemberList", colMemberList);
        IDataModel model = this.getModel();
        if (rowMemberList.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(ROW_MEMBER_ENTITY, rowMemberList.size());
            int rowIndex = 0;
            for (Map map : rowMemberList) {
                model.setValue("id", map.get("id"), rowIndex);
                model.setValue("datastatus", (Object)ResManager.loadKDString((String)"\u65b0\u589e", (String)"BatchMemberSettingPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]), rowIndex);
                model.setValue("firstmember", map.get("sheeName"), rowIndex);
                model.setValue("secondmember", map.get("rowMember"), rowIndex);
                model.setValue("memberlist", map.get("rowMember"), rowIndex);
                model.setValue("member", map.get("rowMemberStr"), rowIndex);
                model.setValue("memberflag", map.get("rowFlag"), rowIndex);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView(ROW_MEMBER_ENTITY);
        }
        if (colMemberList.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(COL_MEMBER_ENTITY, colMemberList.size());
            int rowIndex = 0;
            for (Map map : colMemberList) {
                model.setValue("id1", map.get("id"), rowIndex);
                model.setValue("datastatus1", (Object)ResManager.loadKDString((String)"\u65b0\u589e", (String)"BatchMemberSettingPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]), rowIndex);
                model.setValue("firstmember1", map.get("colMember"), rowIndex);
                model.setValue("memberlist1", map.get("colMember"), rowIndex);
                model.setValue("member1", map.get("colMemberStr"), rowIndex);
                model.setValue("memberflag1", map.get("colFlag"), rowIndex);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView(COL_MEMBER_ENTITY);
        }
    }

    private String getMembers(long modelId, String spreadJson) {
        DynamicObjectCollection rowMemberCollection = this.getModel().getEntryEntity(ROW_MEMBER_ENTITY);
        DynamicObjectCollection colMemberCollection = this.getModel().getEntryEntity(COL_MEMBER_ENTITY);
        try {
            List<MemberTreeNode> rowMemberListFromCollection = BatchMemberSettingService.getMemberList(null, rowMemberCollection, "");
            List<MemberTreeNode> colMemberListFromCollection = BatchMemberSettingService.getMemberList(null, colMemberCollection, "1");
            BatchMemberSettingService.saveMembers(modelId, rowMemberListFromCollection, "tpo_row_member");
            BatchMemberSettingService.saveMembers(modelId, colMemberListFromCollection, "tpo_col_member");
            ArrayList<Map<String, Object>> reportItems = new ArrayList<Map<String, Object>>();
            BatchMemberSettingService.saveReportItems(modelId, rowMemberListFromCollection, colMemberListFromCollection, reportItems);
            spreadJson = BatchMemberSettingService.resetSpreadJson(spreadJson, reportItems);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"spreadJsonNew", (Object)spreadJson);
        return spreadJson;
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        switch (control.getKey()) {
            case "preview": {
                if (!this.checkData()) break;
                this.previewMember();
                break;
            }
            case "update": {
                if (!this.checkData()) break;
                this.updateMember();
                break;
            }
        }
    }

    private boolean checkData() {
        String memberNumber;
        DynamicObject obj;
        int i;
        ArrayList<String> rowMembers = new ArrayList<String>(10);
        ArrayList<String> colMembers = new ArrayList<String>(10);
        DynamicObjectCollection rowMemberCollection = this.getModel().getEntryEntity(ROW_MEMBER_ENTITY);
        DynamicObjectCollection colMemberCollection = this.getModel().getEntryEntity(COL_MEMBER_ENTITY);
        int size = rowMemberCollection.size();
        for (i = 0; i < size; ++i) {
            obj = (DynamicObject)rowMemberCollection.get(i);
            memberNumber = obj.getString("member");
            if (rowMembers.contains(memberNumber)) {
                String title = ResManager.loadKDString((String)"\u884c\u7ef4", (String)"BatchMemberSettingService_2", (String)"taxc-tpo", (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7b2c\u3010%2$s\u3011\u884c\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\uff01", (String)"BatchMemberSettingService_1", (String)"taxc-tpo", (Object[])new Object[0]), title, i + 1));
                return false;
            }
            rowMembers.add(memberNumber);
        }
        size = colMemberCollection.size();
        for (i = 0; i < size; ++i) {
            obj = (DynamicObject)colMemberCollection.get(i);
            memberNumber = obj.getString("member1");
            if (colMembers.contains(memberNumber)) {
                String title = ResManager.loadKDString((String)"\u5217\u7ef4", (String)"BatchMemberSettingService_3", (String)"taxc-tpo", (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7b2c\u3010%2$s\u3011\u884c\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\uff01", (String)"BatchMemberSettingService_1", (String)"taxc-tpo", (Object[])new Object[0]), title, i + 1));
                return false;
            }
            colMembers.add(memberNumber);
        }
        return true;
    }

    public void previewMember() {
        long modelId = (Long)TreeUtils.getCache((IPageCache)this.pageCache, (String)"modelId", Long.class);
        String spreadJson = (String)TreeUtils.getCache((IPageCache)this.pageCache, (String)"spreadJson", String.class);
        spreadJson = this.getMembers(modelId, spreadJson);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tpo_batch_member_preview");
        showParameter.setCustomParam("spreadJson", (Object)spreadJson);
        showParameter.setCustomParam("currentSheetIndex", this.getView().getFormShowParameter().getCustomParams().get("currentSheetIndex"));
        showParameter.setCustomParam("currentSheetName", this.getView().getFormShowParameter().getCustomParams().get("currentSheetName"));
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private void updateMember() {
        String name;
        String number;
        long id;
        DynamicObject rowRoot = (DynamicObject)this.getModel().getValue("rowmemberparent");
        DynamicObject colRoot = (DynamicObject)this.getModel().getValue("colmemberparent");
        MemberTreeNode rowRootNode = null;
        MemberTreeNode colRootNode = null;
        if (rowRoot != null) {
            id = rowRoot.getLong("id");
            number = rowRoot.getString("number");
            name = rowRoot.getString("name");
            rowRootNode = new MemberTreeNode();
            rowRootNode.setPkId(id);
            rowRootNode.setNumber(number);
            rowRootNode.setText(name);
        }
        if (colRoot != null) {
            id = colRoot.getLong("id");
            number = colRoot.getString("number");
            name = colRoot.getString("name");
            colRootNode = new MemberTreeNode();
            colRootNode.setPkId(id);
            colRootNode.setNumber(number);
            colRootNode.setText(name);
        }
        long modelId = (Long)TreeUtils.getCache((IPageCache)this.pageCache, (String)"modelId", Long.class);
        long templateId = (Long)TreeUtils.getCache((IPageCache)this.pageCache, (String)"templateId", Long.class);
        String spreadJson = (String)TreeUtils.getCache((IPageCache)this.pageCache, (String)"spreadJson", String.class);
        DynamicObjectCollection rowMemberCollection = this.getModel().getEntryEntity(ROW_MEMBER_ENTITY);
        DynamicObjectCollection colMemberCollection = this.getModel().getEntryEntity(COL_MEMBER_ENTITY);
        List<MemberTreeNode> rowMemberListFromCollection = BatchMemberSettingService.getMemberList(rowRootNode, rowMemberCollection, "");
        List<MemberTreeNode> colMemberListFromCollection = BatchMemberSettingService.getMemberList(colRootNode, colMemberCollection, "1");
        DynamicObjectCollection rowCollection = BatchMemberSettingService.saveMembers(modelId, rowMemberListFromCollection, "tpo_row_member");
        DynamicObjectCollection colCollection = BatchMemberSettingService.saveMembers(modelId, colMemberListFromCollection, "tpo_col_member");
        ArrayList<Map<String, Object>> reportItems = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection reportItemsCollection = BatchMemberSettingService.saveReportItems(modelId, rowMemberListFromCollection, colMemberListFromCollection, reportItems);
        spreadJson = BatchMemberSettingService.resetSpreadJson(spreadJson, reportItems);
        if (rowCollection.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])rowCollection.toArray((Object[])new DynamicObject[0])));
        }
        if (colCollection.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])colCollection.toArray((Object[])new DynamicObject[0])));
        }
        if (reportItemsCollection.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])reportItemsCollection.toArray((Object[])new DynamicObject[0])));
        }
        BatchMemberSettingService.saveSpreadJson(templateId, spreadJson);
        if (reportItems.size() > 0) {
            BatchMemberSettingService.saveTemplaterReportItemsRelation(templateId, reportItems);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"MultiDiTemplateEditPlugin_11", (String)"taxc-tpo", (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject object = changeData.getDataEntity();
        String entity = object.getDataEntityType().getName();
        if (!entity.startsWith(ROW_MEMBER_ENTITY)) {
            return;
        }
        String ext = entity.replace(ROW_MEMBER_ENTITY, "");
        String firstmember = object.getString("firstmember" + ext);
        String secondmember = object.getString("secondmember" + ext);
        String member = StringUtil.removeSpecialCharacter((String)PinYinUtil.getPinYinHeadChar((String)firstmember)) + (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{secondmember}) ? "_" + StringUtil.removeSpecialCharacter((String)PinYinUtil.getPinYinHeadChar((String)secondmember)) : "");
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("member" + ext, (Object)member, rowIndex);
        model.setValue("memberlist" + ext, (Object)(firstmember + (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{secondmember}) ? "_" + secondmember : "")), rowIndex);
        model.endInit();
        this.getView().updateView(entity);
    }
}

