/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.multidimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class DimensionSelectPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
BeforeF7SelectListener,
TreeNodeCheckListener {
    private static final String ROW_TREE = "rowtree";
    private static final String COLUMN_TREE = "columntree";
    private static final int BATCHSIZE = 1000;
    private static Map<String, String> SEARCH_MAP = new HashMap<String, String>(4){
        {
            this.put("mulbasedatafield", DimensionSelectPlugin.ROW_TREE);
            this.put("mulbasedatafield1", DimensionSelectPlugin.COLUMN_TREE);
        }
    };
    private static Map<String, String> TREE_MAP = new HashMap<String, String>(4){
        {
            this.put(DimensionSelectPlugin.ROW_TREE, "tpo_row_member");
            this.put(DimensionSelectPlugin.COLUMN_TREE, "tpo_col_member");
        }
    };

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_cancel", "btn_submit"});
        MulBasedataEdit basedataEdit = (MulBasedataEdit)this.getControl("mulbasedatafield");
        MulBasedataEdit basedataEdit1 = (MulBasedataEdit)this.getControl("mulbasedatafield1");
        basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        basedataEdit1.addAfterF7SelectListener((AfterF7SelectListener)this);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        basedataEdit1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeView rowTree = (TreeView)this.getView().getControl(ROW_TREE);
        rowTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView colomnTree = (TreeView)this.getView().getControl(COLUMN_TREE);
        colomnTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void treeNodeCheck(TreeNodeCheckEvent arg0) {
        TreeView treeView = (TreeView)arg0.getSource();
        String key = treeView.getKey();
        if (ROW_TREE.equalsIgnoreCase(key)) {
            this.loadSelectedList("row");
        } else {
            this.loadSelectedList("column");
        }
    }

    private void loadSelectedList(String flag) {
        TreeView treeView = (TreeView)this.getView().getControl(flag + "tree");
        TreeView.TreeState treeState = treeView.getTreeState();
        List selectNodes = treeState.getCheckedNodes();
        List selectNodeIds = treeState.getCheckedNodeIds();
        List leafNodes = selectNodes.stream().filter(v -> !"ROOT".equals(v.get("id")) && !Boolean.TRUE.equals(v.get("isParent"))).collect(Collectors.toList());
        Label label = (Label)this.getControl("label_" + flag);
        label.setText(String.format(ResManager.loadKDString((String)"\u5df2\u9009\uff08%s\uff09", (String)"DimensionSelectPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]), leafNodes.size()));
        this.getModel().beginInit();
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_" + flag);
        DynamicObjectCollection removeEntries = entries.stream().filter(entry -> !selectNodeIds.contains(entry.getString("id_" + flag))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        entries.removeAll((Collection)removeEntries);
        Set idSet = entries.stream().map(entry -> entry.getString("id_" + flag)).collect(Collectors.toSet());
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        TableValueSetter vs = this.getTableValueSetter(flag);
        int size = leafNodes.size();
        for (int i = 0; i < size; ++i) {
            Map data = (Map)leafNodes.get(i);
            String id = (String)data.get("id");
            if (idSet.contains(id)) continue;
            this.loadRowData(data, vs);
            int rowCount = vs.getCount();
            if (rowCount >= 1000) {
                model.batchCreateNewEntryRow("entryentity_" + flag, vs);
                vs = this.getTableValueSetter(flag);
            }
            idSet.add(id);
        }
        int rowCount = vs.getCount();
        if (rowCount > 0) {
            model.batchCreateNewEntryRow("entryentity_" + flag, vs);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity_" + flag);
    }

    private TableValueSetter getTableValueSetter(String flag) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("name_" + flag, new Object[0]);
        vs.addField("id_" + flag, new Object[0]);
        vs.addField("parentid_" + flag, new Object[0]);
        return vs;
    }

    private void loadRowData(Map<String, Object> data, TableValueSetter vs) {
        List fields = vs.getFields();
        Object[] container = new Object[fields.size()];
        int index = 0;
        container[index++] = data.get("text");
        container[index++] = data.get("id");
        container[index++] = data.get("parentid");
        vs.addRow(container);
    }

    private void clearSelectedList(String flag) {
        this.getModel().deleteEntryData("entryentity_" + flag);
        Label label = (Label)this.getControl("label_" + flag);
        label.setText(String.format(ResManager.loadKDString((String)"\u5df2\u9009\uff08%s\uff09", (String)"DimensionSelectPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]), 0));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (operateKey.startsWith("deleteentry_")) {
            this.loadTreeSelected(operateKey.split("_")[1]);
        } else if (operateKey.startsWith("movetop_")) {
            this.setEntryRowTop(operateKey.split("_")[1]);
        } else if (operateKey.startsWith("movebuttom_")) {
            this.setEntryRowBottom(operateKey.split("_")[1]);
        }
    }

    private void loadTreeSelected(String flag) {
        TreeView treeView = (TreeView)this.getView().getControl(flag + "tree");
        TreeView.TreeState treeState = treeView.getTreeState();
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_" + flag);
        Label label = (Label)this.getControl("label_" + flag);
        label.setText(String.format(ResManager.loadKDString((String)"\u5df2\u9009\uff08%s\uff09", (String)"DimensionSelectPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]), entries.size()));
        Set idSet = entries.stream().map(entry -> entry.getString("id_" + flag)).collect(Collectors.toSet());
        List selectNodes = treeState.getCheckedNodes();
        List removeNodes = selectNodes.stream().filter(v -> !"ROOT".equals(v.get("id")) && !Boolean.TRUE.equals(v.get("isParent")) && !idSet.contains(v.get("id"))).map(v -> (String)v.get("id")).collect(Collectors.toList());
        treeView.uncheckNodes(removeNodes);
    }

    private void setEntryRowTop(String flag) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity_" + flag);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DimensionSelectPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]));
        }
        this.getModel().setEntryRowTop("entryentity_" + flag, selectRows);
    }

    private void setEntryRowBottom(String flag) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity_" + flag);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DimensionSelectPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]));
        }
        this.getModel().setEntryRowBottom("entryentity_" + flag, selectRows);
    }

    public void afterCreateNewData(EventObject e) {
        Object modelid = this.getView().getFormShowParameter().getCustomParam("modelid");
        if (modelid == null) {
            return;
        }
        ArrayList<QFilter> qFilters = this.getDefaultFilters();
        this.buildTree(ROW_TREE, "tpo_row_member", qFilters);
        this.buildTree(COLUMN_TREE, "tpo_col_member", qFilters);
    }

    private ArrayList<QFilter> getDefaultFilters() {
        Object modelid = this.getView().getFormShowParameter().getCustomParam("modelid");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("model", "=", modelid));
        return qFilters;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_submit".equals(key)) {
            TreeView rowTreeView = (TreeView)this.getView().getControl(ROW_TREE);
            TreeView columnTreeView = (TreeView)this.getView().getControl(COLUMN_TREE);
            List rowids = rowTreeView.getTreeState().getSelectedNodeId();
            List columids = columnTreeView.getTreeState().getSelectedNodeId();
            if (EmptyCheckUtils.isEmpty((Object)rowids)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c\u7ef4\u6210\u5458", (String)"DimensionSelectPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]));
            }
            if (EmptyCheckUtils.isEmpty((Object)columids)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5217\u7ef4\u6210\u5458", (String)"DimensionSelectPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection rowQuery = QueryServiceHelper.query((String)"tpo_row_member", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)rowids), qFilter});
            DynamicObjectCollection colQuery = QueryServiceHelper.query((String)"tpo_col_member", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)columids), qFilter});
            Set rowSet = rowQuery.stream().map(a -> a.getString("number")).collect(Collectors.toSet());
            Set colSet = colQuery.stream().map(a -> a.getString("number")).collect(Collectors.toSet());
            DynamicObjectCollection rowEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_row");
            DynamicObjectCollection columnEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_column");
            List rowList = rowEntries.stream().map(entry -> {
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("id", entry.getString("id_row"));
                map.put("text", entry.getString("name_row"));
                map.put("parentid", entry.getString("parentid_row"));
                map.put("isParent", false);
                return map;
            }).collect(Collectors.toList());
            List columnList = columnEntries.stream().map(entry -> {
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("id", entry.getString("id_column"));
                map.put("text", entry.getString("name_column"));
                map.put("parentid", entry.getString("parentid_column"));
                map.put("isParent", false);
                return map;
            }).collect(Collectors.toList());
            List rowListMap = rowList.stream().filter(a -> rowSet.contains(a.get("id"))).collect(Collectors.toList());
            List columnListMap = columnList.stream().filter(a -> colSet.contains(a.get("id"))).collect(Collectors.toList());
            if (EmptyCheckUtils.isEmpty(rowListMap)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c\u7ef4\u6210\u5458\u53f6\u5b50\u8282\u70b9", (String)"DimensionSelectPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            if (EmptyCheckUtils.isEmpty(columnListMap)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5217\u7ef4\u6210\u5458\u53f6\u5b50\u8282\u70b9", (String)"DimensionSelectPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            ArrayList rowListMap1 = new ArrayList(rowListMap.size());
            for (Object map : rowListMap) {
                if ("ROOT".equals(map.get("id")) || Boolean.TRUE.equals(map.get("isParent"))) continue;
                rowListMap1.add(map);
            }
            rowListMap = rowListMap1;
            ArrayList columnListMap1 = new ArrayList(rowListMap.size());
            for (Map map : columnListMap) {
                if ("ROOT".equals(map.get("id")) || Boolean.TRUE.equals(map.get("isParent"))) continue;
                columnListMap1.add(map);
            }
            columnListMap = columnListMap1;
            if (rowListMap.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c\u7ef4\u6210\u5458", (String)"DimensionSelectPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            if (columnListMap.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5217\u7ef4\u6210\u5458", (String)"DimensionSelectPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            HashMap returnData = new HashMap();
            returnData.put("row", rowListMap);
            returnData.put("column", columnListMap);
            this.getView().setReturnData(returnData);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if ("btn_cancel".equals(key)) {
            this.getView().close();
        }
    }

    private void buildTree(String treeViewId, String dimensionEntityId, List<QFilter> filters) {
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)dimensionEntityId, (String)"isleaf,id,number,name,parent.number as parent", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        for (DynamicObject obj : dcs) {
            TreeNode leftRoot = new TreeNode();
            String number = obj.getString("number");
            String name = obj.getString("name");
            String parentid = obj.getString("parent");
            leftRoot.setId(number);
            leftRoot.setText(name);
            leftRoot.setType(number);
            leftRoot.setParentid(parentid);
            nodeList.add(leftRoot);
        }
        List treeNodes = TreeUtils.buildWithChildren(nodeList);
        TreeNode leftRoot = this.createRoot();
        leftRoot.addChildren(treeNodes);
        this.setTreeNode(treeViewId, leftRoot);
        this.clearSelectedList(treeViewId.equalsIgnoreCase(ROW_TREE) ? "row" : "column");
    }

    private TreeNode createRoot() {
        TreeNode columnRoot = new TreeNode();
        columnRoot.setId("ROOT");
        columnRoot.setText(ResManager.loadKDString((String)"\u6839\u8282\u70b9", (String)"DimensionSelectPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]));
        columnRoot.setParentid("");
        return columnRoot;
    }

    private void setTreeNode(String treeName, TreeNode rootNode) {
        TreeView treeView = (TreeView)this.getView().getControl(treeName);
        treeView.deleteAllNodes();
        treeView.addNode(rootNode);
        rootNode.setIsOpened(true);
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        ArrayList<QFilter> defaultFilters = this.getDefaultFilters();
        BasedataEdit edit = (BasedataEdit)afterF7SelectEvent.getSource();
        String key = edit.getKey();
        String treeViewId = SEARCH_MAP.get(key);
        ListSelectedRowCollection selectedRowCollection = afterF7SelectEvent.getListSelectedRowCollection();
        List inputValues = afterF7SelectEvent.getInputValues();
        List inputTexts = afterF7SelectEvent.getInputTexts();
        if (selectedRowCollection != null && selectedRowCollection.size() > 0) {
            defaultFilters.add(new QFilter("id", "in", (Object)selectedRowCollection.getPrimaryKeyValues()));
            this.buildTree(treeViewId, TREE_MAP.get(treeViewId), defaultFilters);
        } else if (inputValues != null && inputValues.size() > 0) {
            List collect = inputValues.stream().map(a -> Long.parseLong(a.toString())).collect(Collectors.toList());
            defaultFilters.add(new QFilter("id", "in", collect));
            this.buildTree(treeViewId, TREE_MAP.get(treeViewId), defaultFilters);
        } else if (EmptyCheckUtils.isNotEmpty((Object)inputTexts)) {
            ArrayList<String> numbers = new ArrayList<String>(16);
            for (String inputText : inputTexts) {
                if (inputText == null) continue;
                String[] split = inputText.split(",");
                numbers.addAll(Arrays.asList(split));
            }
            if (numbers.size() > 0) {
                defaultFilters.add(new QFilter("number", "in", numbers));
                this.buildTree(treeViewId, TREE_MAP.get(treeViewId), defaultFilters);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ArrayList<QFilter> defaultFilters = this.getDefaultFilters();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.getTreeFilterParameter().setQFilters(defaultFilters);
        formShowParameter.getListFilterParameter().setQFilters(defaultFilters);
    }
}

