/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.multidimension;

import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.common.enums.DeclareConfExtraTableEnum;

public class ExportDeclareConfScriptPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(ExportDeclareConfScriptPlugin.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    public static final String START = "1900-01-01 00:00:00";
    public static final String END = "2055-01-01 00:00:00";
    public static final int CODEMAXLENTH = 100000;
    private static final String t_tpo_rowcol_mapping = "t_tpo_rowcol_mapping";
    private static final String t_tpo_rowcol_mapping_fields = "FID,FNUMBER,FNAME,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FISPRESIT";
    private static final String t_tpo_rowcol_mapping_l = "t_tpo_rowcol_mapping_l";
    private static final String t_tpo_rowcol_mapping_fields1 = "FPKID,FID,FLOCALEID,FNAME";
    private static final String t_tpo_row_mapping = "t_tpo_row_mapping";
    private static final String t_tpo_row_mapping_fields = "FID,FENTRYID,FSEQ,FROW,FISRPRESIT,FROWNAME,FROWMEMBER";
    private static final String t_tpo_col_mapping = "t_tpo_col_mapping";
    private static final String t_tpo_col_mapping_fields = "FID,FENTRYID,FSEQ,FCOLUMN,FISCPRESIT,FCOLUMNNAME,FCOLUMNMEMBER";
    private static final String t_tpo_row_member = "t_tpo_row_member";
    private static final String t_tpo_row_member_fields = "FID,FNUMBER,FNAME,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FLONGNUMBER,FLEVEL,FISLEAF,FPARENTID,FREMARK,FSYSPRESET,FMODEL,FDIMENSION";
    private static final String t_tpo_col_member = "t_tpo_col_member";
    private static final String t_tpo_col_member_fields = "FID,FNUMBER,FNAME,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FLONGNUMBER,FLEVEL,FISLEAF,FPARENTID,FDATATYPE,FSYSPRESET,FREMARK,FMODEL,FDIMENSION,FFORMAT,FMINLENGTH,FMAXLENGTH";
    private static final String t_tpo_report_item = "t_tpo_report_item";
    private static final String t_tpo_report_item_fields = "FID,FNUMBER,FMODELID,FROWID,FFCOLUMNID,FNAME,FLONGNAME,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID";
    private static final Set<String> upd_entitys = Sets.newHashSet((Object[])new String[]{DeclareConfExtraTableEnum.COL_MEMBER.getEntity(), DeclareConfExtraTableEnum.ROW_MEMBER.getEntity(), DeclareConfExtraTableEnum.REPORT_ITEM.getEntity()});

    public void initialize() {
        this.addClickListeners(new String[]{"exportscript"});
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        switch (control.getKey()) {
            case "exportscript": {
                this.execScript();
                break;
            }
        }
    }

    private void execScript() {
        boolean bDownloadfile = (Boolean)this.getModel().getValue("downloadfile");
        boolean templaterel = (Boolean)this.getModel().getValue("templaterel");
        boolean templateupd = (Boolean)this.getModel().getValue("templateupd");
        boolean combinefile = (Boolean)this.getModel().getValue("combinefile");
        String textfield = (String)this.getModel().getValue("textfield");
        String routefield = "taxc";
        String orderfield = "";
        Long modelId = (Long)this.getModel().getValue("model_id");
        Long templateId = (Long)this.getModel().getValue("template_id");
        Date startTime = (Date)this.getModel().getValue("starttime");
        Date endTime = (Date)this.getModel().getValue("endtime");
        String rowMemberIdList = this.getFieldFilterStr("rowmember");
        String colMemberIdList = this.getFieldFilterStr("colmember");
        String reportItemIdList = "";
        String ruleFetchIdList = this.getFieldFilterStr("rulefetch");
        String ruleStyleIdList = this.getFieldFilterStr("rulestyle");
        String ruleCheckIdList = this.getFieldFilterStr("rulecheck");
        String ruleFetchTempIdList = "";
        String ruleStyleTempIdList = "";
        String ruleCheckTempIdList = "";
        if (templaterel) {
            rowMemberIdList = this.filterByTemplateId(rowMemberIdList, templateId, DeclareConfExtraTableEnum.ROW_MEMBER.getTempRelSql());
            colMemberIdList = this.filterByTemplateId(colMemberIdList, templateId, DeclareConfExtraTableEnum.COL_MEMBER.getTempRelSql());
            reportItemIdList = this.filterByTemplateId(reportItemIdList, templateId, DeclareConfExtraTableEnum.REPORT_ITEM.getTempRelSql());
            ruleFetchIdList = this.filterByTemplateId(ruleFetchIdList, templateId, DeclareConfExtraTableEnum.RULE_FETCH.getTempRelSql());
            ruleStyleIdList = this.filterByTemplateId(ruleStyleIdList, templateId, DeclareConfExtraTableEnum.RULE_STYLE.getTempRelSql());
            ruleCheckIdList = this.filterByTemplateId(ruleCheckIdList, templateId, DeclareConfExtraTableEnum.RULE_CHECK.getTempRelSql());
            ruleFetchTempIdList = this.filterByTemplateId(ruleFetchTempIdList, templateId, DeclareConfExtraTableEnum.REP_IT_FETCH_RE.getTempRelSql());
            ruleStyleTempIdList = this.filterByTemplateId(ruleStyleTempIdList, templateId, DeclareConfExtraTableEnum.TEMP_REP_RELATION.getTempRelSql());
            ruleCheckTempIdList = this.filterByTemplateId(ruleCheckTempIdList, templateId, DeclareConfExtraTableEnum.REP_IT_CHECK_RE.getTempRelSql());
        }
        if (this.getModel().getValue("template") == null) {
            this.getView().showErrorNotification("Please Select Template!");
            return;
        }
        String templateType = ((DynamicObject)this.getModel().getValue("template")).getString("type.number");
        StringBuilder sqlStr = new StringBuilder();
        HashMap<String, Object> combineMap = new HashMap<String, Object>(4);
        for (DeclareConfExtraTableEnum tableEnum : DeclareConfExtraTableEnum.values()) {
            List result;
            String entryTable;
            String entity = tableEnum.getEntity();
            if (templateupd && templaterel && upd_entitys.contains(entity) || !StringUtil.isNotBlank((CharSequence)entity)) continue;
            EntityInfo entityInfo = MetadataUtil.getEntityById((String)tableEnum.getEntity());
            String fromfield = entityInfo.getTableName();
            String selectFieldStr = tableEnum.getEntityFields();
            if (StringUtil.isBlank((CharSequence)selectFieldStr) || selectFieldStr.equals("*")) {
                StringBuilder selectField = new StringBuilder();
                List fieldList = entityInfo.getFieldList();
                fieldList.forEach(e -> {
                    if (StringUtil.isEmpty((CharSequence)e.getColumnName()) || e.getFieldType().equals("MuliLangText") || "t_tctb_template_taxtype".equals(e.getColumnName())) {
                        return;
                    }
                    selectField.append(e.getColumnName()).append(',');
                });
                selectFieldStr = selectField.substring(0, selectField.length() - 1);
            }
            String wherefield = tableEnum.getEntityFilter();
            wherefield = this.parseFilter(wherefield, modelId, templateId, templateType, startTime, endTime);
            if (fromfield.equals(t_tpo_row_member) && StringUtil.isNotBlank((CharSequence)rowMemberIdList)) {
                wherefield = wherefield + rowMemberIdList;
            }
            if (fromfield.equals(t_tpo_col_member) && StringUtil.isNotBlank((CharSequence)colMemberIdList)) {
                wherefield = wherefield + colMemberIdList;
            }
            if (fromfield.equals(t_tpo_report_item)) {
                if (StringUtil.isNotBlank((CharSequence)rowMemberIdList)) {
                    rowMemberIdList = rowMemberIdList.replace("fid", "frowid");
                    wherefield = wherefield + rowMemberIdList;
                }
                if (StringUtil.isNotBlank((CharSequence)colMemberIdList)) {
                    colMemberIdList = colMemberIdList.replace("fid", "ffcolumnid");
                    wherefield = wherefield + colMemberIdList;
                }
            }
            if (fromfield.equals("t_tpo_rule_fetch") && StringUtil.isNotBlank((CharSequence)ruleFetchIdList)) {
                wherefield = wherefield + ruleFetchIdList;
            }
            if (fromfield.equals("t_tpo_rule_style") && StringUtil.isNotBlank((CharSequence)ruleStyleIdList)) {
                wherefield = wherefield + ruleStyleIdList;
            }
            if (fromfield.equals("t_tpo_rule_check") && StringUtil.isNotBlank((CharSequence)ruleCheckIdList)) {
                wherefield = wherefield + ruleCheckIdList;
            }
            if (fromfield.equals(t_tpo_report_item) && StringUtil.isNotBlank((CharSequence)reportItemIdList)) {
                wherefield = wherefield + reportItemIdList;
            }
            if (fromfield.equals("t_tpo_template_rule_fetch") && StringUtil.isNotBlank((CharSequence)ruleFetchTempIdList)) {
                wherefield = wherefield + ruleFetchTempIdList;
            }
            if (fromfield.equals("t_tpo_template_rule_style") && StringUtil.isNotBlank((CharSequence)ruleStyleTempIdList)) {
                wherefield = wherefield + ruleStyleTempIdList;
            }
            if (fromfield.equals("t_tpo_template_rule_check") && StringUtil.isNotBlank((CharSequence)ruleCheckTempIdList)) {
                wherefield = wherefield + ruleCheckTempIdList;
            }
            Map<String, Object> map = this.getSqlMap(routefield, fromfield, selectFieldStr, wherefield, orderfield, textfield);
            String sql = (String)map.get("sql");
            if (bDownloadfile) {
                if (combinefile) {
                    this.downloadXmlFile(map);
                } else {
                    this.downloadFile(map, fromfield);
                }
            }
            sqlStr.append(sql);
            String table = tableEnum.getExtTable();
            if (StringUtil.isNotBlank((CharSequence)table)) {
                List result2 = DBUtils.query((String)("select fid from " + fromfield + " where " + wherefield));
                if (CollectionUtils.isEmpty((Collection)result2)) continue;
                StringBuilder entryIdListStr = new StringBuilder();
                if ("t_tctb_template_type_det".equals(table)) {
                    result2.forEach(e -> entryIdListStr.append("'").append(e.get("FID").toString()).append("'").append(','));
                } else {
                    result2.forEach(e -> entryIdListStr.append(e.get("FID").toString()).append(','));
                }
                String entryIdList = entryIdListStr.substring(0, entryIdListStr.length() - 1);
                String tableWherefield = tableEnum.getTableFilter();
                if (tableWherefield.contains("{entityId}")) {
                    tableWherefield = tableWherefield.replace("{entityId}", entryIdList);
                }
                Map<String, Object> map2 = this.getSqlMap(routefield, table, tableEnum.getTableFields(), tableWherefield, orderfield, textfield);
                String sql2 = (String)map2.get("sql");
                if (bDownloadfile) {
                    if (combinefile) {
                        this.downloadXmlFile(map2);
                    } else {
                        this.downloadFile(map2, table);
                    }
                }
                sqlStr.append(sql2);
            }
            if (!StringUtil.isNotBlank((CharSequence)(entryTable = tableEnum.getEntryTable())) || CollectionUtils.isEmpty((Collection)(result = DBUtils.query((String)("select fid from " + fromfield + " where " + wherefield))))) continue;
            StringBuilder entryIdListStr = new StringBuilder();
            if ("t_tctb_template_type_det".equals(entryTable)) {
                result.forEach(e -> entryIdListStr.append("'").append(e.get("FID").toString()).append("'").append(','));
            } else {
                result.forEach(e -> entryIdListStr.append(e.get("FID").toString()).append(','));
            }
            String entryIdList = entryIdListStr.substring(0, entryIdListStr.length() - 1);
            String tableWherefield = String.format("fid in (%s)", entryIdList);
            Map<String, Object> map2 = this.getSqlMap(routefield, entryTable, tableEnum.getEntryTableFields(), tableWherefield, orderfield, textfield);
            String sql2 = (String)map2.get("sql");
            if (bDownloadfile) {
                if (combinefile) {
                    this.downloadXmlFile(map2);
                } else {
                    this.downloadFile(map2, entryTable);
                }
            }
            sqlStr.append(sql2);
        }
        if (combinefile) {
            combineMap.put("sql", sqlStr.toString());
            this.downloadFile(combineMap, "tpo_multi_declare_presit_data");
        }
        if (templateupd && templaterel) {
            this.exportTemplateUpdate(bDownloadfile, textfield, routefield, orderfield, templateId);
        }
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
        if (sqlStr.length() > 100000) {
            String text = String.format(ResManager.loadKDString((String)"\u811a\u672c\u592a\u5927\uff0c\u5c06\u88ab\u622a\u65ad ...%1$s%2$s", (String)"ExportDeclareConfScriptPlugin1", (String)"taxc-tpo", (Object[])new Object[0]), System.lineSeparator(), sqlStr.substring(0, 100000));
            codeSQLshow.setText(text);
        } else {
            codeSQLshow.setText(sqlStr.toString());
        }
    }

    private void exportTemplateUpdate(boolean bDownloadfile, String textfield, String routefield, String orderfield, Long templateId) {
        StringBuilder sqlStr = new StringBuilder();
        Set<String> tempMetadata = this.getTempMetadata(templateId);
        String numbers = tempMetadata.stream().map(a -> "'" + a + "'").collect(Collectors.joining(","));
        String where = String.format("fnumber in (%s)", numbers);
        String sql = String.format("select %s from %s where %s", "FID", t_tpo_rowcol_mapping, where);
        List result = DBUtils.query((String)sql);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            String fidStr = result.stream().map(a -> String.valueOf(a.get("FID"))).collect(Collectors.joining(","));
            this.dealTable(bDownloadfile, textfield, routefield, orderfield, sqlStr, t_tpo_rowcol_mapping, t_tpo_rowcol_mapping_fields, where);
            where = String.format("fid in (%s)", fidStr);
            this.dealTable(bDownloadfile, textfield, routefield, orderfield, sqlStr, t_tpo_rowcol_mapping_l, t_tpo_rowcol_mapping_fields1, where);
            this.dealTable(bDownloadfile, textfield, routefield, orderfield, sqlStr, t_tpo_row_mapping, t_tpo_row_mapping_fields, where);
            this.dealTable(bDownloadfile, textfield, routefield, orderfield, sqlStr, t_tpo_col_mapping, t_tpo_col_mapping_fields, where);
            result = DBUtils.query((String)String.format("select %s from %s where %s", "FROWMEMBER", t_tpo_row_mapping, where));
            String rowfidStr = result.stream().map(a -> String.valueOf(a.get("FROWMEMBER"))).collect(Collectors.joining(","));
            String rowWhere = String.format("fid in (%s)", rowfidStr);
            result = DBUtils.query((String)String.format("select %s from %s where %s", "FPARENTID", t_tpo_row_member, rowWhere));
            String rowParentidStr = result.stream().map(a -> String.valueOf(a.get("FPARENTID"))).distinct().collect(Collectors.joining(","));
            rowWhere = String.format("fid in (%s,%s)", rowfidStr, StringUtil.isNotBlank((CharSequence)rowParentidStr) ? rowParentidStr : "0");
            this.dealTable(bDownloadfile, textfield, routefield, orderfield, sqlStr, t_tpo_row_member, t_tpo_row_member_fields, rowWhere);
            this.dealTable(bDownloadfile, textfield, routefield, orderfield, sqlStr, DeclareConfExtraTableEnum.ROW_MEMBER.getExtTable(), DeclareConfExtraTableEnum.ROW_MEMBER.getTableFields(), rowWhere);
            result = DBUtils.query((String)String.format("select %s from %s where %s", "FCOLUMNMEMBER", t_tpo_col_mapping, where));
            String colfidStr = result.stream().map(a -> String.valueOf(a.get("FCOLUMNMEMBER"))).collect(Collectors.joining(","));
            String colWhere = String.format("fid in (%s)", colfidStr);
            result = DBUtils.query((String)String.format("select %s from %s where %s", "FPARENTID", t_tpo_col_member, colWhere));
            String colParentidStr = result.stream().map(a -> String.valueOf(a.get("FPARENTID"))).distinct().collect(Collectors.joining(","));
            colWhere = String.format("fid in (%s,%s)", colfidStr, StringUtil.isNotBlank((CharSequence)colParentidStr) ? colParentidStr : "0");
            this.dealTable(bDownloadfile, textfield, routefield, orderfield, sqlStr, t_tpo_col_member, t_tpo_col_member_fields, colWhere);
            this.dealTable(bDownloadfile, textfield, routefield, orderfield, sqlStr, DeclareConfExtraTableEnum.COL_MEMBER.getExtTable(), DeclareConfExtraTableEnum.COL_MEMBER.getTableFields(), colWhere);
            String reportWhere = String.format("frowid in (%s) and ffcolumnid  in (%s) ", rowfidStr, colfidStr);
            result = DBUtils.query((String)String.format("select %s from %s where %s", "FID", t_tpo_report_item, reportWhere));
            String reportItemIdStr = result.stream().map(a -> String.valueOf(a.get("FID"))).collect(Collectors.joining(","));
            reportWhere = String.format("fid in (%s) ", reportItemIdStr);
            this.dealTable(bDownloadfile, textfield, routefield, orderfield, sqlStr, t_tpo_report_item, t_tpo_report_item_fields, reportWhere);
            this.dealTable(bDownloadfile, textfield, routefield, orderfield, sqlStr, DeclareConfExtraTableEnum.REPORT_ITEM.getExtTable(), DeclareConfExtraTableEnum.REPORT_ITEM.getTableFields(), reportWhere);
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("sql", sqlStr.toString());
            this.downloadFile(map, "tpo_template_update_all_presit_data");
        }
    }

    private void dealTable(boolean bDownloadfile, String textfield, String routefield, String orderfield, StringBuilder sqlStr, String table, String fields, String where) {
        Map<String, Object> map2 = this.getSqlMap(routefield, table, fields, where, orderfield, textfield);
        String sql2 = (String)map2.get("sql");
        sqlStr.append(sql2);
    }

    private String filterByTemplateId(String rowMemberIdList, Long templateId, String tempRelSql) {
        String replaceSql = tempRelSql.replace("{templateid}", String.valueOf(templateId));
        List query = DBUtils.query((String)replaceSql);
        String ids = query.stream().map(a -> String.valueOf(a.get("ID"))).collect(Collectors.joining(","));
        if (query.size() > 0) {
            String filter = String.format(" and fid in (%s)", ids);
            if (StringUtil.isNotBlank((CharSequence)rowMemberIdList)) {
                return rowMemberIdList + filter;
            }
            return filter;
        }
        String filter = " and 1 != 1";
        if (StringUtil.isNotBlank((CharSequence)rowMemberIdList)) {
            return rowMemberIdList + filter;
        }
        return filter;
    }

    private String getFieldFilterStr(String fieldName) {
        DynamicObjectCollection collection = (DynamicObjectCollection)this.getModel().getValue(fieldName);
        StringBuilder memberIdListStr = new StringBuilder();
        String memberIdList = "";
        if (collection.size() > 0) {
            memberIdListStr.append(" and fid in (");
            collection.forEach(e -> memberIdListStr.append(((DynamicObject)e.get("fbasedataid")).getLong("id")).append(","));
            memberIdList = memberIdListStr.substring(0, memberIdListStr.length() - 1) + ")";
        }
        return memberIdList;
    }

    private Map<String, Object> getSqlMap(String routefield, String fromfield, String selectFieldStr, String wherefield, String orderfield, String textfield) {
        Map map;
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)routefield), fromfield, selectFieldStr, wherefield, orderfield, textfield);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        return map;
    }

    private String parseFilter(String filterStr, Long modelId, Long templateId, String templateType, Date startTime, Date endTime) {
        String filter = filterStr;
        if (filter.contains("{modelId}")) {
            filter = filter.replace("{modelId}", String.valueOf(modelId));
        }
        if (filter.contains("{templateId}")) {
            filter = filter.replace("{templateId}", String.valueOf(templateId));
        }
        if (filter.contains("{templateType}")) {
            filter = filter.replace("{templateType}", templateType);
        }
        String start = "";
        String end = "";
        start = startTime == null ? START : DateUtils.format((Date)startTime, (String)"yyyy-MM-dd HH:mm:ss");
        end = endTime == null ? END : DateUtils.format((Date)endTime, (String)"yyyy-MM-dd HH:mm:ss");
        if (filter.contains("{startTime}")) {
            filter = filter.replace("{startTime}", start);
        }
        if (filter.contains("{endTime}")) {
            filter = filter.replace("{endTime}", end);
        }
        return filter;
    }

    private void downloadFile(Map<String, Object> map, String fileName) {
        String sql = (String)map.get("sql");
        if (StringUtil.isNotBlank((CharSequence)sql)) {
            String sqlFileName = String.format("%s_%s.sql", fileName, new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            try (ByteArrayInputStream ins = new ByteArrayInputStream(sql.getBytes(StandardCharsets.UTF_8));){
                this.exportFile(ins, sqlFileName);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
            }
        }
        this.downloadXmlFile(map);
    }

    private void downloadXmlFile(Map<String, Object> map) {
        Object xml = map.get("xml");
        if (xml != null) {
            HashMap longTextDataFile = (HashMap)xml;
            for (Map.Entry entry : longTextDataFile.entrySet()) {
                StringWriter sw = (StringWriter)entry.getValue();
                byte[] barray = sw.toString().getBytes(StandardCharsets.UTF_8);
                try {
                    ByteArrayInputStream ins1 = new ByteArrayInputStream(barray);
                    Throwable throwable = null;
                    try {
                        this.exportFile(ins1, (String)entry.getKey());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ins1 == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)ins1).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)ins1).close();
                    }
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
                }
            }
        }
    }

    private void downloadFileBatch(String sql, String fileName) {
        String sqlFileName = String.format("%s_%s.sql", fileName, new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sql.getBytes(StandardCharsets.UTF_8));){
            this.exportFile(ins, sqlFileName);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
        }
    }

    private void exportFile(InputStream ins, String sqlFileName) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, ins, 5000);
        this.getView().openUrl(url);
    }

    private Set<String> getTempMetadata(long templateId) {
        Map metadata = TemplateFormulaServiceHelper.getMetaDataListByTmpId((Long)templateId);
        return new HashSet<String>(metadata.values());
    }
}

