/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.multidimension;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.Spread;
import kd.bos.form.spread.SpreadActionAdapter;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.refactor.template.domain.SpreadConstants;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tpo.formplugin.multidimension.MultiDiTemplateEditPlugin;
import kd.taxc.tpo.formplugin.multidimension.SpreadCallBack;

public class MulDiSpreadDataModel
extends SpreadActionAdapter {
    private static final String lastSelect = "lastselect";
    private static final String CONTROLSTATES = "controlstates";
    private static final String SHEET_NAME = "sheetName";
    private static Log logger = LogFactory.getLog(MulDiSpreadDataModel.class);
    private static final String selCols = "selCols";
    private static final String selRows = "selRows";
    private static final String selectCellKey = "selCellKey";
    private String spreadName;
    private static final String METHOD = "method";
    private static final String INDEX = "index";
    private static final String VISIBLE = "visible";
    private static final String CURRENT_SHEET_NAME = "currentSheetName";
    private static final String CURRENT_SHEET_INDEX = "currentIndex";
    private String entityTemplate;
    private IPageCache pageCache;
    private static final List<String> BLACKLIST = Collections.singletonList("tpo_batch_member_preview");

    public MulDiSpreadDataModel(AbstractFormPlugin plugin, String spreadName, String entityTemplate) {
        super(plugin);
        this.spreadName = spreadName;
        this.entityTemplate = entityTemplate;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    public void setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public void selectedSpread(SpreadEvent event) {
        if (StringUtil.isNotBlank((CharSequence)this.entityTemplate) && BLACKLIST.contains(this.entityTemplate)) {
            return;
        }
        logger.info("\u8c03\u7528SpreadDataModel.selectedSpread()");
        if (event == null) {
            return;
        }
        if (this.pageCache.get(CURRENT_SHEET_NAME) != null) {
            this.cacheSheetName(this.pageCache.get(CURRENT_SHEET_NAME));
            this.pageCache.remove(CURRENT_SHEET_NAME);
        }
        SpreadPostDataInfo postDataInfo = event.getPostData();
        List selColsList = postDataInfo.getSelCols();
        List selRowsList = postDataInfo.getSelRows();
        if (this.plugin instanceof SpreadCallBack) {
            String json = this.getPageCache().get("templatejson");
            if (StringUtils.isNotEmpty((CharSequence)json) && !"{}".equals(json)) {
                Map<String, Object> cellParamMap = this.resolveCellKey(event, json, null);
                cellParamMap.put("SpreadEvent", event);
                ((SpreadCallBack)this.plugin).selectedCallBack(cellParamMap);
            }
        } else {
            IDataModel model = this.plugin.getView().getModel();
            String json = (String)model.getValue("content_tag");
            Object id = model.getValue("id");
            Map<String, Object> cellParamMap = this.resolveCellKey(event, json, id);
            TreeUtils.putCache((IPageCache)this.plugin.getPageCache(), (String)selCols, (Object)selColsList);
            TreeUtils.putCache((IPageCache)this.plugin.getPageCache(), (String)selRows, (Object)selRowsList);
            TreeUtils.putCache((IPageCache)this.plugin.getPageCache(), (String)selectCellKey, (Object)JsonUtil.toJson(cellParamMap));
            TreeUtils.putCache((IPageCache)this.plugin.getPageCache(), (String)lastSelect, (Object)SerializationUtils.toJsonString((Object)event.getPostData()));
            if (this.plugin instanceof MultiDiTemplateEditPlugin) {
                ((MultiDiTemplateEditPlugin)this.plugin).selectedCallBack(cellParamMap);
            }
        }
    }

    public List<Integer> getSelCols() {
        return (List)TreeUtils.getCache((IPageCache)this.plugin.getPageCache(), (String)selCols, List.class);
    }

    public Integer getCurrentSheetIndex() {
        return (Integer)TreeUtils.getCache((IPageCache)this.plugin.getPageCache(), (String)CURRENT_SHEET_INDEX, Integer.class);
    }

    public String getCurrentSheetName() {
        Map spreadmap;
        Map map;
        String controlstates;
        if (this.pageCache != null && StringUtils.isNotEmpty((CharSequence)(controlstates = this.getPageCache().get(CONTROLSTATES))) && !(map = (Map)SerializationUtils.fromJsonString((String)controlstates, Map.class)).isEmpty() && (spreadmap = (Map)map.get("spreadap")) != null && !spreadmap.isEmpty()) {
            return (String)spreadmap.get(SHEET_NAME);
        }
        return null;
    }

    public String getSelectedCellKey() {
        logger.info("\u8c03\u7528SpreadDataModel.getSelectedCellKey(),\u8fd4\u56de:{}", TreeUtils.getCache((IPageCache)this.plugin.getPageCache(), (String)selectCellKey, String.class));
        return (String)TreeUtils.getCache((IPageCache)this.plugin.getPageCache(), (String)selectCellKey, String.class);
    }

    public void reSelectLastCell() {
        logger.info("\u8c03\u7528SpreadDataModel.reSelectLastCell()");
        String eventJson = (String)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)lastSelect, String.class);
        if (StringUtils.isNotEmpty((CharSequence)eventJson)) {
            SpreadPostDataInfo spreadPostDataInfo = (SpreadPostDataInfo)SerializationUtils.fromJsonString((String)eventJson, SpreadPostDataInfo.class);
            Spread spread = (Spread)this.plugin.getControl(this.spreadName);
            this.selectedSpread(new SpreadEvent((Object)spread, spreadPostDataInfo));
        }
    }

    public void updateCellValue(SpreadEvent event) {
        SpreadPostDataInfo postDataInfo = event.getPostData();
        List list = postDataInfo.getValues();
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "updataValue", new Object[]{list});
    }

    public List<Integer> getSelRows() {
        return (List)TreeUtils.getCache((IPageCache)this.plugin.getPageCache(), (String)selRows, List.class);
    }

    public void init() {
        String s = "{}";
        this.setSpreadJson(s);
    }

    public void setCellStyle(List<Map<String, Object>> list) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "setCellStyle", new Object[]{list});
    }

    public void updataValue(List<Map<String, Object>> list) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "updataValue", new Object[]{list});
    }

    public void setSpreadJson(String json) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "setSpreadJson", new Object[]{json});
    }

    public void getSpreadJson(Map<String, String> params) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "getSpreadJson", new Object[]{params});
    }

    public void setSpreadParams(Map<String, Object> params) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "setSpreadParams", new Object[]{params});
    }

    public void setFormula(Map<String, Object> params) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "setFormula", new Object[]{params});
    }

    public void setCustomFormulaCell(Map<String, Object> params) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "setCustomFormulaCell", new Object[]{params});
    }

    private IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.plugin.getView().getService(IClientViewProxy.class);
    }

    public void askExecute(SpreadEvent event) {
        logger.info("spread custom event");
        LinkedHashMap map = event.getPostData().getInvokeParams();
        logger.debug("invoke params:" + map);
        if (!map.isEmpty()) {
            Object method = map.get(METHOD);
            logger.info("request method:" + method);
            this.executeAction(map);
        }
    }

    private void executeAction(Map<String, Object> params) {
        if (!params.isEmpty()) {
            Object method = params.get(METHOD);
            Map<Object, Object> objectMap = new HashMap(16);
            if (StringUtils.isNotBlank((Object)method)) {
                switch (method.toString()) {
                    case "hideSheet": {
                        objectMap = this.assembleRequestMap(params);
                        objectMap.put(VISIBLE, Boolean.FALSE);
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, (String)SpreadConstants.getActionMappings().get(method), new Object[]{objectMap});
                        break;
                    }
                    case "insertSheet": {
                        ArrayList list = new ArrayList(SpreadConstants.getDefaultAddSheetCount());
                        for (int i = 1; i <= SpreadConstants.getDefaultAddSheetCount(); ++i) {
                            HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
                            itemMap.put(INDEX, Integer.parseInt(params.get(INDEX).toString()) + i);
                            itemMap.put("name", "Sheet" + itemMap.get(INDEX));
                            list.add(itemMap);
                        }
                        objectMap.put("sheets", list);
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, (String)SpreadConstants.getActionMappings().get(method), new Object[]{objectMap});
                        break;
                    }
                    case "activeSheetChange": {
                        if (params.get(SHEET_NAME) != null) {
                            this.pageCache.put(CURRENT_SHEET_NAME, params.get(SHEET_NAME).toString());
                        }
                    }
                    case "newTab": {
                        if (this.pageCache != null) {
                            this.pageCache.put(CURRENT_SHEET_INDEX, String.valueOf(params.get(INDEX)));
                        }
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, method.toString(), new Object[]{params});
                        break;
                    }
                    case "deleteSheet": {
                        objectMap = this.assembleRequestMap(params);
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, (String)SpreadConstants.getActionMappings().get(method), new Object[]{objectMap});
                        break;
                    }
                    case "deleteRow": 
                    case "deleteCol": {
                        this.reverseIndexArr(params);
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, method.toString(), new Object[]{params});
                        break;
                    }
                    case "insertRow": 
                    case "insertCol": {
                        this.assembleActionRequestMap(params);
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, method.toString(), new Object[]{params});
                        break;
                    }
                    default: {
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, method.toString(), new Object[]{params});
                    }
                }
            }
        }
    }

    private void assembleActionRequestMap(Map<String, Object> params) {
        Object data = params.get("data");
        if (data instanceof Map) {
            Map map = (Map)data;
            int selectIndex = (Integer)map.get("selectIndex");
            int count = (Integer)map.get("count");
            String dir = (String)map.get("dir");
            ArrayList list = Lists.newArrayListWithExpectedSize((int)count);
            for (int i = 0; i < count; ++i) {
                list.add(selectIndex++);
            }
            params.put("data", list);
            if (StringUtils.isNotEmpty((CharSequence)dir)) {
                params.put("dir", dir);
            }
        }
    }

    private void cacheSheetName(String sheetName) {
        Map map;
        String controlstates;
        if (this.pageCache != null && StringUtils.isNotEmpty((CharSequence)(controlstates = this.getPageCache().get(CONTROLSTATES))) && !(map = (Map)SerializationUtils.fromJsonString((String)controlstates, Map.class)).isEmpty()) {
            HashMap<String, String> spreadmap = (HashMap<String, String>)map.get("spreadap");
            if (spreadmap == null) {
                spreadmap = new HashMap<String, String>(10);
                map.put("spreadap", spreadmap);
            }
            spreadmap.put(SHEET_NAME, sheetName);
            this.pageCache.put(CONTROLSTATES, SerializationUtils.toJsonString((Object)map));
            this.pageCache.saveChanges();
        }
    }

    private Map<String, Object> reverseIndexArr(Map<String, Object> params) {
        List indexs;
        if (params.containsKey("data") && (indexs = (List)params.get("data")) != null) {
            Collections.reverse(indexs);
        }
        return params;
    }

    private Map<String, Object> assembleRequestMap(Map<String, Object> params) {
        Integer index = (Integer)params.get(INDEX);
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        indexList.add(index);
        HashMap<String, Object> requestMap = new HashMap<String, Object>(4);
        requestMap.put(INDEX, indexList);
        return requestMap;
    }

    public Map<String, Object> resolveCellKey(SpreadEvent event, String json, Object id) {
        logger.info("\u8c03\u7528SpreadDataModel.resolveCellKey");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        SpreadPostDataInfo postDataInfo = event.getPostData();
        Spread spread = (Spread)event.getSource();
        IPageCache pageCache = (IPageCache)spread.getView().getService(IPageCache.class);
        if (null != pageCache) {
            Map cacheAll = pageCache.getAll();
            boolean hasFound = false;
            if (!CollectionUtils.isEmpty((Map)cacheAll) && StringUtils.isNotBlank((CharSequence)((CharSequence)cacheAll.get(CONTROLSTATES)))) {
                Map spreadmap;
                Map map = (Map)SerializationUtils.fromJsonString((String)((String)cacheAll.get(CONTROLSTATES)), Map.class);
                List selColsList = postDataInfo.getSelCols();
                List selRowsList = postDataInfo.getSelRows();
                if (!map.isEmpty() && StringUtils.isNotEmpty((CharSequence)json) && (spreadmap = (Map)map.get("spreadap")) != null && !spreadmap.isEmpty() && null != spreadmap.get(SHEET_NAME)) {
                    String sheetName = spreadmap.get(SHEET_NAME).toString();
                    Object templateId = id;
                    String jsonString = json;
                    List sheets = SpreadUtils.getSheets((String)jsonString, (String)sheetName);
                    List columncellList = new ArrayList();
                    if (!sheets.isEmpty()) {
                        List rowList = ((Sheet)sheets.get(0)).getRowList();
                        for (int i = 0; i < rowList.size(); ++i) {
                            if (i != (Integer)selRowsList.get(0)) continue;
                            columncellList = (List)rowList.get(i);
                            break;
                        }
                    }
                    String text = null;
                    Object textName = null;
                    for (Cell cell : columncellList) {
                        if (!((Integer)selRowsList.get(0)).equals(cell.getRow()) || !((Integer)selColsList.get(0)).equals(cell.getCol())) continue;
                        text = cell.getText();
                        if (!StringUtils.isNotEmpty((CharSequence)text) || !text.startsWith("${") || !(text = text.replace("${", "").replace("}", "")).endsWith("%")) break;
                        text = text.replace("%", "");
                        break;
                    }
                    paramMap.put("templateId", templateId);
                    paramMap.put("selectCellKey", text);
                    paramMap.put("selectCellName", textName);
                    hasFound = true;
                }
            }
            if (!hasFound) {
                this.handleSelectedkey(cacheAll, postDataInfo, null, paramMap);
            }
        }
        return paramMap;
    }

    private void handleSelectedkey(Map<String, String> cacheAll, SpreadPostDataInfo postDataInfo, String sheetName, Map<String, Object> paramMap) {
        String templateIdStr;
        List selColsList = postDataInfo.getSelCols();
        List selRowsList = postDataInfo.getSelRows();
        String string = templateIdStr = StringUtils.isEmpty((CharSequence)cacheAll.get("MUTEX_OBJ_ID")) ? cacheAll.get("HMUTEX_OBJ_ID") : cacheAll.get("MUTEX_OBJ_ID");
        if (!CollectionUtils.isEmpty(cacheAll) && StringUtils.isNotEmpty((CharSequence)templateIdStr)) {
            Long templateId = Long.parseLong(templateIdStr);
            logger.info("\u8c03\u7528SpreadDataModel.handleSelectedkey\uff0ctemplateId={}", (Object)templateId);
            DynamicObject templateObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)this.entityTemplate);
            DynamicObjectCollection entryentity = templateObject.getDynamicObjectCollection("entryentity");
            HashMap<String, String> tempColsMap = new HashMap<String, String>(entryentity.size());
            for (DynamicObject dynamicObject : entryentity) {
                DynamicObject cell = (DynamicObject)dynamicObject.get("reportitem");
                if (cell == null) continue;
                String name = cell.getString("name");
                String number = cell.getString("number");
                tempColsMap.put(number, name);
            }
            if (templateObject != null && StringUtils.isNotEmpty((CharSequence)templateObject.getString("content_tag"))) {
                String jsonString = templateObject.getString("content_tag");
                List sheets = SpreadUtils.getSheets((String)jsonString, null);
                List columncellList = new ArrayList();
                if (!sheets.isEmpty()) {
                    List rowList = ((Sheet)sheets.get(0)).getRowList();
                    for (int i = 0; i < rowList.size(); ++i) {
                        if (i != (Integer)selRowsList.get(0)) continue;
                        columncellList = (List)rowList.get(i);
                        break;
                    }
                }
                String text = null;
                for (Cell cell : columncellList) {
                    if (!((Integer)selRowsList.get(0)).equals(cell.getRow()) || !((Integer)selColsList.get(0)).equals(cell.getCol())) continue;
                    text = cell.getText();
                    if (!StringUtils.isNotEmpty((CharSequence)text) || !text.startsWith("${") || !(text = text.replace("${", "").replace("}", "")).endsWith("%")) break;
                    text = text.replace("%", "");
                    break;
                }
                String textName = (String)tempColsMap.get(text);
                paramMap.put("templateId", templateId);
                paramMap.put("selectCellKey", text);
                paramMap.put("selectCellName", textName);
            }
        }
    }
}

