/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.multidimension;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.FireFocusEvent;
import kd.bos.form.control.events.InputFocusListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.multidimension.MultiDiConstant;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.formplugin.multidimension.MulDiSpreadDataModel;
import kd.taxc.tpo.formplugin.multidimension.SpreadCallBack;

public class MultiDiFormulaBzPlugin
extends AbstractFormPlugin
implements InputFocusListener,
SpreadCallBack {
    private static final String FORMULATYPE = "formulatype";
    private static final String EDIT = "edit";
    private static final String OPERATE_TYPE = "operateType";
    private static final String REPORTITEM = "reportitem";
    private static final String FOCUS_KEY = "focusfield";
    private static final String R_FORMULA_FORMAT = "{R[values]}";
    private static final String C_FORMULA_FORMAT = "{C[values]}";
    private static final String P_FORMULA_FORMAT = "{P[values]}";
    private static final String Q_FORMULA_FORMAT = "{Q[values]}";
    private static final String BDTAXR_FORMULA_CONSTANT = "bdtaxr_formula_constant";
    private static final String SPREAD_NAME = "spreadap";
    private static final Map<String, String> operationCharacter = new HashMap<String, String>(){
        {
            this.put("plus", "+");
            this.put("subtract", "-");
            this.put("multiple", "*");
            this.put("divide", "/");
            this.put("equal", "==");
            this.put("less", "<");
            this.put("lessequal", "<=");
            this.put("leftparentheses", "(");
            this.put("greater", ">");
            this.put("greaterequal", ">=");
            this.put("squarebrackets", "<>");
            this.put("rightparentheses", ")");
            this.put("and", "&&");
            this.put("or", "||");
            this.put("clr", "CLR");
            this.put("constant", "constant");
            this.put("if", "if(");
            this.put("comma", ",");
            this.put("qushu", "qushu");
            this.put("param", "param");
            this.put("bbxqs", "bbxqs");
            this.put("sum", "sum");
            this.put("seqno", "seq()");
        }
    };
    private static final String CELLTYPE = "celltype";
    private static final String CHECKTYPE = "checktype";
    private static Map<String, String> CHECKMAP = new HashMap<String, String>(4){
        {
            this.put("formula", ResManager.loadKDString((String)"\u516c\u5f0f", (String)"MultiDiFormulaBzPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
            this.put("name", ResManager.loadKDString((String)"\u516c\u5f0f\u540d\u79f0", (String)"MultiDiFormulaBzPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
            this.put("prompt", ResManager.loadKDString((String)"\u63d0\u793a\u8bed", (String)"MultiDiFormulaBzPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]));
            this.put("title", ResManager.loadKDString((String)"\u6807\u9898", (String)"MultiDiFormulaBzPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]));
        }
    };
    private static ArrayList<String> CHECK_FIELDS = Lists.newArrayList((Object[])new String[]{"number", "formula", "name", "prompt", "title", "datatype", "celltype", "checktype"});
    private static final String DEFAUL_VALUE = MultiDiFormulaBzPlugin.getDefaultValue();

    private static String getDefaultValue() {
        return ResManager.loadKDString((String)"\u5fc5\u586b\u9879", (String)"MultiDiFormulaBzPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]);
    }

    public void initialize() {
        for (Map.Entry<String, String> entry : operationCharacter.entrySet()) {
            String key = entry.getKey().toString().toLowerCase();
            Button btn = (Button)this.getControl(key);
            btn.addClickListener((ClickListener)this);
        }
        TextEdit name = (TextEdit)this.getControl("name");
        name.addInputFocusListener((InputFocusListener)this);
        TextEdit content = (TextEdit)this.getControl("prompt");
        content.addInputFocusListener((InputFocusListener)this);
        MulDiSpreadDataModel spreadDataModel = new MulDiSpreadDataModel(this, SPREAD_NAME, "tpo_template");
        spreadDataModel.setPageCache(this.getPageCache());
        this.getView().addService(ISpreadAction.class, (Object)spreadDataModel);
    }

    private MulDiSpreadDataModel getSpreadDataModel() {
        return (MulDiSpreadDataModel)((Object)this.getView().getService(ISpreadAction.class));
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put(FOCUS_KEY, "name");
        this.getSpreadDataModel().init();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String formulatype = (String)customParams.get(FORMULATYPE);
        String operateType = (String)customParams.get(OPERATE_TYPE);
        String formulaBillId = (String)MultiDiConstant.FORMULA_BILL_TYPE_MAP.get(formulatype);
        this.getView().setVisible(Boolean.FALSE, new String[]{REPORTITEM});
        this.getView().setEnable(Boolean.valueOf(!EDIT.equals(operateType)), new String[]{FORMULATYPE, "model"});
        if (EDIT.equals(operateType)) {
            Object id = customParams.get("pk");
            this.getModel().setValue("id", id);
            DynamicObject formula = BusinessDataServiceHelper.loadSingle(id, (String)formulaBillId);
            if (formula != null) {
                this.getModel().setValue(FORMULATYPE, (Object)formulatype);
                this.getModel().setValue("model", (Object)formula.getString("model.id"));
                this.getModel().setValue("number", (Object)formula.getString("number"));
                this.getModel().setValue("formula", (Object)formula.getString("formula"));
                this.getModel().setValue("name", (Object)formula.getString("name"));
                this.getModel().setValue("description", (Object)formula.getString("description"));
                DynamicObjectCollection entryentity = formula.getDynamicObjectCollection("entryentity");
                if (EmptyCheckUtils.isNotEmpty((Object)entryentity)) {
                    this.getModel().setValue(REPORTITEM, ((DynamicObject)entryentity.get(0)).get(REPORTITEM));
                }
                this.getModel().setValue("description", (Object)formula.getString("description"));
                switch (formulatype) {
                    case "fetch": {
                        this.getModel().setValue("datatype", (Object)formula.getString("datatype"));
                        break;
                    }
                    case "check": {
                        this.getModel().setValue("title", (Object)formula.getString("title"));
                        this.getModel().setValue("prompt", (Object)formula.getString("content"));
                        this.getModel().setValue(CHECKTYPE, formula.get(CHECKTYPE));
                        break;
                    }
                    case "style": {
                        this.getModel().setValue(CELLTYPE, (Object)formula.getString(CELLTYPE));
                    }
                }
            }
        } else {
            Long modelId;
            String fittype = (String)customParams.get("fittype");
            String cellid = (String)customParams.get("cellid");
            this.getModel().setValue(FORMULATYPE, (Object)formulatype);
            if (StringUtil.isNotEmpty((CharSequence)cellid)) {
                this.getModel().setValue(REPORTITEM, (Object)Long.valueOf(cellid));
                this.getView().setEnable(Boolean.FALSE, new String[]{"model"});
            }
            if ((modelId = this.getModelId()) > 0L) {
                this.getModel().setValue("model", (Object)modelId);
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)formulaBillId);
            dynamicObject.set("fittype", (Object)fittype);
            String number = CodeRuleServiceHelper.readNumber((String)formulaBillId, (DynamicObject)dynamicObject, null);
            this.getModel().setValue("number", (Object)number);
        }
        this.setFieldVisible((String)this.getModel().getValue(FORMULATYPE), (String)this.getModel().getValue(CELLTYPE), this.getModel().getValue(REPORTITEM));
    }

    private void setFieldVisible(String formulaType, String cellType, Object cell) {
        this.getView().setVisible(Boolean.valueOf(cell != null), new String[]{REPORTITEM});
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("qushu".equals(key)) {
            this.showQushuForm(this.getView().getFormShowParameter().getCustomParams());
        } else if ("param".equals(key)) {
            this.showRuleListForm(this.getView().getFormShowParameter().getCustomParams());
        } else if ("bbxqs".equals(key)) {
            this.bbxqsClick("cellCallback");
        } else if (null != operationCharacter.get(key)) {
            this.operation(key);
        }
    }

    private void bbxqsClick(String callbackName) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"tpo_template", (boolean)false, (int)0);
        listShowParameter.setStatus(OperationStatus.EDIT);
        listShowParameter.setBillFormId("tpo_template");
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setParentPageId(this.getView().getPageId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callbackName);
        listShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void setValueName(String values, int index, String key) {
        String currentFormular = (String)this.getModel().getValue(key);
        StringBuilder sb = new StringBuilder();
        sb.append(currentFormular);
        if (StringUtils.isBlank((CharSequence)currentFormular)) {
            index = 0;
        }
        sb.insert(index, values);
        this.getModel().setValue(key, (Object)sb.toString());
        FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)key, (int)(index + values.length()));
    }

    private void setValue(String values, int index, String key) {
        String currentFormular = (String)this.getModel().getValue(key);
        StringBuilder sb = new StringBuilder();
        sb.append(currentFormular);
        sb.insert(index, values);
        this.getModel().setValue(key, (Object)sb.toString());
        FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)key, (int)(index + values.length()));
    }

    private void setFormulaValue(String id, String name, String formulaType) {
        String formulaKey;
        String focusKey = this.getPageCache().get(FOCUS_KEY);
        String btnName = formulaType;
        if ("name".equals(focusKey)) {
            String formulaTextName = "name";
            if ("qushu".equals(formulaType)) {
                this.setValueName(R_FORMULA_FORMAT.replace("values", name), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaTextName), formulaTextName);
            } else if ("param".equals(formulaType)) {
                this.setValueName(P_FORMULA_FORMAT.replace("values", name), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaTextName), formulaTextName);
            } else if (REPORTITEM.equals(formulaType)) {
                this.setValueName(Q_FORMULA_FORMAT.replace("values", name), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaTextName), formulaTextName);
            } else if ("constant".equals(formulaType) && StringUtils.isNotBlank((CharSequence)name)) {
                this.setValueName(C_FORMULA_FORMAT.replace("values", name), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaTextName), formulaTextName);
            }
        }
        String string = formulaKey = "name".equals(focusKey) ? "formula" : focusKey;
        if ("qushu".equals(formulaType)) {
            this.setValue(R_FORMULA_FORMAT.replace("values", id), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaKey), formulaKey);
        } else if ("param".equals(formulaType)) {
            this.setValue(P_FORMULA_FORMAT.replace("values", id), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaKey), formulaKey);
        } else if (REPORTITEM.equals(formulaType)) {
            this.setValue(Q_FORMULA_FORMAT.replace("values", id), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaKey), formulaKey);
        } else if ("constant".equals(formulaType) && StringUtils.isNotBlank((CharSequence)name)) {
            this.setValue(C_FORMULA_FORMAT.replace("values", id), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaKey), formulaKey);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection listSelectedRows;
        Object[] primaryKeyValues;
        if (event.getReturnData() == null) {
            return;
        }
        if ("selectQushu".equals(event.getActionId())) {
            ListSelectedRow row;
            String id;
            QFilter q1;
            QFilter[] filters;
            DynamicObject d;
            ListSelectedRowCollection list = (ListSelectedRowCollection)event.getReturnData();
            if (list != null && list.size() > 0 && null != (d = QueryServiceHelper.queryOne((String)"bdtaxr_rule_set", (String)"id,name", (QFilter[])(filters = new QFilter[]{q1 = new QFilter("id", "=", (Object)Long.parseLong(id = (row = list.get(0)).getPrimaryKeyValue().toString()))})))) {
                String name = d.get("name").toString();
                this.setFormulaValue(id, name, "qushu");
            }
        } else if ("callbackRuleList".equals(event.getActionId())) {
            ListSelectedRow row;
            String id;
            QFilter q1;
            QFilter[] filters;
            DynamicObject d;
            ListSelectedRowCollection list = (ListSelectedRowCollection)event.getReturnData();
            if (list != null && list.size() > 0 && null != (d = QueryServiceHelper.queryOne((String)"bdtaxr_datasource_entry", (String)"fieldsubname,fieldname,bizsubname", (QFilter[])(filters = new QFilter[]{q1 = new QFilter("id", "=", (Object)Long.parseLong(id = (row = list.get(0)).getPrimaryKeyValue().toString()))})))) {
                String fieldsubname = d.get("fieldsubname").toString();
                String fieldname = d.get("fieldname").toString();
                String bizsubname = d.get("bizsubname").toString();
                this.setFormulaValue(fieldsubname + '#' + fieldname, fieldsubname + '#' + bizsubname, "param");
            }
        } else if ("selectConstant".equals(event.getActionId())) {
            String constantValue = (String)event.getReturnData();
            this.setFormulaValue(constantValue, constantValue, "constant");
        } else if ("cellCallback".equals(event.getActionId()) && (primaryKeyValues = (listSelectedRows = (ListSelectedRowCollection)event.getReturnData()).getPrimaryKeyValues()) != null && primaryKeyValues.length > 0) {
            Object primaryKeyValue = primaryKeyValues[0];
            DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"tpo_template");
            String json = template.getString("content_tag");
            this.getPageCache().put("templatejson", json);
            this.getPageCache().put("firstflag", "1");
            json = this.replaceCellNumberToName(json);
            this.getSpreadDataModel().setSpreadJson(json);
        }
    }

    private String replaceCellNumberToName(String json) {
        Map<String, String> colsMap = this.getColsMap();
        for (Map.Entry<String, String> ent : colsMap.entrySet()) {
            json = json.replace("${" + ent.getKey() + "}", "${" + ent.getValue() + "}");
        }
        return json;
    }

    private Map<String, String> getColsMap() {
        Map<String, String> colsMap = (Map<String, String>)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"tpo_report_item_allField", Map.class);
        if (colsMap != null) {
            return colsMap;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tpo_report_item", (String)"number ,name", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).toArray());
        colsMap = query.stream().collect(Collectors.toMap(a -> a.getString("number"), b -> b.getString("name"), (m, n) -> m));
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"tpo_report_item_allField", colsMap);
        return colsMap;
    }

    private void showQushuForm(Map<String, Object> customParams) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bdtaxr_rule_set", (boolean)false, (int)0);
        parameter.setStatus(OperationStatus.EDIT);
        if (EmptyCheckUtils.isNotEmpty(customParams)) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(customParams.size());
            qFilterList.add(new QFilter("enable", "=", (Object)"1"));
            parameter.getListFilterParameter().setQFilters(qFilterList);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectQushu");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showRuleListForm(Map<String, Object> customParams) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bdtaxr_datasource_entry", (boolean)false, (int)0);
        parameter.setStatus(OperationStatus.EDIT);
        if (EmptyCheckUtils.isNotEmpty(customParams)) {
            ArrayList qFilterList = new ArrayList(customParams.size());
            parameter.getListFilterParameter().setQFilters(qFilterList);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callbackRuleList");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void operation(String key) {
        String character = operationCharacter.get(key);
        String focusKey = this.getPageCache().get(FOCUS_KEY);
        if (character.equalsIgnoreCase("clr")) {
            this.getModel().setValue(focusKey, (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)focusKey, (int)0);
            if ("name".equals(focusKey)) {
                this.getModel().setValue("formula", (Object)"");
                FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)"formula", (int)0);
            }
        } else if ("backspace".equalsIgnoreCase(character)) {
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)key, (String)focusKey);
            if ("name".equals(focusKey)) {
                FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)key, (String)"formula");
            }
        } else if ("constant".equalsIgnoreCase(character)) {
            this.showConstantForm();
        } else {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)key, (String)focusKey, (String)character);
            if ("name".equals(focusKey)) {
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)key, (String)"formula", (String)character);
            }
        }
    }

    private void showConstantForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(BDTAXR_FORMULA_CONSTANT);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectConstant");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("bar_save".equals(key)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String formulatype = (String)customParams.get(FORMULATYPE);
            String fittype = (String)customParams.get("fittype");
            String checkResult = this.saveCheck(formulatype);
            if (StringUtil.isNotEmpty((CharSequence)checkResult)) {
                String msg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u586b\u5199%s\u3002", (String)"MultiDiFormulaBzPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]), checkResult);
                this.getView().showTipNotification(msg);
                return;
            }
            DynamicObject record = null;
            String formulaBillId = null;
            Long id = (Long)this.getModel().getValue("id");
            if (id != null && id > 0L) {
                formulaBillId = (String)MultiDiConstant.FORMULA_BILL_TYPE_MAP.get(formulatype);
                record = BusinessDataServiceHelper.loadSingle((Object)id, (String)formulaBillId);
            } else {
                formulaBillId = (String)MultiDiConstant.FORMULA_BILL_TYPE_MAP.get(this.getModel().getValue(FORMULATYPE));
                record = BusinessDataServiceHelper.newDynamicObject((String)formulaBillId);
                if ("BBXGZ".equals(fittype) && this.getModel().getValue(REPORTITEM) != null) {
                    Object entryentity = record.getDynamicObjectCollection("entryentity");
                    DynamicObject dynamicObject = entryentity.addNew();
                    dynamicObject.set(REPORTITEM, this.getModel().getValue(REPORTITEM));
                    record.set("fittype", (Object)"BBXGZ");
                } else {
                    record.set("fittype", (Object)"TYXGZ");
                }
            }
            record.set("name", this.getModel().getValue("name"));
            record.set("formula", this.getModel().getValue("formula"));
            record.set("description", this.getModel().getValue("description"));
            record.set("model", this.getModel().getValue("model"));
            record.set("modifytime", (Object)new Date());
            record.set("modifier", (Object)RequestContext.get().getCurrUserId());
            record.set("createtime", (Object)new Date());
            record.set("creator", (Object)RequestContext.get().getCurrUserId());
            record.set("status", (Object)"A");
            record.set("enable", (Object)"1");
            switch (formulatype) {
                case "fetch": {
                    record.set("datatype", this.getModel().getValue("datatype"));
                    break;
                }
                case "check": {
                    record.set("title", this.getModel().getValue("title"));
                    record.set("content", this.getModel().getValue("prompt"));
                    record.set(CHECKTYPE, this.getModel().getValue(CHECKTYPE));
                    break;
                }
                case "style": {
                    record.set(CELLTYPE, this.getModel().getValue(CELLTYPE));
                }
            }
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)formulaBillId, (DynamicObject[])new DynamicObject[]{record}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                operationResult.setMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"MultiDiFormulaBzPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]));
                this.getModel().setValue("id", operationResult.getSuccessPkIds().get(0));
            }
            this.getView().showOperationResult(operationResult);
        } else if ("bar_close".equals(key)) {
            String formulatype = (String)this.getView().getFormShowParameter().getCustomParam(FORMULATYPE);
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put(FORMULATYPE, formulatype);
            customParams.put("id", this.getModel().getValue("id"));
            this.getView().setReturnData(customParams);
            this.getView().returnDataToParent(customParams);
            this.getView().close();
        }
    }

    private Long getModelId() {
        String model = (String)this.getView().getFormShowParameter().getCustomParam("model");
        return StringUtil.isNotEmpty((CharSequence)model) ? Long.parseLong(model) : 0L;
    }

    private String saveCheck(String formulatype) {
        HashMap<String, String> valueMap = new HashMap<String, String>(8);
        for (String field : CHECK_FIELDS) {
            valueMap.put(field, (String)this.getModel().getValue(field));
        }
        if (StringUtil.isEmpty((CharSequence)((CharSequence)valueMap.get("number")))) {
            return CHECKMAP.getOrDefault("number", DEFAUL_VALUE);
        }
        switch (formulatype) {
            case "fetch": {
                for (String s : Arrays.asList("datatype", "name", "formula")) {
                    if (!StringUtil.isEmpty((CharSequence)((CharSequence)valueMap.get(s)))) continue;
                    return CHECKMAP.getOrDefault(s, DEFAUL_VALUE);
                }
                break;
            }
            case "check": {
                for (String s : Arrays.asList("prompt", "title", "formula", "name")) {
                    if (!StringUtil.isEmpty((CharSequence)((CharSequence)valueMap.get(s)))) continue;
                    return CHECKMAP.getOrDefault(s, DEFAUL_VALUE);
                }
                break;
            }
            case "style": {
                List<String> needFormulas = Arrays.asList("1", "6");
                for (String s : Arrays.asList(CELLTYPE, "formula", "name")) {
                    if (!StringUtil.isEmpty((CharSequence)((CharSequence)valueMap.get(s))) || needFormulas.contains(valueMap.get(CELLTYPE))) continue;
                    return CHECKMAP.getOrDefault(s, DEFAUL_VALUE);
                }
                break;
            }
        }
        return "";
    }

    public void inputFocus(FireFocusEvent fireFocusEvent) {
        Control control = (Control)fireFocusEvent.getSource();
        String key = control.getKey();
        if ("name".equals(key)) {
            this.getPageCache().put(FOCUS_KEY, key);
        } else if ("prompt".equals(key)) {
            this.getPageCache().put(FOCUS_KEY, key);
        }
    }

    @Override
    public void selectedCallBack(Map<String, Object> params) {
        Map cacheAll = this.getPageCache().getAll();
        if (cacheAll.containsKey("firstflag")) {
            this.getPageCache().remove("firstflag");
            return;
        }
        if (params != null && params.get("selectCellKey") != null) {
            String focusKey = this.getPageCache().get(FOCUS_KEY);
            String selectCellKey = (String)params.get("selectCellKey");
            String selectCellName = this.getColsMap().get(selectCellKey);
            if (StringUtil.isNotEmpty((CharSequence)selectCellKey)) {
                String formulaKey = "formula";
                this.setValue(Q_FORMULA_FORMAT.replace("values", selectCellKey), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)"bbxqs", (String)formulaKey), formulaKey);
            }
            if ("name".equals(focusKey) && StringUtil.isNotEmpty((CharSequence)selectCellName)) {
                String formulaTextName = "name";
                this.setValueName(Q_FORMULA_FORMAT.replace("values", selectCellName), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)"bbxqs", (String)formulaTextName), formulaTextName);
            }
        }
    }

    public void doubleClickLockedCell(Integer row, Integer cloumn) {
    }

    public void showFormulaPanel(Integer row, Integer cloumn) {
    }
}

