/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.multidimension;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.formplugin.multidimension.MultiDiUtils;

public class MultiDiFormulaConfigPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log LOGGER = LogFactory.getLog(MultiDiFormulaConfigPlugin.class);
    private static final List<String> RULE_KEYS = Lists.newArrayList((Object[])new String[]{"fetchrule", "checkrule", "stylerule"});

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        for (String ruleKey : RULE_KEYS) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(ruleKey);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection dynamicObjects;
        boolean fromTemplate;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().beginInit();
        String templatenum = (String)customParams.get("templatenum");
        String templateid = (String)customParams.get("templateid");
        String cellkey = (String)customParams.get("cellkey");
        String templatetype = (String)customParams.get("templatetype");
        this.getModel().setValue("templatetype", (Object)templatetype);
        this.getModel().setValue("templatenum", (Object)templatenum);
        if (customParams.containsKey("fromTemplate") && (fromTemplate = ((Boolean)customParams.get("fromTemplate")).booleanValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_close", "templatetype", "templatenum"});
            HashMap colorMap = new HashMap(10);
            String border = "0px_solid_#ffffff";
            HashMap<String, String> borderProperties = new HashMap<String, String>(4);
            borderProperties.put("b", border);
            borderProperties.put("l", border);
            borderProperties.put("r", border);
            borderProperties.put("t", border);
            HashMap<String, HashMap<String, String>> style = new HashMap<String, HashMap<String, String>>(1);
            style.put("b", borderProperties);
            colorMap.put("s", style);
            this.getView().updateControlMetadata("flexpanelap1", colorMap);
            HashMap prop = new HashMap(1);
            HashMap<String, String> editor = new HashMap<String, String>(1);
            editor.put("dsp", "number");
            prop.put("item", editor);
            prop.put("w", new LocaleString("350px"));
            this.getView().updateControlMetadata("reportitem", prop);
        }
        if ((dynamicObjects = QueryServiceHelper.query((String)"tpo_report_item", (String)"id", (QFilter[])new QFilter("number", "=", (Object)cellkey).toArray())).size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u9879\u4e0d\u5b58\u5728\uff01", (String)"MultiDiFormulaConfigPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("reportitem", ((DynamicObject)dynamicObjects.get(0)).get("id"));
        QFilter[] qFilter = new QFilter("template", "=", (Object)Long.valueOf(templateid)).and("reportitem.number", "=", (Object)cellkey).toArray();
        DynamicObject fetchRule = QueryServiceHelper.queryOne((String)"tpo_template_rule_fetch", (String)"template, reportitem, formula", (QFilter[])qFilter);
        DynamicObject styleRule = QueryServiceHelper.queryOne((String)"tpo_template_rule_style", (String)"template, reportitem, formula", (QFilter[])qFilter);
        if (fetchRule != null) {
            this.getModel().setValue("fetchrule", fetchRule.get("formula"));
        }
        if (styleRule != null) {
            this.getModel().setValue("stylerule", styleRule.get("formula"));
        }
        DynamicObjectCollection checkRules = QueryServiceHelper.query((String)"tpo_template_rule_check", (String)"template, reportitem, formula", (QFilter[])qFilter, (String)"formula desc");
        this.getModel().getEntryEntity("entryentity").clear();
        if (checkRules.size() > 0) {
            for (DynamicObject checkRule : checkRules) {
                int row = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("checkrule", checkRule.get("formula"), row);
            }
        } else {
            this.getModel().createNewEntryRow("entryentity");
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        block28: {
            Object cellid;
            String templateid;
            Throwable throwable;
            TXHandle h;
            block25: {
                block26: {
                    block27: {
                        key = evt.getItemKey();
                        if (!"bar_save".equals(key)) break block28;
                        h = TX.requiresNew();
                        throwable = null;
                        templateid = (String)this.getView().getFormShowParameter().getCustomParam("templateid");
                        DynamicObject cell = (DynamicObject)this.getModel().getValue("reportitem");
                        if (cell != null) {
                            cellid = cell.get("id");
                            break block25;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u9879\u4e0d\u5b58\u5728\uff01", (String)"MultiDiFormulaConfigPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]));
                        if (h == null) break block26;
                        if (throwable == null) break block27;
                        try {
                            h.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block26;
                    }
                    h.close();
                }
                return;
            }
            try {
                try {
                    DynamicObjectCollection entryentity;
                    Set checkRules;
                    DynamicObject stylerule;
                    QFilter cellFilter = new QFilter("reportitem", "=", cellid);
                    QFilter templateFilter = new QFilter("template", "=", (Object)Long.valueOf(templateid));
                    DynamicObject fetchrule = (DynamicObject)this.getModel().getValue("fetchrule");
                    if (fetchrule != null && !QueryServiceHelper.exists((String)"tpo_template_rule_fetch", (QFilter[])new QFilter[]{cellFilter, templateFilter, new QFilter("formula", "=", fetchrule.get("id"))})) {
                        DeleteServiceHelper.delete((String)"tpo_template_rule_fetch", (QFilter[])new QFilter[]{cellFilter, templateFilter});
                        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tpo_template_rule_fetch");
                        this.setCommonField(dynamicObject, fetchrule.get("id"), cellid, templateid, this.getModelId());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    }
                    if ((stylerule = (DynamicObject)this.getModel().getValue("stylerule")) != null && !QueryServiceHelper.exists((String)"tpo_template_rule_style", (QFilter[])new QFilter[]{cellFilter, templateFilter, new QFilter("formula", "=", stylerule.get("id"))})) {
                        DeleteServiceHelper.delete((String)"tpo_template_rule_style", (QFilter[])new QFilter[]{cellFilter, templateFilter});
                        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tpo_template_rule_style");
                        this.setCommonField(dynamicObject, stylerule.get("id"), cellid, templateid, this.getModelId());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    }
                    if ((checkRules = (entryentity = this.getModel().getEntryEntity("entryentity")).stream().filter(a -> a.get("checkrule") != null).map(b -> ((DynamicObject)b.get("checkrule")).get("id")).collect(Collectors.toSet())).size() > 0) {
                        Sets.SetView saveData;
                        DynamicObjectCollection queryDB = QueryServiceHelper.query((String)"tpo_template_rule_check", (String)"formula", (QFilter[])new QFilter[]{cellFilter, templateFilter});
                        Set dbFormulas = queryDB.stream().map(a -> a.get("formula")).collect(Collectors.toSet());
                        Sets.SetView removeData = Sets.difference(dbFormulas, checkRules);
                        if (!removeData.isEmpty()) {
                            DeleteServiceHelper.delete((String)"tpo_template_rule_check", (QFilter[])new QFilter[]{cellFilter, templateFilter, new QFilter("formula", "in", (Object)removeData)});
                        }
                        if (!(saveData = Sets.difference(checkRules, dbFormulas)).isEmpty()) {
                            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(4);
                            for (Object checkRule : saveData) {
                                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tpo_template_rule_check");
                                this.setCommonField(dynamicObject, checkRule, cellid, templateid, this.getModelId());
                                dynamicObjects.add(dynamicObject);
                            }
                            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
                        }
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"MultiDiFormulaConfigPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]));
                }
                catch (Throwable t) {
                    h.markRollback();
                    LOGGER.error(t);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u53d1\u751f\u9519\u8bef\uff01", (String)"MultiDiFormulaConfigPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]));
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        if ("formulaview".equals(key)) {
            HashMap customeMap = new HashMap();
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"bdtaxr_formulaview", (IFormView)this.getView(), customeMap, (IFormPlugin)this);
        }
    }

    private void setCommonField(DynamicObject dynamicObject, Object ruleid, Object cellid, String templateid, Long modelid) {
        dynamicObject.set("formula", ruleid);
        dynamicObject.set("reportitem", cellid);
        dynamicObject.set("template", (Object)Long.valueOf(templateid));
        dynamicObject.set("model", (Object)modelid);
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createtime", (Object)new Date());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Control control = (Control)beforeF7SelectEvent.getSource();
        String key = control.getKey();
        if (RULE_KEYS.contains(key)) {
            beforeF7SelectEvent.setCancel(true);
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            DynamicObject cell = (DynamicObject)this.getModel().getValue("reportitem");
            if (cell != null) {
                String cellid = cell.getString("id");
                customParams.put("cellid", cellid);
                customParams.put("formulatype", key);
                customParams.put("model", this.getModelId().toString());
                customParams.put("row", beforeF7SelectEvent.getRow());
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("tpo_rule_select_dialog");
                showParameter.setParentPageId(this.getView().getPageId());
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParams(customParams);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "tpo_rule_select_dialog");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62a5\u8868\u9879", (String)"MultiDiFormulaConfigPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndexs = e.getRowIndexs();
        if (rowIndexs != null && rowIndexs.length == 1 && rowIndexs[0] == 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5f97\u5220\u9664", (String)"MultiDiFormulaConfigPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
        }
    }

    private Long getModelId() {
        String model = (String)this.getView().getFormShowParameter().getCustomParam("model");
        if (StringUtil.isEmpty((CharSequence)model)) {
            String templatenum = (String)this.getView().getFormShowParameter().getCustomParam("templatenum");
            DynamicObject temp = QueryServiceHelper.queryOne((String)"tpo_template", (String)"model", (QFilter[])new QFilter("number", "=", (Object)templatenum).toArray());
            return temp.getLong("model");
        }
        return Long.parseLong(model);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        Object data = event.getReturnData();
        if (data != null && "tpo_rule_select_dialog".equals(event.getActionId())) {
            if (Map.class.isAssignableFrom(data.getClass())) {
                Map returnData2 = (Map)data;
                if (returnData2.containsKey("okreturn")) {
                    String formulatype = (String)returnData2.get("formulatype");
                    Object selectedRowPk = returnData2.get("selectedRow");
                    switch (formulatype) {
                        case "fetchrule": {
                            this.getModel().setValue("fetchrule", selectedRowPk);
                            break;
                        }
                        case "checkrule": {
                            int row = (Integer)returnData2.get("row");
                            this.getModel().setValue("checkrule", selectedRowPk, row);
                            break;
                        }
                        case "stylerule": {
                            this.getModel().setValue("stylerule", selectedRowPk);
                        }
                    }
                } else if (returnData2.containsKey("newrule")) {
                    String formulatype = (String)returnData2.get("formulatype");
                    HashMap<String, Object> customParams = new HashMap<String, Object>();
                    DynamicObject cell = (DynamicObject)this.getModel().getValue("reportitem");
                    if (cell != null) {
                        String cellid = cell.getString("id");
                        customParams.put("cellid", cellid);
                    }
                    customParams.put("formulatype", formulatype.replace("rule", ""));
                    customParams.put("fittype", "BBXGZ");
                    customParams.put("operateType", "add");
                    customParams.put("model", this.getModelId().toString());
                    customParams.put("noCloseCallBack", Boolean.TRUE);
                    PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"tpo_formula_bz", (IFormView)this.getView(), customParams, (IFormPlugin)this);
                } else if (returnData2.containsKey("editrule")) {
                    String formulatype = (String)returnData2.get("formulatype");
                    Object selectedRowPk = returnData2.get("selectedRow");
                    MultiDiUtils.openEditRuleBzForm(this.getView(), formulatype.replace("rule", ""), selectedRowPk, (IFormPlugin)this);
                }
            }
        } else if ("tpo_formula_bz".equals(event.getActionId()) && data != null && Map.class.isAssignableFrom(data.getClass()) && (returnData = (Map)data).get("id") != null && returnData.get("formulatype") != null) {
            String formulatype;
            switch (formulatype = (String)returnData.get("formulatype")) {
                case "fetch": {
                    this.getModel().setValue("fetchrule", returnData.get("id"));
                    break;
                }
                case "check": {
                    CardEntry entryentity = (CardEntry)this.getControl("entryentity");
                    int[] selectRows = entryentity.getSelectRows();
                    if (selectRows.length <= 0) break;
                    this.getModel().setValue("checkrule", returnData.get("id"), selectRows[0]);
                    break;
                }
                case "style": {
                    this.getModel().setValue("stylerule", returnData.get("id"));
                }
            }
        }
    }
}

