/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.multidimension;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class MultiDiFormulaSelectPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String BTNOK = "btnok";
    private static final String[] billListaps = new String[]{"billlistap", "billlistap1", "billlistap2"};
    private static final String BILLLISTKEY = "billlistkey";
    public static Map<String, String> BILLLIST_TYPE_MAP = new HashMap<String, String>(4){
        {
            this.put("fetchrule", "billlistap");
            this.put("checkrule", "billlistap1");
            this.put("stylerule", "billlistap2");
        }
    };

    public void registerListener(EventObject e) {
        this.init();
        this.addHyperClickListener("billlistap", "billlistap1", "billlistap2");
    }

    public void initialize() {
        this.init();
    }

    private void init() {
        String billListap;
        BillList billList;
        String formulatype = (String)this.getView().getFormShowParameter().getCustomParam("formulatype");
        if (StringUtil.isNotEmpty((CharSequence)formulatype) && null != (billList = (BillList)this.getControl(billListap = BILLLIST_TYPE_MAP.getOrDefault(formulatype, "billlistap")))) {
            billList.addSetFilterListener(this::setFilter);
        }
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btncancel", BTNOK});
    }

    private void addHyperClickListener(String ... controls) {
        for (String control : controls) {
            BillList billList = (BillList)this.getControl(control);
            billList.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String formulatype = (String)this.getView().getFormShowParameter().getCustomParam("formulatype");
        this.getView().setVisible(Boolean.FALSE, billListaps);
        if (StringUtil.isNotEmpty((CharSequence)formulatype)) {
            switch (formulatype) {
                case "fetchrule": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"billlistap"});
                    this.getPageCache().put(BILLLISTKEY, "billlistap");
                    break;
                }
                case "checkrule": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"billlistap1"});
                    this.getPageCache().put(BILLLISTKEY, "billlistap1");
                    break;
                }
                case "stylerule": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"billlistap2"});
                    this.getPageCache().put(BILLLISTKEY, "billlistap2");
                }
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        String cellid = (String)this.getView().getFormShowParameter().getCustomParam("cellid");
        if (StringUtil.isNotEmpty((CharSequence)cellid)) {
            List qFilters = e.getQFilters();
            QFilter cellQf = new QFilter("entryentity.reportitem.id", "=", (Object)Long.parseLong(cellid)).and("fittype", "=", (Object)"BBXGZ");
            QFilter fittype = new QFilter("fittype", "=", (Object)"TYXGZ").or(cellQf);
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId()).and(fittype);
            qFilters.add(qFilter);
        }
    }

    private Long getModelId() {
        String model = (String)this.getView().getFormShowParameter().getCustomParam("model");
        return StringUtil.isNotEmpty((CharSequence)model) ? Long.parseLong(model) : 0L;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTNOK.equals(key)) {
            String billlistkey = this.getPageCache().get(BILLLISTKEY);
            BillList billList = (BillList)this.getControl(billlistkey);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"MultiDiFormulaSelectPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]));
            } else {
                Map returnData = this.getView().getFormShowParameter().getCustomParams();
                returnData.put("okreturn", Boolean.TRUE);
                returnData.put("selectedRow", selectedRows.get(0).getPrimaryKeyValue());
                this.getView().setReturnData((Object)returnData);
                this.getView().returnDataToParent((Object)returnData);
                this.getView().close();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("newrule".equals(key)) {
            String formulatype = (String)this.getView().getFormShowParameter().getCustomParam("formulatype");
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("formulatype", formulatype);
            customParams.put("newrule", "true");
            this.getView().setReturnData(customParams);
            this.getView().returnDataToParent(customParams);
            this.getView().close();
        } else if ("refresh".equals(key)) {
            String billlistkey = this.getPageCache().get(BILLLISTKEY);
            BillList billList = (BillList)this.getControl(billlistkey);
            billList.refresh();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        Map returnData = this.getView().getFormShowParameter().getCustomParams();
        BillList list = (BillList)args.getSource();
        String formulatype = (String)this.getView().getFormShowParameter().getCustomParam("formulatype");
        returnData.put("editrule", Boolean.TRUE);
        returnData.put("selectedRow", list.getCurrentSelectedRowInfo().getPrimaryKeyValue());
        returnData.put("formulatype", formulatype);
        this.getView().setReturnData((Object)returnData);
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }
}

