/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.multidimension;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.domain.TemplateCacheParams;
import kd.taxc.bdtaxr.common.multidimension.MultiDiConstant;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.crypto.MD5;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.tpo.business.formula.MultiDynamicRowService;
import kd.taxc.tpo.business.multidideclare.BatchMemberSettingService;
import kd.taxc.tpo.business.multidideclare.MultiDiTemplateHelper;
import kd.taxc.tpo.formplugin.multidimension.MulDiSpreadDataModel;
import kd.taxc.tpo.formplugin.multidimension.MultiDiHelper;

public class MultiDiTemplateEditPlugin
extends AbstractFormPlugin {
    private static final String FORMULA_CACHE_CAL = "formulaCacheCal";
    private static final String FORMULA_CACHE_VAL = "formulaCacheVal";
    private static final String FORMULA_CACHE_CELL = "formulaCacheCell";
    private static final String CALLBACK_SELECT_FORMULA = "selectFormula";
    private static final String CALLBACK_DYN_ROW = "dynamicRow";
    public static final String CALLBACK_CELL_TIP = "cellTip";
    private static final String TEMPLATE = "template";
    private static final String ENTRYENTITY = "entryentity";
    private static final String LINKING_CHAR = "|";
    public static final String PROPERTYSET = "propertyset";
    private static Log LOGGER = LogFactory.getLog(MultiDiTemplateEditPlugin.class);
    private static final String DYNROWSET_ENTITY_NAME = "bdtaxr_template_dynrow";
    public static final String CELLTIPSET_ENTITY_NAME = "bdtaxr_celltip";
    private static final String SPREAD_NAME = "spreadap";
    private static final String TEMPLATE_ENTITY_NAME = "tpo_template";
    private static final String BUTTON_SETTING = "btn_setting";
    public static final String BUTTON_CELL_TIP = "btn_celltip";
    private static final String BUTTON_SAVE = "bar_save";
    private static final String BUTTON_VIEW = "btn_view";
    private static final String ACTIONID_SETTIING = "ACTIONID_SETTIING";
    private static final String BUTTON_SETFORMULA = "btn_setformula";
    private static final String BUTTON_FORMULA = "btn_formula";
    private static final String BUTTON_DELETE_FORMULA = "btn_delete_formula";
    private static final String DELETE_CALCULATE_FORMULA = "del_calculate_formula";
    private static final String DELETE_VALIDATE_FORMULA = "del_validate_formula";
    private static final String DELETE_STYLE_FORMULA = "del_style_formula";
    private static final String BUTTON_DYNROW = "btn_dynrow";
    private static final String BUTTON_DYNROWDEL = "btn_dynrowdel";
    private static final String BTN_TYPE = "btn_type";
    private static final String ORIGINAL_ID = "originalId";
    private static final String TEMPLATE_ID = "template_id";
    private static final String ROW = "row";
    private static final String COLUMN = "column";
    private static final String TPO_TEMPLATE_TYPE = "tpo_template_type";
    private static final String ACTION_VIEW = "actionView";
    private static final String TCTB_TEMPLATE_FORMULA = "tpo_template_formula";
    private static final String SELECT_CELL_KEY = "selectCellKey";
    private static final String ACTION_SAVE = "actionSave";
    private static final String DYN_ROW_ALL_KEYS = "id,dynrow_no,rule_name,start_row,enable,rule_id,modifier,creator,template_id,modifytime,createtime,seq_no,group_no,type,pluginpath,disablefrontop,modeltype";
    private static final String bbx_Exp = "\\$\\{(.*?)\\}";

    public void initialize() {
        MulDiSpreadDataModel spreadDataModel = new MulDiSpreadDataModel(this, SPREAD_NAME, TEMPLATE_ENTITY_NAME);
        spreadDataModel.setPageCache(this.getPageCache());
        this.getView().addService(ISpreadAction.class, (Object)spreadDataModel);
    }

    private MulDiSpreadDataModel getSpreadDataModel() {
        return (MulDiSpreadDataModel)((Object)this.getView().getService(ISpreadAction.class));
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("model", (Object)MultiDiConstant.DEFAULT_MODEL);
        this.getSpreadDataModel().init();
    }

    public void afterBindData(EventObject e) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        HashMap<String, String> data = new HashMap<String, String>(4);
        data.put("useNewInsert", "false");
        params.put("data", data);
        this.getSpreadDataModel().setSpreadParams(params);
        String json = (String)this.getModel().getValue("content_tag");
        if (!StringUtils.isEmpty((CharSequence)json)) {
            Map<String, String> colsMap = this.getColsMap();
            for (Map.Entry<String, String> ent : colsMap.entrySet()) {
                json = json.replace("${" + ent.getKey() + "}", "${" + this.getShowText(ent.getValue(), ent.getKey()) + "}");
            }
            this.getSpreadDataModel().setSpreadJson(json);
        }
        if (this.getModel().getValue("id") != null) {
            this.setTempColsMap();
        }
        Map cellTipMap = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)CELLTIPSET_ENTITY_NAME, Map.class);
        Long id = (Long)this.getModel().getValue("id");
        if (id != null && id != 0L) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)TEMPLATE_ENTITY_NAME);
            String fcontent_tag = dynamicObject.getString("content_tag");
            Map parseCellTipFromJson = SpreadUtils.parseCellTipFromJson((String)fcontent_tag, (Map)cellTipMap);
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)CELLTIPSET_ENTITY_NAME, (Object)parseCellTipFromJson);
        }
    }

    private String getShowText(String name, String key) {
        return name + LINKING_CHAR + key;
    }

    public void afterCopyData(EventObject e) {
        BillShowParameter param = (BillShowParameter)this.getView().getFormShowParameter();
        DynamicObject copyFrom = BusinessDataServiceHelper.loadSingle((Object)param.getPkId(), (String)TEMPLATE_ENTITY_NAME);
        String json = copyFrom.getString("content_tag");
        this.getModel().setValue("content_tag", (Object)json);
        this.getModel().setValue("id", null);
        this.getModel().setValue("number", copyFrom.get("number"));
        this.getModel().setValue("name", copyFrom.get("name"));
        this.getModel().setValue("type", copyFrom.get("type"));
        this.getModel().setValue("description", copyFrom.get("description"));
        this.getModel().setValue("model", copyFrom.get("model"));
        Map<String, String> colsMap = this.getColsMap();
        Set<Map.Entry<String, String>> entry = colsMap.entrySet();
        for (Map.Entry<String, String> ent : entry) {
            json = json.replace("${" + ent.getKey() + "}", "${" + this.getShowText(ent.getValue(), ent.getKey()) + "}");
        }
        this.getSpreadDataModel().setSpreadJson(json);
    }

    public void itemClick(ItemClickEvent evt) {
        this.invokeOperationByKey(evt.getItemKey());
    }

    private void invokeOperationByKey(String key) {
        Object id = this.getModel().getValue("id");
        FormShowParameter showParameter = new FormShowParameter();
        if (StringUtils.isNotBlank((CharSequence)key)) {
            switch (key) {
                case "bar_save": {
                    this.save();
                    break;
                }
                case "btn_setting": {
                    if (!this.checkCellFormulaIsSelected()) break;
                    this.spreadOption("actionCacheJson");
                    this.settingClick();
                    break;
                }
                case "globalsetting": 
                case "designatedsetting": {
                    String json;
                    List<Integer> selRows = null;
                    List<Integer> selCols = null;
                    if (key.equals("designatedsetting")) {
                        if (!this.checkCellFormulaIsSelected()) break;
                        selRows = this.getSpreadDataModel().getSelRows();
                        selCols = this.getSpreadDataModel().getSelCols();
                        showParameter.setCustomParam("selectRows", selRows);
                        showParameter.setCustomParam("selectCols", selCols);
                        showParameter.setCustomParam("currentSheetName", (Object)this.getSpreadDataModel().getCurrentSheetName());
                        showParameter.setCustomParam("currentSheetIndex", (Object)this.getSpreadDataModel().getCurrentSheetIndex());
                    }
                    if (StringUtil.isBlank((CharSequence)(json = (String)this.getModel().getValue("content_tag")))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6a21\u677f", (String)"MultiDiTemplateEditPlugin_16", (String)"taxc-tpo", (Object[])new Object[0]));
                        return;
                    }
                    boolean hasIdentifyCell = BatchMemberSettingService.hasIdentifyCell(json, selRows, selCols, this.getSpreadDataModel().getCurrentSheetName());
                    if (!hasIdentifyCell) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f85\u6807\u8bc6\u533a\u57df\u4ee5\u751f\u6210\u884c\u5217\u7ef4", (String)"MultiDiTemplateEditPlugin_18", (String)"taxc-tpo", (Object[])new Object[0]));
                        return;
                    }
                    showParameter.setFormId("tpo_batch_member_setting");
                    showParameter.setCustomParam("settingKey", (Object)key);
                    showParameter.setCustomParam("templateId", id);
                    showParameter.setCustomParam("preadJson", (Object)json);
                    showParameter.setCustomParam("model", this.getModel().getValue("model"));
                    showParameter.setParentPageId(this.getView().getPageId());
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(showParameter);
                    break;
                }
                case "btn_view": {
                    this.spreadOption(ACTION_VIEW);
                    break;
                }
                case "btn_formula": {
                    showParameter.setFormId(TCTB_TEMPLATE_FORMULA);
                    showParameter.setParentPageId(this.getView().getPageId());
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(showParameter);
                    break;
                }
                case "btn_setformula": {
                    if (!this.checkCellKeyDimensionInfo()) break;
                    Map paramMap = (Map)SerializationUtils.fromJsonString((String)this.getSpreadSelectedCellKey(), Map.class);
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.putAll(paramMap);
                    this.showFormulaList(param, "tpo_formula_config");
                    break;
                }
                case "btn_type": {
                    showParameter = new ListShowParameter();
                    ((ListShowParameter)showParameter).setBillFormId(TPO_TEMPLATE_TYPE);
                    showParameter.setFormId("bos_list");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TPO_TEMPLATE_TYPE);
                    showParameter.setCloseCallBack(closeCallBack);
                    this.getView().showForm(showParameter);
                    break;
                }
                case "btn_delete_formula": {
                    if (!this.checkCellKeyDimensionInfo()) break;
                    this.deleteFormulaByKeyAndType(null, String.valueOf(id), key);
                    break;
                }
                case "del_calculate_formula": {
                    if (!this.checkCellKeyDimensionInfo()) break;
                    this.deleteFormulaByKeyAndType("fetch", String.valueOf(id), key);
                    break;
                }
                case "del_validate_formula": {
                    if (!this.checkCellKeyDimensionInfo()) break;
                    this.deleteFormulaByKeyAndType("check", String.valueOf(id), key);
                    break;
                }
                case "del_style_formula": {
                    if (!this.checkCellKeyDimensionInfo()) break;
                    this.deleteFormulaByKeyAndType("style", String.valueOf(id), key);
                    break;
                }
                case "btn_dynrow": {
                    if (!this.checkCellFormulaIsSelected()) break;
                    this.dynamicRowSetting();
                    break;
                }
                case "btn_dynrowdel": {
                    if (!this.checkCellFormulaIsSelected()) break;
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BUTTON_DYNROWDEL, (IFormPlugin)this);
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MultiDiTemplateListPlugin_7", (String)"taxc-tpo", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"MultiDiTemplateListPlugin_8", (String)"taxc-tpo", (Object[])new Object[0]));
                    MessageBoxOptions options = MessageBoxOptions.OKCancel;
                    String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u76841\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"MultiDiTemplateListPlugin_11", (String)"taxc-tpo", (Object[])new Object[0]);
                    this.getView().showConfirm(msg, "", options, ConfirmTypes.Delete, confirmCallBacks, btnNameMaps);
                    break;
                }
                case "btn_celltip": {
                    if (!this.checkCellFormulaIsSelected()) break;
                    this.cellTipSetting();
                }
            }
        }
    }

    private void cellTipSetting() {
        List<Integer> selCols = this.getSpreadDataModel().getSelCols();
        List<Integer> selRows = this.getSpreadDataModel().getSelRows();
        String sheetName = this.getSpreadDataModel().getCurrentSheetName();
        if (selCols == null || selCols.isEmpty() || selRows == null || selRows.isEmpty() || sheetName == null) {
            return;
        }
        String selectedCol = selCols.get(0).toString();
        String selectedRow = selRows.get(0).toString();
        String keyForCellTip = SpreadUtils.createKeyForCellTip((String)sheetName, (String)selectedRow, (String)selectedCol);
        Map cellTipMap = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)CELLTIPSET_ENTITY_NAME, Map.class);
        Map singleCellTipMap = null;
        if (!EmptyCheckUtils.isEmpty((Object)cellTipMap)) {
            singleCellTipMap = (Map)cellTipMap.get(keyForCellTip);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(CELLTIPSET_ENTITY_NAME);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("modeltype", (Object)"3");
        parameter.setCustomParam("singleCellTipMap", (Object)singleCellTipMap);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_CELL_TIP);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    public void selectedCallBack(Map<String, Object> params) {
        this.loadFormulaPage();
    }

    public void loadFormulaPage() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{PROPERTYSET});
        String spreadSelectedCellKey = this.getSpreadSelectedCellKey();
        if (StringUtils.isEmpty((CharSequence)spreadSelectedCellKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PROPERTYSET});
            return;
        }
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)spreadSelectedCellKey, Map.class);
        String cellkey = (String)paramMap.get(SELECT_CELL_KEY);
        if (StringUtils.isEmpty((CharSequence)cellkey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PROPERTYSET});
            return;
        }
        HashMap param = new HashMap();
        param.putAll(paramMap);
        String formId = "tpo_formula_config";
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("formulaconfig");
        parameter.setParentPageId(this.getView().getPageId());
        parameter.setStatus(OperationStatus.EDIT);
        DynamicObject typeObject = (DynamicObject)this.getModel().getValue("type");
        cellkey = (String)param.get(SELECT_CELL_KEY);
        if (!QueryServiceHelper.exists((String)"tpo_report_item", (QFilter[])new QFilter("number", "=", (Object)cellkey).toArray())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PROPERTYSET});
            return;
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        String templatetype = typeObject.getString("id");
        String templateNumber = (String)this.getModel().getValue("number");
        String templateId = String.valueOf(this.getModel().getValue("id"));
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("templatenum", templateNumber);
        customParams.put("templateid", templateId);
        customParams.put("cellkey", cellkey);
        customParams.put("model", model.getString("id"));
        customParams.put("templatetype", templatetype);
        customParams.put("fromTemplate", true);
        parameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_SELECT_FORMULA);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private String convertLocalName(OrmLocaleValue ormLocaleValue) {
        if (null != ormLocaleValue) {
            return ormLocaleValue.getLocaleValue();
        }
        return "";
    }

    private void deleteFormulaByKeyAndType(String formulaType, String templateId, String operationKey) {
        if (!this.checkCellFormulaIsSelected()) {
            return;
        }
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"formulaType", (Object)formulaType);
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"templateId", (Object)templateId);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("delete", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MultiDiTemplateListPlugin_7", (String)"taxc-tpo", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"MultiDiTemplateListPlugin_8", (String)"taxc-tpo", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u76841\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"MultiDiTemplateListPlugin_11", (String)"taxc-tpo", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Delete, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if ("delete".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            try {
                Map paramMap = (Map)SerializationUtils.fromJsonString((String)this.getSpreadSelectedCellKey(), Map.class);
                long templateId = (Long)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"templateId", Long.class);
                String formulaType = (String)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"formulaType", String.class);
                QFilter qFilter = new QFilter(TEMPLATE, "=", (Object)templateId);
                String cellNumber = (String)paramMap.get(SELECT_CELL_KEY);
                QFilter qFilter1 = new QFilter("reportitem.number", "=", (Object)cellNumber);
                if (StringUtils.isEmpty((CharSequence)formulaType)) {
                    MultiDiConstant.TEMPLATE_FORMULA_MAP.values().forEach(a -> DeleteServiceHelper.delete((String)a, (QFilter[])new QFilter[]{qFilter, qFilter1}));
                } else if (MultiDiConstant.TEMPLATE_FORMULA_MAP.containsKey(formulaType)) {
                    DeleteServiceHelper.delete((String)((String)MultiDiConstant.TEMPLATE_FORMULA_MAP.get(formulaType)), (QFilter[])new QFilter[]{qFilter, qFilter1});
                }
                this.loadFormulaPage();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"MultiDiTemplateEditPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
            }
            catch (Exception ex) {
                LOGGER.error("deleteFormulaByKeyAndType error:" + ThrowableHelper.toString((Exception)ex));
            }
        } else if (BUTTON_DYNROWDEL.equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.dynamicRowDel();
        }
    }

    private void save() {
        if (this.checkTemplate(this.getModel(), this.getView())) {
            return;
        }
        this.spreadOption(ACTION_SAVE);
    }

    private boolean checkTemplate(IDataModel dataModel, IFormView view) {
        DynamicObject typeObject = (DynamicObject)this.getModel().getValue("type");
        String name = this.convertLocalName((OrmLocaleValue)this.getModel().getValue("name"));
        String number = (String)this.getModel().getValue("number");
        Date startdate = DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue("startdate")));
        Date enddate = DateUtils.getLastDateOfMonth((Date)((Date)this.getModel().getValue("enddate")));
        if (StringUtils.isEmpty((CharSequence)number)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u677f\u7f16\u7801", (String)"MultiDiTemplateEditPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u677f\u540d\u79f0", (String)"MultiDiTemplateEditPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]));
            return true;
        }
        if (typeObject == null || StringUtils.isEmpty((CharSequence)typeObject.getString("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u7c7b\u578b", (String)"MultiDiTemplateEditPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]));
            return true;
        }
        if (startdate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u677f\u751f\u6548\u65e5\u671f", (String)"MultiDiTemplateEditPlugin_7", (String)"taxc-tpo", (Object[])new Object[0]));
            return true;
        }
        if (enddate != null && startdate.compareTo(enddate) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6a21\u677f\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f", (String)"MultiDiTemplateEditPlugin_8", (String)"taxc-tpo", (Object[])new Object[0]));
            return true;
        }
        String type = typeObject.getString("id");
        DynamicObject tempTypeObj = BusinessDataServiceHelper.loadSingle((Object)typeObject.get("id"), (String)TPO_TEMPLATE_TYPE);
        String uniqueType = tempTypeObj.getString("uniquetype");
        if (!"multiple".equals(uniqueType)) {
            QFilter qfilter2;
            Object idObj = this.getModel().getValue("id");
            QFilter qfilter = new QFilter("type", "=", (Object)type);
            if (idObj != null) {
                qfilter = qfilter.and(new QFilter("id", "!=", idObj));
            }
            if ("number".equals(uniqueType)) {
                qfilter = qfilter.and(new QFilter("number", "=", (Object)number));
            }
            if (enddate == null) {
                qfilter2 = QFilter.isNull((String)"enddate");
                qfilter2 = qfilter2.or(new QFilter("startdate", ">=", (Object)startdate));
                qfilter = qfilter.and(qfilter2);
            } else {
                qfilter2 = new QFilter("startdate", ">=", (Object)enddate);
                qfilter2 = qfilter2.and(new QFilter("enddate", "<=", (Object)enddate));
                QFilter qfilter3 = new QFilter("startdate", ">=", (Object)startdate);
                qfilter3 = qfilter3.and(new QFilter("enddate", "<=", (Object)startdate));
                QFilter qfilter4 = new QFilter("startdate", ">=", (Object)startdate);
                qfilter4 = qfilter4.and(new QFilter("startdate", "<=", (Object)enddate));
                QFilter q = qfilter2.or(qfilter3).or(qfilter4);
                qfilter.and(q);
            }
            DynamicObjectCollection collection = QueryServiceHelper.query((String)TEMPLATE_ENTITY_NAME, (String)"id,name", (QFilter[])new QFilter[]{qfilter});
            if (collection != null && !collection.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677f\u751f\u6548\u65f6\u95f4\u6bb5\u5df2\u7ecf\u6709\u6a21\u677f\uff0c\u8bf7\u4fee\u6539\u751f\u6548\u6216\u5931\u6548\u65e5\u671f", (String)"MultiDiTemplateEditPlugin_9", (String)"taxc-tpo", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void spreadOption(String method) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("callback", "invokeAction");
        params.put("invokemethod", method);
        this.getPageCache().put("starttime", System.currentTimeMillis() + "");
        this.getSpreadDataModel().getSpreadJson(params);
    }

    public void doubleClickLockedCell(int r, int c) {
    }

    private void settingClick() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tpo_rowcol_setting");
        HashMap<String, Long> param = new HashMap<String, Long>();
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"MultiDiTemplateEditPlugin_17", (String)"taxc-tpo", (Object[])new Object[0]));
            return;
        }
        Long modelId = model.getLong("id");
        param.put("modelid", modelId);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(param);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTIONID_SETTIING);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map<String, String> tempColsMap = this.getTempColsMap();
        Object data = event.getReturnData();
        if (data != null && ACTIONID_SETTIING.equals(event.getActionId())) {
            if (Map.class.isAssignableFrom(data.getClass())) {
                List<Integer> selRows = this.getSpreadDataModel().getSelRows();
                List<Integer> selCols = this.getSpreadDataModel().getSelCols();
                if (selCols == null || selRows == null || selRows.isEmpty() || selCols.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u5143\u683c", (String)"MultiDiTemplateEditPlugin_10", (String)"taxc-tpo", (Object[])new Object[0]));
                    return;
                }
                Map returnData = (Map)data;
                List row = (List)returnData.get(ROW);
                List column = (List)returnData.get(COLUMN);
                List<Map<String, Object>> updateCells = this.getFillCells(selRows.get(0), selCols.get(0), row, column, tempColsMap);
                if (kd.taxc.bdtaxr.common.util.EmptyCheckUtils.isEmpty(updateCells)) {
                    updateCells = this.getFillCellsOld(selRows, selCols, row, column, tempColsMap);
                }
                HashMap<String, Object> features = new HashMap<String, Object>(4);
                HashMap<String, String> styleMap = new HashMap<String, String>(4);
                styleMap.put("bkc", "#d4ffaa");
                features.put("style", styleMap);
                features.put("range", updateCells);
                this.getSpreadDataModel().updataValue(updateCells);
                this.getSpreadDataModel().setCellStyle(Lists.newArrayList((Object[])new Map[]{features}));
                TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"tpo_report_item_tempCell", tempColsMap);
            }
        } else if (TPO_TEMPLATE_TYPE.equals(event.getActionId())) {
            this.getView().updateView();
        } else if (CALLBACK_CELL_TIP.equals(event.getActionId()) && data != null) {
            Map returnData = (Map)data;
            Boolean enableCellTip = (Boolean)returnData.get("enablecelltip");
            String tipMessage = (String)returnData.get("tipmessage");
            if (this.checkCellFormulaIsSelected()) {
                List<Integer> selCols = this.getSpreadDataModel().getSelCols();
                List<Integer> selRows = this.getSpreadDataModel().getSelRows();
                String sheetName = this.getSpreadDataModel().getCurrentSheetName();
                if (selCols == null || selCols.isEmpty() || selRows == null || selRows.isEmpty() || sheetName == null) {
                    return;
                }
                String selectedCol = selCols.get(0).toString();
                String selectedRow = selRows.get(0).toString();
                String keyForCellTip = SpreadUtils.createKeyForCellTip((String)sheetName, (String)selectedRow, (String)selectedCol);
                HashMap<String, Object> singleCellTipMap = new HashMap<String, Object>();
                singleCellTipMap.put("selectedCol", selectedCol);
                singleCellTipMap.put("selectedRow", selectedRow);
                singleCellTipMap.put("enableCellTip", enableCellTip);
                singleCellTipMap.put("tipMessage", tipMessage);
                singleCellTipMap.put("selectedSheetName", sheetName);
                HashMap cellTipMap = (HashMap)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)CELLTIPSET_ENTITY_NAME, Map.class);
                if (EmptyCheckUtils.isEmpty((Object)cellTipMap)) {
                    cellTipMap = new HashMap();
                }
                cellTipMap.put(keyForCellTip, singleCellTipMap);
                TreeUtils.putCache((IPageCache)this.getPageCache(), (String)CELLTIPSET_ENTITY_NAME, cellTipMap);
            }
        }
    }

    private List<Map<String, Object>> getFillCellsOld(List<Integer> selRows, List<Integer> selCols, List<Map<String, Object>> row, List<Map<String, Object>> column, Map<String, String> tempColsMap) {
        ArrayList<Map<String, Object>> updateCells = new ArrayList<Map<String, Object>>();
        int rowId = selRows.get(0);
        for (Map<String, Object> rowMap : row) {
            String rowValueId = (String)rowMap.get("id");
            int colId = selCols.get(0);
            for (Map<String, Object> colMap : column) {
                String colValueId = (String)colMap.get("id");
                HashMap<String, Object> valMap = new HashMap<String, Object>(16);
                valMap.put("r", rowId);
                valMap.put("c", colId);
                String valnumber = rowValueId + "#" + colValueId;
                String valText = rowMap.get("text") + "#" + colMap.get("text");
                tempColsMap.put(valnumber, valText);
                valText = this.getShowText(valText, valnumber);
                valMap.put("v", "${" + valText + "}");
                valMap.put("rc", 1);
                valMap.put("cc", 1);
                updateCells.add(valMap);
                ++colId;
            }
            ++rowId;
        }
        return updateCells;
    }

    private List<Map<String, Object>> getFillCells(int startR, int startC, List<Map<String, Object>> rowMap, List<Map<String, Object>> colMap, Map<String, String> tempColsMap) {
        int rCount = rowMap.size();
        int cCount = colMap.size();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(rCount);
        String spreadJson = this.getPageCache().get("spreadJson");
        String controlstates = this.getPageCache().get("controlstates");
        if (StringUtils.isEmpty((CharSequence)spreadJson) || StringUtils.isEmpty((CharSequence)controlstates)) {
            return result;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)controlstates, Map.class);
        Map spreadmap = (Map)map.get(SPREAD_NAME);
        if (spreadmap != null && !spreadmap.isEmpty() && null != spreadmap.get("sheetName")) {
            String jsonString = SpreadUtils.getJson((String)spreadJson);
            String sheetName = spreadmap.get("sheetName").toString();
            List sheets = SpreadUtils.getSheets((String)jsonString, (String)sheetName);
            List rowList = ((Sheet)sheets.get(0)).getRowList();
            int rowOffset = startR;
            for (int i = 0; i < rCount; ++i) {
                int rowIndex = i + rowOffset;
                if (rowList.size() <= rowIndex) continue;
                List cells = (List)rowList.get(rowIndex);
                String rowValueId = (String)rowMap.get(i).get("id");
                int columnOffset = 0;
                for (int i1 = 0; i1 < cells.size(); ++i1) {
                    Cell cell = (Cell)cells.get(i1);
                    if (cell.getCol() > startC || cell.getCol() + cell.getColCount() <= startC) continue;
                    columnOffset = i1;
                    break;
                }
                int jumpRow = 0;
                for (int j = 0; j < cCount; ++j) {
                    int columnIndex = j + columnOffset;
                    if (cells.size() <= columnIndex) continue;
                    Cell cell = (Cell)cells.get(columnIndex);
                    int n = jumpRow = cell.getRowCount() - 1 > jumpRow ? cell.getRowCount() - 1 : jumpRow;
                    if (cell == null) continue;
                    String colValueId = (String)colMap.get(j).get("id");
                    HashMap<String, Object> valMap = new HashMap<String, Object>(16);
                    valMap.put("r", cell.getRow());
                    valMap.put("c", cell.getCol());
                    String valnumber = rowValueId + "#" + colValueId;
                    String valText = rowMap.get(i).get("text") + "#" + colMap.get(j).get("text");
                    tempColsMap.put(valnumber, valText);
                    valText = this.getShowText(valText, valnumber);
                    valMap.put("v", "${" + valText + "}");
                    valMap.put("rc", cell.getRowCount());
                    valMap.put("cc", cell.getColCount());
                    result.add(valMap);
                }
                rowOffset += jumpRow;
            }
        }
        return result;
    }

    private Map<String, String> getTempColsMap() {
        HashMap tempColsMap = (HashMap)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"tpo_report_item_tempCell", Map.class);
        if (tempColsMap == null) {
            tempColsMap = new HashMap(4);
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"tpo_report_item_tempCell", tempColsMap);
        }
        return tempColsMap;
    }

    private void setTempColsMap() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        HashMap<String, String> tempColsMap = new HashMap<String, String>(entryentity.size());
        for (DynamicObject dynamicObject : entryentity) {
            DynamicObject cell = (DynamicObject)dynamicObject.get("reportitem");
            if (cell == null) continue;
            String name = cell.getString("name");
            String number = cell.getString("number");
            tempColsMap.put(number, name);
        }
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"tpo_report_item_tempCell", tempColsMap);
    }

    private void buildReportCell(DynamicObject template, String json, Set<String> bbxList) {
        if (bbxList.isEmpty()) {
            return;
        }
        List partList = Lists.partition(new ArrayList<String>(bbxList), (int)1000);
        DynamicObjectCollection reportCell = new DynamicObjectCollection();
        DynamicObjectCollection partReportCell = null;
        for (List part : partList) {
            partReportCell = QueryServiceHelper.query((String)"tpo_report_item", (String)"id,number", (QFilter[])new QFilter("number", "in", (Object)part).toArray());
            reportCell.addAll((Collection)partReportCell);
        }
        Map<String, Long> existMap = reportCell.stream().collect(Collectors.toMap(a -> a.getString("number"), b -> b.getLong("id"), (m, n) -> m));
        List collect = bbxList.stream().filter(a -> a.contains("#") && !existMap.containsKey(a)).collect(Collectors.toList());
        List<String> rows = collect.stream().map(a -> a.split("#")[0]).collect(Collectors.toList());
        List<String> cols = collect.stream().map(a -> a.split("#")[1]).collect(Collectors.toList());
        Long model = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        Map<String, DynamicObject> rowMembers = MultiDiHelper.queryRowDimensionByNumber(rows, model).stream().collect(Collectors.toMap(a -> a.getString("number"), b -> b, (m, n) -> m));
        Map<String, DynamicObject> colMembers = MultiDiHelper.queryColDimensionByNumber(cols, model).stream().collect(Collectors.toMap(a -> a.getString("number"), b -> b, (m, n) -> m));
        ArrayList<DynamicObject> reportCellCreate = new ArrayList<DynamicObject>(bbxList.size());
        for (String bbx : collect) {
            String[] split = bbx.split("#");
            String rowNum = split[0];
            String colNum = split[1];
            if (!rowMembers.containsKey(rowNum) || !colMembers.containsKey(colNum)) continue;
            DynamicObject rowM = rowMembers.get(rowNum);
            DynamicObject colM = colMembers.get(colNum);
            DynamicObject cell = BusinessDataServiceHelper.newDynamicObject((String)"tpo_report_item");
            cell.set("number", (Object)bbx);
            String name = rowM.getString("name") + "#" + colM.getString("name");
            cell.set("name", (Object)name);
            String longName = rowM.getString("fullname") + "#" + colM.getString("fullname");
            cell.set("longname", (Object)longName);
            cell.set(ROW, (Object)rowM.getLong("id"));
            cell.set("col", (Object)colM.getLong("id"));
            cell.set("model", (Object)model);
            cell.set("status", (Object)"C");
            cell.set("enable", (Object)"1");
            cell.set("createtime", (Object)new Date());
            cell.set("creator", (Object)RequestContext.get().getCurrUserId());
            cell.set("modifytime", (Object)new Date());
            cell.set("modifier", (Object)RequestContext.get().getCurrUserId());
            reportCellCreate.add(cell);
        }
        if (reportCellCreate.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])reportCellCreate.toArray(new DynamicObject[reportCellCreate.size()]));
        }
    }

    private Set<String> paseCellBbx(String json) {
        Pattern r = Pattern.compile(bbx_Exp);
        Matcher m = r.matcher(json);
        HashSet<String> sets = new HashSet<String>(128);
        while (m.find()) {
            sets.add(m.group(1));
        }
        return sets;
    }

    private void dynamicRowSetting() {
        Map<String, Object> param = this.getDynrowKeyParam();
        if (!this.checkDynrowKeyParam(param)) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(DYNROWSET_ENTITY_NAME);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParams(param);
        parameter.getOpenStyle().setInlineStyleCss(new StyleCss());
        parameter.getOpenStyle().getInlineStyleCss().setHeight("460");
        parameter.setCustomParam("modeltype", (Object)"3");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_DYN_ROW);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private boolean checkDynrowKeyParam(Map<String, Object> param) {
        Object templateId = param.get("templateId");
        if (templateId == null || Long.parseLong(templateId.toString()) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6a21\u677f", (String)"MultiDiTemplateEditPlugin_16", (String)"taxc-tpo", (Object[])new Object[0]));
            return false;
        }
        String selectedKey = (String)param.get(SELECT_CELL_KEY);
        if (StringUtils.isEmpty((CharSequence)selectedKey)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u8bbe\u7f6e\u884c\u5217\u7ef4\u7684\u5355\u5143\u683c\u64cd\u4f5c\u3002", (String)"MultiDiTemplateEditPlugin_14", (String)"taxc-tpo", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, Object> getDynrowKeyParam() {
        String selectCellKey;
        int i;
        String cellJson = this.getSpreadDataModel().getSelectedCellKey();
        Map param = (Map)JsonUtil.fromJson((String)cellJson, Map.class);
        if (param.get(SELECT_CELL_KEY) != null && (i = (selectCellKey = (String)param.get(SELECT_CELL_KEY)).indexOf("#")) > -1) {
            String newkey = selectCellKey.substring(0, i) + "#1" + selectCellKey.substring(i);
            param.put(SELECT_CELL_KEY, newkey);
        }
        param.put("jumpFrom", "muldi");
        return param;
    }

    private void dynamicRowDel() {
        Map<String, Object> param = this.getDynrowKeyParam();
        if (this.checkDynrowKeyParam(param)) {
            String selectedKey = (String)param.get(SELECT_CELL_KEY);
            Long templateId = (Long)param.get("templateId");
            selectedKey = selectedKey.substring(0, selectedKey.lastIndexOf(35));
            QFilter qFilter = new QFilter(TEMPLATE_ID, "=", (Object)templateId).and("dynrow_no", "=", (Object)selectedKey);
            int delete = DeleteServiceHelper.delete((String)DYNROWSET_ENTITY_NAME, (QFilter[])qFilter.toArray());
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"MultiDiTemplateEditPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]), delete));
        }
    }

    public void actionView(String spreadJson) {
        String json = SpreadUtils.getJson((String)spreadJson);
        String pageId = MD5.md5crypt((String)this.getView().getPageId());
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("operation", "edit");
        String templateHtml = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TemplateService", (String)"extractMuldiJson", (Object[])new Object[]{json, null, null, pageId, customParams});
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tpo_templat_view");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("json", (Object)templateHtml);
        this.getView().showForm(showParameter);
    }

    public void actionCacheJson(String spreadJson) {
        this.getPageCache().put("spreadJson", spreadJson);
    }

    public void actionSave(String spreadJson) {
        String number;
        boolean isSuccess = false;
        IDataModel model = this.getModel();
        Long idObj = (Long)model.getValue("id");
        QFilter numberQfilter = new QFilter("id", "!=", (Object)idObj).and("number", "=", (Object)(number = (String)model.getValue("number")));
        if (QueryServiceHelper.exists((String)TEMPLATE_ENTITY_NAME, (QFilter[])numberQfilter.toArray())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\uff01", (String)"MultiDiTemplateEditPlugin_15", (String)"taxc-tpo", (Object[])new Object[0]));
            return;
        }
        Optional<String> optional = MultiDynamicRowService.checkDynRowDuplicate(idObj);
        if (optional.isPresent()) {
            this.getView().showErrorNotification(optional.get());
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                isSuccess = this.doSave(spreadJson);
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.error("Template save error!!!", t);
            }
        }
        this.getSpreadDataModel().reSelectLastCell();
        if (isSuccess) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"MultiDiTemplateEditPlugin_11", (String)"taxc-tpo", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"MultiDiTemplateEditPlugin_12", (String)"taxc-tpo", (Object[])new Object[0]));
        }
        this.getModel().setDataChanged(false);
        this.getView().sendFormAction(this.getView());
    }

    private boolean doSave(String spreadJson) {
        Map<String, Object> map;
        DynamicObject template;
        String json = SpreadUtils.getJson((String)spreadJson);
        Map cellTipsMap = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)CELLTIPSET_ENTITY_NAME, Map.class);
        if (!EmptyCheckUtils.isEmpty((Object)cellTipsMap)) {
            json = SpreadUtils.handleParseSpreadJsonForCellTip((Map)cellTipsMap, (String)json);
        }
        IDataModel model = this.getModel();
        Long idObj = (Long)model.getValue("id");
        Object name = this.getModel().getValue("name");
        String number = (String)model.getValue("number");
        if (idObj != null && idObj > 0L && QueryServiceHelper.exists((String)TEMPLATE_ENTITY_NAME, (Object)idObj)) {
            template = BusinessDataServiceHelper.loadSingle((Object)idObj, (String)TEMPLATE_ENTITY_NAME);
        } else {
            template = BusinessDataServiceHelper.newDynamicObject((String)TEMPLATE_ENTITY_NAME);
            template.set("creator", (Object)RequestContext.get().getCurrUserId());
            template.set("createtime", (Object)new Date());
        }
        Date startdate = DateUtils.getFirstDateOfMonth((Date)((Date)model.getValue("startdate")));
        LOGGER.info(DateUtils.format((Date)((Date)model.getValue("enddate")), (String)"yyyy-MM-dd HH:mm:ss"));
        Date enddate = DateUtils.getLastDateOfMonth((Date)((Date)model.getValue("enddate")));
        if (enddate != null) {
            enddate = DateUtils.trunc((Date)enddate);
        }
        LOGGER.info(DateUtils.format((Date)enddate, (String)"yyyy-MM-dd HH:mm:ss"));
        Map<String, String> colsMap = this.getColsMap();
        for (Map.Entry<String, String> ent : colsMap.entrySet()) {
            json = json.replace("${" + this.getShowText(ent.getValue(), ent.getKey()) + "}", "${" + ent.getKey() + "}");
        }
        DynamicObject type = (DynamicObject)this.getModel().getValue("type");
        template.set("type", (Object)type);
        template.set("number", (Object)number);
        template.set("name", name);
        template.set("startdate", (Object)startdate);
        template.set("enddate", (Object)enddate);
        template.set("modifytime", (Object)new Date());
        template.set("modifier", (Object)RequestContext.get().getCurrUserId());
        template.set("status", (Object)"C");
        template.set("enable", (Object)"1");
        template.set("content_tag", (Object)json);
        DynamicObject md = (DynamicObject)this.getModel().getValue("model");
        template.set("model", (Object)md);
        template.set("description", this.getModel().getValue("description"));
        Set<String> bbxList = this.paseCellBbx(json);
        this.buildReportCell(template, json, bbxList);
        this.updateEntrySet(template, md, bbxList);
        Object[] ids = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{template});
        Object id = null;
        for (Object obj : ids) {
            DynamicObject idObj1 = (DynamicObject)obj;
            id = idObj1.getPkValue();
            model.setValue("id", id);
            model.setValue("content_tag", (Object)json);
        }
        if (id != null) {
            this.deleteChangeOldRel(bbxList, id);
        }
        if (StringUtils.isNotBlank((Object)(map = this.getCopyTemplateNumAndId()).get(ORIGINAL_ID)) && (idObj == null || idObj == 0L)) {
            QFilter qFilter = new QFilter(TEMPLATE, "=", map.get(ORIGINAL_ID));
            for (String formulaBillID : MultiDiConstant.TEMPLATE_FORMULA_MAP.values()) {
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)formulaBillID, (String)MetadataUtil.getAllFieldToQuery((String)formulaBillID), (QFilter[])new QFilter[]{qFilter});
                if (dynamicObjects.length <= 0) continue;
                SaveServiceHelper.save((DynamicObject[])this.copyFormula(formulaBillID, dynamicObjects, model.getValue("id")));
            }
            QFilter q2 = new QFilter(TEMPLATE_ID, "=", map.get(ORIGINAL_ID));
            DynamicObject[] dynrows = BusinessDataServiceHelper.load((String)DYNROWSET_ENTITY_NAME, (String)DYN_ROW_ALL_KEYS, (QFilter[])new QFilter[]{q2});
            if (dynrows.length > 0) {
                SaveServiceHelper.save((DynamicObject[])this.copyDynrowFormula(dynrows, model, DYN_ROW_ALL_KEYS));
            }
        }
        try {
            TemplateCacheParams params = new TemplateCacheParams();
            params.setStartDate(startdate);
            params.setEndDate(enddate);
            params.setModelId(Long.valueOf(md.getLong("id")));
            params.setTemplateType(type.getString("id"));
            params.setTemplateContent(json);
            params.setTemplateNumber(number);
            params.setTemplateId((Long)model.getValue("id"));
            MultiDiTemplateHelper.refreshTemplateCache(params);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return true;
    }

    private void deleteChangeOldRel(Set<String> bbxList, Object id) {
        QFilter qFilter = new QFilter(TEMPLATE, "=", id);
        List<String> entitys = Arrays.asList("tpo_template_rule_check", "tpo_template_rule_fetch", "tpo_template_rule_style");
        for (String relEntityId : entitys) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)relEntityId, (String)"id,reportitem.number", (QFilter[])qFilter.toArray());
            Map<String, Object> numberMap = query.stream().filter(a -> !bbxList.contains(a.getString("reportitem.number"))).collect(Collectors.toMap(a -> a.getString("reportitem.number"), b -> b.get("id"), (m, n) -> m));
            DeleteServiceHelper.delete((String)relEntityId, (QFilter[])new QFilter[]{new QFilter("id", "in", numberMap.values())});
        }
    }

    private void updateEntrySet(DynamicObject template, DynamicObject model, Set<String> bbxList) {
        DynamicObjectCollection entryentity = template.getDynamicObjectCollection(ENTRYENTITY);
        Set oldSet = entryentity.stream().map(a -> a.getString("rowcol")).collect(Collectors.toSet());
        List partList = Lists.partition(new ArrayList<String>(bbxList), (int)1000);
        DynamicObjectCollection reportCell = new DynamicObjectCollection();
        DynamicObjectCollection partReportCell = null;
        for (Object part : partList) {
            partReportCell = QueryServiceHelper.query((String)"tpo_report_item", (String)"id,number", (QFilter[])new QFilter("number", "in", part).and("model", "=", model.get("id")).toArray());
            reportCell.addAll((Collection)partReportCell);
        }
        Set newSet = reportCell.stream().map(a -> a.getString("number")).collect(Collectors.toSet());
        for (DynamicObject cell2 : reportCell) {
            if (oldSet.contains(cell2.get("number"))) continue;
            DynamicObject dynamicObject = entryentity.addNew();
            dynamicObject.set("reportitem", (Object)BusinessDataServiceHelper.loadSingle((Object)cell2.get("id"), (String)"tpo_report_item"));
            dynamicObject.set("rowcol", cell2.get("number"));
            this.getModel().createNewEntryRow(ENTRYENTITY, dynamicObject);
        }
        List<DynamicObject> removeobjs = entryentity.stream().filter(cell -> !newSet.contains(cell.get("rowcol"))).collect(Collectors.toList());
        removeobjs.forEach(a -> entryentity.remove(a));
        this.getModel().updateEntryCache(entryentity);
        this.getView().updateView(ENTRYENTITY);
    }

    private Map<String, String> getColsMap() {
        Map<String, String> colsMap = (Map<String, String>)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"tpo_report_item_allField", Map.class);
        if (colsMap != null) {
            colsMap.putAll(this.getTempColsMap());
            return colsMap;
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        long modelId = model.getLong("id");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tpo_report_item", (String)"number ,name", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        colsMap = query.stream().collect(Collectors.toMap(a -> a.getString("number"), b -> b.getString("name"), (m, n) -> m));
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"tpo_report_item_allField", colsMap);
        colsMap.putAll(this.getTempColsMap());
        return colsMap;
    }

    private boolean checkCellKeyDimensionInfo() {
        String spreadSelectedCellKey = this.getSpreadSelectedCellKey();
        String kdString = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u8bbe\u7f6e\u884c\u5217\u7ef4\u7684\u5355\u5143\u683c\u64cd\u4f5c\u3002", (String)"MultiDiTemplateEditPlugin_14", (String)"taxc-tpo", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)spreadSelectedCellKey)) {
            this.getView().showErrorNotification(kdString);
            return false;
        }
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)spreadSelectedCellKey, Map.class);
        String cellkey = (String)paramMap.get(SELECT_CELL_KEY);
        if (StringUtils.isEmpty((CharSequence)cellkey)) {
            this.getView().showErrorNotification(kdString);
            return false;
        }
        return true;
    }

    private boolean checkCellFormulaIsSelected() {
        List<Integer> selCols = this.getSpreadDataModel().getSelCols();
        List<Integer> selRows = this.getSpreadDataModel().getSelRows();
        Object type = this.getModel().getValue("type");
        if (type == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u7c7b\u578b", (String)"MultiDiTemplateEditPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]));
            return false;
        }
        if (selCols == null || selRows == null || selRows.isEmpty() || selCols.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u5143\u683c", (String)"MultiDiTemplateEditPlugin_10", (String)"taxc-tpo", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String getSpreadSelectedCellKey() {
        return this.getSpreadDataModel().getSelectedCellKey();
    }

    private Map<String, Object> getCopyTemplateNumAndId() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Object originalId = null;
        FormShowParameter object = this.getView().getFormShowParameter();
        if (object instanceof BillShowParameter) {
            BillShowParameter showParameter = (BillShowParameter)object;
            OperationStatus status = showParameter.getStatus();
            Object pkId = showParameter.getPkId();
            if (OperationStatus.ADDNEW == status && StringUtils.isNotBlank((Object)pkId)) {
                originalId = pkId;
            }
        }
        paramMap.put(ORIGINAL_ID, originalId);
        return paramMap;
    }

    private DynamicObject[] copyFormula(String formulaBillID, DynamicObject[] dynamicObjects, Object templateid) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (dynamicObjects.length > 0) {
            Date now = new Date();
            for (DynamicObject dyo : dynamicObjects) {
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)formulaBillID);
                object.set(TEMPLATE, templateid);
                object.set("reportitem", dyo.get("reportitem"));
                object.set("formula", dyo.get("formula"));
                object.set("creator", dyo.get("creator"));
                object.set("model", dyo.get("model"));
                object.set("creator", (Object)RequestContext.get().getCurrUserId());
                object.set("createtime", (Object)now);
                list.add(object);
            }
        }
        return list.toArray(new DynamicObject[list.size()]);
    }

    private DynamicObject[] copyDynrowFormula(DynamicObject[] dynamicObjects, IDataModel model, String allFields) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (dynamicObjects.length > 0) {
            for (DynamicObject dyo : dynamicObjects) {
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)DYNROWSET_ENTITY_NAME);
                for (String key : allFields.split(",")) {
                    if (key.equals("id")) continue;
                    object.set(key, dyo.get(key));
                }
                object.set(TEMPLATE_ID, model.getValue("id"));
                object.set("createtime", (Object)new Date());
                object.set("modifytime", (Object)new Date());
                list.add(object);
            }
        }
        return list.toArray(new DynamicObject[list.size()]);
    }

    private void showFormulaList(Map<String, Object> param, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setParentPageId(this.getView().getPageId());
        parameter.setStatus(OperationStatus.EDIT);
        DynamicObject typeObject = (DynamicObject)this.getModel().getValue("type");
        String cellkey = (String)param.get(SELECT_CELL_KEY);
        if (!QueryServiceHelper.exists((String)"tpo_report_item", (QFilter[])new QFilter("number", "=", (Object)cellkey).toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u62a5\u8868\u9879\u672a\u751f\u6210\uff0c\u8bf7\u5148\u4fdd\u5b58\u6a21\u677f\u3002", (String)"MultiDiTemplateEditPlugin_13", (String)"taxc-tpo", (Object[])new Object[0]));
            return;
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        String templatetype = typeObject.getString("id");
        String templateNumber = (String)this.getModel().getValue("number");
        String templateId = String.valueOf(this.getModel().getValue("id"));
        HashMap<String, String> customParams = new HashMap<String, String>(16);
        customParams.put("templatenum", templateNumber);
        customParams.put("templateid", templateId);
        customParams.put("cellkey", cellkey);
        customParams.put("model", model.getString("id"));
        customParams.put("templatetype", templatetype);
        parameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_SELECT_FORMULA);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }
}

