/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.multidimension;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.multidimension.MultiDiConstant;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class MultiDiTemplateListPlugin
extends AbstractListPlugin {
    private static final String DELETE_KEY = "delete";
    private static final String GENERAL = "general";
    private static final String TPO_TEMPLATE = "tpo_template";
    private static final String KEY_CONDITIONJSON = "conditionjson";
    private static final String KEY_FILTERCONDITION = "filtercondition";
    public static final String KEY_FILTERDESCRIPTION = "filterdescription";
    public static final String KEY_FILTER_VALUE = "filtervalue";
    private static final String GENERALBTN = "generalbtn";
    private static final String FILTERCONFIG = "filterconfig";

    public void afterCreateNewData(EventObject e) {
        if ("zlxz".equals(this.getView().getFormShowParameter().getCustomParam("from"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap", "toolbarap"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        List successPkIds;
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        if (DELETE_KEY.equals(itemKey) && EmptyCheckUtils.isNotEmpty((Object)(successPkIds = (operationResult = afterDoOperationEventArgs.getOperationResult()).getSuccessPkIds()))) {
            MultiDiConstant.TEMPLATE_FORMULA_MAP.values().forEach(a -> DeleteServiceHelper.delete((String)a, (QFilter[])new QFilter[]{new QFilter("template", "in", (Object)successPkIds)}));
            QFilter qFilter = new QFilter("template_id", "in", (Object)successPkIds);
            DeleteServiceHelper.delete((String)"bdtaxr_template_dynrow", (QFilter[])qFilter.toArray());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        String itemKey = evt.getItemKey();
        List<String> keys = Arrays.asList(GENERALBTN, FILTERCONFIG);
        if (keys.contains(itemKey)) {
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MultiDiTemplateListPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            if (list.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"MultiDiTemplateListPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
        }
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)GENERALBTN)) {
            this.confirmGeneral(list.get(0).getPrimaryKeyValue());
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)FILTERCONFIG)) {
            Object primaryKeyValue = list.get(0).getPrimaryKeyValue();
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)billlist.getBillFormId());
            if (EmptyCheckUtils.isEmpty((Object)object)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8bb0\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"MultiDiTemplateListPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            boolean general = object.getBoolean(GENERAL);
            if (general) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u7528\u6a21\u677f\u4e0d\u53ef\u4ee5\u914d\u7f6e\u9002\u7528\u6027\uff0c\u8bf7\u5148\u5207\u6362\u901a\u7528\u6807\u8bc6\u3002", (String)"MultiDiTemplateListPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            this.openSettingPage(object, KEY_CONDITIONJSON, "setting");
        }
    }

    private void confirmGeneral(Object pkValue) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmgeneral", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MultiDiTemplateListPlugin_7", (String)"taxc-tpo", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"MultiDiTemplateListPlugin_8", (String)"taxc-tpo", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5207\u6362\u4e3a\u901a\u7528\u5417\uff1f", (String)"MultiDiTemplateListPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, String.valueOf(pkValue));
    }

    public static DynamicObject[] getCoverTemplateObjects(Long pkValue, String templateType, Date startDate, Date endDate) {
        DynamicObject[] load;
        QFilter qFilter1 = new QFilter("type", "=", (Object)templateType);
        QFilter qFilter2 = new QFilter("id", "!=", (Object)pkValue);
        if (endDate != null) {
            QFilter startInRange = new QFilter("startdate", ">=", (Object)startDate).and("startdate", "<=", (Object)DateUtils.getDayLast((Date)endDate));
            QFilter endInRange = new QFilter("enddate", ">=", (Object)startDate).and("enddate", "<=", (Object)DateUtils.getDayLast((Date)endDate));
            QFilter startLessStart = new QFilter("startdate", "<=", (Object)startDate);
            QFilter qFilter = startInRange.or(startLessStart.and(endInRange.or(QFilter.isNull((String)"enddate"))));
            load = BusinessDataServiceHelper.load((String)TPO_TEMPLATE, (String)"id,number,general,startdate,enddate", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter1});
        } else {
            QFilter qFilter = QFilter.isNull((String)"enddate").or("enddate", ">=", (Object)startDate);
            load = BusinessDataServiceHelper.load((String)TPO_TEMPLATE, (String)"id,number,general,startdate,enddate", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter1});
        }
        return load;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("confirmgeneral".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            String customVaule = event.getCustomVaule();
            Long pkValue = Long.valueOf(customVaule);
            BillList billlist = (BillList)this.getControl("billlistap");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)billlist.getBillFormId());
            String type = object.getString("type.id");
            Date startdate = object.getDate("startdate");
            Date enddate = object.getDate("enddate");
            DynamicObject[] templateObjects = MultiDiTemplateListPlugin.getCoverTemplateObjects(pkValue, type, startdate, enddate);
            List<DynamicObject> generalList = Arrays.stream(templateObjects).filter(a -> !String.valueOf(pkValue).equals(a.getString("id")) && a.getBoolean(GENERAL)).collect(Collectors.toList());
            try (TXHandle h = TX.requiresNew();){
                try {
                    if (generalList.size() > 0) {
                        for (DynamicObject dynamicObject : generalList) {
                            dynamicObject.set(GENERAL, (Object)Boolean.FALSE);
                        }
                        SaveServiceHelper.update((DynamicObject[])generalList.toArray(new DynamicObject[generalList.size()]));
                    }
                    object.set(GENERAL, (Object)Boolean.TRUE);
                    object.set(KEY_CONDITIONJSON, null);
                    object.set(KEY_FILTERCONDITION, null);
                    SaveServiceHelper.update((DynamicObject)object);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6807\u8bc6\u901a\u7528\u6210\u529f", (String)"MultiDiTemplateListPlugin_9", (String)"taxc-tpo", (Object[])new Object[0]));
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw new RuntimeException(t);
                }
            }
            billlist.refresh();
        }
    }

    private void openSettingPage(DynamicObject selectedRow, String conditionjson, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("tpo_tcvat_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCustomParam("entityNumber", (Object)"tctb_tax_main_form");
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCaption(ResManager.loadKDString((String)"\u6761\u4ef6\u914d\u7f6e", (String)"MultiDiTemplateListPlugin_10", (String)"taxc-tpo", (Object[])new Object[0]));
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        BillList billList = (BillList)this.getControl("billlistap");
        if ("setting".equals(evt.getActionId())) {
            Map filterData = (Map)evt.getReturnData();
            if (filterData == null) {
                return;
            }
            ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
            DynamicObject selectRecord = BusinessDataServiceHelper.loadSingle((String)billList.getBillFormId(), (String)"id,filtercondition,conditionjson", (QFilter[])new QFilter[]{new QFilter("id", "=", listSelectedRows.get(0).getPrimaryKeyValue())});
            if (EmptyCheckUtils.isEmpty((Object)selectRecord)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8bb0\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"MultiDiTemplateListPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            selectRecord.set(KEY_CONDITIONJSON, EmptyCheckUtils.isEmpty((Object)filterData) ? null : filterData.get(KEY_FILTER_VALUE));
            selectRecord.set(KEY_FILTERCONDITION, EmptyCheckUtils.isEmpty((Object)filterData) ? null : filterData.get(KEY_FILTERDESCRIPTION));
            SaveServiceHelper.update((DynamicObject)selectRecord);
        }
        billList.refresh();
    }
}

