/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.prerate;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TaxPreRateListPlugin
extends AbstractListPlugin {
    private static final String FILTER_CONFIG = "filterconfig";
    private static final String GENERAL_BTN = "generalbtn";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String KEY_FILTERCONDITION = "filtercondition";
    private static final String KEY_CONDITIONJSON = "conditionjson";
    private static final String TOP_TCVAT_PRERATE = "tpo_tcvat_prerate";
    private static final String GENERAL = "general";
    private static final String CLOSE_GENERAL = "closegeneral";
    private static final String NUMBER = "number";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String FILEDS = "id,name,number,startdate,enddate";

    public void itemClick(ItemClickEvent evt) {
        if (GENERAL_BTN.equals(evt.getItemKey()) || FILTER_CONFIG.equals(evt.getItemKey())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u591a\u9009\u4e2d\u4e00\u884c\u8bb0\u5f55", (String)"TaxPreRateListPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            if (FILTER_CONFIG.equals(evt.getItemKey())) {
                DynamicObjectCollection selectRecords = QueryServiceHelper.query((String)TOP_TCVAT_PRERATE, (String)"id,filtercondition,conditionjson", (QFilter[])new QFilter[]{new QFilter(ID, "=", selectedRows.get(0).getPrimaryKeyValue())});
                if (EmptyCheckUtils.isEmpty((Object)selectRecords)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8bb0\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762", (String)"TaxPreRateListPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]));
                    return;
                }
                this.openSettingPage((DynamicObject)selectRecords.get(0), ENTRY_ENTITY, KEY_CONDITIONJSON, "setting");
            } else {
                ListSelectedRow selectedRow = selectedRows.get(0);
                DynamicObject itemObj = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)TOP_TCVAT_PRERATE);
                if (itemObj.getBoolean(GENERAL)) {
                    String itemNumber = itemObj.getString(NUMBER);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u8bb0\u5f55\u5df2\u4e3a\u901a\u7528\u6570\u636e", (String)"TaxPreRateListPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]), itemNumber));
                    return;
                }
                StringBuilder errorMess = this.checkGeneralPreRate(itemObj);
                if (errorMess.length() > 0) {
                    this.getView().showErrorNotification(errorMess.toString());
                    return;
                }
                itemObj.set(GENERAL, (Object)Boolean.TRUE);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{itemObj});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u542f\u6210\u529f", (String)"TaxPreRateListPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
                billList.refreshData();
            }
        } else if (CLOSE_GENERAL.equals(evt.getItemKey())) {
            DynamicObject[] items;
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u8bb0\u5f55", (String)"TaxPreRateListPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            ArrayList<String> closeData = new ArrayList<String>();
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(selectedRows.size());
            for (DynamicObject itemObj : items = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TOP_TCVAT_PRERATE))) {
                if (!itemObj.getBoolean(GENERAL)) continue;
                itemObj.set(GENERAL, (Object)Boolean.FALSE);
                closeData.add(itemObj.getString(NUMBER));
                saveList.add(itemObj);
            }
            if (!saveList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            }
            if (closeData.size() > 0) {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5173\u95ed%s\u6761\u6570\u636e", (String)"TaxPreRateListPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]), closeData.size()));
                billList.refreshData();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5173\u95ed\u901a\u7528", (String)"TaxPreRateListPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]));
            }
        }
    }

    private StringBuilder checkGeneralPreRate(DynamicObject itemObj) {
        Date startdate = itemObj.getDate(STARTDATE);
        Date enddate = itemObj.getDate(ENDDATE);
        QFilter f1 = new QFilter(ID, "!=", (Object)itemObj.getLong(ID));
        QFilter f2 = new QFilter(GENERAL, "=", (Object)"1");
        QFilter[] filters = new QFilter[]{f1, f2};
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)TOP_TCVAT_PRERATE, (String)FILEDS, (QFilter[])filters);
        StringBuilder errorMess = new StringBuilder();
        for (DynamicObject c : collection) {
            Date sdate = c.getDate(STARTDATE);
            Date edate = c.getDate(ENDDATE);
            String cnumber = c.getString(NUMBER);
            String cname = c.getLocaleString(NAME).getLocaleValue();
            String msg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u901a\u7528\u9884\u5f81\u7387\uff08\u7f16\u7801\uff1a%1$s,\u540d\u79f0\uff1a%2$s\uff09\uff0c\u8bf7\u5148\u53d6\u6d88\u901a\u7528!", (String)"TaxPreRateListPlugin_7", (String)"taxc-tpo", (Object[])new Object[0]), cnumber, cname);
            if (Objects.isNull(edate) && Objects.nonNull(enddate) && !sdate.after(enddate)) {
                errorMess.append(ResManager.loadKDString((String)msg, (String)"GeneralDateRangeSaveValidator_1", (String)"TaxPreRateListPlugin_11", (Object[])new Object[0]));
                break;
            }
            if (Objects.isNull(enddate) && Objects.nonNull(edate) && !startdate.after(edate)) {
                errorMess.append(ResManager.loadKDString((String)msg, (String)"GeneralDateRangeSaveValidator_1", (String)"TaxPreRateListPlugin_11", (Object[])new Object[0]));
                break;
            }
            if (Objects.isNull(edate) && Objects.isNull(enddate)) {
                errorMess.append(ResManager.loadKDString((String)msg, (String)"GeneralDateRangeSaveValidator_1", (String)"TaxPreRateListPlugin_11", (Object[])new Object[0]));
                break;
            }
            if (DateUtils.isEffectiveDate((Date)startdate, (Date)sdate, (Date)edate)) {
                errorMess.append(ResManager.loadKDString((String)msg, (String)"GeneralDateRangeSaveValidator_1", (String)"TaxPreRateListPlugin_11", (Object[])new Object[0]));
                break;
            }
            if (!Objects.nonNull(enddate) || !DateUtils.isEffectiveDate((Date)enddate, (Date)sdate, (Date)edate)) continue;
            errorMess.append(ResManager.loadKDString((String)msg, (String)"GeneralDateRangeSaveValidator_2", (String)"TaxPreRateListPlugin_12", (Object[])new Object[0]));
            break;
        }
        return errorMess;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("setting".equals(evt.getActionId())) {
            Map filterData = (Map)evt.getReturnData();
            if (filterData == null) {
                return;
            }
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
            DynamicObject selectRecord = BusinessDataServiceHelper.loadSingle((String)TOP_TCVAT_PRERATE, (String)"id,filtercondition,conditionjson", (QFilter[])new QFilter[]{new QFilter(ID, "=", listSelectedRows.get(0).getPrimaryKeyValue())});
            if (EmptyCheckUtils.isEmpty((Object)selectRecord)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8bb0\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762", (String)"TaxPreRateListPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            selectRecord.set(KEY_CONDITIONJSON, EmptyCheckUtils.isEmpty((Object)filterData) ? null : filterData.get("filtervalue"));
            selectRecord.set(KEY_FILTERCONDITION, EmptyCheckUtils.isEmpty((Object)filterData) ? null : filterData.get("filterdescription"));
            SaveServiceHelper.update((DynamicObject)selectRecord);
            this.getView().updateView();
        }
    }

    private void openSettingPage(DynamicObject selectedRow, String entityfield, String conditionjson, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("tpo_tcvat_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCustomParam("entityNumber", (Object)"tctb_tax_main");
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCaption(ResManager.loadKDString((String)"\u6761\u4ef6\u914d\u7f6e", (String)"TaxPreRateListPlugin_13", (String)"taxc-tpo", (Object[])new Object[0]));
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }
}

