/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.qysds;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.common.utils.AbstractEndDateUpdateSavePlugin;

public class DiscountProjSaveOp
extends AbstractEndDateUpdateSavePlugin {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    String type = currentObj.getString("type");
                    Date start = currentObj.getDate("start");
                    Date end = currentObj.getDate("end");
                    String template = currentObj.getString("template");
                    if (null != end && start.after(end)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4.", (String)"DiscountProjSaveOp_0", (String)"taxc-tpo", (Object[])new Object[0]));
                        return;
                    }
                    boolean endTimeIsNull = false;
                    if (null == end) {
                        endTimeIsNull = true;
                        end = new Date();
                    }
                    Object id = currentObj.get("id");
                    DynamicObjectCollection colls = QueryServiceHelper.query((String)currentObj.getDataEntityType().getExtendName(), (String)"id,start,end", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)type), new QFilter("template", "=", (Object)template)});
                    for (DynamicObject exist : colls) {
                        if (id.equals(exist.get("id"))) continue;
                        Date existStart = exist.getDate("start");
                        Date existEnd = exist.getDate("end");
                        if (null == existEnd) {
                            existEnd = new Date();
                        }
                        if (null == existStart || existStart.after(end) || existEnd.before(start)) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u751f\u6548\u65f6\u95f4\u6bb5\u5df2\u7ecf\u6709\u6a21\u677f\uff0c\u8bf7\u4fee\u6539\u6709\u6548\u671f\u8d77\u3001\u6b62\u65e5\u671f.", (String)"DiscountProjSaveOp_1", (String)"taxc-tpo", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObjectCollection subColls = currentObj.getDynamicObjectCollection("subtable");
                    for (DynamicObject dynamicObject : subColls) {
                        boolean isDiscount;
                        if ("tpo_discount_items".equals(currentObj.getDataEntityType().getExtendName()) && (isDiscount = "1".equals(dynamicObject.getString("isdiscount"))) && StringUtil.isEmpty((CharSequence)dynamicObject.getString("projtype"))) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a\u4f18\u60e0\u9879\u76ee\u7c7b\u578b", (String)"DiscountProjSaveOp_2", (String)"taxc-tpo", (Object[])new Object[0]));
                            return;
                        }
                        dynamicObject.set("enablecopy", (Object)"1");
                        dynamicObject.set("statuscopy", (Object)"C");
                        dynamicObject.set("templatecopy", currentObj.get("template"));
                        dynamicObject.set("typecopy", (Object)type);
                        dynamicObject.set("startcopy", (Object)start);
                        dynamicObject.set("endcopy", (Object)(endTimeIsNull ? null : end));
                        dynamicObject.set("templatecopy", currentObj.get("template"));
                    }
                }
            }
        });
    }

    @Override
    protected String getFieldName() {
        return "end";
    }
}

