/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.rule;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.common.enums.RuleTypeStrategyEnum;

public class DownloadHistoryListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruleNumber = (String)customParams.get("ruleNumber");
        long userId = RequestContext.get().getCurrUserId();
        String appid = this.getView().getFormShowParameter().getAppId();
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)userId, (String)appid, (String)"tpo_rule", (String)"45H/TA/UW5/8");
        if (taxResult.isSuccess()) {
            List orgList = (List)taxResult.getData();
            evt.getCustomQFilters().add(new QFilter("org.id", "in", (Object)orgList));
        }
        if (StringUtil.isNotBlank((CharSequence)ruleNumber)) {
            evt.getQFilters().clear();
            evt.getQFilters().add(new QFilter("sourserule.number", "=", (Object)ruleNumber));
        }
    }

    private boolean containsTimeOrg(List<QFilter> qFilters) {
        if (CollectionUtils.isEmpty(qFilters)) {
            return false;
        }
        List<String> matchKeys = Arrays.asList("time", "org");
        for (QFilter qFilter : qFilters) {
            String matchKey = qFilter.getProperty();
            if (!matchKeys.contains(matchKey)) continue;
            matchKeys.remove(matchKey);
        }
        return CollectionUtils.isEmpty(matchKeys);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        Long pkid = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String operateSource = customParams.getOrDefault("operateSource", "");
        DynamicObject historyObj = QueryServiceHelper.queryOne((String)list.getEntityId(), (String)"sourserule", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkid)});
        if (historyObj == null) {
            return;
        }
        Long sourceRuleId = historyObj.getLong("sourserule");
        DynamicObject ruleObject = QueryServiceHelper.queryOne((String)"tpo_rule", (String)"group,issystem,ruledetail_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceRuleId)});
        if (ruleObject == null) {
            return;
        }
        String formId = RuleTypeStrategyEnum.getStrategyByGroupId(ruleObject.getString("group")).getFormId();
        if (StringUtil.isBlank((CharSequence)formId)) {
            return;
        }
        String ruledetail = ruleObject.getString("ruledetail_tag");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId((Object)pkid);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("ruledetail", (Object)ruledetail);
        if (StringUtil.isNotBlank((CharSequence)operateSource)) {
            showParameter.setCustomParam("operateSource", (Object)operateSource);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

